/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.store.impls.mock;

import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.core.util.shortcode.ShortCodeUtils;
import icu.easyj.middleware.dwz.server.core.domain.entity.DwzLogEntity;
import icu.easyj.middleware.dwz.server.core.domain.enums.DwzLogStatus;
import icu.easyj.middleware.dwz.server.core.store.IDwzLogStore;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class MockDwzLogStoreImpl
implements IDwzLogStore {
    private final Map<Long, DwzLogEntity> dwzLogMap = new ConcurrentHashMap<Long, DwzLogEntity>();
    private final ISequenceService sequenceService;

    public MockDwzLogStoreImpl(ISequenceService sequenceService) {
        this.sequenceService = sequenceService;
    }

    @Override
    @NonNull
    public synchronized DwzLogEntity save(@NonNull String longUrl, Date termOfValidity) {
        long id = this.sequenceService.nextVal("SEQ_DWZ_LOG_ID");
        if (this.dwzLogMap.containsKey(id)) {
            throw new DuplicateKeyException("ID\u5df2\u7ecf\u5b58\u5728\uff1a" + id);
        }
        String shortUrlCode = ShortCodeUtils.toCode((Long)id);
        Date now = new Date();
        DwzLogEntity dwzLog = new DwzLogEntity();
        dwzLog.setId(id);
        dwzLog.setShortUrlCode(shortUrlCode);
        dwzLog.setLongUrl(longUrl);
        dwzLog.setTermOfValidity(termOfValidity);
        dwzLog.setStatus(DwzLogStatus.EFFECTIVE);
        dwzLog.setCreateTime(now);
        dwzLog.setUpdateTime(now);
        dwzLog.setVersion(1);
        this.dwzLogMap.put(id, dwzLog);
        return dwzLog;
    }

    @Override
    @Nullable
    public synchronized DwzLogEntity getByLongUrlForUpdate(@NonNull String longUrl) {
        for (DwzLogEntity entity : this.dwzLogMap.values()) {
            if (!longUrl.equals(entity.getLongUrl())) continue;
            return entity;
        }
        return null;
    }

    @Override
    public synchronized void update(@NonNull DwzLogEntity dwzLog) {
    }

    @Override
    @Nullable
    public synchronized String getLongUrlByShortUrlCode(@NonNull String shortUrlCode) {
        for (DwzLogEntity entity : this.dwzLogMap.values()) {
            if (!entity.isStatus(DwzLogStatus.EFFECTIVE) || !shortUrlCode.equals(entity.getShortUrlCode())) continue;
            return entity.getLongUrl();
        }
        return null;
    }

    @Override
    @Nullable
    public synchronized Long getMaxId() {
        Long maxId = null;
        for (Long id : this.dwzLogMap.keySet()) {
            if (maxId != null && maxId >= id) continue;
            maxId = id;
        }
        return maxId;
    }

    @Override
    public synchronized int deleteOvertime() {
        int count = 0;
        Date now = new Date();
        for (DwzLogEntity entity : this.dwzLogMap.values()) {
            if (entity.getTermOfValidity() == null || entity.getTermOfValidity().compareTo(now) > 0) continue;
            this.dwzLogMap.remove(entity.getId());
            ++count;
        }
        return count;
    }

    @Override
    public synchronized int updateOvertime() {
        int count = 0;
        Date now = new Date();
        for (DwzLogEntity entity : this.dwzLogMap.values()) {
            if (entity.getTermOfValidity() == null || entity.getTermOfValidity().compareTo(now) > 0 || !entity.isNotStatus(DwzLogStatus.Expired)) continue;
            entity.setStatus(DwzLogStatus.Expired);
            ++count;
        }
        return count;
    }
}

