/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class EasyjDwzResponse {
    private String shortUrl;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private Date createTime;
    private Long expireIn;

    public EasyjDwzResponse() {
    }

    public EasyjDwzResponse(@NonNull String shortUrl, @NonNull Date createTime, @Nullable Date termOfValidity) {
        Assert.notNull((Object)shortUrl, (String)"'shortUrl' must not be null");
        Assert.notNull((Object)createTime, (String)"'createTime' must not be null");
        Assert.isTrue((termOfValidity == null || termOfValidity.compareTo(createTime) > 0 ? 1 : 0) != 0, (String)"termOfValidity\u53ef\u4e3a\u7a7a\u6216\u5fc5\u987b\u5927\u4e8ecreateTime");
        this.shortUrl = shortUrl;
        this.createTime = createTime;
        this.expireIn = termOfValidity == null ? 0L : termOfValidity.getTime() - createTime.getTime();
    }

    public String getShortUrl() {
        return this.shortUrl;
    }

    public void setShortUrl(String shortUrl) {
        this.shortUrl = shortUrl;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getExpireIn() {
        return this.expireIn;
    }

    public void setExpireIn(Long expireIn) {
        this.expireIn = expireIn;
    }
}

