/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.template.impls.feign;

import icu.easyj.middleware.dwz.domain.EasyjDwzRequest;
import icu.easyj.middleware.dwz.template.impls.feign.EasyjDwzRestControllerFeignClient;
import icu.easyj.middleware.dwz.template.impls.feign.IFeignExceptionHandler;
import icu.easyj.sdk.dwz.DwzRequest;
import icu.easyj.sdk.dwz.DwzResponse;
import icu.easyj.sdk.dwz.DwzSdkException;
import icu.easyj.sdk.dwz.IDwzTemplate;
import java.util.Date;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class SpringCloudFeignEasyjMiddleWareDwzTemplateImpl
implements IDwzTemplate {
    @NonNull
    private final EasyjDwzRestControllerFeignClient feignClient;
    @Nullable
    private final IFeignExceptionHandler exceptionHandler;

    public SpringCloudFeignEasyjMiddleWareDwzTemplateImpl(@NonNull EasyjDwzRestControllerFeignClient feignClient, @Nullable IFeignExceptionHandler exceptionHandler) {
        this.feignClient = feignClient;
        this.exceptionHandler = exceptionHandler;
    }

    public SpringCloudFeignEasyjMiddleWareDwzTemplateImpl(@NonNull EasyjDwzRestControllerFeignClient feignClient) {
        this(feignClient, null);
    }

    public DwzResponse createShortUrl(@NonNull DwzRequest request) {
        try {
            Date termOfValidity = (Date)request.getConfig("term-of-validity");
            EasyjDwzRequest req = new EasyjDwzRequest(request.getLongUrl(), termOfValidity);
            return this.feignClient.createShortUrl(req);
        }
        catch (RuntimeException ex) {
            try {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle(ex);
                }
            }
            catch (DwzSdkException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DwzSdkException("\u8c03\u7528EasyJ\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25", (Throwable)e);
            }
            throw new DwzSdkException("\u8c03\u7528EasyJ\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25", (Throwable)ex);
        }
    }
}

