/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package icu.easyj.middleware.dwz.domain;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * @author wangliang181230
 */
public class EasyjDwzRequest implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 长链接
	 */
	private String longUrl;

	/**
	 * 有效期
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss.SSS")
	private Date termOfValidity;


	public EasyjDwzRequest() {
	}

	public EasyjDwzRequest(String longUrl, Date termOfValidity) {
		this.longUrl = longUrl;
		this.termOfValidity = termOfValidity;
	}


	public String getLongUrl() {
		return longUrl;
	}

	public void setLongUrl(String longUrl) {
		this.longUrl = longUrl;
	}

	public Date getTermOfValidity() {
		return termOfValidity;
	}

	public void setTermOfValidity(Date termOfValidity) {
		this.termOfValidity = termOfValidity;
	}
}
