/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.baidu.cloud.dwz;

import icu.easyj.core.json.EasyjSupportedJSON;
import icu.easyj.core.json.IJSONService;
import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.ObjectUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.TimeMeter;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzConfig;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzErrorType;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzResponse;
import icu.easyj.sdk.baidu.cloud.dwz.BaiduDwzResponseData;
import icu.easyj.sdk.dwz.DwzRequest;
import icu.easyj.sdk.dwz.DwzResponse;
import icu.easyj.sdk.dwz.DwzSdkClientException;
import icu.easyj.sdk.dwz.DwzSdkException;
import icu.easyj.sdk.dwz.DwzSdkServerException;
import icu.easyj.sdk.dwz.IDwzTemplate;
import icu.easyj.web.util.HttpClientUtils;
import icu.easyj.web.util.httpclient.IHttpClientService;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;

public class BaiduDwzTemplateImpl
implements IDwzTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiduDwzTemplateImpl.class);
    private static final IJSONService JSON_SERVICE = (IJSONService)EnhancedServiceLoader.loadBySupportNames(IJSONService.class, (String[])EasyjSupportedJSON.SUPPORTED);
    @NonNull
    private final BaiduDwzConfig config;
    @NonNull
    private final IHttpClientService httpClientService;

    public BaiduDwzTemplateImpl(BaiduDwzConfig config, IHttpClientService httpClientService) {
        Assert.notNull((Object)config, (String)"'config' must not be null");
        Assert.notNull((Object)httpClientService, (String)"'httpClientService' must be not null");
        this.config = config;
        this.httpClientService = httpClientService;
    }

    public BaiduDwzTemplateImpl(BaiduDwzConfig config) {
        this(config, HttpClientUtils.getService());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DwzResponse createShortUrl(DwzRequest request) throws DwzSdkException {
        DwzResponse dwzResponse;
        Throwable ex;
        String respStr;
        String body;
        TimeMeter tm;
        BaiduDwzConfig config;
        block12: {
            Assert.notNull((Object)request, (String)"'request' must not be null");
            Assert.notNull((Object)request.getLongUrl(), (String)"'request.longUrl' must not be null");
            config = (BaiduDwzConfig)ObjectUtils.mergeData((Object)this.config, (Map)request.getConfigs());
            tm = TimeMeter.create();
            body = null;
            respStr = null;
            ex = null;
            try {
                block11: {
                    body = String.format("[{\"LongUrl\":\"%s\",\"TermOfValidity\":\"%s\"}]", request.getLongUrl(), config.getTermOfValidity());
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("Dwz-Token", config.getToken());
                    headers.add("Content-Type", "application/json;charset=UTF-8");
                    headers.add("Content-Language", config.getResponseLanguage());
                    try {
                        respStr = (String)this.httpClientService.post(config.getServiceUrl(), (Object)body, (MultiValueMap)headers, String.class);
                    }
                    catch (RestClientResponseException e) {
                        respStr = e.getResponseBodyAsString();
                        if (respStr.startsWith("{")) break block11;
                        respStr = "[" + e.getRawStatusCode() + "]" + respStr;
                        throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25\uff1a[" + e.getRawStatusCode() + "]" + e.getMessage(), "SERVER_ERROR", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)respStr)) {
                    throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u65e0\u54cd\u5e94", "EMPTY_RESPONSE");
                }
                BaiduDwzResponse resp = (BaiduDwzResponse)JSON_SERVICE.toBean(respStr, BaiduDwzResponse.class);
                if (!resp.isSuccess()) {
                    BaiduDwzErrorType errorType = resp.getErrorType();
                    String errorCodeAndMessage = resp.getErrorCodeAndMessage();
                    String errorCode = errorType != null ? errorType.name() : (resp.getCode() == null ? null : resp.getCode().toString());
                    throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25\uff1a" + errorCodeAndMessage, errorCode);
                }
                if (CollectionUtils.isEmpty(resp.getShortUrls())) {
                    throw new DwzSdkServerException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u7684\u54cd\u5e94\u4e2d\u65e0\u6570\u636e", "NO_DATA");
                }
                dwzResponse = this.convertToStandard(resp, config.getTermOfValidity());
                if (ex != null) break block12;
            }
            catch (DwzSdkException e) {
                try {
                    ex = e;
                    throw e;
                    catch (RuntimeException e2) {
                        ex = e2;
                        throw new DwzSdkClientException("\u8bf7\u6c42\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u672a\u77e5\u5f02\u5e38", "UNKNOWN_ERROR", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (ex == null) {
                        if (!LOGGER.isInfoEnabled()) throw throwable;
                        LOGGER.info("\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n==>\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms\r\n==>\r\n", new Object[]{config.getServiceUrl(), body, respStr, tm.spendMilliSeconds()});
                        throw throwable;
                    }
                    if (!LOGGER.isErrorEnabled()) throw throwable;
                    LOGGER.error("{}{}\r\n==>\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms\r\n<==\r\n", new Object[]{ex instanceof DwzSdkException ? "" : "\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a", ex, config.getServiceUrl(), body, respStr, tm.spendMilliSeconds()});
                    throw throwable;
                }
            }
            if (!LOGGER.isInfoEnabled()) return dwzResponse;
            LOGGER.info("\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n==>\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms\r\n==>\r\n", new Object[]{config.getServiceUrl(), body, respStr, tm.spendMilliSeconds()});
            return dwzResponse;
        }
        if (!LOGGER.isErrorEnabled()) return dwzResponse;
        LOGGER.error("{}{}\r\n==>\r\n -  url: {}\r\n - body: {}\r\n - resp: {}\r\n - cost: {} ms\r\n<==\r\n", new Object[]{ex instanceof DwzSdkException ? "" : "\u767e\u5ea6\u4e91\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a", ex, config.getServiceUrl(), body, respStr, tm.spendMilliSeconds()});
        return dwzResponse;
    }

    private DwzResponse convertToStandard(BaiduDwzResponse resp, String termOfValidity) {
        DwzResponse response = new DwzResponse();
        BaiduDwzResponseData data = resp.getShortUrls().get(0);
        response.setShortUrl(data.getShortUrl());
        response.setCreateTime(new Date());
        if (termOfValidity != null) {
            switch (termOfValidity) {
                case "1-year": {
                    response.setExpireIn(Long.valueOf(31536000000L));
                    break;
                }
                default: {
                    response.setExpireIn(Long.valueOf(0L));
                    break;
                }
            }
        } else {
            response.setExpireIn(Long.valueOf(0L));
        }
        return response;
    }
}

