/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.ocr.idcardocr;

import icu.easyj.sdk.ocr.CardSide;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrAdvanced;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrRequest;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrResponse;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrSdkException;
import icu.easyj.sdk.ocr.idcardocr.SimpleIdCardOcrRequest;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public interface IIdCardOcrTemplate {
    @NonNull
    public IdCardOcrResponse idCardOcr(@NonNull IdCardOcrRequest var1) throws IdCardOcrSdkException;

    @NonNull
    default public IdCardOcrResponse idCardOcr(@NonNull String image, @Nullable CardSide cardSide, IdCardOcrAdvanced ... advancedArr) throws IdCardOcrSdkException {
        return this.idCardOcr(new IdCardOcrRequest(image, cardSide, advancedArr, null));
    }

    @NonNull
    default public IdCardOcrResponse idCardOcr(@NonNull String image, IdCardOcrAdvanced ... advancedArr) throws IdCardOcrSdkException {
        return this.idCardOcr(image, (CardSide)null, advancedArr);
    }

    @NonNull
    default public IdCardOcrResponse idCardOcr(@NonNull String image1, @NonNull String image2, boolean returnIfHasWarn, SimpleIdCardOcrRequest simpleRequest) throws IdCardOcrSdkException {
        IdCardOcrResponse backResponse;
        IdCardOcrResponse doubleResponse;
        IdCardOcrRequest request = new IdCardOcrRequest(simpleRequest);
        request.setImage(image1);
        IdCardOcrResponse response1 = this.idCardOcr(request);
        if (returnIfHasWarn && !response1.getWarns().isEmpty()) {
            return response1;
        }
        CardSide cardSide2 = CardSide.FRONT;
        if (CardSide.FRONT == response1.getCardSide()) {
            cardSide2 = CardSide.BACK;
        }
        request.setImage(image2);
        request.setCardSide(cardSide2);
        IdCardOcrResponse response2 = this.idCardOcr(request);
        if (response2.getCardSide() == response1.getCardSide()) {
            throw new IdCardOcrSdkException("\u4e24\u5f20\u56fe\u7247\u7684\u6b63\u53cd\u9762\u5c5e\u6027\u76f8\u540c", "SAME_CARD_SIDE");
        }
        if (CardSide.FRONT == response1.getCardSide()) {
            doubleResponse = response1;
            backResponse = response2;
        } else {
            doubleResponse = response2;
            backResponse = response1;
        }
        doubleResponse.setCardSide(CardSide.BOTH);
        doubleResponse.setAuthority(backResponse.getAuthority());
        doubleResponse.setValidDateStart(backResponse.getValidDateStart());
        doubleResponse.setValidDateEnd(backResponse.getValidDateEnd());
        doubleResponse.setBackIdCardBase64(backResponse.getIdCardBase64());
        doubleResponse.getWarns().addAll(backResponse.getWarns());
        return doubleResponse;
    }

    @NonNull
    default public IdCardOcrResponse idCardOcr(@NonNull String image1, @NonNull String image2, boolean returnIfHasWarn, IdCardOcrAdvanced ... advancedArr) throws IdCardOcrSdkException {
        return this.idCardOcr(image1, image2, returnIfHasWarn, new SimpleIdCardOcrRequest(advancedArr));
    }

    default public IdCardOcrResponse idCardOcr(@NonNull String image1, @NonNull String image2, IdCardOcrAdvanced ... advancedArr) throws IdCardOcrSdkException {
        return this.idCardOcr(image1, image2, false, advancedArr);
    }
}

