/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.s3.dwz;

import icu.easyj.core.json.EasyjSupportedJSON;
import icu.easyj.core.json.IJSONService;
import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.util.ObjectUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.TimeMeter;
import icu.easyj.core.util.UrlUtils;
import icu.easyj.sdk.dwz.DwzRequest;
import icu.easyj.sdk.dwz.DwzResponse;
import icu.easyj.sdk.dwz.DwzSdkClientException;
import icu.easyj.sdk.dwz.DwzSdkException;
import icu.easyj.sdk.dwz.DwzSdkServerException;
import icu.easyj.sdk.dwz.IDwzTemplate;
import icu.easyj.sdk.s3.dwz.S3DwzConfig;
import icu.easyj.sdk.s3.dwz.S3DwzErrorType;
import icu.easyj.sdk.s3.dwz.S3DwzResponse;
import icu.easyj.sdk.s3.dwz.S3DwzResponseData;
import icu.easyj.web.util.HttpClientUtils;
import icu.easyj.web.util.httpclient.IHttpClientService;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClientResponseException;

public class S3DwzTemplateImpl
implements IDwzTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3DwzTemplateImpl.class);
    private static final IJSONService JSON_SERVICE = (IJSONService)EnhancedServiceLoader.loadBySupportNames(IJSONService.class, (String[])EasyjSupportedJSON.SUPPORTED);
    @NonNull
    private final S3DwzConfig config;
    @NonNull
    private final IHttpClientService httpClientService;

    public S3DwzTemplateImpl(S3DwzConfig config, IHttpClientService httpClientService) {
        Assert.notNull((Object)config, (String)"'config' must not be null");
        Assert.notNull((Object)httpClientService, (String)"'httpClientService' must be not null");
        this.config = config;
        this.httpClientService = httpClientService;
    }

    public S3DwzTemplateImpl(S3DwzConfig config) {
        this(config, HttpClientUtils.getService());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DwzResponse createShortUrl(DwzRequest request) throws DwzSdkException {
        DwzResponse dwzResponse;
        Throwable t;
        String respStr;
        String url;
        TimeMeter tm;
        block11: {
            Assert.notNull((Object)request, (String)"'request' must not be null");
            Assert.notNull((Object)request.getLongUrl(), (String)"'longUrl' must not be null");
            tm = TimeMeter.create();
            S3DwzConfig config = (S3DwzConfig)ObjectUtils.mergeData((Object)this.config, (Map)request.getConfigs());
            url = null;
            respStr = null;
            t = null;
            try {
                url = config.getServiceUrl() + "?client_id=" + config.getClientId() + "&client_secret=" + config.getClientSecret() + "&url=" + UrlUtils.encode((String)request.getLongUrl());
                try {
                    respStr = this.httpClientService.get(url);
                }
                catch (RestClientResponseException e) {
                    respStr = "[" + e.getRawStatusCode() + "]" + e.getResponseBodyAsString();
                    throw new DwzSdkServerException("\u8bf7\u6c42S-3\u77ed\u94fe\u63a5\u670d\u52a1\u5f02\u5e38\uff1a" + respStr, "SERVER_ERROR", (Throwable)e);
                }
                if (StringUtils.isEmpty((CharSequence)respStr)) {
                    throw new DwzSdkServerException("\u8bf7\u6c42S-3\u77ed\u94fe\u63a5\u670d\u52a1\u65e0\u54cd\u5e94\u5185\u5bb9", "EMPTY_RESPONSE");
                }
                S3DwzResponse resp = (S3DwzResponse)JSON_SERVICE.toBean(respStr, S3DwzResponse.class);
                if (!resp.isSuccess()) {
                    S3DwzErrorType errorType = resp.getErrorType();
                    String errorMsg = resp.getErrorMessage(errorType);
                    String errorCode = errorType != null ? errorType.name() : resp.getCode();
                    throw new DwzSdkServerException("\u8bf7\u6c42S-3\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25\uff1a[" + resp.getCode() + "]" + errorMsg, errorCode);
                }
                if (resp.getData() == null) {
                    throw new DwzSdkServerException("\u8bf7\u6c42S-3\u77ed\u94fe\u63a5\u670d\u52a1\u7684\u54cd\u5e94\u4e2d\u65e0\u6570\u636e", "NO_DATA");
                }
                dwzResponse = this.convertToStandard(resp);
                if (t != null) break block11;
            }
            catch (DwzSdkException e) {
                try {
                    t = e;
                    throw e;
                    catch (RuntimeException e2) {
                        t = e2;
                        throw new DwzSdkClientException("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u672a\u77e5\u5f02\u5e38", "UNKNOWN_ERROR", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (t == null) {
                        if (!LOGGER.isInfoEnabled()) throw throwable;
                        LOGGER.info("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n==>\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms\r\n<==\r\n", new Object[]{url, respStr, tm.spendMilliSeconds()});
                        throw throwable;
                    }
                    if (!LOGGER.isErrorEnabled()) throw throwable;
                    LOGGER.error("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a{}\r\n==>\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms\r\n<==\r\n", new Object[]{t.getMessage(), url, respStr, tm.spendMilliSeconds()});
                    throw throwable;
                }
            }
            if (!LOGGER.isInfoEnabled()) return dwzResponse;
            LOGGER.info("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n==>\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms\r\n<==\r\n", new Object[]{url, respStr, tm.spendMilliSeconds()});
            return dwzResponse;
        }
        if (!LOGGER.isErrorEnabled()) return dwzResponse;
        LOGGER.error("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a{}\r\n==>\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms\r\n<==\r\n", new Object[]{t.getMessage(), url, respStr, tm.spendMilliSeconds()});
        return dwzResponse;
    }

    private DwzResponse convertToStandard(S3DwzResponse resp) {
        DwzResponse response = new DwzResponse();
        S3DwzResponseData data = resp.getData();
        response.setShortUrl(data.getUrlShort());
        if (data.getCreateTime() != null) {
            response.setCreateTime(new Date(data.getCreateTime() * 1000L));
        } else {
            response.setCreateTime(new Date());
        }
        response.setExpireIn(Long.valueOf(data.getExpireIn() != null ? data.getExpireIn() : 0L));
        return response;
    }
}

