/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.tencent.cloud.ocr.idcardocr;

import cn.hutool.core.codec.Base64;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRRequest;
import icu.easyj.sdk.ocr.CardSide;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.IdCardOcrAdvancedConfig;
import java.io.InputStream;

public class IdCardOcrRequestBuilder {
    private final IDCardOCRRequest request = new IDCardOCRRequest();
    private IdCardOcrAdvancedConfig config;

    public IdCardOcrRequestBuilder image(String image) {
        if (image.startsWith("http://") || image.startsWith("https://")) {
            this.request.setImageUrl(image);
        } else {
            this.request.setImageBase64(image);
        }
        return this;
    }

    public IdCardOcrRequestBuilder image(InputStream imageInputStream) {
        this.request.setImageBase64(Base64.encode((InputStream)imageInputStream));
        return this;
    }

    public IdCardOcrRequestBuilder cardSide(String cardSide) {
        this.request.setCardSide(cardSide);
        return this;
    }

    public IdCardOcrRequestBuilder cardSide(CardSide cardSide) {
        if (cardSide == null) {
            return this;
        }
        return this.cardSide(cardSide.name());
    }

    public IdCardOcrRequestBuilder frontCardSide() {
        return this.cardSide(CardSide.FRONT);
    }

    public IdCardOcrRequestBuilder backCardSide() {
        return this.cardSide(CardSide.BACK);
    }

    public IdCardOcrRequestBuilder enableCropIdCard() {
        this.getConfig().setCropIdCard(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableCropPortrait() {
        this.getConfig().setCropPortrait(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableQuality() {
        this.getConfig().setQuality(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableMultiCardDetect() {
        this.getConfig().setMultiCardDetect(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableInvalidDateWarn() {
        this.getConfig().setInvalidDateWarn(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableBorderCheckWarn() {
        this.getConfig().setBorderCheckWarn(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableReflectWarn() {
        this.getConfig().setReflectWarn(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableCopyWarn() {
        this.getConfig().setCopyWarn(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableReshootWarn() {
        this.getConfig().setReshootWarn(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableTempIdWarn() {
        this.getConfig().setTempIdWarn(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableDetectPsWarn() {
        this.getConfig().setDetectPsWarn(true);
        return this;
    }

    public IdCardOcrRequestBuilder enableAllAdvanced() {
        this.enableCropIdCard();
        this.enableCropPortrait();
        this.enableQuality();
        this.enableMultiCardDetect();
        this.enableInvalidDateWarn();
        this.enableBorderCheckWarn();
        this.enableReflectWarn();
        this.enableCopyWarn();
        this.enableReshootWarn();
        this.enableTempIdWarn();
        this.enableDetectPsWarn();
        return this;
    }

    public IDCardOCRRequest build() {
        if (this.config != null) {
            this.optimizeConfigBeforeBuild();
            this.request.setConfig(this.config.toJson());
        }
        return this.request;
    }

    private void optimizeConfigBeforeBuild() {
        if (this.config.getCropPortrait() != null && CardSide.BACK.name().equals(this.request.getCardSide())) {
            this.config.setCropPortrait(null);
        }
    }

    private IdCardOcrAdvancedConfig getConfig() {
        if (this.config == null) {
            this.config = new IdCardOcrAdvancedConfig();
        }
        return this.config;
    }
}

