/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.tencent.cloud.ocr.idcardocr.impls;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.common.profile.Language;
import com.tencentcloudapi.ocr.v20181119.OcrClient;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRRequest;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRResponse;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.TimeMeter;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.ITencentCloudIdCardOcrService;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.TencentCloudIdCardOcrConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultTencentCloudIdCardOcrServiceImpl
implements ITencentCloudIdCardOcrService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTencentCloudIdCardOcrServiceImpl.class);
    private static final String ENDPOINT = "ocr.tencentcloudapi.com";
    @NonNull
    private final TencentCloudIdCardOcrConfig globalConfig;
    @NonNull
    private final OcrClient globalClient;

    public DefaultTencentCloudIdCardOcrServiceImpl(@NonNull TencentCloudIdCardOcrConfig config) {
        Assert.notNull((Object)config, (String)"'config' must not be null");
        this.globalConfig = config;
        this.globalClient = this.newOcrClient(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDCardOCRResponse doIdCardOcr(IDCardOCRRequest request, @Nullable TencentCloudIdCardOcrConfig config) throws TencentCloudSDKException {
        if (config == null) {
            config = this.globalConfig;
        }
        Assert.notNull((Object)config.getSecretId(), (String)"'secretId' must not be null");
        Assert.notNull((Object)config.getSecretKey(), (String)"'secretKey' must not be null");
        Assert.notNull((Object)config.getRegion(), (String)"'region' must not be null");
        TimeMeter tm = TimeMeter.create();
        try {
            OcrClient client = config == this.globalConfig ? this.globalClient : this.newOcrClient(config);
            IDCardOCRResponse response = client.IDCardOCR(request);
            if (LOGGER.isInfoEnabled()) {
                String imageBase64Bak = request.getImageBase64();
                String advancedInfoBak = response.getAdvancedInfo();
                request.setImageBase64(null);
                response.setAdvancedInfo(null);
                try {
                    LOGGER.info("IDCardOCR \u8bf7\u6c42\u6210\u529f\uff01\r\n==>\r\n -  Request: {}\r\n - Response: {}\r\n -   Config: {}\r\n -     Cost: {} ms\r\n<==\r\n", new Object[]{StringUtils.toString((Object)request), StringUtils.toString((Object)response), StringUtils.toString((Object)config), tm.spendMilliSeconds()});
                }
                finally {
                    request.setImageBase64(imageBase64Bak);
                    response.setAdvancedInfo(advancedInfoBak);
                }
            }
            return response;
        }
        catch (TencentCloudSDKException | RuntimeException e) {
            String imageBase64Bak = request.getImageBase64();
            request.setImageBase64(null);
            try {
                LOGGER.error("\u8eab\u4efd\u8bc1\u8bc6\u522b\u670d\u52a1\u8bf7\u6c42\u5931\u8d25\uff1a{}\r\n==>\r\n - Request: {}\r\n -  Config: {}\r\n -    Cost: {} ms\r\n<==\r\n", new Object[]{e.getMessage(), StringUtils.toString((Object)request), StringUtils.toString((Object)config), tm.spendMilliSeconds()});
            }
            finally {
                request.setImageBase64(imageBase64Bak);
            }
            throw e;
        }
    }

    @Nullable
    private Credential newCredential(TencentCloudIdCardOcrConfig config) {
        if (StringUtils.isNotBlank((CharSequence)config.getSecretId()) && StringUtils.isNotBlank((CharSequence)config.getSecretKey())) {
            return new Credential(config.getSecretId(), config.getSecretKey());
        }
        return null;
    }

    @NonNull
    private HttpProfile newHttpProfile(TencentCloudIdCardOcrConfig config) {
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint(ENDPOINT);
        if (config.getConnTimeout() != null && config.getConnTimeout() > 0) {
            httpProfile.setConnTimeout(config.getConnTimeout().intValue());
        }
        if (config.getWriteTimeout() != null && config.getWriteTimeout() > 0) {
            httpProfile.setWriteTimeout(config.getWriteTimeout().intValue());
        }
        if (config.getReadTimeout() != null && config.getReadTimeout() > 0) {
            httpProfile.setReadTimeout(config.getReadTimeout().intValue());
        }
        return httpProfile;
    }

    private ClientProfile newClientProfile(HttpProfile httpProfile, TencentCloudIdCardOcrConfig config) {
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        clientProfile.setLanguage(config.getLanguage() == null ? Language.ZH_CN : config.getLanguage());
        clientProfile.setDebug(config.getDebug() != null && config.getDebug() != false);
        return clientProfile;
    }

    private OcrClient newOcrClient(TencentCloudIdCardOcrConfig config) {
        Credential cred = this.newCredential(config);
        HttpProfile httpProfile = this.newHttpProfile(config);
        ClientProfile clientProfile = this.newClientProfile(httpProfile, config);
        return new OcrClient(cred, config.getRegion(), clientProfile);
    }

    @Override
    @NonNull
    public TencentCloudIdCardOcrConfig getGlobalConfig() {
        return this.globalConfig;
    }
}

