/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.tencent.cloud.ocr.idcardocr;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRResponse;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.StringUtils;
import java.util.Set;
import org.springframework.lang.Nullable;

public class IdCardOcrAdvancedInfo {
    @SerializedName(value="IdCard")
    @Expose
    private String idCardBase64;
    @SerializedName(value="Portrait")
    @Expose
    private String portraitBase64;
    @SerializedName(value="Quality")
    @Expose
    private Integer quality;
    @SerializedName(value="BorderCodeValue")
    @Expose
    private Integer borderCodeValue;
    @SerializedName(value="WarnInfos")
    @Expose
    private Set<Integer> warnInfos;

    public boolean hasNoWarn() {
        return CollectionUtils.isEmpty(this.warnInfos);
    }

    public boolean hasAnyWarn() {
        return !this.hasNoWarn();
    }

    private boolean hasWarn(int warnCode) {
        if (this.hasNoWarn()) {
            return false;
        }
        return this.warnInfos.contains(warnCode);
    }

    public boolean hasInvalidDateWarn() {
        return this.hasWarn(-9100);
    }

    public boolean hasBorderIncompleteWarn() {
        return this.hasWarn(-9101);
    }

    public boolean hasCopyWarn() {
        return this.hasWarn(-9102);
    }

    public boolean hasReshootWarn() {
        return this.hasWarn(-9103);
    }

    public boolean hasTempIdWarn() {
        return this.hasWarn(-9104);
    }

    public boolean hasInFrameCoveredWarn() {
        return this.hasWarn(-9105);
    }

    public boolean hasDetectPsWarn() {
        return this.hasWarn(-9106);
    }

    @Nullable
    public static IdCardOcrAdvancedInfo fromJsonString(String advanceInfoJson) {
        if (StringUtils.isBlank((CharSequence)advanceInfoJson) || advanceInfoJson.length() == 2) {
            return null;
        }
        return (IdCardOcrAdvancedInfo)IDCardOCRResponse.fromJsonString((String)advanceInfoJson, IdCardOcrAdvancedInfo.class);
    }

    public String getIdCardBase64() {
        return this.idCardBase64;
    }

    public void setIdCardBase64(String idCardBase64) {
        this.idCardBase64 = idCardBase64;
    }

    public String getPortraitBase64() {
        return this.portraitBase64;
    }

    public void setPortraitBase64(String portraitBase64) {
        this.portraitBase64 = portraitBase64;
    }

    public Integer getQuality() {
        return this.quality;
    }

    public void setQuality(Integer quality) {
        this.quality = quality;
    }

    public Integer getBorderCodeValue() {
        return this.borderCodeValue;
    }

    public void setBorderCodeValue(Integer borderCodeValue) {
        this.borderCodeValue = borderCodeValue;
    }

    public Set<Integer> getWarnInfos() {
        return this.warnInfos;
    }

    public void setWarnInfos(Set<Integer> warnInfos) {
        this.warnInfos = warnInfos;
    }
}

