/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package icu.easyj.sdk.tencent.cloud.ocr;

import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.IdCardOcrRequestBuilder;

/**
 * OCR请求对象构建者
 *
 * @author wangliang181230
 */
public abstract class OcrRequestBuilder {

	/**
	 * 创建身份证识别（IDCardOCR）请求构建者
	 *
	 * @return 身份证识别（IDCardOCR）请求构建者
	 */
	public static IdCardOcrRequestBuilder idCardOcrRequestBuilder() {
		return new IdCardOcrRequestBuilder();
	}
}
