/*
 * Decompiled with CFR 0.152.
 */
package icu.etl.springboot.starter.ioc;

import icu.etl.ioc.BeanArgument;
import icu.etl.ioc.IocContext;
import java.util.Objects;
import org.springframework.context.ApplicationContext;

public class SpringIocContext
implements IocContext {
    private ApplicationContext springContext;

    public SpringIocContext(ApplicationContext springContext) {
        this.springContext = Objects.requireNonNull(springContext);
    }

    public String getName() {
        return SpringIocContext.class.getSimpleName();
    }

    public <E> E getBean(Class<E> cls, Object[] args) {
        if (args.length == 0) {
            return (E)this.springContext.getBean(cls);
        }
        if (args[0] instanceof String) {
            BeanArgument argument = new BeanArgument(args);
            Object bean = this.springContext.getBean(argument.getName(), cls);
            if (bean != null) {
                return (E)bean;
            }
            bean = this.springContext.getBean(argument.getName(), argument.getArgs());
            if (bean != null) {
                return (E)bean;
            }
            bean = this.springContext.getBean(argument.getName());
            if (bean != null) {
                return (E)bean;
            }
        }
        return (E)this.springContext.getBean(cls, args);
    }
}

