/*
 * Decompiled with CFR 0.152.
 */
package icu.etl.springboot.starter;

import icu.etl.ioc.BeanInfoRegister;
import icu.etl.ioc.EasyBeanContext;
import icu.etl.ioc.IocContext;
import icu.etl.springboot.starter.ioc.SpringEasyBeanInfo;
import icu.etl.springboot.starter.ioc.SpringIocContext;
import icu.etl.util.ArrayUtils;
import icu.etl.util.ClassUtils;
import icu.etl.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;

public class SpringEasyApplication {
    public static synchronized void run(ConfigurableApplicationContext springContext, SpringApplication application, String[] args, Logger log) {
        Annotation[] annotations;
        String app = "easyetl-spring-boot-starter";
        String beanName = EasyBeanContext.class.getSimpleName();
        if (springContext.getBeanFactory().containsBeanDefinition(beanName)) {
            return;
        }
        long start = System.currentTimeMillis();
        if (application == null) {
            log.error("{} start fail!", (Object)app);
            throw new NullPointerException();
        }
        log.info("{} starting ..", (Object)app);
        Class cls = application.getMainApplicationClass();
        log.info("SpringBoot Application {}", (Object)cls.getName());
        log.info("SpringBoot Application args {}", (Object)StringUtils.toString((Object)args));
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (Annotation obj : annotations = cls.getAnnotations()) {
            SpringBootApplication anno;
            if (obj instanceof SpringBootApplication) {
                anno = (SpringBootApplication)obj;
                includes.addAll(ArrayUtils.asList((Object[])anno.scanBasePackages()));
                includes.addAll(ClassUtils.asNameList((Class[])anno.scanBasePackageClasses()));
                excludes.addAll(ArrayUtils.asList((Object[])anno.excludeName()));
                excludes.addAll(ClassUtils.asNameList((Class[])anno.exclude()));
                continue;
            }
            if (!(obj instanceof ComponentScan)) continue;
            anno = (ComponentScan)obj;
            includes.addAll(ArrayUtils.asList((Object[])anno.value()));
            includes.addAll(ArrayUtils.asList((Object[])anno.basePackages()));
            includes.addAll(ClassUtils.asNameList((Class[])anno.basePackageClasses()));
        }
        String argument = SpringEasyApplication.mergeToPackage(includes, excludes);
        ClassLoader classLoader = application.getClassLoader();
        log.info("{} classLoader {}", (Object)app, (Object)(classLoader == null ? "" : classLoader.getClass().getName()));
        log.info("{} includeds package {}", (Object)app, (Object)StringUtils.join(includes, (String)","));
        log.info("{} excludeds package {}", (Object)app, (Object)StringUtils.join(excludes, (String)","));
        EasyBeanContext context = new EasyBeanContext(classLoader, new String[]{argument});
        context.addIoc((IocContext)new SpringIocContext((ApplicationContext)springContext));
        context.addBean((BeanInfoRegister)new SpringEasyBeanInfo((ApplicationContext)springContext));
        springContext.getBeanFactory().registerSingleton(beanName, (Object)context);
        log.info("{} initialization in " + (System.currentTimeMillis() - start) + " ms ..", (Object)app);
    }

    protected static String mergeToPackage(List<String> includes, List<String> excludes) {
        StringBuilder buf = new StringBuilder(100);
        for (String pkg : includes) {
            buf.append(SpringEasyApplication.removeGPattern(pkg)).append(',');
        }
        for (String pkg : excludes) {
            buf.append('!').append(SpringEasyApplication.removeGPattern(pkg)).append(',');
        }
        return StringUtils.replaceLast((String)buf.toString(), (String)",", (String)"");
    }

    protected static String removeGPattern(String str) {
        String name;
        String[] array = str.split("\\.");
        StringBuilder buf = new StringBuilder(str.length());
        for (int i = 0; i < array.length && (name = array[i]).indexOf(42) == -1 && name.indexOf(63) == -1; ++i) {
            buf.append(name).append('.');
        }
        return StringUtils.replaceLast((String)buf.toString(), (String)".", (String)"");
    }
}

