/*
 * Decompiled with CFR 0.152.
 */
package icu.etl.springboot.starter;

import icu.etl.ioc.BeanInfoRegister;
import icu.etl.ioc.EasyBeanContext;
import icu.etl.ioc.EasyScanPatternList;
import icu.etl.ioc.IocContext;
import icu.etl.springboot.starter.ioc.SpringEasyBeanInfo;
import icu.etl.springboot.starter.ioc.SpringIocContext;
import icu.etl.util.ArrayUtils;
import icu.etl.util.ClassUtils;
import icu.etl.util.FileUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;

public class SpringEasyApplication {
    public static final AtomicBoolean SPRING_CONTEXT_REFRESHED = new AtomicBoolean(false);
    public static final String APP_SPRING_BEANNAME = "easyetl";
    public static final String APP_NAME = "easyetl-spring-boot-starter";

    public static synchronized void run(ConfigurableApplicationContext springContext, SpringApplication application, String[] args, Logger log) {
        Annotation[] annotations;
        if (!SPRING_CONTEXT_REFRESHED.get()) {
            if (log.isDebugEnabled()) {
                log.debug("unable to start {}, because spring context not refreshed!", (Object)APP_NAME);
            }
            return;
        }
        if ("bootstrap".equalsIgnoreCase(springContext.getId())) {
            if (log.isDebugEnabled()) {
                log.debug("unable to start {}, because spring context id is bootstrap!", (Object)APP_NAME);
            }
            return;
        }
        if (springContext.getBeanFactory().containsBeanDefinition(APP_SPRING_BEANNAME)) {
            if (log.isDebugEnabled()) {
                log.debug("unable to start {}, because {} has registered!", (Object)APP_NAME, (Object)APP_SPRING_BEANNAME);
            }
            return;
        }
        long start = System.currentTimeMillis();
        if (application == null) {
            log.error("{} start fail!", (Object)APP_NAME);
            throw new UnsupportedOperationException();
        }
        log.info("{} starting ..", (Object)APP_NAME);
        Class cls = application.getMainApplicationClass();
        log.info("{} SpringBoot {}", (Object)APP_NAME, (Object)cls.getName());
        log.info("{} SpringBoot args {}", (Object)APP_NAME, (Object)Arrays.toString(args));
        ClassLoader classLoader = application.getClassLoader();
        log.info("{} classLoader {}", (Object)APP_NAME, (Object)(classLoader == null ? "" : classLoader.getClass().getName()));
        EasyScanPatternList list = new EasyScanPatternList();
        for (Annotation obj : annotations = cls.getAnnotations()) {
            SpringBootApplication anno;
            if (obj instanceof SpringBootApplication) {
                anno = (SpringBootApplication)obj;
                list.addAll((Collection)ArrayUtils.asList((Object[])anno.scanBasePackages()));
                list.addAll((Collection)ClassUtils.asNameList((Class[])anno.scanBasePackageClasses()));
                list.exclude((Collection)ArrayUtils.asList((Object[])anno.excludeName()));
                list.exclude((Collection)ClassUtils.asNameList((Class[])anno.exclude()));
                continue;
            }
            if (!(obj instanceof ComponentScan)) continue;
            anno = (ComponentScan)obj;
            list.addAll((Collection)ArrayUtils.asList((Object[])anno.value()));
            list.addAll((Collection)ArrayUtils.asList((Object[])anno.basePackages()));
            list.addAll((Collection)ClassUtils.asNameList((Class[])anno.basePackageClasses()));
        }
        if (list.getScanPattern().isEmpty()) {
            String[] array;
            for (String classpath : array = ClassUtils.getJavaClassPath()) {
                if (!FileUtils.isDirectory((String)classpath)) continue;
                list.addAll((Collection)ClassUtils.findShortPackage((ClassLoader)classLoader, (String)classpath));
            }
        }
        list.addProperty();
        list.addGroupID();
        log.info("{} scan pattern {}", (Object)APP_NAME, (Object)list.toArgumentString());
        EasyBeanContext context = new EasyBeanContext(classLoader);
        context.setArgument(args);
        context.loadBeanInfo(list.toArray());
        context.addIoc((IocContext)new SpringIocContext((ApplicationContext)springContext));
        context.addBean((BeanInfoRegister)new SpringEasyBeanInfo((ApplicationContext)springContext));
        springContext.getBeanFactory().registerSingleton(APP_SPRING_BEANNAME, (Object)context);
        log.info("{} initialization in {} ms ..", (Object)APP_NAME, (Object)(System.currentTimeMillis() - start));
    }
}

