/*
 * Decompiled with CFR 0.152.
 */
package icu.etl.springboot.starter;

import icu.etl.concurrent.ExecutorsFactory;
import icu.etl.concurrent.ThreadSource;
import icu.etl.ioc.EasyBeanContext;
import icu.etl.ioc.EasyBeanInfoValue;
import icu.etl.ioc.EasyContainerContext;
import icu.etl.ioc.EasyContext;
import icu.etl.ioc.scan.EasyScanPatternList;
import icu.etl.log.LogBuilder;
import icu.etl.log.LogFactory;
import icu.etl.log.slf4j.Slf4jLogBuilder;
import icu.etl.springboot.starter.concurrent.SpringExecutorsFactory;
import icu.etl.springboot.starter.ioc.SpringEasyBeanInfo;
import icu.etl.springboot.starter.ioc.SpringIocContext;
import icu.etl.util.ArrayUtils;
import icu.etl.util.ClassUtils;
import icu.etl.util.Ensure;
import icu.etl.util.FileUtils;
import icu.etl.util.Settings;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasySpringApplication {
    public static void run(ConfigurableApplicationContext springContext, SpringApplication application, String[] args, Logger log) {
        Ensure.notNull((Object)application);
        ClassLoader classLoader = application.getClassLoader();
        Class applicationClass = application.getMainApplicationClass();
        EasySpringApplication.run(classLoader, springContext, applicationClass, args, log);
    }

    public static synchronized void run(ClassLoader classLoader, ConfigurableApplicationContext springContext, Class<?> mainApplicationClass, String[] args, Logger log) {
        long start = System.currentTimeMillis();
        LogFactory.getContext().setStartMillis(start);
        LogFactory.getContext().setBuilder((LogBuilder)new Slf4jLogBuilder());
        Ensure.notNull((Object)springContext);
        String applicationName = Settings.getApplicationName();
        String springbootStarterName = applicationName + "-spring-boot-starter";
        if ("bootstrap".equalsIgnoreCase(springContext.getId())) {
            if (log.isDebugEnabled()) {
                log.debug("unable to start {}, because spring context id is bootstrap!", (Object)springbootStarterName);
            }
            return;
        }
        if (springContext.getBeanFactory().containsBeanDefinition(applicationName)) {
            if (log.isDebugEnabled()) {
                log.debug("unable to start {}, because {} has registered!", (Object)springbootStarterName, (Object)applicationName);
            }
            return;
        }
        log.info("{} starting ..", (Object)springbootStarterName);
        if (classLoader == null) {
            classLoader = springContext.getClassLoader();
        }
        if (classLoader != null) {
            log.info("{} classLoader is {}", (Object)springbootStarterName, (Object)classLoader.getClass().getName());
        }
        EasyScanPatternList list = new EasyScanPatternList();
        list.addProperty();
        list.addArgument(args);
        log.info("{} args {}", (Object)springbootStarterName, (Object)Arrays.toString(args));
        if (mainApplicationClass != null) {
            log.info("{} SpringBoot Application is {}", (Object)springbootStarterName, (Object)mainApplicationClass.getName());
            Annotation[] annotations = mainApplicationClass.getAnnotations();
            for (Annotation obj : annotations) {
                SpringBootApplication anno;
                if (obj instanceof SpringBootApplication) {
                    anno = (SpringBootApplication)obj;
                    list.addAll((Collection)ArrayUtils.asList((Object[])anno.scanBasePackages()));
                    list.addAll((Collection)ClassUtils.asNameList((Class[])anno.scanBasePackageClasses()));
                    list.exclude((Collection)ArrayUtils.asList((Object[])anno.excludeName()));
                    list.exclude((Collection)ClassUtils.asNameList((Class[])anno.exclude()));
                    continue;
                }
                if (!(obj instanceof ComponentScan)) continue;
                anno = (ComponentScan)obj;
                list.addAll((Collection)ArrayUtils.asList((Object[])anno.value()));
                list.addAll((Collection)ArrayUtils.asList((Object[])anno.basePackages()));
                list.addAll((Collection)ClassUtils.asNameList((Class[])anno.basePackageClasses()));
            }
        }
        if (list.getScanPattern().isEmpty()) {
            String[] array = ClassUtils.getJavaClassPath();
            for (String classpath : array) {
                if (!FileUtils.isDirectory((String)classpath)) continue;
                list.addAll((Collection)ClassUtils.findShortPackage((ClassLoader)classLoader, (String)classpath));
            }
        }
        list.addGroupID();
        log.info("{} class scan pattern is {}", (Object)springbootStarterName, (Object)list.toArgumentString());
        EasyBeanContext context = new EasyBeanContext(classLoader);
        context.setArgument(args);
        context.loadBeanInfo(list.toArray());
        context.setParent((EasyContext)EasySpringApplication.findEasyContext(springContext, applicationName, log));
        context.addIoc((EasyContainerContext)new SpringIocContext((ApplicationContext)springContext));
        context.addBean((EasyBeanInfoValue)new SpringEasyBeanInfo((ApplicationContext)springContext));
        log.info("SpringContext: id={}, appName={}, displayName={}", new Object[]{springContext.getId(), springContext.getApplicationName(), springContext.getDisplayName()});
        springContext.getBeanFactory().registerSingleton(applicationName, (Object)context);
        EasySpringApplication.findThreadPool(springContext, context, log);
        log.info("{} initialization in {} ms ..", (Object)springbootStarterName, (Object)(System.currentTimeMillis() - start));
    }

    private static void findThreadPool(ConfigurableApplicationContext springContext, EasyBeanContext context, Logger log) {
        block12: {
            Object service;
            ThreadSource source;
            block11: {
                block10: {
                    source = (ThreadSource)context.getBean(ThreadSource.class, new Object[0]);
                    if (source == null) {
                        return;
                    }
                    try {
                        ThreadPoolTaskExecutor pool = (ThreadPoolTaskExecutor)springContext.getBean("taskExecutor");
                        if (pool != null) {
                            log.info("Springboot taskExecutor: {}", (Object)pool);
                            source.setExecutorsFactory((ExecutorsFactory)new SpringExecutorsFactory(pool));
                            return;
                        }
                    }
                    catch (Throwable e) {
                        if (!log.isDebugEnabled()) break block10;
                        log.debug(e.getLocalizedMessage(), e);
                    }
                }
                try {
                    service = (ThreadPoolTaskExecutor)springContext.getBean(ThreadPoolTaskExecutor.class);
                    if (service != null) {
                        log.info("Spring ThreadPoolTaskExecutor: {}", service);
                        source.setExecutorsFactory((ExecutorsFactory)new SpringExecutorsFactory((ThreadPoolTaskExecutor)service));
                        return;
                    }
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug(e.getLocalizedMessage(), e);
                }
            }
            try {
                service = (ExecutorService)springContext.getBean(ExecutorService.class);
                if (service != null) {
                    log.info("Spring ExecutorService: {}", service);
                    source.setExecutorsFactory((ExecutorsFactory)new SpringExecutorsFactory((ExecutorService)service));
                    return;
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block12;
                log.debug(e.getLocalizedMessage(), e);
            }
        }
        log.info("No available thread pools found in Spring!");
    }

    protected static EasyBeanContext findEasyContext(ConfigurableApplicationContext springContext, String applicationName, Logger log) {
        ConfigurableApplicationContext parent = springContext;
        while ((parent = parent.getParent()) != null) {
            if (!parent.containsBeanDefinition(applicationName)) continue;
            log.info("SpringContext id={} already contains {} ..", (Object)parent.getId(), (Object)applicationName);
            EasyBeanContext context = (EasyBeanContext)parent.getBean(applicationName);
            if (context == null) continue;
            return context;
        }
        return null;
    }
}

