/*
 * Decompiled with CFR 0.152.
 */
package icu.funkye.redis.cache.starter.service.impl;

import icu.funkye.redis.cache.starter.service.IRedisCacheService;
import java.time.Duration;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@DependsOn(value={"redisCacheTemplate"})
@Service(value="redisCacheService")
public class RedisCacheServiceImpl<K, V>
implements IRedisCacheService<K, V> {
    @Autowired
    private RedisTemplate<K, V> redisCacheTemplate;

    @Override
    public void set(K key, V value, Duration timeout) {
        this.redisCacheTemplate.opsForValue().set(key, value, timeout);
    }

    @Override
    public Boolean delete(K key) {
        return this.redisCacheTemplate.delete(key);
    }

    @Override
    public V get(K key) {
        return (V)this.redisCacheTemplate.opsForValue().get(key);
    }

    @Override
    public Boolean setIfAbsent(K key, V value, Duration timeout) {
        return this.redisCacheTemplate.opsForValue().setIfAbsent(key, value, timeout);
    }

    @Override
    public Set<K> keys(K key) {
        return this.redisCacheTemplate.keys(key);
    }

    @Override
    public Long delete(Set<K> key) {
        return this.redisCacheTemplate.delete(key);
    }
}

