/*
 * Decompiled with CFR 0.152.
 */
package icu.funkye.redis.lock.starter;

import icu.funkye.redis.lock.starter.config.JedisLockProperties;
import java.time.Duration;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import redis.clients.jedis.Jedis;

@ComponentScan(basePackages={"icu.funkye.redis.lock.starter.config", "icu.funkye.redis.lock.starter.service", "icu.funkye.redis.lock.starter.aspect"})
@EnableConfigurationProperties(value={JedisLockProperties.class})
@ConditionalOnClass(value={Jedis.class})
@Configuration
public class RedisLockAutoConfigure {
    @Autowired
    private JedisLockProperties prop;
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLockAutoConfigure.class);

    @PostConstruct
    public void load() {
        LOGGER.info("\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u521d\u59cb\u5316\u4e2d........................");
    }

    @Bean(name={"jedisLockConnectionFactory"})
    public JedisConnectionFactory getConnectionFactory() {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(null == this.prop.getHost() || this.prop.getHost().length() <= 0 ? "127.0.0.1" : this.prop.getHost());
        redisStandaloneConfiguration.setPort(this.prop.getPort() <= 0 ? 6379 : this.prop.getPort());
        redisStandaloneConfiguration.setDatabase(this.prop.getDataBase() <= 0 ? 0 : this.prop.getDataBase());
        if (this.prop.getPassword() != null && this.prop.getPassword().length() > 0) {
            redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.prop.getPassword()));
        }
        JedisClientConfiguration.JedisClientConfigurationBuilder jedisClientConfiguration = JedisClientConfiguration.builder();
        jedisClientConfiguration.connectTimeout(Duration.ofMillis(this.prop.getTimeOut() > 0 ? (long)this.prop.getTimeOut() : 60000L));
        JedisConnectionFactory factory = new JedisConnectionFactory(redisStandaloneConfiguration, jedisClientConfiguration.build());
        LOGGER.info("\u5206\u5e03\u5f0f\u4e8b\u52a1\u9501\u521d\u59cb\u5316\u5b8c\u6210:{}........................", (Object)this.prop);
        return factory;
    }

    @DependsOn(value={"jedisLockConnectionFactory"})
    @Bean
    public RedisTemplate<String, Object> redisLockTemplate(@Qualifier(value="jedisLockConnectionFactory") JedisConnectionFactory jedisLockConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)jedisLockConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new JdkSerializationRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }
}

