/*
 * Decompiled with CFR 0.152.
 */
package icu.funkye.redis.lock.starter.aspect;

import icu.funkye.redis.lock.starter.config.annotation.RedisLock;
import icu.funkye.redis.lock.starter.service.IRedisLockService;
import java.time.Duration;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"redisLockService"})
@Aspect
@Component
public class RedisClusterLockAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisClusterLockAspect.class);
    @Autowired
    private IRedisLockService<String, String> redisLockService;

    @Pointcut(value="@annotation(icu.funkye.redis.lock.starter.config.annotation.RedisLock)")
    public void annotationPoinCut() {
    }

    @Around(value="annotationPoinCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        RedisLock annotation = signature.getMethod().getAnnotation(RedisLock.class);
        String key = annotation.key();
        if (key == null || key.length() <= 0) {
            key = joinPoint.getTarget().getClass().getName() + signature.getName();
        }
        Long startTime = System.currentTimeMillis();
        while (true) {
            if (this.redisLockService.setIfAbsent(key, "0", Duration.ofMillis(annotation.lockTimeout())).booleanValue()) break;
            if (System.currentTimeMillis() - startTime > (long)annotation.timeoutMills()) {
                throw new RuntimeException("\u5c1d\u8bd5\u83b7\u5f97\u5206\u5e03\u5f0f\u9501\u8d85\u65f6..........");
            }
            LOGGER.debug("########## \u5c1d\u8bd5\u83b7\u53d6\u9501:{} ##########", (Object)key);
            Thread.sleep(annotation.retry());
        }
        LOGGER.debug("########## \u5f97\u5230\u9501:{} ##########", (Object)key);
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Throwable e) {
            LOGGER.error("\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            throw e;
        }
        finally {
            this.redisLockService.delete(key);
            LOGGER.debug("########## \u91ca\u653e\u9501:{},\u603b\u8017\u65f6:{}ms,{} ##########", (Object)key, (Object)(System.currentTimeMillis() - startTime));
        }
    }
}

