/*
 * Decompiled with CFR 0.152.
 */
package icu.funkye.redis.lock.starter.service.impl;

import icu.funkye.redis.lock.starter.service.IRedisLockService;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@DependsOn(value={"redisLockTemplate"})
@Service(value="redisLockService")
public class RedisLockServiceImpl<K, V>
implements IRedisLockService<K, V> {
    @Autowired
    private RedisTemplate<K, V> redisLockTemplate;

    @Override
    public void set(K key, V value, Duration timeout) {
        this.redisLockTemplate.opsForValue().set(key, value, timeout);
    }

    @Override
    public Boolean delete(K key) {
        return this.redisLockTemplate.delete(key);
    }

    @Override
    public V get(K key) {
        return (V)this.redisLockTemplate.opsForValue().get(key);
    }

    @Override
    public Boolean setIfAbsent(K key, V value, Duration timeout) {
        return this.redisLockTemplate.opsForValue().setIfAbsent(key, value, timeout);
    }
}

