/*
 * Decompiled with CFR 0.152.
 */
package icu.funkye.redis.lock.starter.aspect;

import icu.funkye.redis.lock.starter.config.annotation.RedisLock;
import icu.funkye.redis.lock.starter.service.IRedisLockService;
import java.time.Duration;
import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"redisLockService"})
@Aspect
@Component
public class RedisClusterLockAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisClusterLockAspect.class);
    @Autowired
    private IRedisLockService<String, String> redisLockService;

    @Pointcut(value="@annotation(icu.funkye.redis.lock.starter.config.annotation.RedisLock)")
    public void annotationPoinCut() {
    }

    @Around(value="annotationPoinCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object object;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        RedisLock annotation = signature.getMethod().getAnnotation(RedisLock.class);
        String key = annotation.key();
        if (key == null || key.length() <= 0) {
            key = joinPoint.getTarget().getClass().getName() + signature.getName();
        }
        Long startTime = System.currentTimeMillis();
        String uuid = UUID.randomUUID().toString();
        Integer spin = annotation.spin();
        while (!this.lock(key, uuid, annotation)) {
            if (spin > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("########## \u5c1d\u8bd5\u81ea\u65cb\u83b7\u53d6\u9501:{},\u5269\u4f59\u6b21\u6570:{} ##########", (Object)key, (Object)spin);
                }
                if (this.lock(key, uuid, annotation)) break;
                object = spin;
                Integer n = spin = Integer.valueOf(spin - 1);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("########## \u5c1d\u8bd5\u83b7\u53d6\u9501:{} ##########", (Object)key);
                }
                Thread.sleep(annotation.retry());
            }
            if (System.currentTimeMillis() - startTime <= annotation.timeoutMills()) continue;
            throw new RuntimeException("\u5c1d\u8bd5\u83b7\u5f97\u5206\u5e03\u5f0f\u9501\u8d85\u65f6..........");
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("########## {}\u5f97\u5230\u9501:{} ##########", (Object)(spin < annotation.spin() ? (spin > 0 ? "\u81ea\u65cb\u83b7\u53d6" : "\u91cd\u91cf\u7ea7\u83b7\u53d6") : ""), (Object)key);
            }
            object = joinPoint.proceed();
            return object;
        }
        catch (Throwable e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            throw e;
        }
        finally {
            String owner = this.redisLockService.get(key);
            if (uuid.equals(owner)) {
                this.redisLockService.delete(key);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("########## \u91ca\u653e\u9501:{},\u603b\u8017\u65f6:{}ms,{} ##########", (Object)key, (Object)(System.currentTimeMillis() - startTime));
                }
            }
        }
    }

    public boolean lock(String key, String uuid, RedisLock redisLock) {
        return this.redisLockService.setIfAbsent(key, uuid, Duration.ofMillis(redisLock.lockTimeout()));
    }
}

