/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.entity;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import icu.mhb.mybatisplus.plugln.entity.ChainFieldData;
import icu.mhb.mybatisplus.plugln.entity.TableInfoExt;
import icu.mhb.mybatisplus.plugln.exception.Exceptions;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseChainModel<Children> {
    protected final Children typedThis = this;
    private Object entity;
    private final SharedString alias = SharedString.emptyString();
    private final SharedString tableName = SharedString.emptyString();
    private final Class<?> modelClass;
    private final List<ChainFieldData> chainFieldDataList = new ArrayList<ChainFieldData>();

    protected void setAlias(String alias) {
        this.alias.setStringValue(alias);
    }

    protected void setEntity(Object entity) {
        this.entity = entity;
    }

    public String getAlias() {
        return this.alias.getStringValue();
    }

    protected BaseChainModel(String alias, Class<?> modelClass) {
        this.modelClass = modelClass;
        this.init(alias);
    }

    protected BaseChainModel(Class<?> modelClass) {
        this(null, modelClass);
    }

    private void init(String alias) {
        TableInfoExt tableInfo = this.getTableInfo();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            this.setAlias(alias);
        } else {
            this.setAlias(tableInfo.getTableInfo().getTableName());
        }
        this.tableName.setStringValue(tableInfo.getTableInfo().getTableName());
    }

    protected void add(ChainFieldData chainFieldData) {
        this.chainFieldDataList.add(chainFieldData);
    }

    protected void add(List<ChainFieldData> chainFieldDataList) {
        this.chainFieldDataList.addAll(chainFieldDataList);
    }

    protected void add(String property, Object val) {
        this.chainFieldDataList.add(this.buildChainFieldData(property, val));
    }

    protected ChainFieldData buildChainFieldData(String property, Object val) {
        String colum = this.getTableInfo().getColumByProperty(property);
        Exceptions.throwMpje(StringUtils.isBlank((CharSequence)colum), "\u5728 mybatis-plus FieldList \u5b57\u6bb5\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\u5c5e\u6027\uff1a %s", property);
        return new ChainFieldData(property, colum, this.alias.getStringValue(), this.tableName.getStringValue(), this.modelClass, val);
    }

    public <T extends BaseChainModel<T>> T to(T t) {
        t.add(this.chainFieldDataList);
        this.chainFieldDataList.clear();
        return t;
    }

    public Children clear() {
        this.chainFieldDataList.clear();
        return this.typedThis;
    }

    public Children end() {
        this.clear();
        return this.typedThis;
    }

    public String getTableName() {
        return this.tableName.getStringValue();
    }

    public TableInfoExt getTableInfo() {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.getModelClass());
        return new TableInfoExt(tableInfo);
    }

    public Object getEntity() {
        return this.entity;
    }

    public Class<?> getModelClass() {
        return this.modelClass;
    }

    public List<ChainFieldData> getChainFieldDataList() {
        return this.chainFieldDataList;
    }
}

