/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.tookit;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import icu.mhb.mybatisplus.plugln.entity.BaseChainModel;
import icu.mhb.mybatisplus.plugln.entity.ChainFieldData;
import icu.mhb.mybatisplus.plugln.entity.MockChainModel;
import icu.mhb.mybatisplus.plugln.entity.TableInfoExt;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ChainUtil {
    public static String getAliasColum(ChainFieldData fieldData) {
        return fieldData.getAlias() + "." + fieldData.getColumn();
    }

    public static BaseChainModel<?> initAllChainFieldData(BaseChainModel<?> model) {
        return ChainUtil.initAllChainFieldData(model, null);
    }

    public static BaseChainModel<?> formFieldChangeToModel(ChainFieldData fieldData) {
        MockChainModel chainModel = new MockChainModel(fieldData.getAlias(), fieldData.getModelClass());
        chainModel.getChainFieldDataList().add(fieldData);
        return chainModel;
    }

    public static BaseChainModel<?> initAllChainFieldData(BaseChainModel<?> model, Predicate<TableFieldInfo> predicate) {
        Class<?> modelClass = model.getModelClass();
        TableInfoExt tableInfoExt = TableInfoExt.get(modelClass);
        List fieldDataList = tableInfoExt.getTableInfo().getFieldList().stream().filter(Optional.ofNullable(predicate).orElseGet(() -> i -> true)).map(field -> new ChainFieldData(field.getProperty(), field.getColumn(), model.getAlias(), model.getTableName(), modelClass, null)).collect(Collectors.toList());
        if (tableInfoExt.getTableInfo().havePK()) {
            fieldDataList.add(new ChainFieldData(tableInfoExt.getTableInfo().getKeyProperty(), tableInfoExt.getTableInfo().getKeyColumn(), model.getAlias(), model.getTableName(), modelClass, null));
        }
        model.getChainFieldDataList().addAll(fieldDataList);
        return model;
    }
}

