/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.entity;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import icu.mhb.mybatisplus.plugln.entity.TableFieldInfoExt;
import icu.mhb.mybatisplus.plugln.tookit.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TableInfoExt {
    private TableInfo tableInfo;

    public TableInfoExt(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public List<String> chooseSelect(Predicate<TableFieldInfo> predicate, String alias) {
        String sqlSelect = this.tableInfo.havePK() ? TableFieldInfoExt.getAliasColumn(this.tableInfo.getKeySqlSelect(), alias) : "";
        List<String> fieldsSqlSelect = this.tableInfo.getFieldList().stream().filter(predicate).map(TableFieldInfo::getSqlSelect).map(i -> TableFieldInfoExt.getAliasColumn(i, alias)).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)sqlSelect) && CollectionUtils.isNotEmpty(fieldsSqlSelect)) {
            fieldsSqlSelect.add(sqlSelect);
        }
        if (CollectionUtils.isNotEmpty(fieldsSqlSelect)) {
            return fieldsSqlSelect;
        }
        return StringUtils.isNotBlank((CharSequence)sqlSelect) ? Lists.newArrayList(sqlSelect) : Lists.newArrayList();
    }

    public String getAllSqlWhere(boolean ignoreLogicDelFiled, boolean withId, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String filedSqlScript = this.tableInfo.getFieldList().stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.tableInfo.isWithLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(TableFieldInfoExt::new).map(i -> i.getSqlWhere(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining(" "));
        if (!withId || StringUtils.isBlank((CharSequence)this.tableInfo.getKeyProperty())) {
            return filedSqlScript;
        }
        String newKeyProperty = newPrefix + this.tableInfo.getKeyProperty();
        String keySqlScript = TableFieldInfoExt.getAliasColumn(this.tableInfo.getKeyColumn(), null) + "=" + SqlScriptUtils.safeParam((String)newKeyProperty);
        return SqlScriptUtils.convertIf((String)keySqlScript, (String)String.format("%s != null", newKeyProperty), (boolean)false) + "\n" + filedSqlScript;
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean isWhere, String alias) {
        if (this.tableInfo.isWithLogicDelete()) {
            String logicDeleteSql = this.formatLogicDeleteSql(isWhere, alias);
            if (startWithAnd) {
                logicDeleteSql = " AND " + logicDeleteSql;
            }
            return logicDeleteSql;
        }
        return "";
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean isWhere) {
        return this.getLogicDeleteSql(startWithAnd, isWhere, null);
    }

    public static TableInfoExt get(Class<?> clz) {
        TableInfo info = TableInfoHelper.getTableInfo(clz);
        return new TableInfoExt(info);
    }

    public String getColumByProperty(String property) {
        if (this.tableInfo.havePK() && this.tableInfo.getKeyProperty().equals(property)) {
            return this.tableInfo.getKeyColumn();
        }
        return this.tableInfo.getFieldList().stream().filter(i -> i.getProperty().equals(property)).map(TableFieldInfo::getColumn).findFirst().orElseGet(() -> "");
    }

    private String formatLogicDeleteSql(boolean isWhere, String alias) {
        String value;
        String string = value = isWhere ? this.tableInfo.getLogicDeleteFieldInfo().getLogicNotDeleteValue() : this.tableInfo.getLogicDeleteFieldInfo().getLogicDeleteValue();
        if (isWhere) {
            if ("null".equalsIgnoreCase(value)) {
                return TableFieldInfoExt.getAliasColumn(this.tableInfo.getLogicDeleteFieldInfo().getColumn(), alias) + " IS NULL";
            }
            return TableFieldInfoExt.getAliasColumn(this.tableInfo.getLogicDeleteFieldInfo().getColumn(), alias) + "=" + String.format(this.tableInfo.getLogicDeleteFieldInfo().isCharSequence() ? "'%s'" : "%s", value);
        }
        String targetStr = TableFieldInfoExt.getAliasColumn(this.tableInfo.getLogicDeleteFieldInfo().getColumn(), alias) + "=";
        if ("null".equalsIgnoreCase(value)) {
            return targetStr + "null";
        }
        return targetStr + String.format(this.tableInfo.getLogicDeleteFieldInfo().isCharSequence() ? "'%s'" : "%s", value);
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }
}

