/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.core.support;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.AbstractISegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.GroupBySegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.HavingSegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.conditions.segments.NormalSegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.OrderBySegmentList;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Between;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Eq;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Ge;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Gt;
import icu.mhb.mybatisplus.plugln.annotations.conditions.In;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Le;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Like;
import icu.mhb.mybatisplus.plugln.annotations.conditions.LikeLeft;
import icu.mhb.mybatisplus.plugln.annotations.conditions.LikeRight;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Lt;
import icu.mhb.mybatisplus.plugln.annotations.conditions.Ne;
import icu.mhb.mybatisplus.plugln.annotations.conditions.NotIn;
import icu.mhb.mybatisplus.plugln.annotations.conditions.NotLike;
import icu.mhb.mybatisplus.plugln.annotations.conditions.NotLikeLeft;
import icu.mhb.mybatisplus.plugln.annotations.conditions.NotLikeRight;
import icu.mhb.mybatisplus.plugln.base.mapper.JoinBaseMapper;
import icu.mhb.mybatisplus.plugln.core.func.IfCompareFun;
import icu.mhb.mybatisplus.plugln.entity.ConditionAnnoVal;
import icu.mhb.mybatisplus.plugln.entity.FieldMapping;
import icu.mhb.mybatisplus.plugln.entity.ManyToManySelectBuild;
import icu.mhb.mybatisplus.plugln.entity.OneToOneSelectBuild;
import icu.mhb.mybatisplus.plugln.entity.TableFieldInfoExt;
import icu.mhb.mybatisplus.plugln.enums.ConditionType;
import icu.mhb.mybatisplus.plugln.keyword.DefaultFuncKeyWord;
import icu.mhb.mybatisplus.plugln.keyword.IFuncKeyWord;
import icu.mhb.mybatisplus.plugln.tookit.ArrayUtils;
import icu.mhb.mybatisplus.plugln.tookit.ClassUtils;
import icu.mhb.mybatisplus.plugln.tookit.CollUtil;
import icu.mhb.mybatisplus.plugln.tookit.Lists;
import icu.mhb.mybatisplus.plugln.tookit.Maps;
import icu.mhb.mybatisplus.plugln.tookit.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SupportJoinWrapper<T, R, Children extends SupportJoinWrapper<T, R, Children>>
extends AbstractWrapper<T, R, Children>
implements IfCompareFun<Children, R> {
    private static final Logger log = LoggerFactory.getLogger(SupportJoinWrapper.class);
    protected List<OneToOneSelectBuild> oneToOneSelectBuildList;
    protected List<ManyToManySelectBuild> manyToManySelectBuildList;
    protected List<FieldMapping> fieldMappingList;
    protected List<SharedString> sqlSelect;
    protected List<SharedString> joinSql;
    protected boolean masterLogicDelete;
    protected String masterTableAlias;
    protected boolean notDefaultSelectAll;
    protected boolean hasDistinct;
    protected Map<R, String> customAliasMap = Maps.newHasMap();
    @Autowired(required=false)
    private IFuncKeyWord funcKeyWord;

    public Children setFuncKeyWord(IFuncKeyWord funcKeyWord) {
        this.funcKeyWord = funcKeyWord;
        return (Children)((SupportJoinWrapper)this.typedThis);
    }

    public IFuncKeyWord getFuncKeyWord() {
        if (this.funcKeyWord == null) {
            this.funcKeyWord = new DefaultFuncKeyWord();
        }
        return this.funcKeyWord;
    }

    public Children masterLogicDelete(boolean masterLogicDelete) {
        this.masterLogicDelete = masterLogicDelete;
        return (Children)((SupportJoinWrapper)this.typedThis);
    }

    public Children distinct() {
        this.hasDistinct = true;
        return (Children)((SupportJoinWrapper)this.typedThis);
    }

    public String getJoinSql() {
        StringBuilder sql = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.joinSql)) {
            for (SharedString sharedString : this.joinSql) {
                sql.append(sharedString.getStringValue()).append(" ");
            }
        }
        return sql.toString();
    }

    protected int readWrapperInfo(String alias, MergeSegments mergeSegments, String id, boolean isAdd) {
        int conditionCount = 0;
        conditionCount += this.processNormalSegments(alias, mergeSegments, id);
        this.processGroupBySegments(alias, mergeSegments);
        if (isAdd) {
            this.expressionAdd((AbstractISegmentList)mergeSegments.getGroupBy(), SqlKeyword.GROUP_BY);
            mergeSegments.getGroupBy().clear();
        }
        this.processHavingSegments(mergeSegments, id);
        if (isAdd) {
            this.expressionAdd((AbstractISegmentList)mergeSegments.getHaving(), SqlKeyword.HAVING);
            mergeSegments.getHaving().clear();
        }
        this.processOrderBySegments(alias, mergeSegments);
        if (isAdd) {
            this.expressionAdd((AbstractISegmentList)mergeSegments.getOrderBy(), SqlKeyword.ORDER_BY);
            mergeSegments.getOrderBy().clear();
        }
        return conditionCount;
    }

    private int processNormalSegments(String alias, MergeSegments mergeSegments, String id) {
        int conditionCount = 0;
        NormalSegmentList normalSegments = mergeSegments.getNormal();
        for (int i = 0; i < normalSegments.size(); ++i) {
            String sql;
            ISqlSegment segment = (ISqlSegment)normalSegments.get(i);
            if (segment instanceof SqlKeyword) continue;
            if (segment instanceof AbstractWrapper) {
                conditionCount += this.processAbstractWrapper(alias, (AbstractWrapper)segment, id);
                continue;
            }
            String sqlSegment = segment.getSqlSegment();
            normalSegments.remove(segment);
            if (!sqlSegment.contains("#{")) {
                ++conditionCount;
                sql = this.getAliasAndField(alias, sqlSegment);
                normalSegments.add(i, (ISqlSegment & Serializable)() -> sql);
                continue;
            }
            sql = sqlSegment.replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + id);
            normalSegments.add(i, (ISqlSegment & Serializable)() -> sql);
        }
        return conditionCount;
    }

    private int processAbstractWrapper(String alias, AbstractWrapper wrapper, String id) {
        return this.readWrapperInfo(alias, wrapper.getExpression(), id, false);
    }

    private void processGroupBySegments(String alias, MergeSegments mergeSegments) {
        GroupBySegmentList groupBy = mergeSegments.getGroupBy();
        for (int i = 0; i < groupBy.size(); ++i) {
            String sqlSegment;
            ISqlSegment segment = (ISqlSegment)groupBy.get(i);
            if (segment instanceof SqlKeyword || (sqlSegment = segment.getSqlSegment()).contains("#{")) continue;
            groupBy.remove((Object)segment);
            groupBy.add(i, (ISqlSegment & Serializable)() -> this.getAliasAndField(alias, sqlSegment));
        }
    }

    private void processHavingSegments(MergeSegments mergeSegments, String id) {
        HavingSegmentList having = mergeSegments.getHaving();
        for (int i = 0; i < having.size(); ++i) {
            String sqlSegment;
            ISqlSegment segment = (ISqlSegment)having.get(i);
            if (segment instanceof SqlKeyword || !(sqlSegment = segment.getSqlSegment()).contains("#{")) continue;
            having.remove((Object)segment);
            having.add(i, (ISqlSegment & Serializable)() -> sqlSegment.replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + id));
        }
    }

    private void processOrderBySegments(String alias, MergeSegments mergeSegments) {
        OrderBySegmentList orderBy = mergeSegments.getOrderBy();
        for (int i = 0; i < orderBy.size(); ++i) {
            String sqlSegment;
            ISqlSegment segment = (ISqlSegment)orderBy.get(i);
            if (segment instanceof SqlKeyword || (sqlSegment = segment.getSqlSegment()).contains("#{")) continue;
            orderBy.remove((Object)segment);
            orderBy.add(i, (ISqlSegment & Serializable)() -> this.getAliasAndField(alias, sqlSegment));
        }
    }

    private void expressionAdd(AbstractISegmentList list, SqlKeyword sqlKeyword) {
        if (!list.isEmpty()) {
            if (null != sqlKeyword) {
                list.add(0, (Object)sqlKeyword);
            }
            ISqlSegment[] iSqlSegmentArrays = new ISqlSegment[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ISqlSegment sqlSegment;
                iSqlSegmentArrays[i] = sqlSegment = (ISqlSegment)list.get(i);
            }
            this.getExpression().add(iSqlSegmentArrays);
        }
    }

    protected String getAliasAndField(String alias, String fieldName) {
        if (StringUtils.isBlank((CharSequence)alias)) {
            return fieldName;
        }
        return alias + "." + fieldName;
    }

    protected Class<?> getTableClass(Class<?> clz) {
        return ClassUtils.getTableClass(clz);
    }

    protected Class<?> getEntityOrMasterClass() {
        Class aClass = this.getEntityClass();
        if (null != aClass) {
            return this.getTableClass(aClass);
        }
        return null;
    }

    public Children addObjConditions(Object obj) {
        return this.addObjConditions(obj, null);
    }

    public Children addObjConditions(Object obj, Class<?> groupClass) {
        Class<?> objClass = obj.getClass();
        List fieldList = ReflectionKit.getFieldList(obj.getClass());
        for (Field field : fieldList) {
            ConditionAnnoVal conditionAnnoVal = this.getConditionAnnoVal(field);
            if (conditionAnnoVal == null || ArrayUtils.isNotEmpty(conditionAnnoVal.getGroup()) && groupClass != null && !ArrayUtils.contains(conditionAnnoVal.getGroup(), groupClass)) continue;
            R r = this.getConditionR(obj.getClass(), field);
            String tableAlias = StringUtils.isNotBlank((CharSequence)conditionAnnoVal.getTableAlias()) ? conditionAnnoVal.getTableAlias() : this.getMasterTableAlias();
            String columnAlias = StringUtils.isNotBlank((CharSequence)conditionAnnoVal.getMappingColum()) ? conditionAnnoVal.getMappingColum() : StringUtils.camelToUnderline((String)field.getName());
            this.customAliasMap.put(r, tableAlias + "." + columnAlias);
            Object fieldValue = ReflectionKit.getFieldValue((Object)obj, (String)field.getName());
            switch (conditionAnnoVal.getType()) {
                case EQ: {
                    this.eqIfNull(r, fieldValue);
                    break;
                }
                case GT: {
                    this.gtIfNull(r, fieldValue);
                    break;
                }
                case GE: {
                    this.geIfNull(r, fieldValue);
                    break;
                }
                case LT: {
                    this.ltIfNull(r, fieldValue);
                    break;
                }
                case LE: {
                    this.leIfNull(r, fieldValue);
                    break;
                }
                case NE: {
                    this.neIfNull(r, fieldValue);
                    break;
                }
                case IN: {
                    if (!ObjectUtils.isNotEmpty((Object)fieldValue)) break;
                    if (fieldValue instanceof Collection) {
                        this.in(r, (Collection)fieldValue);
                        break;
                    }
                    if (fieldValue.getClass().isArray()) {
                        this.in(r, Arrays.asList((Object[])fieldValue));
                        break;
                    }
                    this.in(r, Collections.singletonList(fieldValue));
                    break;
                }
                case NOT_IN: {
                    if (!ObjectUtils.isNotEmpty((Object)fieldValue)) break;
                    if (fieldValue instanceof Collection) {
                        this.notIn(r, (Collection)fieldValue);
                        break;
                    }
                    if (fieldValue.getClass().isArray()) {
                        this.notIn(r, Arrays.asList((Object[])fieldValue));
                        break;
                    }
                    this.notIn(r, Collections.singletonList(fieldValue));
                    break;
                }
                case LIKE: {
                    this.likeIfNull(r, fieldValue);
                    break;
                }
                case LIKE_LEFT: {
                    this.likeLeftIfNull(r, fieldValue);
                    break;
                }
                case LIKE_RIGHT: {
                    this.likeRightIfNull(r, fieldValue);
                    break;
                }
                case NOT_LIKE: {
                    this.notLikeIfNull(r, fieldValue);
                    break;
                }
                case NOT_LIKE_LEFT: {
                    this.notLikeLeftIfNull(r, fieldValue);
                    break;
                }
                case NOT_LIKE_RIGHT: {
                    this.notLikeRightIfNull(r, fieldValue);
                    break;
                }
                case BETWEEN: {
                    Object[] vals;
                    if (!ObjectUtils.isNotEmpty((Object)fieldValue)) break;
                    if (fieldValue instanceof Collection) {
                        Collection collection = (Collection)fieldValue;
                        this.betweenIfNull(r, CollUtil.get(collection, 0), CollUtil.get(collection, 1));
                        break;
                    }
                    if (fieldValue.getClass().isArray()) {
                        vals = (Object[])fieldValue;
                        this.betweenIfNull(r, ArrayUtils.get(vals, 0), ArrayUtils.get(vals, 1));
                        break;
                    }
                    if (fieldValue instanceof String) {
                        vals = ((String)fieldValue).split(",");
                        this.betweenIfNull(r, ArrayUtils.get(vals, 0), ArrayUtils.get(vals, 1));
                        break;
                    }
                    log.warn("@Between The type of the passed value {} is not supported. Please use Array, List, or a comma-separated string.");
                }
            }
        }
        return (Children)((SupportJoinWrapper)this.typedThis);
    }

    private ConditionAnnoVal getConditionAnnoVal(Field field) {
        if (field.isAnnotationPresent(Eq.class)) {
            Eq annotation = field.getAnnotation(Eq.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.EQ);
        }
        if (field.isAnnotationPresent(Gt.class)) {
            Gt annotation = field.getAnnotation(Gt.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.GT);
        }
        if (field.isAnnotationPresent(Ge.class)) {
            Ge annotation = field.getAnnotation(Ge.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.GE);
        }
        if (field.isAnnotationPresent(Lt.class)) {
            Lt annotation = field.getAnnotation(Lt.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.LT);
        }
        if (field.isAnnotationPresent(Le.class)) {
            Le annotation = field.getAnnotation(Le.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.LE);
        }
        if (field.isAnnotationPresent(Ne.class)) {
            Ne annotation = field.getAnnotation(Ne.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.NE);
        }
        if (field.isAnnotationPresent(In.class)) {
            In annotation = field.getAnnotation(In.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.IN);
        }
        if (field.isAnnotationPresent(NotIn.class)) {
            NotIn annotation = field.getAnnotation(NotIn.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.NOT_IN);
        }
        if (field.isAnnotationPresent(Like.class)) {
            Like annotation = field.getAnnotation(Like.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.LIKE);
        }
        if (field.isAnnotationPresent(LikeLeft.class)) {
            LikeLeft annotation = field.getAnnotation(LikeLeft.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.LIKE_LEFT);
        }
        if (field.isAnnotationPresent(LikeRight.class)) {
            LikeRight annotation = field.getAnnotation(LikeRight.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.LIKE_RIGHT);
        }
        if (field.isAnnotationPresent(NotLike.class)) {
            NotLike annotation = field.getAnnotation(NotLike.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.NOT_LIKE);
        }
        if (field.isAnnotationPresent(NotLikeLeft.class)) {
            NotLikeLeft annotation = field.getAnnotation(NotLikeLeft.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.NOT_LIKE_LEFT);
        }
        if (field.isAnnotationPresent(NotLikeRight.class)) {
            NotLikeRight annotation = field.getAnnotation(NotLikeRight.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.NOT_LIKE_RIGHT);
        }
        if (field.isAnnotationPresent(Between.class)) {
            Between annotation = field.getAnnotation(Between.class);
            return new ConditionAnnoVal(annotation.tableAlias(), annotation.mappingColum(), annotation.group(), ConditionType.BETWEEN);
        }
        return null;
    }

    public abstract R getConditionR(Class<?> var1, Field var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R executeQuery(SFunction<JoinBaseMapper<T>, R> function) {
        SqlSession sqlSession = SqlHelper.sqlSession(this.getEntityOrMasterClass());
        try {
            Object object = function.apply((Object)((JoinBaseMapper)SqlHelper.getMapper(this.getEntityOrMasterClass(), (SqlSession)sqlSession)));
            return (R)object;
        }
        finally {
            SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(this.getEntityOrMasterClass()));
        }
    }

    protected void initNeed() {
        super.initNeed();
        this.fieldMappingList = Lists.newArrayList();
        this.sqlSelect = Lists.newArrayList();
        this.joinSql = Lists.newArrayList();
        this.masterLogicDelete = true;
        this.notDefaultSelectAll = false;
        this.hasDistinct = false;
        this.oneToOneSelectBuildList = Lists.newArrayList();
        this.manyToManySelectBuildList = Lists.newArrayList();
        Class<?> entityClass = this.getEntityOrMasterClass();
    }

    protected void setFieldMappingList(String fieldName, String columns) {
        TableFieldInfo info = this.getTableFieldInfoByFieldName(fieldName);
        if (null != info && (info.getTypeHandler() != null || info.getJdbcType() != null)) {
            TableFieldInfoExt fieldInfoExt = new TableFieldInfoExt(info);
            fieldInfoExt.setColumn(columns);
            fieldInfoExt.setProperty(fieldName);
            this.fieldMappingList.add(new FieldMapping(columns, fieldName, fieldInfoExt));
            return;
        }
        this.fieldMappingList.add(new FieldMapping(columns, fieldName, null));
    }

    protected TableFieldInfo getTableFieldInfoByFieldName(String fieldName, Class<?> clz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clz);
        if (null == tableInfo) {
            return null;
        }
        Optional<TableFieldInfo> fieldInfoOpt = tableInfo.getFieldList().stream().filter(i -> i.getProperty().equals(fieldName)).findFirst();
        return fieldInfoOpt.orElse(null);
    }

    protected TableFieldInfo getTableFieldInfoByFieldName(String fieldName) {
        return this.getTableFieldInfoByFieldName(fieldName, this.getEntityClass());
    }

    public List<OneToOneSelectBuild> getOneToOneSelectBuildList() {
        return this.oneToOneSelectBuildList;
    }

    public List<ManyToManySelectBuild> getManyToManySelectBuildList() {
        return this.manyToManySelectBuildList;
    }

    public List<FieldMapping> getFieldMappingList() {
        return this.fieldMappingList;
    }

    public boolean isMasterLogicDelete() {
        return this.masterLogicDelete;
    }

    public String getMasterTableAlias() {
        return this.masterTableAlias;
    }
}

