/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.interceptor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import icu.mhb.mybatisplus.plugln.config.MybatisPlusJoinConfig;
import icu.mhb.mybatisplus.plugln.core.support.SupportJoinWrapper;
import icu.mhb.mybatisplus.plugln.entity.FieldMapping;
import icu.mhb.mybatisplus.plugln.entity.ManyToManySelectBuild;
import icu.mhb.mybatisplus.plugln.entity.OneToOneSelectBuild;
import icu.mhb.mybatisplus.plugln.enums.JoinSqlMethod;
import icu.mhb.mybatisplus.plugln.enums.PropertyType;
import icu.mhb.mybatisplus.plugln.exception.Exceptions;
import icu.mhb.mybatisplus.plugln.injector.JoinDefaultResultType;
import icu.mhb.mybatisplus.plugln.tookit.ClassUtils;
import icu.mhb.mybatisplus.plugln.tookit.Lists;
import icu.mhb.mybatisplus.plugln.tookit.StringUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class JoinInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(JoinInterceptor.class);
    @Autowired(required=false)
    private MybatisPlusJoinConfig mybatisPlusJoinConfig;
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (!(ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_COUNT.getMethod()) || ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_LIST.getMethod()) || ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_PAGE.getMethod()) || ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_ONE.getMethod()))) {
            return invocation.proceed();
        }
        if (!(args[1] instanceof Map)) {
            return invocation.proceed();
        }
        Map paramMap = (Map)args[1];
        Object ew = paramMap.getOrDefault("ew", null);
        Object returnClass = paramMap.getOrDefault("returnClassType0000000001111", null);
        if (null == ew) {
            return invocation.proceed();
        }
        if (ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_COUNT.getMethod()) ? !(ew instanceof SupportJoinWrapper) : !(ew instanceof SupportJoinWrapper) || returnClass == null) {
            return invocation.proceed();
        }
        SupportJoinWrapper joinWrapper = ew;
        Class classType = returnClass;
        List resultMaps = ms.getResultMaps();
        if (CollectionUtils.isEmpty((Collection)resultMaps)) {
            return invocation.proceed();
        }
        ResultMap resultMap = (ResultMap)resultMaps.get(0);
        if (resultMap.getType() != JoinDefaultResultType.class) {
            return invocation.proceed();
        }
        args[0] = this.createMappedStatement(ms, joinWrapper, classType);
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappedStatement createMappedStatement(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        Map<Configuration, MappedStatement> statementMap;
        if (ms == null || joinWrapper == null || classType == null) {
            throw Exceptions.mpje("Invalid parameters for creating MappedStatement", new Object[0]);
        }
        String msId = this.buildMappedStatementId(ms, joinWrapper, classType);
        Map<Configuration, MappedStatement> map = statementMap = this.getMybatisPlusJoinConfig().isUseMsCache() ? MS_CACHE.get(msId) : null;
        if (statementMap != null && statementMap.containsKey(ms.getConfiguration())) {
            return statementMap.get(ms.getConfiguration());
        }
        MappedStatement newMs = this.buildNewMappedStatement(ms, msId, joinWrapper, classType);
        if (this.getMybatisPlusJoinConfig().isUseMsCache()) {
            Map<String, Map<Configuration, MappedStatement>> map2 = MS_CACHE;
            synchronized (map2) {
                MS_CACHE.computeIfAbsent(msId, k -> new ConcurrentHashMap()).put(ms.getConfiguration(), newMs);
            }
        }
        return newMs;
    }

    private String buildMappedStatementId(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        if (!this.getMybatisPlusJoinConfig().isUseMsCache()) {
            return ms.getId();
        }
        return (ms.getId() + ":" + classType.getName() + "_" + joinWrapper.getSqlSelect()).replaceAll("\\s+", "");
    }

    private MappedStatement buildNewMappedStatement(MappedStatement ms, String id, SupportJoinWrapper joinWrapper, Class<?> classType) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        ResultMap resultMap = this.createResultMap(ms, joinWrapper, classType);
        builder.resultMaps(Lists.newArrayList(resultMap));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultMap createResultMap(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        if (ms == null || joinWrapper == null || classType == null) {
            throw Exceptions.mpje("Invalid parameters for creating ResultMap", new Object[0]);
        }
        String resultMapId = this.buildResultMapId(ms, joinWrapper, classType);
        Configuration configuration = ms.getConfiguration();
        try {
            if (PropertyType.hasBaseType(classType) || ClassUtils.hasIncludeClass(classType, Map.class)) {
                return new ResultMap.Builder(configuration, resultMapId, classType, Collections.emptyList()).build();
            }
            if (configuration.hasResultMap(resultMapId)) {
                return configuration.getResultMap(resultMapId);
            }
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                if (configuration.hasResultMap(resultMapId)) {
                    return configuration.getResultMap(resultMapId);
                }
                List<ResultMapping> resultMappings = this.buildResultMappings(configuration, joinWrapper.getFieldMappingList(), classType);
                this.processOneToOneMapping(configuration, resultMapId, joinWrapper, resultMappings);
                this.processManyToManyMapping(configuration, resultMapId, joinWrapper, resultMappings);
                ResultMap resultMap = new ResultMap.Builder(configuration, resultMapId, classType, resultMappings).build();
                try {
                    configuration.addResultMap(resultMap);
                }
                catch (IllegalArgumentException e) {
                    log.debug("ResultMap [{}] already exists, using existing one", (Object)resultMapId);
                    return configuration.getResultMap(resultMapId);
                }
                return resultMap;
            }
        }
        catch (Exception e) {
            throw Exceptions.mpje("Failed to create ResultMap for id: %s", e, resultMapId);
        }
    }

    private void processOneToOneMapping(Configuration configuration, String baseId, SupportJoinWrapper joinWrapper, List<ResultMapping> resultMappings) {
        List<OneToOneSelectBuild> oneToOneBuilds = joinWrapper.getOneToOneSelectBuildList();
        if (CollectionUtils.isEmpty(oneToOneBuilds)) {
            return;
        }
        for (OneToOneSelectBuild build : oneToOneBuilds) {
            String oneToOneId = baseId + "_" + build.getOneToOneField();
            if (!configuration.hasResultMap(oneToOneId = oneToOneId.replaceAll("\\s+", ""))) {
                ResultMap oneToOneResultMap = new ResultMap.Builder(configuration, oneToOneId, build.getOneToOneClass(), this.buildResultMappings(configuration, build.getBelongsColumns(), build.getOneToOneClass())).build();
                this.addResultMapSafely(configuration, oneToOneResultMap, oneToOneId);
            }
            resultMappings.add(new ResultMapping.Builder(configuration, build.getOneToOneField()).javaType(build.getOneToOneClass()).nestedResultMapId(oneToOneId).build());
        }
    }

    private void processManyToManyMapping(Configuration configuration, String baseId, SupportJoinWrapper joinWrapper, List<ResultMapping> resultMappings) {
        List<ManyToManySelectBuild> manyToManyBuilds = joinWrapper.getManyToManySelectBuildList();
        if (CollectionUtils.isEmpty(manyToManyBuilds)) {
            return;
        }
        for (ManyToManySelectBuild build : manyToManyBuilds) {
            String manyToManyId = baseId + "_" + build.getManyToManyField();
            if (!configuration.hasResultMap(manyToManyId = manyToManyId.replaceAll("\\s+", ""))) {
                ResultMap manyToManyResultMap = new ResultMap.Builder(configuration, manyToManyId, build.getManyToManyClass(), this.buildResultMappings(configuration, build.getBelongsColumns(), build.getManyToManyClass())).build();
                this.addResultMapSafely(configuration, manyToManyResultMap, manyToManyId);
            }
            resultMappings.add(new ResultMapping.Builder(configuration, build.getManyToManyField()).javaType(build.getManyToManyPropertyType()).nestedResultMapId(manyToManyId).build());
        }
    }

    private synchronized void addResultMapSafely(Configuration configuration, ResultMap resultMap, String id) {
        if (configuration == null || resultMap == null || StringUtils.isBlank((CharSequence)id)) {
            throw Exceptions.mpje("Invalid parameters for adding ResultMap", new Object[0]);
        }
        try {
            if (!configuration.hasResultMap(id)) {
                configuration.addResultMap(resultMap);
            }
        }
        catch (IllegalArgumentException e) {
            log.debug("ResultMap [{}] already exists, ignore", (Object)id);
        }
        catch (Exception e) {
            throw Exceptions.mpje("Failed to add ResultMap: %s", e, id);
        }
    }

    private String buildResultMapId(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        return (ms.getId() + ":" + classType.getName() + "_" + joinWrapper.getSqlSelect()).replaceAll("\\s+", "");
    }

    private List<ResultMapping> buildResultMappings(Configuration configuration, List<FieldMapping> fieldMappings, Class<?> clz) {
        if (CollectionUtils.isEmpty(fieldMappings)) {
            throw Exceptions.mpje("No field mappings found for class: %s", clz.getName());
        }
        return fieldMappings.stream().map(fieldMapping -> {
            try {
                return this.buildResultMapping(configuration, (FieldMapping)fieldMapping, clz);
            }
            catch (Exception e) {
                throw Exceptions.mpje("Failed to build ResultMapping", e, new Object[0]);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ResultMapping buildResultMapping(Configuration configuration, FieldMapping fieldMapping, Class<?> clz) {
        try {
            Field field = ClassUtils.getDeclaredField(clz, fieldMapping.getFieldName());
            if (field == null) {
                return null;
            }
            if (fieldMapping.getTableFieldInfoExt() != null) {
                return fieldMapping.getTableFieldInfoExt().getResultMapping(configuration);
            }
            return new ResultMapping.Builder(configuration, field.getName(), fieldMapping.getColumn(), field.getType()).build();
        }
        catch (Exception e) {
            throw Exceptions.mpje("Failed to build ResultMapping for field: %s", e, fieldMapping.getFieldName());
        }
    }

    public MybatisPlusJoinConfig getMybatisPlusJoinConfig() {
        if (this.mybatisPlusJoinConfig == null) {
            this.mybatisPlusJoinConfig = MybatisPlusJoinConfig.builder().build();
        }
        return this.mybatisPlusJoinConfig;
    }
}

