/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.core.str.util;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import icu.mhb.mybatisplus.plugln.entity.FieldMapping;
import icu.mhb.mybatisplus.plugln.entity.TableFieldInfoExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class StrQueryWrapperHelper {
    private StrQueryWrapperHelper() {
    }

    public static String handleColumnPrefix(String alias, String column) {
        if (StringUtils.isNotBlank((CharSequence)column)) {
            if (column.contains(".")) {
                return column;
            }
            if (column.toLowerCase().contains(" as ")) {
                String[] parts = column.split("(?i) as ");
                String field = parts[0].trim();
                String asAlias = parts[1].trim();
                if (!field.contains(".")) {
                    return alias + "." + field + " AS " + asAlias;
                }
                return column;
            }
            return alias + "." + column;
        }
        return column;
    }

    public static String checkAndHandleColumn(String column, String masterTableAlias) {
        if (StringUtils.isNotBlank((CharSequence)column) && !column.contains(".")) {
            return StrQueryWrapperHelper.handleColumnPrefix(masterTableAlias, column);
        }
        return column;
    }

    public static TableFieldInfo getTableFieldInfoByFieldName(String fieldName, Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (tableInfo == null) {
            return null;
        }
        return tableInfo.getFieldList().stream().filter(i -> i.getProperty().equals(fieldName)).findFirst().orElse(null);
    }

    public static TableFieldInfo getTableFieldInfoByColumn(String fieldName, Class<?> clazz) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (tableInfo == null) {
            return null;
        }
        return tableInfo.getFieldList().stream().filter(i -> i.getColumn().equals(fieldName)).findFirst().orElse(null);
    }

    public static TableFieldInfo getTableFieldInfoByColumn(String fieldName, String tableName) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
        if (tableInfo == null) {
            return null;
        }
        return tableInfo.getFieldList().stream().filter(i -> i.getColumn().equals(fieldName)).findFirst().orElse(null);
    }

    public static FieldMapping createFieldMapping(String fieldName, String columns, Class<?> clz, Map<String, String> alias2table, String masterTableAlias) {
        TableFieldInfoExt fieldInfoExt = null;
        String tableAlias = masterTableAlias;
        String rawColumn = columns;
        String column = fieldName;
        if (columns.contains(".")) {
            String[] fieldParts = columns.split("\\.");
            tableAlias = fieldParts[0];
            rawColumn = fieldParts[1];
        }
        if (columns.toLowerCase().contains(" as ")) {
            String[] parts = columns.split("(?i) as ");
            String originalField = parts[0].trim();
            column = parts[1].trim();
            if (originalField.contains(".")) {
                String[] fieldParts = originalField.split("\\.");
                tableAlias = fieldParts[0];
                rawColumn = fieldParts[1];
            } else {
                rawColumn = originalField;
            }
        }
        TableFieldInfo info = null;
        if (clz == null) {
            String tableName = alias2table.get(tableAlias);
            info = StrQueryWrapperHelper.getTableFieldInfoByColumn(rawColumn, tableName);
        } else {
            info = StrQueryWrapperHelper.getTableFieldInfoByColumn(rawColumn, clz);
        }
        if (info != null && (info.getTypeHandler() != null || info.getJdbcType() != null)) {
            fieldInfoExt = new TableFieldInfoExt(info);
            fieldInfoExt.setColumn(column);
            fieldInfoExt.setProperty(fieldName);
        }
        return new FieldMapping(column, rawColumn, tableAlias, fieldName, fieldInfoExt);
    }

    public static List<FieldMapping> buildFieldMappingList(String tableNameOrAlias, boolean autoAlias, Map<String, String> alias2table, String ... columns) {
        ArrayList<FieldMapping> fieldMappings;
        block11: {
            String tableName;
            block10: {
                fieldMappings = new ArrayList<FieldMapping>();
                tableName = alias2table.getOrDefault(tableNameOrAlias, tableNameOrAlias);
                if (!ArrayUtils.isEmpty((Object[])columns)) break block10;
                TableInfo tableInfo = TableInfoHelper.getTableInfo((String)tableName);
                if (tableInfo == null) break block11;
                if (tableInfo.havePK()) {
                    String keyColumn = tableInfo.getKeyColumn();
                    String keyProperty = tableInfo.getKeyProperty();
                    String columnAlias = autoAlias ? tableNameOrAlias + "_" + keyProperty : keyProperty;
                    fieldMappings.add(new FieldMapping(columnAlias, keyColumn, tableNameOrAlias, keyProperty, null));
                }
                for (TableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                    if (!fieldInfo.isSelect()) continue;
                    String column = fieldInfo.getColumn();
                    String property = fieldInfo.getProperty();
                    String columnAlias = autoAlias ? tableNameOrAlias + "_" + property : property;
                    TableFieldInfoExt fieldInfoExt = null;
                    if (fieldInfo.getTypeHandler() != null || fieldInfo.getJdbcType() != null) {
                        fieldInfoExt = new TableFieldInfoExt(fieldInfo);
                        fieldInfoExt.setColumn(columnAlias);
                        fieldInfoExt.setProperty(property);
                    }
                    fieldMappings.add(new FieldMapping(columnAlias, column, tableNameOrAlias, property, fieldInfoExt));
                }
                break block11;
            }
            for (String column : columns) {
                if (column.toLowerCase().contains(" as ")) {
                    String[] parts = column.split("(?i) as ");
                    String originalField = parts[0].trim();
                    String aliasName = parts[1].trim();
                    TableFieldInfo fieldInfo = StrQueryWrapperHelper.getTableFieldInfoByColumn(originalField, tableName);
                    TableFieldInfoExt fieldInfoExt = null;
                    if (fieldInfo != null) {
                        fieldInfoExt = new TableFieldInfoExt(fieldInfo);
                        fieldInfoExt.setColumn(aliasName);
                        fieldInfoExt.setProperty(aliasName);
                    }
                    fieldMappings.add(new FieldMapping(aliasName, originalField, tableNameOrAlias, aliasName, fieldInfoExt));
                    continue;
                }
                TableFieldInfo fieldInfo = StrQueryWrapperHelper.getTableFieldInfoByColumn(column, tableName);
                TableFieldInfoExt fieldInfoExt = null;
                String property = column;
                String columnAlias = column;
                if (fieldInfo != null) {
                    property = fieldInfo.getProperty();
                    if (autoAlias) {
                        columnAlias = tableNameOrAlias + "_" + property;
                    }
                    fieldInfoExt = new TableFieldInfoExt(fieldInfo);
                    fieldInfoExt.setColumn(columnAlias);
                    fieldInfoExt.setProperty(property);
                } else if (autoAlias) {
                    columnAlias = tableNameOrAlias + "_" + column;
                }
                fieldMappings.add(new FieldMapping(columnAlias, column, tableNameOrAlias, property, fieldInfoExt));
            }
        }
        return fieldMappings;
    }

    public static void addSelectByFieldMappings(List<FieldMapping> fieldMappings, List<SharedString> sqlSelect, List<FieldMapping> fieldMappingList) {
        for (FieldMapping mapping : fieldMappings) {
            String selectColumn = mapping.getTableAlias() != null && !mapping.getRawColumn().contains(".") ? mapping.getTableAlias() + "." + mapping.getRawColumn() : mapping.getRawColumn();
            if (!mapping.getColumn().equals(mapping.getRawColumn())) {
                selectColumn = selectColumn + " AS " + mapping.getColumn();
            }
            sqlSelect.add(new SharedString(selectColumn));
            fieldMappingList.add(mapping);
        }
    }
}

