/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;

public class TableFieldInfoExt {
    private TableFieldInfo tableFieldInfo;
    private String column;
    private String property;

    public TableFieldInfoExt(TableFieldInfo tableFieldInfo) {
        this.tableFieldInfo = tableFieldInfo;
    }

    public String getSqlWhere(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String sqlScript = " AND " + String.format(this.tableFieldInfo.getCondition(), TableFieldInfoExt.getAliasColumn(this.tableFieldInfo.getColumn(), null), newPrefix + this.tableFieldInfo.getEl());
        return this.convertIf(sqlScript, this.convertIfProperty(newPrefix, this.tableFieldInfo.getProperty()), this.tableFieldInfo.getWhereStrategy());
    }

    public static String getAliasColumn(String column, String alias) {
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            return alias + "." + column;
        }
        return "${ew.masterTableAlias}." + column;
    }

    private String convertIfProperty(String prefix, String property) {
        return StringUtils.isNotBlank((CharSequence)prefix) ? prefix.substring(0, prefix.length() - 1) + "['" + property + "']" : property;
    }

    private String convertIf(String sqlScript, String property, FieldStrategy fieldStrategy) {
        if (fieldStrategy == FieldStrategy.NEVER) {
            return null;
        }
        if (this.tableFieldInfo.isPrimitive() || fieldStrategy == FieldStrategy.ALWAYS) {
            return sqlScript;
        }
        if (fieldStrategy == FieldStrategy.NOT_EMPTY && this.tableFieldInfo.isCharSequence()) {
            return SqlScriptUtils.convertIf((String)sqlScript, (String)String.format("%s != null and %s != ''", property, property), (boolean)false);
        }
        return SqlScriptUtils.convertIf((String)sqlScript, (String)String.format("%s != null", property), (boolean)false);
    }

    public ResultMapping getResultMapping(Configuration configuration) {
        ResultMapping.Builder builder = new ResultMapping.Builder(configuration, this.getProperty() == null ? this.tableFieldInfo.getProperty() : this.getProperty(), StringUtils.getTargetColumn((String)(this.getColumn() == null ? this.tableFieldInfo.getColumn() : this.getColumn())), this.tableFieldInfo.getPropertyType());
        TypeHandlerRegistry registry = configuration.getTypeHandlerRegistry();
        if (this.tableFieldInfo.getJdbcType() != null && this.tableFieldInfo.getJdbcType() != JdbcType.UNDEFINED) {
            builder.jdbcType(this.tableFieldInfo.getJdbcType());
        }
        if (this.tableFieldInfo.getTypeHandler() != null && this.tableFieldInfo.getTypeHandler() != UnknownTypeHandler.class) {
            TypeHandler typeHandler = registry.getMappingTypeHandler(this.tableFieldInfo.getTypeHandler());
            if (typeHandler == null) {
                typeHandler = registry.getInstance(this.tableFieldInfo.getPropertyType(), this.tableFieldInfo.getTypeHandler());
            }
            builder.typeHandler(typeHandler);
        }
        return builder.build();
    }

    public TableFieldInfo getTableFieldInfo() {
        return this.tableFieldInfo;
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public void setTableFieldInfo(TableFieldInfo tableFieldInfo) {
        this.tableFieldInfo = tableFieldInfo;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableFieldInfoExt)) {
            return false;
        }
        TableFieldInfoExt other = (TableFieldInfoExt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableFieldInfo this$tableFieldInfo = this.getTableFieldInfo();
        TableFieldInfo other$tableFieldInfo = other.getTableFieldInfo();
        if (this$tableFieldInfo == null ? other$tableFieldInfo != null : !this$tableFieldInfo.equals(other$tableFieldInfo)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        return !(this$property == null ? other$property != null : !this$property.equals(other$property));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableFieldInfoExt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableFieldInfo $tableFieldInfo = this.getTableFieldInfo();
        result = result * 59 + ($tableFieldInfo == null ? 43 : $tableFieldInfo.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        return result;
    }

    public String toString() {
        return "TableFieldInfoExt(tableFieldInfo=" + this.getTableFieldInfo() + ", column=" + this.getColumn() + ", property=" + this.getProperty() + ")";
    }
}

