/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.interceptor;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.toolkit.Db;
import icu.mhb.mybatisplus.plugln.annotations.FieldTrans;
import icu.mhb.mybatisplus.plugln.annotations.ManyToMany;
import icu.mhb.mybatisplus.plugln.annotations.OneToOne;
import icu.mhb.mybatisplus.plugln.config.ConfigUtil;
import icu.mhb.mybatisplus.plugln.config.MpjConfig;
import icu.mhb.mybatisplus.plugln.config.MybatisPlusJoinConfig;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.core.support.SupportJoinWrapper;
import icu.mhb.mybatisplus.plugln.entity.FieldMapping;
import icu.mhb.mybatisplus.plugln.entity.ManyToManySelectBuild;
import icu.mhb.mybatisplus.plugln.entity.OneToOneSelectBuild;
import icu.mhb.mybatisplus.plugln.enums.JoinSqlMethod;
import icu.mhb.mybatisplus.plugln.enums.PropertyType;
import icu.mhb.mybatisplus.plugln.exception.Exceptions;
import icu.mhb.mybatisplus.plugln.extend.Joins;
import icu.mhb.mybatisplus.plugln.injector.JoinDefaultResultType;
import icu.mhb.mybatisplus.plugln.tookit.ClassUtils;
import icu.mhb.mybatisplus.plugln.tookit.Lambdas;
import icu.mhb.mybatisplus.plugln.tookit.Lists;
import icu.mhb.mybatisplus.plugln.tookit.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class JoinInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(JoinInterceptor.class);
    @Autowired(required=false)
    private MybatisPlusJoinConfig mybatisPlusJoinConfig;
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (!(ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_COUNT.getMethod()) || ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_LIST.getMethod()) || ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_PAGE.getMethod()) || ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_ONE.getMethod()))) {
            return invocation.proceed();
        }
        if (!(args[1] instanceof Map)) {
            return invocation.proceed();
        }
        Map paramMap = (Map)args[1];
        Object ew = paramMap.getOrDefault("ew", null);
        Object returnClass = paramMap.getOrDefault("returnClassType0000000001111", null);
        if (null == ew) {
            return invocation.proceed();
        }
        if (ms.getId().endsWith(JoinSqlMethod.JOIN_SELECT_COUNT.getMethod()) ? !(ew instanceof SupportJoinWrapper) : !(ew instanceof SupportJoinWrapper) || returnClass == null) {
            return invocation.proceed();
        }
        SupportJoinWrapper joinWrapper = ew;
        Class classType = returnClass;
        List resultMaps = ms.getResultMaps();
        if (CollectionUtils.isEmpty((Collection)resultMaps)) {
            return invocation.proceed();
        }
        ResultMap resultMap = (ResultMap)resultMaps.get(0);
        if (resultMap.getType() != JoinDefaultResultType.class) {
            return invocation.proceed();
        }
        args[0] = this.createMappedStatement(ms, joinWrapper, classType);
        Object proceed = invocation.proceed();
        if (ObjectUtils.isNotEmpty((Object)proceed)) {
            this.processAnnotationMapping(proceed, classType);
        }
        return proceed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappedStatement createMappedStatement(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        Map<Configuration, MappedStatement> statementMap;
        if (ms == null || joinWrapper == null || classType == null) {
            throw Exceptions.mpje("Invalid parameters for creating MappedStatement", new Object[0]);
        }
        String msId = this.buildMappedStatementId(ms, joinWrapper, classType);
        Map<Configuration, MappedStatement> map = statementMap = this.isUseMsCache() ? MS_CACHE.get(msId) : null;
        if (statementMap != null && statementMap.containsKey(ms.getConfiguration())) {
            return statementMap.get(ms.getConfiguration());
        }
        MappedStatement newMs = this.buildNewMappedStatement(ms, msId, joinWrapper, classType);
        if (this.isUseMsCache()) {
            Map<String, Map<Configuration, MappedStatement>> map2 = MS_CACHE;
            synchronized (map2) {
                MS_CACHE.computeIfAbsent(msId, k -> new ConcurrentHashMap()).put(ms.getConfiguration(), newMs);
            }
        }
        return newMs;
    }

    private String buildMappedStatementId(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        if (!this.isUseMsCache()) {
            return ms.getId();
        }
        return (ms.getId() + ":" + classType.getName() + "_" + joinWrapper.getSqlSelect()).replaceAll("\\s+", "");
    }

    private MappedStatement buildNewMappedStatement(MappedStatement ms, String id, SupportJoinWrapper joinWrapper, Class<?> classType) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length > 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        ResultMap resultMap = this.createResultMap(ms, joinWrapper, classType);
        builder.resultMaps(Lists.newArrayList(resultMap));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultMap createResultMap(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        if (ms == null || joinWrapper == null || classType == null) {
            throw Exceptions.mpje("Invalid parameters for creating ResultMap", new Object[0]);
        }
        String resultMapId = this.buildResultMapId(ms, joinWrapper, classType);
        Configuration configuration = ms.getConfiguration();
        try {
            if (PropertyType.hasBaseType(classType) || ClassUtils.hasIncludeClass(classType, Map.class)) {
                return new ResultMap.Builder(configuration, resultMapId, classType, Collections.emptyList()).build();
            }
            if (configuration.hasResultMap(resultMapId)) {
                return configuration.getResultMap(resultMapId);
            }
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                if (configuration.hasResultMap(resultMapId)) {
                    return configuration.getResultMap(resultMapId);
                }
                List<ResultMapping> resultMappings = this.buildResultMappings(configuration, joinWrapper.getFieldMappingList(), classType);
                this.processOneToOneMapping(configuration, resultMapId, joinWrapper, resultMappings);
                this.processManyToManyMapping(configuration, resultMapId, joinWrapper, resultMappings);
                ResultMap resultMap = new ResultMap.Builder(configuration, resultMapId, classType, resultMappings).build();
                try {
                    configuration.addResultMap(resultMap);
                }
                catch (IllegalArgumentException e) {
                    log.debug("ResultMap [{}] already exists, using existing one", (Object)resultMapId);
                    return configuration.getResultMap(resultMapId);
                }
                return resultMap;
            }
        }
        catch (Exception e) {
            throw Exceptions.mpje("Failed to create ResultMap for id: %s", e, resultMapId);
        }
    }

    private void processOneToOneMapping(Configuration configuration, String baseId, SupportJoinWrapper joinWrapper, List<ResultMapping> resultMappings) {
        List<OneToOneSelectBuild> oneToOneBuilds = joinWrapper.getOneToOneSelectBuildList();
        if (CollectionUtils.isEmpty(oneToOneBuilds)) {
            return;
        }
        for (OneToOneSelectBuild build : oneToOneBuilds) {
            String oneToOneId = baseId + "_" + build.getOneToOneField();
            if (!configuration.hasResultMap(oneToOneId = oneToOneId.replaceAll("\\s+", ""))) {
                ResultMap oneToOneResultMap = new ResultMap.Builder(configuration, oneToOneId, build.getOneToOneClass(), this.buildResultMappings(configuration, build.getBelongsColumns(), build.getOneToOneClass())).build();
                this.addResultMapSafely(configuration, oneToOneResultMap, oneToOneId);
            }
            resultMappings.add(new ResultMapping.Builder(configuration, build.getOneToOneField()).javaType(build.getOneToOneClass()).nestedResultMapId(oneToOneId).build());
        }
    }

    private void processManyToManyMapping(Configuration configuration, String baseId, SupportJoinWrapper joinWrapper, List<ResultMapping> resultMappings) {
        List<ManyToManySelectBuild> manyToManyBuilds = joinWrapper.getManyToManySelectBuildList();
        if (CollectionUtils.isEmpty(manyToManyBuilds)) {
            return;
        }
        for (ManyToManySelectBuild build : manyToManyBuilds) {
            String manyToManyId = baseId + "_" + build.getManyToManyField();
            if (!configuration.hasResultMap(manyToManyId = manyToManyId.replaceAll("\\s+", ""))) {
                ResultMap manyToManyResultMap = new ResultMap.Builder(configuration, manyToManyId, build.getManyToManyClass(), this.buildResultMappings(configuration, build.getBelongsColumns(), build.getManyToManyClass())).build();
                this.addResultMapSafely(configuration, manyToManyResultMap, manyToManyId);
            }
            resultMappings.add(new ResultMapping.Builder(configuration, build.getManyToManyField()).javaType(build.getManyToManyPropertyType()).nestedResultMapId(manyToManyId).build());
        }
    }

    private synchronized void addResultMapSafely(Configuration configuration, ResultMap resultMap, String id) {
        if (configuration == null || resultMap == null || StringUtils.isBlank((CharSequence)id)) {
            throw Exceptions.mpje("Invalid parameters for adding ResultMap", new Object[0]);
        }
        try {
            if (!configuration.hasResultMap(id)) {
                configuration.addResultMap(resultMap);
            }
        }
        catch (IllegalArgumentException e) {
            log.debug("ResultMap [{}] already exists, ignore", (Object)id);
        }
        catch (Exception e) {
            throw Exceptions.mpje("Failed to add ResultMap: %s", e, id);
        }
    }

    private String buildResultMapId(MappedStatement ms, SupportJoinWrapper joinWrapper, Class<?> classType) {
        return (ms.getId() + ":" + classType.getName() + "_" + joinWrapper.getSqlSelect()).replaceAll("\\s+", "");
    }

    private List<ResultMapping> buildResultMappings(Configuration configuration, List<FieldMapping> fieldMappings, Class<?> clz) {
        if (CollectionUtils.isEmpty(fieldMappings)) {
            throw Exceptions.mpje("No field mappings found for class: %s", clz.getName());
        }
        return fieldMappings.stream().map(fieldMapping -> {
            try {
                return this.buildResultMapping(configuration, (FieldMapping)fieldMapping, clz);
            }
            catch (Exception e) {
                throw Exceptions.mpje("Failed to build ResultMapping", e, new Object[0]);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ResultMapping buildResultMapping(Configuration configuration, FieldMapping fieldMapping, Class<?> clz) {
        try {
            Field field = ClassUtils.getDeclaredField(clz, fieldMapping.getFieldName());
            if (field == null) {
                return null;
            }
            if (fieldMapping.getTableFieldInfoExt() != null) {
                return fieldMapping.getTableFieldInfoExt().getResultMapping(configuration);
            }
            String columnName = com.baomidou.mybatisplus.core.toolkit.StringUtils.getTargetColumn((String)fieldMapping.getColumn());
            return new ResultMapping.Builder(configuration, field.getName(), columnName, field.getType()).build();
        }
        catch (Exception e) {
            throw Exceptions.mpje("Failed to build ResultMapping for field: %s", e, fieldMapping.getFieldName());
        }
    }

    private boolean isUseMsCache() {
        if (this.mybatisPlusJoinConfig == null) {
            MpjConfig config = ConfigUtil.getConfig();
            return config.isUseMsCache();
        }
        return this.mybatisPlusJoinConfig.isUseMsCache();
    }

    private void processAnnotationMapping(Object result, Class<?> returnClass) {
        try {
            List dataList = null;
            dataList = result instanceof Collection ? (List)result : (result instanceof IPage ? ((IPage)result).getRecords() : Collections.singletonList(result));
            if (CollectionUtils.isEmpty((Collection)dataList)) {
                return;
            }
            Map fieldMap = ReflectionKit.getFieldMap(returnClass);
            HashMap<String, OneToOneAnnotationInfo> oneToOneMap = new HashMap<String, OneToOneAnnotationInfo>();
            HashMap<String, ManyToManyAnnotationInfo> manyToManyMap = new HashMap<String, ManyToManyAnnotationInfo>();
            HashMap<String, FieldTransAnnotationInfo> fieldTransMap = new HashMap<String, FieldTransAnnotationInfo>();
            fieldMap.forEach((fieldName, field) -> {
                FieldTrans fieldTrans;
                ManyToMany manyToMany;
                OneToOne oneToOne = field.getAnnotation(OneToOne.class);
                if (oneToOne != null) {
                    oneToOneMap.put((String)fieldName, new OneToOneAnnotationInfo((Field)field, oneToOne));
                }
                if ((manyToMany = field.getAnnotation(ManyToMany.class)) != null) {
                    manyToManyMap.put((String)fieldName, new ManyToManyAnnotationInfo((Field)field, manyToMany));
                }
                if ((fieldTrans = field.getAnnotation(FieldTrans.class)) != null) {
                    fieldTransMap.put((String)fieldName, new FieldTransAnnotationInfo((Field)field, fieldTrans));
                }
            });
            if (!oneToOneMap.isEmpty()) {
                this.processOneToOneAnnotation(dataList, oneToOneMap, fieldMap);
            }
            if (!manyToManyMap.isEmpty()) {
                this.processManyToManyAnnotation(dataList, manyToManyMap, fieldMap);
            }
            if (!fieldTransMap.isEmpty()) {
                this.processFieldTransAnnotation(dataList, fieldTransMap, fieldMap);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6ce8\u89e3\u6620\u5c04\u5931\u8d25", (Throwable)e);
            throw Exceptions.mpje("\u5904\u7406\u6ce8\u89e3\u6620\u5c04\u5931\u8d25", e, new Object[0]);
        }
    }

    private void processOneToOneAnnotation(Collection<?> dataList, Map<String, OneToOneAnnotationInfo> oneToOneMap, Map<String, Field> fieldMap) {
        for (Map.Entry<String, OneToOneAnnotationInfo> entry : oneToOneMap.entrySet()) {
            String fieldName = entry.getKey();
            OneToOneAnnotationInfo info = entry.getValue();
            OneToOne oneToOne = info.annotation;
            Field annotatedField = info.field;
            try {
                Field refField = fieldMap.get(oneToOne.ref());
                if (refField == null) {
                    log.warn("OneToOne\u6ce8\u89e3\u7684ref\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728", (Object)oneToOne.ref());
                    continue;
                }
                refField.setAccessible(true);
                annotatedField.setAccessible(true);
                HashSet<Object> queryValues = new HashSet<Object>();
                for (Object data : dataList) {
                    Object value = annotatedField.get(data);
                    if (value == null) continue;
                    queryValues.add(value);
                }
                if (queryValues.isEmpty()) continue;
                TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)oneToOne.targetSub());
                String targetIdField = StringUtils.isNotBlank((CharSequence)oneToOne.targetSubId()) ? oneToOne.targetSubId() : tableInfo.getKeyProperty();
                Class<?> refFieldType = refField.getType();
                List subList = ((JoinLambdaWrapper)Joins.of(oneToOne.targetSub()).in(Lambdas.getSFunction(oneToOne.targetSub(), this.getFieldType(oneToOne.targetSub(), targetIdField), targetIdField), queryValues)).joinList(refFieldType);
                if (CollectionUtils.isEmpty((Collection)subList)) continue;
                Field targetIdFieldObj = ClassUtils.getDeclaredField(refFieldType, targetIdField);
                if (targetIdFieldObj == null) {
                    log.warn("\u76ee\u6807\u8868[{}]\u7684ID\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728", (Object)refFieldType.getName(), (Object)targetIdField);
                    continue;
                }
                targetIdFieldObj.setAccessible(true);
                boolean needConvert = !refFieldType.equals(oneToOne.targetSub());
                HashMap<Object, Object> subDataMap = new HashMap<Object, Object>();
                for (Object subData : subList) {
                    Object subIdValue = targetIdFieldObj.get(subData);
                    if (subIdValue == null) continue;
                    if (needConvert) {
                        Object convertedData = this.convertToVO(subData, refFieldType);
                        if (convertedData == null) continue;
                        subDataMap.put(subIdValue, convertedData);
                        continue;
                    }
                    subDataMap.put(subIdValue, subData);
                }
                for (Object data : dataList) {
                    Object queryValue = annotatedField.get(data);
                    if (queryValue == null || !subDataMap.containsKey(queryValue)) continue;
                    refField.set(data, subDataMap.get(queryValue));
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406OneToOne\u6ce8\u89e3[{}]\u5931\u8d25", (Object)fieldName, (Object)e);
            }
        }
    }

    private void processManyToManyAnnotation(Collection<?> dataList, Map<String, ManyToManyAnnotationInfo> manyToManyMap, Map<String, Field> fieldMap) {
        for (Map.Entry<String, ManyToManyAnnotationInfo> entry : manyToManyMap.entrySet()) {
            String fieldName = entry.getKey();
            ManyToManyAnnotationInfo info = entry.getValue();
            ManyToMany manyToMany = info.annotation;
            Field annotatedField = info.field;
            try {
                Field refField = fieldMap.get(manyToMany.ref());
                if (refField == null) {
                    log.warn("ManyToMany\u6ce8\u89e3\u7684ref\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728", (Object)manyToMany.ref());
                    continue;
                }
                refField.setAccessible(true);
                annotatedField.setAccessible(true);
                HashSet<Object> queryValues = new HashSet<Object>();
                for (Object data : dataList) {
                    Object value = annotatedField.get(data);
                    if (value == null) continue;
                    queryValues.add(value);
                }
                if (queryValues.isEmpty()) continue;
                TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)manyToMany.targetSub());
                String targetIdField = StringUtils.isNotBlank((CharSequence)manyToMany.targetSubId()) ? manyToMany.targetSubId() : tableInfo.getKeyProperty();
                Class<?> listGenericType = this.getListGenericType(refField);
                if (null == listGenericType) {
                    log.warn("\u8bf7\u5b9a\u4e49{}\u5b57\u6bb5\u7684List\u6cdb\u578b\uff01", (Object)refField.toString());
                    continue;
                }
                List subList = ((JoinLambdaWrapper)Joins.of(manyToMany.targetSub()).in(Lambdas.getSFunction(manyToMany.targetSub(), this.getFieldType(manyToMany.targetSub(), targetIdField), targetIdField), queryValues)).joinList(listGenericType);
                if (CollectionUtils.isEmpty((Collection)subList)) continue;
                Field targetIdFieldObj = ClassUtils.getDeclaredField(listGenericType, targetIdField);
                if (targetIdFieldObj == null) {
                    log.warn("\u76ee\u6807\u8868[{}]\u7684ID\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728", (Object)listGenericType.getName(), (Object)targetIdField);
                    continue;
                }
                targetIdFieldObj.setAccessible(true);
                boolean needConvert = listGenericType != null && !listGenericType.equals(manyToMany.targetSub());
                HashMap<Object, List> subDataMap = new HashMap<Object, List>();
                for (Object subData : subList) {
                    Object subIdValue = targetIdFieldObj.get(subData);
                    if (subIdValue == null) continue;
                    Object dataToAdd = subData;
                    if (needConvert && (dataToAdd = this.convertToVO(subData, listGenericType)) == null) continue;
                    subDataMap.computeIfAbsent(subIdValue, k -> new ArrayList()).add(dataToAdd);
                }
                for (Object data : dataList) {
                    Object queryValue = annotatedField.get(data);
                    if (queryValue == null) continue;
                    List subDataList = (List)subDataMap.get(queryValue);
                    if (subDataList != null) {
                        refField.set(data, subDataList);
                        continue;
                    }
                    refField.set(data, new ArrayList());
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406ManyToMany\u6ce8\u89e3[{}]\u5931\u8d25", (Object)fieldName, (Object)e);
            }
        }
    }

    private void processFieldTransAnnotation(Collection<?> dataList, Map<String, FieldTransAnnotationInfo> fieldTransMap, Map<String, Field> fieldMap) {
        for (Map.Entry<String, FieldTransAnnotationInfo> entry : fieldTransMap.entrySet()) {
            String fieldName = entry.getKey();
            FieldTransAnnotationInfo info = entry.getValue();
            FieldTrans fieldTrans = info.annotation;
            Field annotatedField = info.field;
            try {
                String targetIdField;
                annotatedField.setAccessible(true);
                HashMap<String, String> fieldMappingConfig = new HashMap<String, String>();
                for (String mapping : fieldTrans.tagetFiledOrRef()) {
                    String[] parts = mapping.split(":");
                    if (parts.length == 2) {
                        String sourceField = parts[0].trim();
                        String targetField = parts[1].trim();
                        fieldMappingConfig.put(sourceField, targetField);
                        continue;
                    }
                    log.warn("FieldTrans\u914d\u7f6e\u683c\u5f0f\u9519\u8bef: {}", (Object)mapping);
                }
                if (fieldMappingConfig.isEmpty()) {
                    log.warn("FieldTrans\u6ce8\u89e3[{}]\u6ca1\u6709\u6709\u6548\u7684\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e", (Object)fieldName);
                    continue;
                }
                HashSet<Object> queryValues = new HashSet<Object>();
                for (Object data : dataList) {
                    Object value = annotatedField.get(data);
                    if (value == null) continue;
                    queryValues.add(value);
                }
                if (queryValues.isEmpty()) continue;
                TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)fieldTrans.targetSub());
                String string = targetIdField = StringUtils.isNotBlank((CharSequence)fieldTrans.targetSubId()) ? fieldTrans.targetSubId() : tableInfo.getKeyProperty();
                List subList = ((LambdaQueryChainWrapper)Db.lambdaQuery((Class)fieldTrans.targetSub()).in((Object)Lambdas.getSFunction(fieldTrans.targetSub(), this.getFieldType(fieldTrans.targetSub(), targetIdField), targetIdField), queryValues)).list();
                if (CollectionUtils.isEmpty((Collection)subList)) continue;
                Field targetIdFieldObj = ClassUtils.getDeclaredField(fieldTrans.targetSub(), targetIdField);
                if (targetIdFieldObj == null) {
                    log.warn("\u76ee\u6807\u8868[{}]\u7684ID\u5b57\u6bb5[{}]\u4e0d\u5b58\u5728", (Object)fieldTrans.targetSub().getName(), (Object)targetIdField);
                    continue;
                }
                targetIdFieldObj.setAccessible(true);
                HashMap subDataMap = new HashMap();
                for (Object subData : subList) {
                    Object subIdValue = targetIdFieldObj.get(subData);
                    if (subIdValue == null) continue;
                    subDataMap.put(subIdValue, subData);
                }
                for (Object data : dataList) {
                    Object queryValue = annotatedField.get(data);
                    if (queryValue == null || !subDataMap.containsKey(queryValue)) continue;
                    Object subData = subDataMap.get(queryValue);
                    for (Map.Entry mappingEntry : fieldMappingConfig.entrySet()) {
                        String sourceFieldName = (String)mappingEntry.getKey();
                        String targetFieldName = (String)mappingEntry.getValue();
                        try {
                            Field sourceField = ClassUtils.getDeclaredField(fieldTrans.targetSub(), sourceFieldName);
                            if (sourceField == null) {
                                log.warn("\u5b50\u8868[{}]\u4e0d\u5b58\u5728\u5b57\u6bb5[{}]", (Object)fieldTrans.targetSub().getName(), (Object)sourceFieldName);
                                continue;
                            }
                            sourceField.setAccessible(true);
                            Object sourceValue = sourceField.get(subData);
                            Field targetField = fieldMap.get(targetFieldName);
                            if (targetField == null) {
                                log.warn("\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728\u5b57\u6bb5[{}]", (Object)targetFieldName);
                                continue;
                            }
                            targetField.setAccessible(true);
                            if (sourceValue != null && targetField.getType().isAssignableFrom(sourceField.getType())) {
                                targetField.set(data, sourceValue);
                                continue;
                            }
                            if (sourceValue == null) continue;
                            log.debug("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d: {} -> {}", sourceField.getType(), targetField.getType());
                        }
                        catch (Exception e) {
                            log.error("\u5b57\u6bb5\u6620\u5c04\u5931\u8d25: {} -> {}", new Object[]{sourceFieldName, targetFieldName, e});
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406FieldTrans\u6ce8\u89e3[{}]\u5931\u8d25", (Object)fieldName, (Object)e);
            }
        }
    }

    private Class<?> getFieldType(Class<?> clazz, String fieldName) {
        try {
            Field field = ClassUtils.getDeclaredField(clazz, fieldName);
            if (field != null) {
                return field.getType();
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5b57\u6bb5\u7c7b\u578b\u5931\u8d25: {}.{}", (Object)clazz.getName(), (Object)fieldName);
        }
        return Object.class;
    }

    private Class<?> getListGenericType(Field field) {
        try {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Type genericType;
            if (field.getType().isAssignableFrom(List.class) && (genericType = field.getGenericType()) instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
                return (Class)actualTypeArguments[0];
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6List\u6cdb\u578b\u7c7b\u578b\u5931\u8d25: {}", (Object)field.getName(), (Object)e);
        }
        return null;
    }

    private Object convertToVO(Object source, Class<?> targetClass) {
        if (source == null || targetClass == null) {
            return null;
        }
        try {
            Object target = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25: {} -> {}", new Object[]{source.getClass().getName(), targetClass.getName(), e});
            return null;
        }
    }

    private static class FieldTransAnnotationInfo {
        Field field;
        FieldTrans annotation;

        FieldTransAnnotationInfo(Field field, FieldTrans annotation) {
            this.field = field;
            this.annotation = annotation;
        }
    }

    private static class ManyToManyAnnotationInfo {
        Field field;
        ManyToMany annotation;

        ManyToManyAnnotationInfo(Field field, ManyToMany annotation) {
            this.field = field;
            this.annotation = annotation;
        }
    }

    private static class OneToOneAnnotationInfo {
        Field field;
        OneToOne annotation;

        OneToOneAnnotationInfo(Field field, OneToOne annotation) {
            this.field = field;
            this.annotation = annotation;
        }
    }
}

