/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.processor;

import icu.mhb.mybatisplus.plugln.tookit.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"icu.mhb.mybatisplus.plugln.annotations.JoinChainModel"})
public class JoinChainModelProcessor
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "cssc");
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                if (!(element instanceof TypeElement)) continue;
                this.generateClass((TypeElement)element);
            }
        }
        return true;
    }

    private void generateClass(TypeElement element) {
        String rawClassName = element.getSimpleName().toString();
        String rawPackageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
        String className = element.getSimpleName().toString() + "Chain";
        String packageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString() + "." + "chain";
        try {
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, new Element[0]);
            try (PrintWriter writer = new PrintWriter(file.openWriter());){
                StringBuilder sb = new StringBuilder();
                List<Element> elementList = element.getEnclosedElements().stream().filter(e -> e.getKind().isField()).collect(Collectors.toList());
                this.buildClassBaseInfo(sb, packageName, rawPackageName, rawClassName, className);
                sb.append("\n");
                this.buildFieldConstantInfo(sb, elementList);
                sb.append("\n");
                this.buildConstructor(sb, className, rawClassName, true);
                sb.append("\n");
                this.buildConstructor(sb, className, rawClassName, false);
                sb.append("\n");
                this.buildSetEntityMethod(sb, packageName, rawPackageName, rawClassName, className);
                sb.append("\n");
                this.buildCreateMethod(sb, className, false);
                sb.append("\n");
                this.buildCreateMethod(sb, className, true);
                sb.append("\n");
                this.buildFieldMethodInfo(sb, className, elementList);
                sb.append("}");
                writer.println(sb.toString());
            }
        }
        catch (IOException e2) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to create source file for " + className);
        }
    }

    private void buildFieldMethodInfo(StringBuilder writer, String className, List<Element> elementList) {
        for (Element element : elementList) {
            String fieldName = element.getSimpleName().toString();
            String fieldType = ((DeclaredType)element.asType()).asElement().getSimpleName().toString();
            HashMap<String, String> param = new HashMap<String, String>(){
                {
                    this.put(Object.class.getSimpleName(), "val");
                }
            };
            this.buildMethodHeader(writer, false, fieldName, className, (Map<String, String>)param);
            writer.append("\t").append("\t").append("super").append(".").append("add").append("(").append(StringUtils.camelToUnderline((String)fieldName).toUpperCase()).append(",").append("val").append(")").append(";").append("\n").append("\t").append("\t").append("return").append(" ").append("this").append(";").append("\n").append("\t").append("}").append("\n");
            this.buildMethodHeader(writer, false, fieldName, className, null);
            writer.append("\t").append("\t").append("return").append(" ").append(fieldName).append("(").append("null").append(")").append(";").append("\n").append("\t").append("}").append("\n");
            this.buildMethodHeader(writer, false, "_" + fieldName, "ChainFieldData", null);
            writer.append("\t").append("\t").append("return").append(" ").append("super").append(".").append("buildChainFieldData").append("(").append(StringUtils.camelToUnderline((String)fieldName).toUpperCase()).append(",").append("null").append(")").append(";").append("\n").append("\t").append("}").append("\n");
            this.buildMethodHeader(writer, false, "_" + fieldName, "ChainFieldData", (Map<String, String>)param);
            writer.append("\t").append("\t").append("return").append(" ").append("super").append(".").append("buildChainFieldData").append("(").append(StringUtils.camelToUnderline((String)fieldName).toUpperCase()).append(",").append("val").append(")").append(";").append("\n").append("\t").append("}").append("\n");
        }
    }

    private void buildFieldConstantInfo(StringBuilder writer, List<Element> elements) {
        for (Element element : elements) {
            String fieldName = element.getSimpleName().toString();
            String fieldType = ((DeclaredType)element.asType()).asElement().getSimpleName().toString();
            writer.append("\t").append("private").append(" ").append("static").append(" ").append("final").append(" ").append("String").append(" ").append(StringUtils.camelToUnderline((String)fieldName).toUpperCase()).append(" ").append("=").append(" ").append("\"").append(fieldName).append("\"").append(";").append("\n");
        }
    }

    private void buildClassBaseInfo(StringBuilder writer, String packageName, String rawPackageName, String rawClassName, String className) {
        writer.append("package").append(" ").append(packageName).append(";").append("\n");
        writer.append("import icu.mhb.mybatisplus.plugln.entity.BaseChainModel;").append("\n");
        writer.append("import icu.mhb.mybatisplus.plugln.entity.ChainFieldData;").append("\n");
        writer.append("import").append(" ").append(rawPackageName).append(".").append(rawClassName).append(";").append("\n");
        writer.append("/** \n * This file is automatically generated, please do not modify it manually \n * generation tool\uff1amybatis-plus-join \n * author\uff1amahuibo \n */ \n");
        writer.append("public").append(" ").append("class").append(" ").append(className).append(" ").append("extends").append(" ").append("BaseChainModel").append("<").append(className).append(">").append("{").append("\n");
        writer.append("\n");
    }

    private void buildSetEntityMethod(StringBuilder writer, String packageName, String rawPackageName, final String rawClassName, String className) {
        this.buildMethodHeader(writer, false, "setEntity", className, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put(rawClassName, "val");
            }
        });
        writer.append("\t").append("\t").append("super").append(".").append("setEntity").append("(").append("val").append(")").append(";").append("\n").append("\t").append("\t").append("return").append(" ").append("this").append(";").append("\n").append("\t").append("}").append("\n");
    }

    private void buildCreateMethod(StringBuilder writer, String className, boolean isParam) {
        HashMap<String, String> params = null;
        if (isParam) {
            params = new HashMap<String, String>(){
                {
                    this.put("String", "alias");
                }
            };
        }
        this.buildMethodHeader(writer, true, "create", className, (Map<String, String>)params);
        writer.append("\t").append("\t").append("return").append(" ").append("new").append(" ").append(className).append("(");
        if (isParam) {
            writer.append("alias");
        }
        writer.append(")").append(";").append("\n").append("\t").append("}").append("\n");
    }

    private void buildConstructor(StringBuilder writer, String className, String rawClassName, boolean isParam) {
        HashMap<String, String> params = null;
        if (isParam) {
            params = new HashMap<String, String>(){
                {
                    this.put("String", "alias");
                }
            };
        }
        this.buildMethodHeader(writer, false, className, "", (Map<String, String>)params);
        writer.append("\t").append("\t").append("super").append("(");
        if (isParam) {
            writer.append("alias").append(",");
        }
        writer.append(rawClassName).append(".").append("class").append(")").append(";").append("\n").append("\t").append("}").append("\n");
    }

    private void buildMethodHeader(StringBuilder writer, boolean isStatic, String methodName, String returnName, Map<String, String> params) {
        writer.append("\t").append("public").append(" ");
        if (isStatic) {
            writer.append("static").append(" ");
        }
        writer.append(returnName).append(" ").append(methodName).append("(");
        String paramsStr = "";
        if (null != params && !params.isEmpty()) {
            paramsStr = params.entrySet().stream().map(e -> (String)e.getKey() + " " + (String)e.getValue()).collect(Collectors.joining(","));
        }
        writer.append(paramsStr).append(")").append(" ").append("{").append("\n");
    }

    private String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

