/*
 * Decompiled with CFR 0.152.
 */
package icu.weboys.io.monitor;

import icu.weboys.io.monitor.FileListenerAdaptor;
import icu.weboys.io.monitor.FileObFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileExecutorAdaptor {
    private Path path;
    private Path recordPath;
    private File record;
    private FileListenerAdaptor listenerAdaptor;
    private FileObFilter filter;
    private Map<Path, Boolean> recordMap = new ConcurrentHashMap<Path, Boolean>();
    private String jobName;

    public FileExecutorAdaptor(String jobName, FileListenerAdaptor listenerAdaptor, Path path, String[] filter) {
        this.listenerAdaptor = listenerAdaptor;
        this.path = path;
        this.filter = filter != null ? new FileObFilter(filter) : new FileObFilter();
        this.jobName = jobName;
        this.initialize();
    }

    private void initialize() {
        Throwable throwable;
        new File(System.getProperty("user.home"), ".fmtmp").mkdir();
        this.recordPath = Paths.get(System.getProperty("user.home") + "\\.fmtmp", this.jobName);
        this.recordPath.toFile().mkdir();
        HashMap<Path, Boolean> re = new HashMap<Path, Boolean>();
        try {
            throwable = null;
            try (Stream<Path> records = Files.walk(this.recordPath, 1, new FileVisitOption[0]);){
                re.putAll(records.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).distinct().collect(Collectors.toMap(k -> k.getFileName(), v -> true)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            throwable = null;
            try (Stream<Path> paths = Files.walk(this.path, 1, new FileVisitOption[0]);){
                this.recordMap.putAll(paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(k -> this.filter.isFI((Path)k)).distinct().collect(Collectors.toMap(k -> k, v -> false)));
                this.recordMap.keySet().stream().filter(k -> re.containsKey(k.getFileName())).forEach(k -> this.recordMap.put((Path)k, true));
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        HashMap re = new HashMap();
        try (Stream<Path> paths = Files.walk(this.path, 1, new FileVisitOption[0]);){
            Stream<Path> append = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(k -> this.filter.isFI((Path)k)).filter(k -> !this.recordMap.containsKey(k));
            append.forEach(k -> {
                try {
                    this.listenerAdaptor.onCreate(k.toFile());
                    re.put(k, true);
                    Files.createFile(Paths.get(new File(this.recordPath.toFile(), k.toFile().getName()).getPath(), new String[0]), new FileAttribute[0]);
                }
                catch (Exception exception) {
                    re.put(k, false);
                    exception.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (re.size() > 0) {
                this.recordMap.putAll(re);
            }
        }
        ArrayList removes = new ArrayList();
        try {
            this.recordMap.keySet().stream().filter(k -> !Files.exists(k, new LinkOption[0])).forEach(k -> {
                try {
                    this.listenerAdaptor.onDelete(k.toFile());
                    Files.delete(Paths.get(new File(this.recordPath.toFile(), k.toFile().getName()).getPath(), new String[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    removes.add(k);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (removes.size() > 0) {
                removes.forEach(k -> this.recordMap.remove(k));
            }
        }
        HashMap lou = new HashMap();
        try {
            this.recordMap.keySet().stream().filter(k -> this.recordMap.get(k) == false).forEach(k -> {
                try {
                    this.listenerAdaptor.onCreate(k.toFile());
                    lou.put(k, true);
                    Files.createFile(Paths.get(new File(this.recordPath.toFile(), k.toFile().getName()).getPath(), new String[0]), new FileAttribute[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (lou.size() > 0) {
                this.recordMap.putAll(lou);
            }
        }
    }
}

