/*
 * Decompiled with CFR 0.152.
 */
package icu.weboys.io.monitor;

import icu.weboys.io.monitor.FileExecutorAdaptor;
import icu.weboys.io.monitor.FileListenerAdaptor;
import icu.weboys.io.monitor.FileMonitorJob;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class FileMonitor {
    public static final String CONFIG = "config";
    private static Scheduler scheduler;
    private JobDetail job;
    private Trigger trigger;
    private int time;

    public static FileMonitorBuild builder() {
        return new FileMonitorBuild();
    }

    public FileMonitor(JobDetail job, int time) {
        this.job = job;
        this.time = time;
        this.trigger = TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)time)).build();
    }

    public boolean start() {
        Boolean b = false;
        try {
            scheduler.scheduleJob(this.job, this.trigger);
            b = true;
            return b;
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        finally {
            return b;
        }
    }

    public Boolean stop() {
        Boolean b = false;
        try {
            scheduler.deleteJob(this.job.getKey());
            b = true;
            return b;
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        finally {
            return b;
        }
    }

    public static void shutdown() throws SchedulerException {
        scheduler.shutdown(true);
    }

    static {
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    static class FileMonitorBuild {
        private String name;
        private String group;
        private int seconds;
        private String[] filter;
        private Path path;
        private FileListenerAdaptor listenerAdaptor;

        FileMonitorBuild() {
        }

        public FileMonitorBuild withIdentity(String name, String group) {
            this.name = name;
            this.group = group;
            return this;
        }

        public FileMonitorBuild time(int seconds) {
            this.seconds = seconds;
            return this;
        }

        public FileMonitorBuild filter(String ... filters) {
            this.filter = filters;
            return this;
        }

        public FileMonitorBuild bindListenAdaptor(FileListenerAdaptor listenerAdaptor) {
            this.listenerAdaptor = listenerAdaptor;
            return this;
        }

        public FileMonitorBuild setPath(String path) {
            this.path = Paths.get(path, new String[0]);
            return this;
        }

        public FileMonitor build() {
            JobDataMap c = new JobDataMap();
            c.put(FileMonitor.CONFIG, (Object)new FileExecutorAdaptor(String.format("%s.%s", this.group, this.name), this.listenerAdaptor, this.path, this.filter));
            return new FileMonitor(JobBuilder.newJob(FileMonitorJob.class).withIdentity(this.name, this.group).setJobData(c).build(), this.seconds);
        }
    }
}

