// Copyright (c) 2020-2021 DragonKnightOfBreeze Windea
// Breeze is blowing...

package icu.windea.breezeframework.core.type

import icu.windea.breezeframework.core.model.*

/**
 * 代表了一个二元素元组。
 *
 * Represents a tuple of two values.
 */
typealias Tuple2<A, B> = Pair<A, B>

/**
 * 代表了一个三元素元组。
 *
 * Represents a tuple of three values.
 */
typealias Tuple3<A, B, C> = Triple<A, B, C>

/**
 * 代表了一个四元素元组。
 *
 * Represents a tuple of four values.
 */
typealias Tuple4<A, B, C, D> = Quadruple<A, B, C, D>

/**
 * 代表了一个五元素元组。
 *
 * Represents a tuple of five values.
 */
typealias Tuple5<A, B, C, D, E> = Quintuple<A, B, C, D, E>


/**
 * 代表了一个单一类型的二元素元组。
 *
 * Represents a typed tuple of two values.
 */
typealias TypedTuple2<T> = Pair<T, T>

/**
 * 代表了一个单一类型的三元素元组。
 *
 * Represents a typed tuple of three values.
 */
typealias TypedTuple3<T> = Triple<T, T, T>

/**
 * 代表了一个单一类型的四元素元组。
 *
 * Represents a typed tuple of four values.
 */
typealias TypedTuple4<T> = Quadruple<T, T, T, T>

/**
 * 代表了一个单一类型的五元素元组。
 *
 * Represents a typed tuple of five values.
 */
typealias TypedTuple5<T> = Quintuple<T, T, T, T, T>



