/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.annotation.UnstableApi;
import icu.windea.breezeframework.core.component.AbstractComponentRegistry;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.extension.StringExtensions;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bg\u0018\u0000 \f2\u00020\u0001:\u0006\b\t\n\u000b\f\rJ\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H&J\u001a\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Licu/windea/breezeframework/core/component/Encoder;", "Licu/windea/breezeframework/core/component/Component;", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "Base64Encoder", "Base64MimeEncoder", "Base64UrlEncoder", "HexEncoder", "Registry", "UrlEncoder", "breeze-core"})
@UnstableApi
public interface Encoder
extends Component {
    @NotNull
    public static final Registry Registry = icu.windea.breezeframework.core.component.Encoder$Registry.$$INSTANCE;

    @NotNull
    public String encode(@NotNull String var1, @NotNull Charset var2);

    public static /* synthetic */ String encode$default(Encoder encoder, String string, Charset charset, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encode");
        }
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return encoder.encode(string, charset);
    }

    @NotNull
    public String decode(@NotNull String var1, @NotNull Charset var2);

    public static /* synthetic */ String decode$default(Encoder encoder, String string, Charset charset, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decode");
        }
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return encoder.decode(string, charset);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoder$Base64Encoder;", "Licu/windea/breezeframework/core/component/Encoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class Base64Encoder
    implements Encoder {
        @NotNull
        public static final Base64Encoder INSTANCE;

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Base64.Encoder encoder = Base64.getEncoder();
            String string = value;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String string2 = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.getEncoder().enco\u2026lue.toByteArray(charset))");
            return string2;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = Base64.getDecoder().decode(value);
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byte[] byArray2 = it;
            Charset charset2 = charset;
            boolean bl4 = false;
            return new String(byArray2, charset2);
        }

        private Base64Encoder() {
        }

        static {
            Base64Encoder base64Encoder;
            INSTANCE = base64Encoder = new Base64Encoder();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoder$Base64UrlEncoder;", "Licu/windea/breezeframework/core/component/Encoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class Base64UrlEncoder
    implements Encoder {
        @NotNull
        public static final Base64UrlEncoder INSTANCE;

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Base64.Encoder encoder = Base64.getUrlEncoder();
            String string = value;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String string2 = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.getUrlEncoder().e\u2026lue.toByteArray(charset))");
            return string2;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = Base64.getUrlDecoder().decode(value);
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byte[] byArray2 = it;
            Charset charset2 = charset;
            boolean bl4 = false;
            return new String(byArray2, charset2);
        }

        private Base64UrlEncoder() {
        }

        static {
            Base64UrlEncoder base64UrlEncoder;
            INSTANCE = base64UrlEncoder = new Base64UrlEncoder();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoder$Base64MimeEncoder;", "Licu/windea/breezeframework/core/component/Encoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class Base64MimeEncoder
    implements Encoder {
        @NotNull
        public static final Base64MimeEncoder INSTANCE;

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Base64.Encoder encoder = Base64.getMimeEncoder();
            String string = value;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String string2 = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.getMimeEncoder().\u2026lue.toByteArray(charset))");
            return string2;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] byArray = Base64.getMimeDecoder().decode(value);
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byte[] byArray2 = it;
            Charset charset2 = charset;
            boolean bl4 = false;
            return new String(byArray2, charset2);
        }

        private Base64MimeEncoder() {
        }

        static {
            Base64MimeEncoder base64MimeEncoder;
            INSTANCE = base64MimeEncoder = new Base64MimeEncoder();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoder$UrlEncoder;", "Licu/windea/breezeframework/core/component/Encoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class UrlEncoder
    implements Encoder {
        @NotNull
        public static final UrlEncoder INSTANCE;

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = URLEncoder.encode(value, charset.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(value, charset.name())");
            return string;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = URLDecoder.decode(value, charset.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLDecoder.decode(value, charset.name())");
            return string;
        }

        private UrlEncoder() {
        }

        static {
            UrlEncoder urlEncoder;
            INSTANCE = urlEncoder = new UrlEncoder();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoder$HexEncoder;", "Licu/windea/breezeframework/core/component/Encoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class HexEncoder
    implements Encoder {
        @NotNull
        public static final HexEncoder INSTANCE;

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return StringExtensions.hex(value, charset);
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return StringExtensions.unhex(value, charset);
        }

        private HexEncoder() {
        }

        static {
            HexEncoder hexEncoder;
            INSTANCE = hexEncoder = new HexEncoder();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Licu/windea/breezeframework/core/component/Encoder$Registry;", "Licu/windea/breezeframework/core/component/AbstractComponentRegistry;", "Licu/windea/breezeframework/core/component/Encoder;", "()V", "registerDefault", "", "breeze-core"})
    public static final class Registry
    extends AbstractComponentRegistry<Encoder> {
        static final /* synthetic */ Registry $$INSTANCE;

        @Override
        protected void registerDefault() {
            this.register((Component)Base64Encoder.INSTANCE);
            this.register((Component)Base64UrlEncoder.INSTANCE);
            this.register((Component)Base64MimeEncoder.INSTANCE);
            this.register((Component)UrlEncoder.INSTANCE);
            this.register((Component)HexEncoder.INSTANCE);
        }

        private Registry() {
        }

        static {
            Registry registry;
            $$INSTANCE = registry = new Registry();
        }
    }
}

