/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.annotation.UnstableApi;
import icu.windea.breezeframework.core.component.AbstractComponentRegistry;
import icu.windea.breezeframework.core.component.Component;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000f\bg\u0018\u0000 \f2\u00020\u0001:\u000b\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H&J\u001c\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Licu/windea/breezeframework/core/component/Encrypter;", "Licu/windea/breezeframework/core/component/Component;", "decrypt", "", "value", "secret", "encrypt", "AesEncrypter", "CipherEncrypter", "DesEncrypter", "Md5Encrypter", "MessageDigestEncrypter", "Registry", "Sha3_256Encrypter", "Sha3_512Encrypter", "Sha_1Encrypter", "Sha_256Encrypter", "Sha_512Encrypter", "breeze-core"})
@UnstableApi
public interface Encrypter
extends Component {
    @NotNull
    public static final Registry Registry = icu.windea.breezeframework.core.component.Encrypter$Registry.$$INSTANCE;

    @NotNull
    public byte[] encrypt(@NotNull byte[] var1, @Nullable byte[] var2);

    public static /* synthetic */ byte[] encrypt$default(Encrypter encrypter, byte[] byArray, byte[] byArray2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encrypt");
        }
        if ((n & 2) != 0) {
            byArray2 = null;
        }
        return encrypter.encrypt(byArray, byArray2);
    }

    @NotNull
    public byte[] decrypt(@NotNull byte[] var1, @Nullable byte[] var2);

    public static /* synthetic */ byte[] decrypt$default(Encrypter encrypter, byte[] byArray, byte[] byArray2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: decrypt");
        }
        if ((n & 2) != 0) {
            byArray2 = null;
        }
        return encrypter.decrypt(byArray, byArray2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$CipherEncrypter;", "Licu/windea/breezeframework/core/component/Encrypter;", "transformation", "", "(Ljava/lang/String;)V", "cipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "getTransformation", "()Ljava/lang/String;", "decrypt", "", "value", "secret", "encrypt", "breeze-core"})
    public static class CipherEncrypter
    implements Encrypter {
        private final Cipher cipher;
        @NotNull
        private final String transformation;

        @Override
        @NotNull
        public byte[] encrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (secret == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            SecretKeySpec keySpec = new SecretKeySpec(secret, this.transformation);
            if (StringsKt.contains$default((CharSequence)this.transformation, (CharSequence)"CBC", (boolean)false, (int)2, null)) {
                this.cipher.init(1, (Key)keySpec, new IvParameterSpec(secret));
            } else {
                this.cipher.init(1, keySpec);
            }
            byte[] byArray = this.cipher.doFinal(value);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(value)");
            return byArray;
        }

        @Override
        @NotNull
        public byte[] decrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (secret == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            SecretKeySpec keySpec = new SecretKeySpec(secret, this.transformation);
            if (StringsKt.contains$default((CharSequence)this.transformation, (CharSequence)"CBC", (boolean)false, (int)2, null)) {
                this.cipher.init(2, (Key)keySpec, new IvParameterSpec(secret));
            } else {
                this.cipher.init(2, keySpec);
            }
            byte[] byArray = this.cipher.doFinal(value);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(value)");
            return byArray;
        }

        @NotNull
        public final String getTransformation() {
            return this.transformation;
        }

        public CipherEncrypter(@NotNull String transformation) {
            Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
            this.transformation = transformation;
            this.cipher = Cipher.getInstance(this.transformation);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$DesEncrypter;", "Licu/windea/breezeframework/core/component/Encrypter$CipherEncrypter;", "()V", "breeze-core"})
    public static final class DesEncrypter
    extends CipherEncrypter {
        @NotNull
        public static final DesEncrypter INSTANCE;

        private DesEncrypter() {
            super("DES");
        }

        static {
            DesEncrypter desEncrypter;
            INSTANCE = desEncrypter = new DesEncrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$AesEncrypter;", "Licu/windea/breezeframework/core/component/Encrypter$CipherEncrypter;", "()V", "breeze-core"})
    public static final class AesEncrypter
    extends CipherEncrypter {
        @NotNull
        public static final AesEncrypter INSTANCE;

        private AesEncrypter() {
            super("AES");
        }

        static {
            AesEncrypter aesEncrypter;
            INSTANCE = aesEncrypter = new AesEncrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$MessageDigestEncrypter;", "Licu/windea/breezeframework/core/component/Encrypter;", "algorithm", "", "(Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "messageDigest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "decrypt", "", "value", "secret", "encrypt", "breeze-core"})
    public static class MessageDigestEncrypter
    implements Encrypter {
        private final MessageDigest messageDigest;
        @NotNull
        private final String algorithm;

        @Override
        @NotNull
        public byte[] encrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] byArray = this.messageDigest.digest(value);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest(value)");
            return byArray;
        }

        @Override
        @NotNull
        public byte[] decrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw (Throwable)new UnsupportedOperationException("Decrypt operation is not supported by message digest encrypter.");
        }

        @NotNull
        public final String getAlgorithm() {
            return this.algorithm;
        }

        public MessageDigestEncrypter(@NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            this.algorithm = algorithm;
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$Md5Encrypter;", "Licu/windea/breezeframework/core/component/Encrypter$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Md5Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Md5Encrypter INSTANCE;

        private Md5Encrypter() {
            super("MD5");
        }

        static {
            Md5Encrypter md5Encrypter;
            INSTANCE = md5Encrypter = new Md5Encrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$Sha_1Encrypter;", "Licu/windea/breezeframework/core/component/Encrypter$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha_1Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha_1Encrypter INSTANCE;

        private Sha_1Encrypter() {
            super("SHA-1");
        }

        static {
            Sha_1Encrypter sha_1Encrypter;
            INSTANCE = sha_1Encrypter = new Sha_1Encrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$Sha_256Encrypter;", "Licu/windea/breezeframework/core/component/Encrypter$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha_256Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha_256Encrypter INSTANCE;

        private Sha_256Encrypter() {
            super("SHA-256");
        }

        static {
            Sha_256Encrypter sha_256Encrypter;
            INSTANCE = sha_256Encrypter = new Sha_256Encrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$Sha_512Encrypter;", "Licu/windea/breezeframework/core/component/Encrypter$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha_512Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha_512Encrypter INSTANCE;

        private Sha_512Encrypter() {
            super("SHA3-512");
        }

        static {
            Sha_512Encrypter sha_512Encrypter;
            INSTANCE = sha_512Encrypter = new Sha_512Encrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$Sha3_256Encrypter;", "Licu/windea/breezeframework/core/component/Encrypter$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha3_256Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha3_256Encrypter INSTANCE;

        private Sha3_256Encrypter() {
            super("SHA3-256");
        }

        static {
            Sha3_256Encrypter sha3_256Encrypter;
            INSTANCE = sha3_256Encrypter = new Sha3_256Encrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$Sha3_512Encrypter;", "Licu/windea/breezeframework/core/component/Encrypter$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha3_512Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha3_512Encrypter INSTANCE;

        private Sha3_512Encrypter() {
            super("SHA3-512");
        }

        static {
            Sha3_512Encrypter sha3_512Encrypter;
            INSTANCE = sha3_512Encrypter = new Sha3_512Encrypter();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Licu/windea/breezeframework/core/component/Encrypter$Registry;", "Licu/windea/breezeframework/core/component/AbstractComponentRegistry;", "Licu/windea/breezeframework/core/component/Encrypter;", "()V", "registerDefault", "", "breeze-core"})
    public static final class Registry
    extends AbstractComponentRegistry<Encrypter> {
        static final /* synthetic */ Registry $$INSTANCE;

        @Override
        protected void registerDefault() {
            this.register((Component)DesEncrypter.INSTANCE);
            this.register((Component)AesEncrypter.INSTANCE);
            this.register((Component)Md5Encrypter.INSTANCE);
            this.register((Component)Sha_1Encrypter.INSTANCE);
            this.register((Component)Sha_256Encrypter.INSTANCE);
            this.register((Component)Sha_512Encrypter.INSTANCE);
            this.register((Component)Sha3_256Encrypter.INSTANCE);
            this.register((Component)Sha3_512Encrypter.INSTANCE);
        }

        private Registry() {
        }

        static {
            Registry registry;
            $$INSTANCE = registry = new Registry();
        }
    }
}

