/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.annotation.UnstableApi;
import icu.windea.breezeframework.core.component.AbstractComponentRegistry;
import icu.windea.breezeframework.core.component.AbstractRandomGenerator;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ConfigurableRandomGenerator;
import icu.windea.breezeframework.core.component.Converter;
import icu.windea.breezeframework.core.component.GenericRandomGenerator;
import icu.windea.breezeframework.core.component.TypedComponent;
import icu.windea.breezeframework.core.extension.InternalExtensions;
import icu.windea.breezeframework.core.extension.RandomExtensions;
import icu.windea.breezeframework.core.model.TypeReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\bf\u0018\u0000 \u001f*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0017\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fJ\r\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\bR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006 \u00c0\u0006\u0001"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator;", "T", "Licu/windea/breezeframework/core/component/TypedComponent;", "targetType", "Ljava/lang/Class;", "getTargetType", "()Ljava/lang/Class;", "generate", "()Ljava/lang/Object;", "RandomBigDecimalGenerator", "RandomBigIntegerGenerator", "RandomBooleanGenerator", "RandomByteGenerator", "RandomCharGenerator", "RandomDateGenerator", "RandomDoubleGenerator", "RandomEnumGenerator", "RandomFloatGenerator", "RandomInstantGenerator", "RandomIntGenerator", "RandomLocalDateGenerator", "RandomLocalDateTimeGenerator", "RandomLocalTimeGenerator", "RandomLongGenerator", "RandomShortGenerator", "RandomStringGenerator", "RandomUByteGenerator", "RandomUIntGenerator", "RandomULongGenerator", "RandomUShortGenerator", "RandomUuidGenerator", "Registry", "breeze-core"})
public interface RandomGenerator<T>
extends TypedComponent {
    @NotNull
    public static final Registry Registry = icu.windea.breezeframework.core.component.RandomGenerator$Registry.$$INSTANCE;

    @Override
    @NotNull
    public Class<T> getTargetType();

    public T generate();

    @JvmStatic
    public static <T> T generate(@NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> configParams) {
        return Registry.generate(targetType, configParams);
    }

    @JvmStatic
    public static <T> T generate(@NotNull Type targetType, @NotNull Map<String, ? extends Object> configParams) {
        return Registry.generate(targetType, configParams);
    }

    @JvmStatic
    @NotNull
    public static <T, C extends RandomGenerator<T>> C getRandomGenerator(@NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> configParams, @NotNull Function0<? extends C> defaultValue) {
        return Registry.getRandomGenerator(targetType, configParams, defaultValue);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\r\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomByteGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()B", "min", "getMin", "configure", "generate", "()Ljava/lang/Byte;", "Default", "breeze-core"})
    public static class RandomByteGenerator
    extends AbstractRandomGenerator<Byte>
    implements ConfigurableRandomGenerator<Byte> {
        private final byte min;
        private final byte max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final byte getMin() {
            return this.min;
        }

        public final byte getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomByteGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomByteGenerator(configParams);
        }

        @Override
        @NotNull
        public Byte generate() {
            byte by;
            if (this.min != (byte)0 && this.max != (byte)0) {
                by = RandomExtensions.nextByte((Random)Random.Default, this.min, this.max);
            } else if (this.min == (byte)0 && this.max == (byte)0) {
                by = RandomExtensions.nextByte((Random)Random.Default);
            } else if (this.max != (byte)0) {
                by = RandomExtensions.nextByte((Random)Random.Default, this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return by;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomByteGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Byte>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Byte by = (Byte)object2;
            this.min = by != null ? by : (byte)0;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Byte>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Byte by2 = (Byte)object;
            this.max = by2 != null ? by2 : (byte)0;
        }

        public /* synthetic */ RandomByteGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomByteGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomByteGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomByteGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomByteGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\r\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomShortGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()S", "min", "getMin", "configure", "generate", "()Ljava/lang/Short;", "Default", "breeze-core"})
    public static class RandomShortGenerator
    extends AbstractRandomGenerator<Short>
    implements ConfigurableRandomGenerator<Short> {
        private final short min;
        private final short max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final short getMin() {
            return this.min;
        }

        public final short getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomShortGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomShortGenerator(configParams);
        }

        @Override
        @NotNull
        public Short generate() {
            short s;
            if (this.min != (short)0 && this.max != (short)0) {
                s = RandomExtensions.nextShort((Random)Random.Default, this.min, this.max);
            } else if (this.min == (short)0 && this.max == (short)0) {
                s = RandomExtensions.nextShort((Random)Random.Default);
            } else if (this.max != (short)0) {
                s = RandomExtensions.nextShort((Random)Random.Default, this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return s;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomShortGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Short>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Short s = (Short)object2;
            this.min = s != null ? s : (short)0;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Short>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Short s2 = (Short)object;
            this.max = s2 != null ? s2 : (short)0;
        }

        public /* synthetic */ RandomShortGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomShortGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomShortGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomShortGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomShortGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\r\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomIntGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()I", "min", "getMin", "configure", "generate", "()Ljava/lang/Integer;", "Default", "breeze-core"})
    public static class RandomIntGenerator
    extends AbstractRandomGenerator<Integer>
    implements ConfigurableRandomGenerator<Integer> {
        private final int min;
        private final int max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomIntGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomIntGenerator(configParams);
        }

        @Override
        @NotNull
        public Integer generate() {
            int n;
            if (this.min != 0 && this.max != 0) {
                n = Random.Default.nextInt(this.min, this.max);
            } else if (this.min == 0 && this.max == 0) {
                n = Random.Default.nextInt();
            } else if (this.max != 0) {
                n = Random.Default.nextInt(this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return n;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomIntGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Integer n = (Integer)object2;
            this.min = n != null ? n : 0;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Integer n2 = (Integer)object;
            this.max = n2 != null ? n2 : 0;
        }

        public /* synthetic */ RandomIntGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomIntGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomIntGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomIntGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomIntGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\r\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLongGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()J", "min", "getMin", "configure", "generate", "()Ljava/lang/Long;", "Default", "breeze-core"})
    public static class RandomLongGenerator
    extends AbstractRandomGenerator<Long>
    implements ConfigurableRandomGenerator<Long> {
        private final long min;
        private final long max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final long getMin() {
            return this.min;
        }

        public final long getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLongGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomLongGenerator(configParams);
        }

        @Override
        @NotNull
        public Long generate() {
            long l;
            if (this.min != 0L && this.max != 0L) {
                l = Random.Default.nextLong(this.min, this.max);
            } else if (this.min == 0L && this.max == 0L) {
                l = Random.Default.nextLong();
            } else if (this.max != 0L) {
                l = Random.Default.nextLong(this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return l;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomLongGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Long l = (Long)object2;
            this.min = l != null ? l : 0L;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Long l2 = (Long)object;
            this.max = l2 != null ? l2 : 0L;
        }

        public /* synthetic */ RandomLongGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomLongGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLongGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomLongGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLongGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\r\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomFloatGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()F", "min", "getMin", "configure", "generate", "()Ljava/lang/Float;", "Default", "breeze-core"})
    public static class RandomFloatGenerator
    extends AbstractRandomGenerator<Float>
    implements ConfigurableRandomGenerator<Float> {
        private final float min;
        private final float max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final float getMin() {
            return this.min;
        }

        public final float getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomFloatGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomFloatGenerator(configParams);
        }

        @Override
        @NotNull
        public Float generate() {
            float f;
            if (this.min != 0.0f && this.max != 0.0f) {
                f = RandomExtensions.nextFloat((Random)Random.Default, this.min, this.max);
            } else if (this.min == 0.0f && this.max == 0.0f) {
                f = Random.Default.nextFloat();
            } else if (this.max != 0.0f) {
                f = RandomExtensions.nextFloat((Random)Random.Default, this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return Float.valueOf(f);
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomFloatGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Float>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Float f = (Float)object2;
            this.min = f != null ? f.floatValue() : 0.0f;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Float>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Float f2 = (Float)object;
            this.max = f2 != null ? f2.floatValue() : 0.0f;
        }

        public /* synthetic */ RandomFloatGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomFloatGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomFloatGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomFloatGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomFloatGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\r\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomDoubleGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()D", "min", "getMin", "configure", "generate", "()Ljava/lang/Double;", "Default", "breeze-core"})
    public static class RandomDoubleGenerator
    extends AbstractRandomGenerator<Double>
    implements ConfigurableRandomGenerator<Double> {
        private final double min;
        private final double max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final double getMin() {
            return this.min;
        }

        public final double getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomDoubleGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomDoubleGenerator(configParams);
        }

        @Override
        @NotNull
        public Double generate() {
            double d;
            if (this.min != 0.0 && this.max != 0.0) {
                d = Random.Default.nextDouble(this.min, this.max);
            } else if (this.min == 0.0 && this.max == 0.0) {
                d = Random.Default.nextDouble();
            } else if (this.max != 0.0) {
                d = Random.Default.nextDouble(this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return d;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomDoubleGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Double>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Double d = (Double)object2;
            this.min = d != null ? d : 0.0;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Double>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Double d2 = (Double)object;
            this.max = d2 != null ? d2 : 0.0;
        }

        public /* synthetic */ RandomDoubleGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomDoubleGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomDoubleGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomDoubleGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomDoubleGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\f\b\u0017\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomBigIntegerGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/math/BigInteger;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/math/BigInteger;", "min", "getMin", "configure", "generate", "Default", "breeze-core"})
    @UnstableApi
    public static class RandomBigIntegerGenerator
    extends AbstractRandomGenerator<BigInteger>
    implements ConfigurableRandomGenerator<BigInteger> {
        @NotNull
        private final BigInteger min;
        @NotNull
        private final BigInteger max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        @NotNull
        public final BigInteger getMin() {
            return this.min;
        }

        @NotNull
        public final BigInteger getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomBigIntegerGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomBigIntegerGenerator(configParams);
        }

        @Override
        @NotNull
        public BigInteger generate() {
            BigInteger bigInteger;
            if (Intrinsics.areEqual((Object)this.min, (Object)BigInteger.ZERO) ^ true && Intrinsics.areEqual((Object)this.max, (Object)BigInteger.ZERO) ^ true) {
                bigInteger = RandomExtensions.nextBigInteger((Random)Random.Default, this.min, this.max);
            } else if (Intrinsics.areEqual((Object)this.min, (Object)BigInteger.ZERO) && Intrinsics.areEqual((Object)this.max, (Object)BigInteger.ZERO)) {
                bigInteger = RandomExtensions.nextBigInteger((Random)Random.Default);
            } else if (Intrinsics.areEqual((Object)this.max, (Object)BigInteger.ZERO) ^ true) {
                bigInteger = RandomExtensions.nextBigInteger((Random)Random.Default, this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return bigInteger;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomBigIntegerGenerator(@NotNull Map<String, ? extends Object> configParams) {
            BigInteger bigInteger;
            Object object;
            BigInteger bigInteger2;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<BigInteger>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            if ((bigInteger2 = (BigInteger)object2) == null) {
                BigInteger bigInteger3 = BigInteger.ZERO;
                bigInteger2 = bigInteger3;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"BigInteger.ZERO");
            }
            this.min = bigInteger2;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<BigInteger>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            if ((bigInteger = (BigInteger)object) == null) {
                BigInteger bigInteger4 = BigInteger.ZERO;
                bigInteger = bigInteger4;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"BigInteger.ZERO");
            }
            this.max = bigInteger;
        }

        public /* synthetic */ RandomBigIntegerGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomBigIntegerGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomBigIntegerGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomBigIntegerGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomBigIntegerGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\f\b\u0017\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomBigDecimalGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/math/BigDecimal;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/math/BigDecimal;", "min", "getMin", "configure", "generate", "Default", "breeze-core"})
    @UnstableApi
    public static class RandomBigDecimalGenerator
    extends AbstractRandomGenerator<BigDecimal>
    implements ConfigurableRandomGenerator<BigDecimal> {
        @NotNull
        private final BigDecimal min;
        @NotNull
        private final BigDecimal max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        @NotNull
        public final BigDecimal getMin() {
            return this.min;
        }

        @NotNull
        public final BigDecimal getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomBigDecimalGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomBigDecimalGenerator(configParams);
        }

        @Override
        @NotNull
        public BigDecimal generate() {
            BigDecimal bigDecimal;
            if (Intrinsics.areEqual((Object)this.min, (Object)BigDecimal.ZERO) ^ true && Intrinsics.areEqual((Object)this.max, (Object)BigDecimal.ZERO) ^ true) {
                bigDecimal = RandomExtensions.nextBigDecimal$default((Random)Random.Default, this.min, this.max, null, 4, null);
            } else if (Intrinsics.areEqual((Object)this.min, (Object)BigDecimal.ZERO) && Intrinsics.areEqual((Object)this.max, (Object)BigDecimal.ZERO)) {
                bigDecimal = RandomExtensions.nextBigDecimal$default((Random)Random.Default, null, 1, null);
            } else if (Intrinsics.areEqual((Object)this.max, (Object)BigDecimal.ZERO) ^ true) {
                bigDecimal = RandomExtensions.nextBigDecimal$default((Random)Random.Default, this.max, null, 2, null);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return bigDecimal;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomBigDecimalGenerator(@NotNull Map<String, ? extends Object> configParams) {
            BigDecimal bigDecimal;
            Object object;
            BigDecimal bigDecimal2;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<BigDecimal>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            if ((bigDecimal2 = (BigDecimal)object2) == null) {
                BigDecimal bigDecimal3 = BigDecimal.ZERO;
                bigDecimal2 = bigDecimal3;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"BigDecimal.ZERO");
            }
            this.min = bigDecimal2;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<BigDecimal>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            if ((bigDecimal = (BigDecimal)object) == null) {
                BigDecimal bigDecimal4 = BigDecimal.ZERO;
                bigDecimal = bigDecimal4;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"BigDecimal.ZERO");
            }
            this.max = bigDecimal;
        }

        public /* synthetic */ RandomBigDecimalGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomBigDecimalGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomBigDecimalGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomBigDecimalGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomBigDecimalGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0014B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\rR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomUByteGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/UByte;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax-w2LRezQ", "()B", "B", "min", "getMin-w2LRezQ", "configure", "generate", "generate-w2LRezQ", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomUByteGenerator
    extends AbstractRandomGenerator<UByte>
    implements ConfigurableRandomGenerator<UByte> {
        private final byte min;
        private final byte max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final byte getMin-w2LRezQ() {
            return this.min;
        }

        public final byte getMax-w2LRezQ() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomUByteGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomUByteGenerator(configParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        public byte generate-w2LRezQ() {
            byte by;
            boolean bl = false;
            boolean bl2 = false;
            if (this.min != UByte.constructor-impl((byte)((byte)(bl ? 1 : 0)))) {
                bl = false;
                bl2 = false;
                if (this.max != UByte.constructor-impl((byte)((byte)(bl ? 1 : 0)))) {
                    by = RandomExtensions.nextUByte-8olNwgk((Random)Random.Default, this.min, this.max);
                    return by;
                }
            }
            bl = false;
            bl2 = false;
            if (this.min == UByte.constructor-impl((byte)((byte)(bl ? 1 : 0)))) {
                bl = false;
                bl2 = false;
                if (this.max == UByte.constructor-impl((byte)((byte)(bl ? 1 : 0)))) {
                    by = RandomExtensions.nextUByte((Random)Random.Default);
                    return by;
                }
            }
            bl = false;
            bl2 = false;
            if (this.max == UByte.constructor-impl((byte)((byte)(bl ? 1 : 0)))) throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            by = RandomExtensions.nextUByte-EK-6454((Random)Random.Default, this.max);
            return by;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomUByteGenerator(@NotNull Map<String, ? extends Object> configParams) {
            byte by;
            Object object;
            byte by2;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv2 = this.configParams.get("min");
            Map configParams$iv2 = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object2 = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<UByte>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            UByte uByte = (UByte)object2;
            if (uByte != null) {
                by2 = uByte.unbox-impl();
            } else {
                boolean $this$convertOrNull$iv2 = false;
                boolean configParams$iv2 = false;
                by2 = UByte.constructor-impl((byte)((byte)($this$convertOrNull$iv2 ? 1 : 0)));
            }
            this.min = by2;
            $this$convertOrNull$iv2 = this.configParams.get("max");
            configParams$iv2 = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<UByte>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            UByte uByte2 = (UByte)object;
            if (uByte2 != null) {
                by = uByte2.unbox-impl();
            } else {
                boolean bl = false;
                boolean bl2 = false;
                by = UByte.constructor-impl((byte)((byte)(bl ? 1 : 0)));
            }
            this.max = by;
        }

        public /* synthetic */ RandomUByteGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomUByteGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomUByteGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomUByteGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomUByteGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0014B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\rR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomUShortGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/UShort;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax-Mh2AYeg", "()S", "S", "min", "getMin-Mh2AYeg", "configure", "generate", "generate-Mh2AYeg", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomUShortGenerator
    extends AbstractRandomGenerator<UShort>
    implements ConfigurableRandomGenerator<UShort> {
        private final short min;
        private final short max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final short getMin-Mh2AYeg() {
            return this.min;
        }

        public final short getMax-Mh2AYeg() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomUShortGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomUShortGenerator(configParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        public short generate-Mh2AYeg() {
            short s;
            boolean bl = false;
            boolean bl2 = false;
            if (this.min != UShort.constructor-impl((short)((short)(bl ? 1 : 0)))) {
                bl = false;
                bl2 = false;
                if (this.max != UShort.constructor-impl((short)((short)(bl ? 1 : 0)))) {
                    s = RandomExtensions.nextUShort-lwaoQsk((Random)Random.Default, this.min, this.max);
                    return s;
                }
            }
            bl = false;
            bl2 = false;
            if (this.min == UShort.constructor-impl((short)((short)(bl ? 1 : 0)))) {
                bl = false;
                bl2 = false;
                if (this.max == UShort.constructor-impl((short)((short)(bl ? 1 : 0)))) {
                    s = RandomExtensions.nextUShort((Random)Random.Default);
                    return s;
                }
            }
            bl = false;
            bl2 = false;
            if (this.max == UShort.constructor-impl((short)((short)(bl ? 1 : 0)))) throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            s = RandomExtensions.nextUShort-i8woANY((Random)Random.Default, this.max);
            return s;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomUShortGenerator(@NotNull Map<String, ? extends Object> configParams) {
            short s;
            Object object;
            short s2;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv2 = this.configParams.get("min");
            Map configParams$iv2 = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object2 = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<UShort>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            UShort uShort = (UShort)object2;
            if (uShort != null) {
                s2 = uShort.unbox-impl();
            } else {
                boolean $this$convertOrNull$iv2 = false;
                boolean configParams$iv2 = false;
                s2 = UShort.constructor-impl((short)((short)($this$convertOrNull$iv2 ? 1 : 0)));
            }
            this.min = s2;
            $this$convertOrNull$iv2 = this.configParams.get("max");
            configParams$iv2 = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<UShort>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            UShort uShort2 = (UShort)object;
            if (uShort2 != null) {
                s = uShort2.unbox-impl();
            } else {
                boolean bl = false;
                boolean bl2 = false;
                s = UShort.constructor-impl((short)((short)(bl ? 1 : 0)));
            }
            this.max = s;
        }

        public /* synthetic */ RandomUShortGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomUShortGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomUShortGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomUShortGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomUShortGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0014B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\rR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomUIntGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/UInt;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax-pVg5ArA", "()I", "I", "min", "getMin-pVg5ArA", "configure", "generate", "generate-pVg5ArA", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomUIntGenerator
    extends AbstractRandomGenerator<UInt>
    implements ConfigurableRandomGenerator<UInt> {
        private final int min;
        private final int max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final int getMin-pVg5ArA() {
            return this.min;
        }

        public final int getMax-pVg5ArA() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomUIntGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomUIntGenerator(configParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        public int generate-pVg5ArA() {
            int n;
            int n2 = 0;
            boolean bl = false;
            if (this.min != UInt.constructor-impl((int)n2)) {
                n2 = 0;
                bl = false;
                if (this.max != UInt.constructor-impl((int)n2)) {
                    n = URandomKt.nextUInt-a8DCA5k((Random)((Random)Random.Default), (int)this.min, (int)this.max);
                    return n;
                }
            }
            n2 = 0;
            bl = false;
            if (this.min == UInt.constructor-impl((int)n2)) {
                n2 = 0;
                bl = false;
                if (this.max == UInt.constructor-impl((int)n2)) {
                    n = URandomKt.nextUInt((Random)((Random)Random.Default));
                    return n;
                }
            }
            n2 = 0;
            bl = false;
            if (this.max == UInt.constructor-impl((int)n2)) throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            n = URandomKt.nextUInt-qCasIEU((Random)((Random)Random.Default), (int)this.max);
            return n;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomUIntGenerator(@NotNull Map<String, ? extends Object> configParams) {
            int n;
            Object object;
            int n2;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv2 = this.configParams.get("min");
            Map configParams$iv2 = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object2 = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            UInt uInt = (UInt)object2;
            if (uInt != null) {
                n2 = uInt.unbox-impl();
            } else {
                int $this$convertOrNull$iv2 = 0;
                boolean configParams$iv2 = false;
                n2 = UInt.constructor-impl((int)$this$convertOrNull$iv2);
            }
            this.min = n2;
            $this$convertOrNull$iv2 = this.configParams.get("max");
            configParams$iv2 = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            UInt uInt2 = (UInt)object;
            if (uInt2 != null) {
                n = uInt2.unbox-impl();
            } else {
                int n3 = 0;
                boolean bl = false;
                n = UInt.constructor-impl((int)n3);
            }
            this.max = n;
        }

        public /* synthetic */ RandomUIntGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomUIntGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomUIntGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomUIntGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomUIntGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0014B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\rR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomULongGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/ULong;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax-s-VKNKU", "()J", "J", "min", "getMin-s-VKNKU", "configure", "generate", "generate-s-VKNKU", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomULongGenerator
    extends AbstractRandomGenerator<ULong>
    implements ConfigurableRandomGenerator<ULong> {
        private final long min;
        private final long max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final long getMin-s-VKNKU() {
            return this.min;
        }

        public final long getMax-s-VKNKU() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomULongGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomULongGenerator(configParams);
        }

        /*
         * Enabled aggressive block sorting
         */
        public long generate-s-VKNKU() {
            long l;
            int n = 0;
            boolean bl = false;
            if (this.min != ULong.constructor-impl((long)n)) {
                n = 0;
                bl = false;
                if (this.max != ULong.constructor-impl((long)n)) {
                    l = URandomKt.nextULong-jmpaW-c((Random)((Random)Random.Default), (long)this.min, (long)this.max);
                    return l;
                }
            }
            n = 0;
            bl = false;
            if (this.min == ULong.constructor-impl((long)n)) {
                n = 0;
                bl = false;
                if (this.max == ULong.constructor-impl((long)n)) {
                    l = URandomKt.nextULong((Random)((Random)Random.Default));
                    return l;
                }
            }
            n = 0;
            bl = false;
            if (this.max == ULong.constructor-impl((long)n)) throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            l = URandomKt.nextULong-V1Xi4fY((Random)((Random)Random.Default), (long)this.max);
            return l;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomULongGenerator(@NotNull Map<String, ? extends Object> configParams) {
            long l;
            Object object;
            long l2;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv2 = this.configParams.get("min");
            Map configParams$iv2 = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object2 = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            ULong uLong = (ULong)object2;
            if (uLong != null) {
                l2 = uLong.unbox-impl();
            } else {
                int $this$convertOrNull$iv2 = 0;
                boolean configParams$iv2 = false;
                l2 = ULong.constructor-impl((long)$this$convertOrNull$iv2);
            }
            this.min = l2;
            $this$convertOrNull$iv2 = this.configParams.get("max");
            configParams$iv2 = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv2 == null) {
                object = $this$convertOrNull$iv2;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv2, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)configParams$iv2);
            }
            ULong uLong2 = (ULong)object;
            if (uLong2 != null) {
                l = uLong2.unbox-impl();
            } else {
                int n = 0;
                boolean bl = false;
                l = ULong.constructor-impl((long)n);
            }
            this.max = l;
        }

        public /* synthetic */ RandomULongGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomULongGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomULongGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomULongGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomULongGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\r\u0010\u0011\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0012R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomCharGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()C", "min", "getMin", "configure", "generate", "()Ljava/lang/Character;", "Default", "breeze-core"})
    public static class RandomCharGenerator
    extends AbstractRandomGenerator<Character>
    implements ConfigurableRandomGenerator<Character> {
        private final char min;
        private final char max;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final char getMin() {
            return this.min;
        }

        public final char getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomCharGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomCharGenerator(configParams);
        }

        @Override
        @NotNull
        public Character generate() {
            char c;
            if (this.min != '\u0000' && this.max != '\u0000') {
                c = RandomExtensions.nextChar((Random)Random.Default, this.min, this.max);
            } else if (this.min == '\u0000' && this.max == '\u0000') {
                c = RandomExtensions.nextChar((Random)Random.Default);
            } else if (this.max != '\u0000') {
                c = RandomExtensions.nextChar((Random)Random.Default, this.max);
            } else {
                throw (Throwable)new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return Character.valueOf(c);
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomCharGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Character c = (Character)object2;
            this.min = c != null ? c.charValue() : (char)'\u0000';
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            Character c2 = (Character)object;
            this.max = c2 != null ? c2.charValue() : (char)'\u0000';
        }

        public /* synthetic */ RandomCharGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomCharGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomCharGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomCharGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomCharGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomBooleanGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "()V", "generate", "()Ljava/lang/Boolean;", "breeze-core"})
    public static final class RandomBooleanGenerator
    extends AbstractRandomGenerator<Boolean> {
        @NotNull
        public static final RandomBooleanGenerator INSTANCE;

        @Override
        @NotNull
        public Boolean generate() {
            return Random.Default.nextBoolean();
        }

        private RandomBooleanGenerator() {
        }

        static {
            RandomBooleanGenerator randomBooleanGenerator;
            INSTANCE = randomBooleanGenerator = new RandomBooleanGenerator();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\b\u0016\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0017B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0015\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomStringGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "length", "", "getLength", "()I", "maxLength", "getMaxLength", "minLength", "getMinLength", "source", "getSource", "()Ljava/lang/String;", "configure", "generate", "Default", "breeze-core"})
    public static class RandomStringGenerator
    extends AbstractRandomGenerator<String>
    implements ConfigurableRandomGenerator<String> {
        private final int length;
        private final int minLength;
        private final int maxLength;
        @NotNull
        private final String source;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        public final int getLength() {
            return this.length;
        }

        public final int getMinLength() {
            return this.minLength;
        }

        public final int getMaxLength() {
            return this.maxLength;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public RandomStringGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomStringGenerator(configParams);
        }

        @Override
        @NotNull
        public String generate() {
            if (this.length < 0) {
                throw (Throwable)new IllegalArgumentException("Config param 'length' cannot be negative.");
            }
            if (this.length == 0) {
                if (this.minLength < 0) {
                    throw (Throwable)new IllegalArgumentException("Config param 'minLength' cannot be negative.");
                }
                if (this.maxLength < 0) {
                    throw (Throwable)new IllegalArgumentException("Config param 'maxLength' cannot be negative.");
                }
                if (this.maxLength == 0) {
                    throw (Throwable)new IllegalArgumentException("Config param 'maxLength cannot be null.'");
                }
            }
            CharSequence charSequence = this.source;
            boolean bl = false;
            if (charSequence.length() == 0) {
                throw (Throwable)new IllegalArgumentException("Config param 'source' cannot be null or empty.");
            }
            int length = this.length != 0 ? this.length : Random.Default.nextInt(this.minLength, this.maxLength);
            bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            int n = length;
            boolean bl6 = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl7 = false;
                $this$buildString.append(RandomExtensions.nextElement((Random)Random.Default, this.source));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        /*
         * Unable to fully structure code
         */
        public RandomStringGenerator(@NotNull Map<String, ? extends Object> configParams) {
            block18: {
                block17: {
                    Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
                    super();
                    this.configParams = configParams;
                    v0 = this.configParams.get("length");
                    if (v0 == null) ** GOTO lbl-1000
                    $this$convertOrNull$iv = v0;
                    configParams$iv = MapsKt.emptyMap();
                    $i$f$convertOrNull = false;
                    if ($this$convertOrNull$iv == null) {
                        v1 = $this$convertOrNull$iv;
                    } else {
                        this_$iv$iv = Converter.Registry;
                        $i$f$convertOrNull = false;
                        $i$f$javaTypeOf = false;
                        v1 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
                    }
                    if ((v0 = (Integer)v1) != null) {
                        v2 = v0.intValue();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = this.length = 0;
                    }
                    if ((v3 = this.configParams.get("minLength")) == null) ** GOTO lbl-1000
                    $this$convertOrNull$iv = v3;
                    configParams$iv = MapsKt.emptyMap();
                    $i$f$convertOrNull = false;
                    if ($this$convertOrNull$iv == null) {
                        v4 = $this$convertOrNull$iv;
                    } else {
                        this_$iv$iv = Converter.Registry;
                        $i$f$convertOrNull = false;
                        $i$f$javaTypeOf = false;
                        v4 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
                    }
                    if ((v3 = (Integer)v4) != null) {
                        v5 = v3.intValue();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = this.minLength = 0;
                    }
                    if ((v6 = this.configParams.get("maxLength")) == null) ** GOTO lbl-1000
                    $this$convertOrNull$iv = v6;
                    configParams$iv = MapsKt.emptyMap();
                    $i$f$convertOrNull = false;
                    if ($this$convertOrNull$iv == null) {
                        v7 = $this$convertOrNull$iv;
                    } else {
                        this_$iv$iv = Converter.Registry;
                        $i$f$convertOrNull = false;
                        $i$f$javaTypeOf = false;
                        v7 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
                    }
                    if ((v6 = (Integer)v7) != null) {
                        v8 = v6.intValue();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = this.maxLength = 0;
                    }
                    if ((v9 = this.configParams.get("source")) == null) break block17;
                    $this$convertOrNull$iv = v9;
                    configParams$iv = MapsKt.emptyMap();
                    $i$f$convertOrNull = false;
                    if ($this$convertOrNull$iv == null) {
                        v10 = $this$convertOrNull$iv;
                    } else {
                        this_$iv$iv = Converter.Registry;
                        $i$f$convertOrNull = false;
                        $i$f$javaTypeOf = false;
                        v10 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<String>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
                    }
                    if ((v9 = (String)v10) != null) break block18;
                }
                v9 = "";
            }
            this.source = v9;
        }

        public /* synthetic */ RandomStringGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomStringGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomStringGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomStringGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomStringGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u0005"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomUuidGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/util/UUID;", "()V", "generate", "breeze-core"})
    public static final class RandomUuidGenerator
    extends AbstractRandomGenerator<UUID> {
        @NotNull
        public static final RandomUuidGenerator INSTANCE;

        @Override
        @NotNull
        public UUID generate() {
            return RandomExtensions.nextUuid((Random)Random.Default);
        }

        private RandomUuidGenerator() {
        }

        static {
            RandomUuidGenerator randomUuidGenerator;
            INSTANCE = randomUuidGenerator = new RandomUuidGenerator();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0014\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomDateGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/util/Date;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/util/Date;", "maxEpochSecond", "", "min", "getMin", "minEpochSecond", "passingConfigParams", "configure", "generate", "Default", "breeze-core"})
    public static class RandomDateGenerator
    extends AbstractRandomGenerator<Date>
    implements ConfigurableRandomGenerator<Date> {
        private final Map<String, Object> passingConfigParams;
        @Nullable
        private final Date min;
        @Nullable
        private final Date max;
        private final long minEpochSecond;
        private final long maxEpochSecond;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        @Nullable
        public final Date getMin() {
            return this.min;
        }

        @Nullable
        public final Date getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomDateGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomDateGenerator(configParams);
        }

        @Override
        @NotNull
        public Date generate() {
            if (this.min == null || this.max == null) {
                throw (Throwable)new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochSecond = Random.Default.nextLong(this.minEpochSecond, this.maxEpochSecond);
            Date date = Date.from(Instant.ofEpochSecond(epochSecond));
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"Date.from(Instant.ofEpochSecond(epochSecond))");
            return date;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomDateGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object t;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            this.passingConfigParams = InternalExtensions.filterConfigParams(this.configParams, "format", "locale", "timeZone");
            Object object2 = this.configParams.get("min");
            Map<String, Object> configParams$iv = this.passingConfigParams;
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                t = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                t = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Date>(){}.getType(), configParams$iv);
            }
            this.min = (Date)t;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = this.passingConfigParams;
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Date>(){}.getType(), configParams$iv);
            }
            this.max = (Date)object;
            Comparable<Date> comparable = this.min;
            this.minEpochSecond = comparable != null && (comparable = ((Date)comparable).toInstant()) != null ? ((Instant)comparable).getEpochSecond() : 0L;
            Comparable<Date> comparable2 = this.max;
            this.maxEpochSecond = comparable2 != null && (comparable2 = ((Date)comparable2).toInstant()) != null ? ((Instant)comparable2).getEpochSecond() : 0L;
        }

        public /* synthetic */ RandomDateGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomDateGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomDateGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomDateGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomDateGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0014\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalDateGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/LocalDate;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/LocalDate;", "maxEpochDay", "", "min", "getMin", "minEpochDay", "passingConfigParams", "configure", "generate", "Default", "breeze-core"})
    public static class RandomLocalDateGenerator
    extends AbstractRandomGenerator<LocalDate>
    implements ConfigurableRandomGenerator<LocalDate> {
        private final Map<String, Object> passingConfigParams;
        @Nullable
        private final LocalDate min;
        @Nullable
        private final LocalDate max;
        private final long minEpochDay;
        private final long maxEpochDay;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        @Nullable
        public final LocalDate getMin() {
            return this.min;
        }

        @Nullable
        public final LocalDate getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLocalDateGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomLocalDateGenerator(configParams);
        }

        @Override
        @NotNull
        public LocalDate generate() {
            if (this.min == null || this.max == null) {
                throw (Throwable)new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochDay = Random.Default.nextLong(this.minEpochDay, this.maxEpochDay);
            LocalDate localDate = LocalDate.ofEpochDay(epochDay);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.ofEpochDay(epochDay)");
            return localDate;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomLocalDateGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object t;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            this.passingConfigParams = InternalExtensions.filterConfigParams(this.configParams, "format", "locale", "timeZone");
            Object object2 = this.configParams.get("min");
            Map<String, Object> configParams$iv = this.passingConfigParams;
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                t = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                t = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDate>(){}.getType(), configParams$iv);
            }
            this.min = (LocalDate)t;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = this.passingConfigParams;
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDate>(){}.getType(), configParams$iv);
            }
            this.max = (LocalDate)object;
            LocalDate localDate = this.min;
            this.minEpochDay = localDate != null ? localDate.toEpochDay() : 0L;
            LocalDate localDate2 = this.max;
            this.maxEpochDay = localDate2 != null ? localDate2.toEpochDay() : 0L;
        }

        public /* synthetic */ RandomLocalDateGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomLocalDateGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalDateGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalDateGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLocalDateGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0014\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalTimeGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/LocalTime;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/LocalTime;", "maxNanoOfDay", "", "min", "getMin", "minNanoOfDay", "passingConfigParams", "configure", "generate", "Default", "breeze-core"})
    public static class RandomLocalTimeGenerator
    extends AbstractRandomGenerator<LocalTime>
    implements ConfigurableRandomGenerator<LocalTime> {
        private final Map<String, Object> passingConfigParams;
        @Nullable
        private final LocalTime min;
        @Nullable
        private final LocalTime max;
        private final long minNanoOfDay;
        private final long maxNanoOfDay;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        @Nullable
        public final LocalTime getMin() {
            return this.min;
        }

        @Nullable
        public final LocalTime getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLocalTimeGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomLocalTimeGenerator(configParams);
        }

        @Override
        @NotNull
        public LocalTime generate() {
            if (this.min == null || this.max == null) {
                throw (Throwable)new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long nanoOfDay = Random.Default.nextLong(this.minNanoOfDay, this.maxNanoOfDay);
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"LocalTime.ofNanoOfDay(nanoOfDay)");
            return localTime;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomLocalTimeGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object t;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            this.passingConfigParams = InternalExtensions.filterConfigParams(this.configParams, "format", "locale", "timeZone");
            Object object2 = this.configParams.get("min");
            Map<String, Object> configParams$iv = this.passingConfigParams;
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                t = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                t = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalTime>(){}.getType(), configParams$iv);
            }
            this.min = (LocalTime)t;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = this.passingConfigParams;
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalTime>(){}.getType(), configParams$iv);
            }
            this.max = (LocalTime)object;
            LocalTime localTime = this.min;
            this.minNanoOfDay = localTime != null ? localTime.toNanoOfDay() : 0L;
            LocalTime localTime2 = this.max;
            this.maxNanoOfDay = localTime2 != null ? localTime2.toNanoOfDay() : 0L;
        }

        public /* synthetic */ RandomLocalTimeGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomLocalTimeGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalTimeGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalTimeGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLocalTimeGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0014\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalDateTimeGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/LocalDateTime;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/LocalDateTime;", "maxEpochSecond", "", "min", "getMin", "minEpochSecond", "passingConfigParams", "configure", "generate", "Default", "breeze-core"})
    public static class RandomLocalDateTimeGenerator
    extends AbstractRandomGenerator<LocalDateTime>
    implements ConfigurableRandomGenerator<LocalDateTime> {
        private final Map<String, Object> passingConfigParams;
        @Nullable
        private final LocalDateTime min;
        @Nullable
        private final LocalDateTime max;
        private final long minEpochSecond;
        private final long maxEpochSecond;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        @Nullable
        public final LocalDateTime getMin() {
            return this.min;
        }

        @Nullable
        public final LocalDateTime getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLocalDateTimeGenerator configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomLocalDateTimeGenerator(configParams);
        }

        @Override
        @NotNull
        public LocalDateTime generate() {
            if (this.min == null || this.max == null) {
                throw (Throwable)new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochSecond = Random.Default.nextLong(this.minEpochSecond, this.maxEpochSecond);
            LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.ofEpochSec\u2026econd, 0, ZoneOffset.UTC)");
            return localDateTime;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomLocalDateTimeGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object t;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            this.passingConfigParams = InternalExtensions.filterConfigParams(this.configParams, "format", "locale", "timeZone");
            Object object2 = this.configParams.get("min");
            Map<String, Object> configParams$iv = this.passingConfigParams;
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                t = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                t = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDateTime>(){}.getType(), configParams$iv);
            }
            this.min = (LocalDateTime)t;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = this.passingConfigParams;
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDateTime>(){}.getType(), configParams$iv);
            }
            this.max = (LocalDateTime)object;
            LocalDateTime localDateTime = this.min;
            this.minEpochSecond = localDateTime != null ? localDateTime.toEpochSecond(ZoneOffset.UTC) : 0L;
            LocalDateTime localDateTime2 = this.max;
            this.maxEpochSecond = localDateTime2 != null ? localDateTime2.toEpochSecond(ZoneOffset.UTC) : 0L;
        }

        public /* synthetic */ RandomLocalDateTimeGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomLocalDateTimeGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalDateTimeGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomLocalDateTimeGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLocalDateTimeGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0015B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomInstantGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/Instant;", "Licu/windea/breezeframework/core/component/ConfigurableRandomGenerator;", "configParams", "", "", "", "(Ljava/util/Map;)V", "getConfigParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/Instant;", "maxEpochSecond", "", "min", "getMin", "minEpochSecond", "configure", "generate", "Default", "breeze-core"})
    public static class RandomInstantGenerator
    extends AbstractRandomGenerator<Instant>
    implements ConfigurableRandomGenerator<Instant> {
        @Nullable
        private final Instant min;
        @Nullable
        private final Instant max;
        private final long minEpochSecond;
        private final long maxEpochSecond;
        @NotNull
        private final Map<String, Object> configParams;
        @NotNull
        public static final Default Default = new Default(null);

        @Nullable
        public final Instant getMin() {
            return this.min;
        }

        @Nullable
        public final Instant getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public ConfigurableRandomGenerator<Instant> configure(@NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return new RandomInstantGenerator(configParams);
        }

        @Override
        @NotNull
        public Instant generate() {
            if (this.min == null || this.max == null) {
                throw (Throwable)new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochSecond = Random.Default.nextLong(this.minEpochSecond, this.maxEpochSecond);
            Instant instant = Instant.ofEpochSecond(epochSecond);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"Instant.ofEpochSecond(epochSecond)");
            return instant;
        }

        @Override
        @NotNull
        public final Map<String, Object> getConfigParams() {
            return this.configParams;
        }

        public RandomInstantGenerator(@NotNull Map<String, ? extends Object> configParams) {
            Object object;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converter.Registry this_$iv$iv;
            Object object2;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            this.configParams = configParams;
            Object $this$convertOrNull$iv = this.configParams.get("min");
            Map configParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object2 = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object2 = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Instant>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            this.min = (Instant)object2;
            $this$convertOrNull$iv = this.configParams.get("max");
            configParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull2 = false;
            if ($this$convertOrNull$iv == null) {
                object = $this$convertOrNull$iv;
            } else {
                this_$iv$iv = Converter.Registry;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                object = this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Instant>(){}.getType(), (Map<String, ? extends Object>)configParams$iv);
            }
            this.max = (Instant)object;
            Instant instant = this.min;
            this.minEpochSecond = instant != null ? instant.getEpochSecond() : 0L;
            Instant instant2 = this.max;
            this.maxEpochSecond = instant2 != null ? instant2.getEpochSecond() : 0L;
        }

        public /* synthetic */ RandomInstantGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        public RandomInstantGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomInstantGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerator$RandomInstantGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomInstantGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$RandomEnumGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/GenericRandomGenerator;", "()V", "generate", "targetType", "Ljava/lang/reflect/Type;", "breeze-core"})
    public static final class RandomEnumGenerator
    extends AbstractRandomGenerator<Enum<?>>
    implements GenericRandomGenerator<Enum<?>> {
        @NotNull
        public static final RandomEnumGenerator INSTANCE;

        @Override
        @NotNull
        public Enum<?> generate(@NotNull Type targetType) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Class<Enum<?>> enumClass = InternalExtensions.inferEnumClass(targetType);
            if (Intrinsics.areEqual(enumClass, Enum.class)) {
                throw (Throwable)new IllegalArgumentException("Cannot get actual enum class.");
            }
            Map<Class<Enum<?>>, List<Enum<?>>> $this$getOrPut$iv = InternalExtensions.getEnumValuesCache();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(enumClass);
            if (value$iv == null) {
                boolean bl = false;
                Object object2 = enumClass.getEnumConstants();
                if (object2 == null || (object2 = ArraysKt.toList((Object[])object2)) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                Object answer$iv = object2;
                $this$getOrPut$iv.put(enumClass, (List<Enum<?>>)answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Object enumValues = object;
            return RandomExtensions.nextElement((Random)Random.Default, enumValues);
        }

        private RandomEnumGenerator() {
        }

        static {
            RandomEnumGenerator randomEnumGenerator;
            INSTANCE = randomEnumGenerator = new RandomEnumGenerator();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J1\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0001\u0010\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0001\u0010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J9\u0010\u0018\u001a\u0002H\u000e\"\u0004\b\u0001\u0010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00162\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0007\u00a2\u0006\u0002\u0010\u0019J3\u0010\u0018\u001a\u0002H\u000e\"\u0004\b\u0001\u0010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0007\u00a2\u0006\u0002\u0010\u001aJ.\u0010\u0018\u001a\u0002H\u000e\"\u0006\b\u0001\u0010\u000e\u0018\u00012\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u001bJU\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0001\u0010\u000e\"\u000e\b\u0002\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u000e0\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00162\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0007\u00a2\u0006\u0002\u0010 J*\u0010!\u001a\u00020\u00062\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00162\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0002J0\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00162\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0002J\b\u0010#\u001a\u00020$H\u0014R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerator$Registry;", "Licu/windea/breezeframework/core/component/AbstractComponentRegistry;", "Licu/windea/breezeframework/core/component/RandomGenerator;", "()V", "componentMap", "", "", "useFallbackStrategy", "", "getUseFallbackStrategy", "()Z", "setUseFallbackStrategy", "(Z)V", "doGenerate", "T", "configParams", "", "", "targetType", "Ljava/lang/reflect/Type;", "(Ljava/util/Map;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "fallbackGenerate", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "generate", "(Ljava/lang/Class;Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/lang/reflect/Type;Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/util/Map;)Ljava/lang/Object;", "getRandomGenerator", "C", "defaultValue", "Lkotlin/Function0;", "(Ljava/lang/Class;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Licu/windea/breezeframework/core/component/RandomGenerator;", "inferKey", "inferRandomGenerator", "registerDefault", "", "breeze-core"})
    public static final class Registry
    extends AbstractComponentRegistry<RandomGenerator<?>> {
        private static final Map<String, RandomGenerator<?>> componentMap;
        private static boolean useFallbackStrategy;
        static final /* synthetic */ Registry $$INSTANCE;

        @Override
        protected void registerDefault() {
            this.register((Component)RandomByteGenerator.Default);
            this.register((Component)RandomShortGenerator.Default);
            this.register((Component)RandomIntGenerator.Default);
            this.register((Component)RandomLongGenerator.Default);
            this.register((Component)RandomFloatGenerator.Default);
            this.register((Component)RandomDoubleGenerator.Default);
            this.register((Component)RandomBooleanGenerator.INSTANCE);
            this.register((Component)RandomCharGenerator.Default);
            this.register((Component)RandomBigIntegerGenerator.Default);
            this.register((Component)RandomBigDecimalGenerator.Default);
            this.register((Component)RandomUByteGenerator.Default);
            this.register((Component)RandomUShortGenerator.Default);
            this.register((Component)RandomUIntGenerator.Default);
            this.register((Component)RandomULongGenerator.Default);
            this.register((Component)RandomStringGenerator.Default);
            this.register((Component)RandomUuidGenerator.INSTANCE);
            this.register((Component)RandomDateGenerator.Default);
            this.register((Component)RandomLocalDateGenerator.Default);
            this.register((Component)RandomLocalTimeGenerator.Default);
            this.register((Component)RandomLocalDateTimeGenerator.Default);
            this.register((Component)RandomInstantGenerator.Default);
            this.register((Component)RandomEnumGenerator.INSTANCE);
        }

        public final boolean getUseFallbackStrategy() {
            return useFallbackStrategy;
        }

        public final void setUseFallbackStrategy(boolean bl) {
            useFallbackStrategy = bl;
        }

        public final /* synthetic */ <T> T generate(Map<String, ? extends Object> configParams) {
            int $i$f$generate = 0;
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            boolean $i$f$javaTypeOf = false;
            Intrinsics.needClassReification();
            return this.generate(new TypeReference<T>(){}.getType(), configParams);
        }

        public static /* synthetic */ Object generate$default(Registry this_, Map configParams, int n, Object object) {
            if ((n & 1) != 0) {
                configParams = MapsKt.emptyMap();
            }
            boolean $i$f$generate = false;
            Intrinsics.checkNotNullParameter((Object)configParams, (String)"configParams");
            boolean $i$f$javaTypeOf = false;
            Intrinsics.needClassReification();
            return this_.generate(new TypeReference<T>(){}.getType(), (Map<String, ? extends Object>)configParams);
        }

        @JvmStatic
        public final <T> T generate(@NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return this.doGenerate(configParams, targetType);
        }

        public static /* synthetic */ Object generate$default(Registry registry, Class clazz, Map map, int n, Object object) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            return registry.generate(clazz, (Map<String, ? extends Object>)map);
        }

        @JvmStatic
        public final <T> T generate(@NotNull Type targetType, @NotNull Map<String, ? extends Object> configParams) {
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            return this.doGenerate(configParams, targetType);
        }

        public static /* synthetic */ Object generate$default(Registry registry, Type type, Map map, int n, Object object) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            return registry.generate(type, (Map<String, ? extends Object>)map);
        }

        private final <T> T doGenerate(Map<String, ? extends Object> configParams, Type targetType) {
            RandomGenerator<?> randomGenerator;
            RandomGenerator<?> randomGenerator2;
            RandomGenerator<?> randomGenerator3;
            Class<?> targetClass = InternalExtensions.inferClass(targetType);
            String key = this.inferKey(targetClass, configParams);
            Map<String, RandomGenerator<?>> $this$getOrPut$iv = componentMap;
            boolean $i$f$getOrPut = false;
            RandomGenerator<?> value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                RandomGenerator<?> result2 = this.inferRandomGenerator(targetClass, configParams);
                if (result2 == null) {
                    Object fallback;
                    if (useFallbackStrategy && (fallback = this.fallbackGenerate(targetClass)) != null) {
                        return (T)fallback;
                    }
                    throw (Throwable)new IllegalArgumentException("No suitable random generator found for target type '" + targetType + "'.");
                }
                RandomGenerator<?> answer$iv = result2;
                $this$getOrPut$iv.put(key, answer$iv);
                randomGenerator3 = answer$iv;
            } else {
                randomGenerator3 = value$iv;
            }
            return (T)((randomGenerator2 = (randomGenerator = randomGenerator3)) instanceof GenericRandomGenerator ? ((GenericRandomGenerator)randomGenerator).generate(targetType) : randomGenerator.generate());
        }

        private final String inferKey(Class<?> targetType, Map<String, ? extends Object> configParams) {
            String string;
            if (configParams.isEmpty()) {
                String string2 = targetType.getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetType.name");
            } else {
                string = targetType.getName() + '@' + configParams;
            }
            return string;
        }

        private final RandomGenerator<?> inferRandomGenerator(Class<?> targetType, Map<String, ? extends Object> configParams) {
            Object v0;
            boolean bl;
            Object object;
            block3: {
                object = this.getComponents();
                bl = false;
                List list = object;
                boolean bl2 = false;
                ListIterator listIterator = list.listIterator(list.size());
                while (listIterator.hasPrevious()) {
                    Object t = listIterator.previous();
                    RandomGenerator it = (RandomGenerator)t;
                    boolean bl3 = false;
                    if (!it.getTargetType().isAssignableFrom(targetType)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            RandomGenerator result2 = v0;
            if (result2 instanceof ConfigurableRandomGenerator) {
                object = configParams;
                bl = false;
                if (!object.isEmpty()) {
                    result2 = ((ConfigurableRandomGenerator)result2).configure(configParams);
                }
            }
            return result2;
        }

        private final <T> T fallbackGenerate(Class<T> targetType) {
            try {
                Constructor<T> constructor;
                Constructor<T> constructor2 = constructor = targetType.getDeclaredConstructor(new Class[0]);
                Intrinsics.checkNotNullExpressionValue(constructor2, (String)"constructor");
                constructor2.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final <T, C extends RandomGenerator<T>> C getRandomGenerator(@NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> configParams, @NotNull Function0<? extends C> defaultValue) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
            Intrinsics.checkNotNullParameter(configParams, (String)"configParams");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            Map<String, RandomGenerator<?>> map = componentMap;
            String key$iv = this.inferKey(targetType, configParams);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Object answer$iv = defaultValue.invoke();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type C");
            }
            return (C)((RandomGenerator)object);
        }

        private Registry() {
        }

        static {
            Registry registry;
            $$INSTANCE = registry = new Registry();
            componentMap = new ConcurrentHashMap();
        }
    }
}

