/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.component.AbstractComponentRegistry;
import icu.windea.breezeframework.core.component.Component;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\bf\u0018\u0000 \r2\u00020\u0001:\t\u0006\u0007\b\t\n\u000b\f\r\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Licu/windea/breezeframework/core/component/StringPattern;", "Licu/windea/breezeframework/core/component/Component;", "matches", "", "value", "", "AlphaPattern", "AlphanumericPattern", "BlankPattern", "BooleanPattern", "IntPattern", "NumberPattern", "NumericPattern", "Registry", "WildcardBooleanPattern", "breeze-core"})
public interface StringPattern
extends Component {
    @NotNull
    public static final Registry Registry = icu.windea.breezeframework.core.component.StringPattern$Registry.$$INSTANCE;

    public boolean matches(@NotNull String var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$BooleanPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "values", "", "", "[Ljava/lang/String;", "matches", "", "value", "breeze-core"})
    public static final class BooleanPattern
    implements StringPattern {
        private static final String[] values;
        @NotNull
        public static final BooleanPattern INSTANCE;

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.contains((Object[])values, (Object)value);
        }

        private BooleanPattern() {
        }

        static {
            BooleanPattern booleanPattern;
            INSTANCE = booleanPattern = new BooleanPattern();
            values = new String[]{"true", "false"};
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$WildcardBooleanPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "values", "", "", "[Ljava/lang/String;", "matches", "", "value", "breeze-core"})
    public static final class WildcardBooleanPattern
    implements StringPattern {
        private static final String[] values;
        @NotNull
        public static final WildcardBooleanPattern INSTANCE;

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.contains((Object[])values, (Object)value);
        }

        private WildcardBooleanPattern() {
        }

        static {
            WildcardBooleanPattern wildcardBooleanPattern;
            INSTANCE = wildcardBooleanPattern = new WildcardBooleanPattern();
            values = new String[]{"true", "false", "yes", "no", "on", "off"};
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$IntPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "signs", "", "matches", "", "value", "", "breeze-core"})
    public static final class IntPattern
    implements StringPattern {
        private static final char[] signs;
        @NotNull
        public static final IntPattern INSTANCE;

        @Override
        public boolean matches(@NotNull String value) {
            boolean bl;
            block5: {
                String string;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Character sign = StringsKt.firstOrNull((CharSequence)value);
                if (sign == null) {
                    string = value;
                } else if (ArraysKt.contains((char[])signs, (char)sign.charValue())) {
                    string = StringsKt.drop((String)value, (int)1);
                } else {
                    return false;
                }
                String noSignValue = string;
                CharSequence $this$any$iv = noSignValue;
                boolean $i$f$any = false;
                CharSequence charSequence = $this$any$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl2 = false;
                    char c = it;
                    boolean bl3 = false;
                    if (!Character.isDigit(c)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            return bl;
        }

        private IntPattern() {
        }

        static {
            IntPattern intPattern;
            INSTANCE = intPattern = new IntPattern();
            signs = new char[]{'+', '-'};
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$NumberPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "signs", "", "matches", "", "value", "", "breeze-core"})
    public static final class NumberPattern
    implements StringPattern {
        private static final char[] signs;
        @NotNull
        public static final NumberPattern INSTANCE;

        @Override
        public boolean matches(@NotNull String value) {
            boolean bl;
            block8: {
                String string;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Character sign = StringsKt.firstOrNull((CharSequence)value);
                if (sign == null) {
                    string = value;
                } else if (ArraysKt.contains((char[])signs, (char)sign.charValue())) {
                    string = StringsKt.drop((String)value, (int)1);
                } else {
                    return false;
                }
                String noSignValue = string;
                boolean hasDot = false;
                CharSequence $this$any$iv = noSignValue;
                boolean $i$f$any = false;
                CharSequence charSequence = $this$any$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char it = element$iv = charSequence.charAt(i);
                    boolean bl2 = false;
                    if (it == '.') {
                        if (!hasDot) {
                            hasDot = true;
                        } else {
                            return false;
                        }
                    }
                    char c = it;
                    boolean bl3 = false;
                    if (!Character.isDigit(c)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            return bl;
        }

        private NumberPattern() {
        }

        static {
            NumberPattern numberPattern;
            INSTANCE = numberPattern = new NumberPattern();
            signs = new char[]{'+', '-'};
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$AlphaPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class AlphaPattern
    implements StringPattern {
        @NotNull
        public static final AlphaPattern INSTANCE;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            boolean bl = false;
            if (charSequence.length() <= 0) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            CharSequence charSequence2 = $this$all$iv;
            int n = 0;
            while (n < charSequence2.length()) {
                char element$iv;
                char it = element$iv = charSequence2.charAt(n);
                boolean bl3 = false;
                char c = it;
                boolean bl4 = false;
                if (!Character.isLetter(c)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private AlphaPattern() {
        }

        static {
            AlphaPattern alphaPattern;
            INSTANCE = alphaPattern = new AlphaPattern();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$NumericPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class NumericPattern
    implements StringPattern {
        @NotNull
        public static final NumericPattern INSTANCE;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            boolean bl = false;
            if (charSequence.length() <= 0) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            CharSequence charSequence2 = $this$all$iv;
            int n = 0;
            while (n < charSequence2.length()) {
                char element$iv;
                char it = element$iv = charSequence2.charAt(n);
                boolean bl3 = false;
                char c = it;
                boolean bl4 = false;
                if (!Character.isDigit(c)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private NumericPattern() {
        }

        static {
            NumericPattern numericPattern;
            INSTANCE = numericPattern = new NumericPattern();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$AlphanumericPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class AlphanumericPattern
    implements StringPattern {
        @NotNull
        public static final AlphanumericPattern INSTANCE;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            boolean bl = false;
            if (charSequence.length() <= 0) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            CharSequence charSequence2 = $this$all$iv;
            int n = 0;
            while (n < charSequence2.length()) {
                char element$iv;
                char it = element$iv = charSequence2.charAt(n);
                boolean bl3 = false;
                char c = it;
                boolean bl4 = false;
                if (!Character.isLetterOrDigit(c)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private AlphanumericPattern() {
        }

        static {
            AlphanumericPattern alphanumericPattern;
            INSTANCE = alphanumericPattern = new AlphanumericPattern();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$BlankPattern;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class BlankPattern
    implements StringPattern {
        @NotNull
        public static final BlankPattern INSTANCE;

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return StringsKt.isBlank((CharSequence)value);
        }

        private BlankPattern() {
        }

        static {
            BlankPattern blankPattern;
            INSTANCE = blankPattern = new BlankPattern();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Licu/windea/breezeframework/core/component/StringPattern$Registry;", "Licu/windea/breezeframework/core/component/AbstractComponentRegistry;", "Licu/windea/breezeframework/core/component/StringPattern;", "()V", "registerDefault", "", "breeze-core"})
    public static final class Registry
    extends AbstractComponentRegistry<StringPattern> {
        static final /* synthetic */ Registry $$INSTANCE;

        @Override
        protected void registerDefault() {
            this.register((Component)BooleanPattern.INSTANCE);
            this.register((Component)WildcardBooleanPattern.INSTANCE);
            this.register((Component)IntPattern.INSTANCE);
            this.register((Component)NumberPattern.INSTANCE);
            this.register((Component)AlphaPattern.INSTANCE);
            this.register((Component)NumericPattern.INSTANCE);
            this.register((Component)AlphanumericPattern.INSTANCE);
        }

        private Registry() {
        }

        static {
            Registry registry;
            $$INSTANCE = registry = new Registry();
        }
    }
}

