/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006\u0010"}, d2={"actualMimeType", "", "Ljava/io/File;", "getActualMimeType", "(Ljava/io/File;)Ljava/lang/String;", "mimeType", "getMimeType", "shortName", "getShortName", "createDirectory", "", "createFile", "toUri", "Ljava/net/URI;", "toUrl", "Ljava/net/URL;", "breeze-core"})
@JvmName(name="FileExtensions")
public final class FileExtensions {
    @NotNull
    public static final String getShortName(@NotNull File $this$shortName) {
        Intrinsics.checkNotNullParameter((Object)$this$shortName, (String)"$this$shortName");
        return FilesKt.getNameWithoutExtension((File)$this$shortName);
    }

    @Nullable
    public static final String getMimeType(@NotNull File $this$mimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$mimeType, (String)"$this$mimeType");
        return URLConnection.guessContentTypeFromName($this$mimeType.getName());
    }

    @Nullable
    public static final String getActualMimeType(@NotNull File $this$actualMimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$actualMimeType, (String)"$this$actualMimeType");
        File file = $this$actualMimeType;
        boolean bl = false;
        return URLConnection.guessContentTypeFromStream(new FileInputStream(file));
    }

    public static final boolean createFile(@NotNull File $this$createFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"$this$createFile");
        $this$createFile.getParentFile().mkdirs();
        return $this$createFile.createNewFile();
    }

    public static final boolean createDirectory(@NotNull File $this$createDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"$this$createDirectory");
        return $this$createDirectory.mkdirs();
    }

    @NotNull
    public static final URI toUri(@NotNull File $this$toUri) {
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"$this$toUri");
        URI uRI = $this$toUri.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"this.toURI()");
        return uRI;
    }

    @NotNull
    public static final URL toUrl(@NotNull File $this$toUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toUrl, (String)"$this$toUrl");
        URL uRL = $this$toUrl.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"this.toURI().toURL()");
        return uRL;
    }
}

