/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import icu.windea.breezeframework.core.annotation.UnstableApi;
import icu.windea.breezeframework.core.extension.InternalExtensions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.List;
import java.util.UUID;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t\u001a&\u0010\u000f\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u001e\u0010\u000f\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\nH\u0007\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0014H\u0007\u001a\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0014H\u0007\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\n\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0016\u001a\u001a\u0010\u0015\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\n\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0018\u001a\u001a\u0010\u0017\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0018\u001a%\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a*\u00020\n2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001a0\u001c\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u0019\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001e\u001a\u0012\u0010\u0019\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0001\u001a#\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a*\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0 \u00a2\u0006\u0002\u0010!\u001a\u0012\u0010\"\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0007\u001a\u001a\u0010\"\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0007\u001a\n\u0010#\u001a\u00020$*\u00020\n\u001a\u0012\u0010#\u001a\u00020$*\u00020\n2\u0006\u0010\u0004\u001a\u00020$\u001a\u001a\u0010#\u001a\u00020$*\u00020\n2\u0006\u0010\u0002\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020$\u001a\u001a\u0010%\u001a\u00020\u0001*\u00020\n2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020(\u001a\u0014\u0010)\u001a\u00020**\u00020\nH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+\u001a!\u0010)\u001a\u00020**\u00020\n2\u0006\u0010\u0004\u001a\u00020*H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b,\u0010-\u001a)\u0010)\u001a\u00020**\u00020\n2\u0006\u0010\u0002\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020*H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b.\u0010/\u001a\u0014\u00100\u001a\u000201*\u00020\nH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102\u001a!\u00100\u001a\u000201*\u00020\n2\u0006\u0010\u0004\u001a\u000201H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b3\u00104\u001a)\u00100\u001a\u000201*\u00020\n2\u0006\u0010\u0002\u001a\u0002012\u0006\u0010\u0004\u001a\u000201H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b5\u00106\u001a\n\u00107\u001a\u000208*\u00020\n\u001a\n\u00109\u001a\u00020\u0001*\u00020\n\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006:"}, d2={"boundsErrorMessage", "", "from", "", "until", "checkRangeBounds", "", "", "checkChance", "", "Lkotlin/random/Random;", "chance", "predicate", "Lkotlin/Function0;", "condition", "nextBigDecimal", "Ljava/math/BigDecimal;", "mathContext", "Ljava/math/MathContext;", "nextBigInteger", "Ljava/math/BigInteger;", "nextByte", "", "nextChar", "", "nextElement", "T", "elements", "", "(Lkotlin/random/Random;[Ljava/lang/Object;)Ljava/lang/Object;", "", "string", "", "(Lkotlin/random/Random;Ljava/util/List;)Ljava/lang/Object;", "nextFloat", "nextShort", "", "nextString", "source", "length", "", "nextUByte", "Lkotlin/UByte;", "(Lkotlin/random/Random;)B", "nextUByte-EK-6454", "(Lkotlin/random/Random;B)B", "nextUByte-8olNwgk", "(Lkotlin/random/Random;BB)B", "nextUShort", "Lkotlin/UShort;", "(Lkotlin/random/Random;)S", "nextUShort-i8woANY", "(Lkotlin/random/Random;S)S", "nextUShort-lwaoQsk", "(Lkotlin/random/Random;SS)S", "nextUuid", "Ljava/util/UUID;", "nextUuidString", "breeze-core"})
@JvmName(name="RandomExtensions")
public final class RandomExtensions {
    public static final byte nextByte(@NotNull Random $this$nextByte) {
        Intrinsics.checkNotNullParameter((Object)$this$nextByte, (String)"$this$nextByte");
        return (byte)$this$nextByte.nextInt(-128, 127);
    }

    public static final byte nextByte(@NotNull Random $this$nextByte, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextByte, (String)"$this$nextByte");
        return (byte)$this$nextByte.nextInt((int)until);
    }

    public static final byte nextByte(@NotNull Random $this$nextByte, byte from, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextByte, (String)"$this$nextByte");
        return (byte)$this$nextByte.nextInt((int)from, (int)until);
    }

    public static final short nextShort(@NotNull Random $this$nextShort) {
        Intrinsics.checkNotNullParameter((Object)$this$nextShort, (String)"$this$nextShort");
        return (short)$this$nextShort.nextInt(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static final short nextShort(@NotNull Random $this$nextShort, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextShort, (String)"$this$nextShort");
        return (short)$this$nextShort.nextInt((int)until);
    }

    public static final short nextShort(@NotNull Random $this$nextShort, short from, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextShort, (String)"$this$nextShort");
        return (short)$this$nextShort.nextInt((int)from, (int)until);
    }

    public static final float nextFloat(@NotNull Random $this$nextFloat, float until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextFloat, (String)"$this$nextFloat");
        return RandomExtensions.nextFloat($this$nextFloat, 0.0f, until);
    }

    /*
     * Unable to fully structure code
     */
    public static final float nextFloat(@NotNull Random $this$nextFloat, float from, float until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextFloat, (String)"$this$nextFloat");
        RandomExtensions.checkRangeBounds(from, until);
        var5_4 = size = until - from;
        var6_5 = false;
        if (!Float.isInfinite(var5_4)) ** GOTO lbl-1000
        var5_4 = from;
        var6_5 = false;
        var7_6 = var5_4;
        var8_7 = false;
        if (Float.isInfinite(var7_6)) ** GOTO lbl-1000
        var7_6 = var5_4;
        var8_7 = false;
        if (!Float.isNaN(var7_6)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) ** GOTO lbl-1000
        var5_4 = until;
        var6_5 = false;
        var7_6 = var5_4;
        var8_7 = false;
        if (Float.isInfinite(var7_6)) ** GOTO lbl-1000
        var7_6 = var5_4;
        var8_7 = false;
        if (!Float.isNaN(var7_6)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (v1) {
            r1 = $this$nextFloat.nextFloat() * (until / (float)2 - from / (float)2);
            v2 = from + r1 + r1;
        } else lbl-1000:
        // 3 sources

        {
            v2 = r = from + $this$nextFloat.nextFloat() * size;
        }
        if (r >= until) {
            var5_4 = until;
            var6_5 = false;
            v3 = Math.nextAfter(var5_4, -Infinity);
        } else {
            v3 = r;
        }
        return v3;
    }

    public static final void checkRangeBounds(float from, float until) {
        boolean bl = until > from;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = RandomExtensions.boundsErrorMessage(Float.valueOf(from), Float.valueOf(until));
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final String boundsErrorMessage(@NotNull Object from, @NotNull Object until) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        return "Random range is empty: [" + from + ", " + until + ").";
    }

    public static final char nextChar(@NotNull Random $this$nextChar) {
        Intrinsics.checkNotNullParameter((Object)$this$nextChar, (String)"$this$nextChar");
        return (char)$this$nextChar.nextInt(0, 65535);
    }

    public static final char nextChar(@NotNull Random $this$nextChar, char until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextChar, (String)"$this$nextChar");
        return (char)$this$nextChar.nextInt((int)until);
    }

    public static final char nextChar(@NotNull Random $this$nextChar, char from, char until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextChar, (String)"$this$nextChar");
        return (char)$this$nextChar.nextInt((int)from, (int)until);
    }

    @UnstableApi
    @NotNull
    public static final BigInteger nextBigInteger(@NotNull Random $this$nextBigInteger) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigInteger, (String)"$this$nextBigInteger");
        long l = $this$nextBigInteger.nextLong();
        boolean bl = false;
        BigInteger bigInteger = BigInteger.valueOf(l);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(this)");
        return bigInteger;
    }

    @UnstableApi
    @NotNull
    public static final BigInteger nextBigInteger(@NotNull Random $this$nextBigInteger, @NotNull BigInteger until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigInteger, (String)"$this$nextBigInteger");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        long l = $this$nextBigInteger.nextLong(InternalExtensions.toLongOrMax(until));
        boolean bl = false;
        BigInteger bigInteger = BigInteger.valueOf(l);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(this)");
        return bigInteger;
    }

    @UnstableApi
    @NotNull
    public static final BigInteger nextBigInteger(@NotNull Random $this$nextBigInteger, @NotNull BigInteger from, @NotNull BigInteger until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigInteger, (String)"$this$nextBigInteger");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        long l = $this$nextBigInteger.nextLong(InternalExtensions.toLongOrMax(from), InternalExtensions.toLongOrMax(until));
        boolean bl = false;
        BigInteger bigInteger = BigInteger.valueOf(l);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.valueOf(this)");
        return bigInteger;
    }

    @UnstableApi
    @NotNull
    public static final BigDecimal nextBigDecimal(@NotNull Random $this$nextBigDecimal, @NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigDecimal, (String)"$this$nextBigDecimal");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        double d = $this$nextBigDecimal.nextDouble();
        boolean bl = false;
        return new BigDecimal(String.valueOf(d), mathContext);
    }

    public static /* synthetic */ BigDecimal nextBigDecimal$default(Random random, MathContext mathContext, int n, Object object) {
        if ((n & 1) != 0) {
            MathContext mathContext2 = MathContext.UNLIMITED;
            Intrinsics.checkNotNullExpressionValue((Object)mathContext2, (String)"MathContext.UNLIMITED");
            mathContext = mathContext2;
        }
        return RandomExtensions.nextBigDecimal(random, mathContext);
    }

    @UnstableApi
    @NotNull
    public static final BigDecimal nextBigDecimal(@NotNull Random $this$nextBigDecimal, @NotNull BigDecimal until, @NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigDecimal, (String)"$this$nextBigDecimal");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        double d = $this$nextBigDecimal.nextDouble(InternalExtensions.toDoubleOrMax(until));
        boolean bl = false;
        return new BigDecimal(String.valueOf(d), mathContext);
    }

    public static /* synthetic */ BigDecimal nextBigDecimal$default(Random random, BigDecimal bigDecimal, MathContext mathContext, int n, Object object) {
        if ((n & 2) != 0) {
            MathContext mathContext2 = MathContext.UNLIMITED;
            Intrinsics.checkNotNullExpressionValue((Object)mathContext2, (String)"MathContext.UNLIMITED");
            mathContext = mathContext2;
        }
        return RandomExtensions.nextBigDecimal(random, bigDecimal, mathContext);
    }

    @UnstableApi
    @NotNull
    public static final BigDecimal nextBigDecimal(@NotNull Random $this$nextBigDecimal, @NotNull BigDecimal from, @NotNull BigDecimal until, @NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigDecimal, (String)"$this$nextBigDecimal");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        double d = $this$nextBigDecimal.nextDouble(InternalExtensions.toDoubleOrMax(from), InternalExtensions.toDoubleOrMax(until));
        boolean bl = false;
        return new BigDecimal(String.valueOf(d), mathContext);
    }

    public static /* synthetic */ BigDecimal nextBigDecimal$default(Random random, BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, int n, Object object) {
        if ((n & 4) != 0) {
            MathContext mathContext2 = MathContext.UNLIMITED;
            Intrinsics.checkNotNullExpressionValue((Object)mathContext2, (String)"MathContext.UNLIMITED");
            mathContext = mathContext2;
        }
        return RandomExtensions.nextBigDecimal(random, bigDecimal, bigDecimal2, mathContext);
    }

    @ExperimentalUnsignedTypes
    public static final byte nextUByte(@NotNull Random $this$nextUByte) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUByte, (String)"$this$nextUByte");
        int n = 0;
        boolean bl = false;
        int n2 = n & 0xFF;
        n = -1;
        bl = false;
        n = $this$nextUByte.nextInt(n2, n & 0xFF);
        bl = false;
        return UByte.constructor-impl((byte)((byte)n));
    }

    @ExperimentalUnsignedTypes
    public static final byte nextUByte-EK-6454(@NotNull Random $this$nextUByte, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUByte, (String)"$this$nextUByte");
        int n = until;
        boolean bl = false;
        n = $this$nextUByte.nextInt(n & 0xFF);
        bl = false;
        return UByte.constructor-impl((byte)((byte)n));
    }

    @ExperimentalUnsignedTypes
    public static final byte nextUByte-8olNwgk(@NotNull Random $this$nextUByte, byte from, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUByte, (String)"$this$nextUByte");
        int n = from;
        boolean bl = false;
        int n2 = n & 0xFF;
        n = until;
        bl = false;
        n = $this$nextUByte.nextInt(n2, n & 0xFF);
        bl = false;
        return UByte.constructor-impl((byte)((byte)n));
    }

    @ExperimentalUnsignedTypes
    public static final short nextUShort(@NotNull Random $this$nextUShort) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUShort, (String)"$this$nextUShort");
        int n = 0;
        boolean bl = false;
        int n2 = n & 0xFFFF;
        n = -1;
        bl = false;
        n = $this$nextUShort.nextInt(n2, n & 0xFFFF);
        bl = false;
        return UShort.constructor-impl((short)((short)n));
    }

    @ExperimentalUnsignedTypes
    public static final short nextUShort-i8woANY(@NotNull Random $this$nextUShort, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUShort, (String)"$this$nextUShort");
        int n = until;
        boolean bl = false;
        n = $this$nextUShort.nextInt(n & 0xFFFF);
        bl = false;
        return UShort.constructor-impl((short)((short)n));
    }

    @ExperimentalUnsignedTypes
    public static final short nextUShort-lwaoQsk(@NotNull Random $this$nextUShort, short from, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUShort, (String)"$this$nextUShort");
        int n = from;
        boolean bl = false;
        int n2 = n & 0xFFFF;
        n = until;
        bl = false;
        n = $this$nextUShort.nextInt(n2, n & 0xFFFF);
        bl = false;
        return UShort.constructor-impl((short)((short)n));
    }

    @NotNull
    public static final String nextString(@NotNull Random $this$nextString, @NotNull String source, int length) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$nextString, (String)"$this$nextString");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string2 = source;
        boolean bl = false;
        char[] cArray = string2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        int size = chars.length;
        if (length < 0) {
            throw (Throwable)new IllegalArgumentException("Length cannot be negetive.");
        }
        if (length == 0) {
            string = "";
        } else {
            bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            int n = length;
            boolean bl6 = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl7 = false;
                $this$buildString.append(chars[$this$nextString.nextInt(size)]);
            }
            String string3 = stringBuilder.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        }
        return string;
    }

    @NotNull
    public static final UUID nextUuid(@NotNull Random $this$nextUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUuid, (String)"$this$nextUuid");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
        return uUID;
    }

    @NotNull
    public static final String nextUuidString(@NotNull Random $this$nextUuidString) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUuidString, (String)"$this$nextUuidString");
        String string = RandomExtensions.nextUuid($this$nextUuidString).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextUuid().toString()");
        return string;
    }

    public static final char nextElement(@NotNull Random $this$nextElement, @NotNull String string) {
        char c;
        Intrinsics.checkNotNullParameter((Object)$this$nextElement, (String)"$this$nextElement");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int length = string.length();
        switch (length) {
            case 0: {
                throw (Throwable)new IllegalArgumentException("Elements cannot be empty.");
            }
            case 1: {
                c = string.charAt(0);
                break;
            }
            default: {
                c = string.charAt($this$nextElement.nextInt(length));
            }
        }
        return c;
    }

    public static final char nextElement(@NotNull Random $this$nextElement, @NotNull char[] elements) {
        char c;
        Intrinsics.checkNotNullParameter((Object)$this$nextElement, (String)"$this$nextElement");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        int size = elements.length;
        switch (size) {
            case 0: {
                throw (Throwable)new IllegalArgumentException("Elements cannot be empty.");
            }
            case 1: {
                c = elements[0];
                break;
            }
            default: {
                c = elements[$this$nextElement.nextInt(size)];
            }
        }
        return c;
    }

    public static final <T> T nextElement(@NotNull Random $this$nextElement, @NotNull T[] elements) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$nextElement, (String)"$this$nextElement");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int size = elements.length;
        switch (size) {
            case 0: {
                throw (Throwable)new IllegalArgumentException("Elements cannot be empty.");
            }
            case 1: {
                t = elements[0];
                break;
            }
            default: {
                t = elements[$this$nextElement.nextInt(size)];
            }
        }
        return t;
    }

    public static final <T> T nextElement(@NotNull Random $this$nextElement, @NotNull List<? extends T> elements) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$nextElement, (String)"$this$nextElement");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int size = elements.size();
        switch (size) {
            case 0: {
                throw (Throwable)new IllegalArgumentException("Elements cannot be empty.");
            }
            case 1: {
                t = elements.get(0);
                break;
            }
            default: {
                t = elements.get($this$nextElement.nextInt(size));
            }
        }
        return t;
    }

    public static final boolean checkChance(@NotNull Random $this$checkChance, float chance) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$checkChance, (String)"$this$checkChance");
        float f = chance;
        boolean bl2 = f >= 0.0f && f <= 1.0f;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Chance must between 0 and 1, but was " + chance + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (chance == 1.0f) {
            bl = true;
        } else if (chance == 0.0f) {
            bl = false;
        } else {
            float f2 = $this$checkChance.nextFloat();
            float f3 = chance;
            bl = f3 >= 0.0f && f3 <= f2;
        }
        return bl;
    }

    public static final boolean checkChance(@NotNull Random $this$checkChance, float chance, boolean condition) {
        Intrinsics.checkNotNullParameter((Object)$this$checkChance, (String)"$this$checkChance");
        return condition && RandomExtensions.checkChance($this$checkChance, chance);
    }

    public static final boolean checkChance(@NotNull Random $this$checkChance, float chance, @NotNull Function0<Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$checkChance, (String)"$this$checkChance");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return (Boolean)predicate.invoke() != false && RandomExtensions.checkChance($this$checkChance, chance);
    }
}

