/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import icu.windea.breezeframework.core.extension.MathExtensions;
import icu.windea.breezeframework.core.extension.RegexExtensions;
import icu.windea.breezeframework.core.extension.StringExtensions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u001a\u0012\u0010\f\u001a\u00020\u0007*\u00020\b2\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"coerceLastLimitAtLeast", "", "firstLimit", "coerceLastLimitAtMost", "last", "findLastLimitIn", "fromRange", "", "Lkotlin/text/Regex$Companion;", "first", "range", "Lkotlin/ranges/ClosedRange;", "trim", "pattern", "breeze-core"})
@JvmName(name="RegexExtensions")
public final class RegexExtensions {
    @NotNull
    public static final String trim(@NotNull Regex.Companion $this$trim, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)$this$trim, (String)"$this$trim");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return StringExtensions.remove$default(pattern, "\\Q\\E", false, 2, null);
    }

    @NotNull
    public static final String fromRange(@NotNull Regex.Companion $this$fromRange, @NotNull ClosedRange<Integer> range) {
        Intrinsics.checkNotNullParameter((Object)$this$fromRange, (String)"$this$fromRange");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return RegexExtensions.fromRange($this$fromRange, ((Number)((Object)range.getStart())).intValue(), ((Number)((Object)range.getEndInclusive())).intValue());
    }

    @NotNull
    public static final String fromRange(@NotNull Regex.Companion $this$fromRange, int first, int last) {
        Intrinsics.checkNotNullParameter((Object)$this$fromRange, (String)"$this$fromRange");
        if (first > last) {
            throw (Throwable)new IllegalArgumentException("first " + first + " is greater than last " + last + '.');
        }
        if (first == last) {
            return String.valueOf(first);
        }
        if (first < 10 && last < 10) {
            return "" + '[' + first + '-' + last + ']';
        }
        boolean bl = false;
        List pairs = new ArrayList();
        int firstLimit = first;
        int lastLimit = RegexExtensions.findLastLimitIn(firstLimit, last);
        pairs.add(TuplesKt.to((Object)firstLimit, (Object)lastLimit));
        while (lastLimit < last) {
            firstLimit = lastLimit + 1;
            lastLimit = RegexExtensions.findLastLimitIn(firstLimit, last);
            pairs.add(TuplesKt.to((Object)firstLimit, (Object)lastLimit));
        }
        return CollectionsKt.joinToString$default((Iterable)pairs, (CharSequence)"|", null, null, (int)0, null, (Function1)fromRange.1.INSTANCE, (int)30, null);
    }

    private static final int findLastLimitIn(int firstLimit, int last) {
        int lastLimitAtLeast = RegexExtensions.coerceLastLimitAtLeast(firstLimit);
        int lastLimitAtMost = RegexExtensions.coerceLastLimitAtMost(firstLimit, last);
        boolean bl = false;
        return Math.min(lastLimitAtLeast, lastLimitAtMost);
    }

    private static final int coerceLastLimitAtLeast(int firstLimit) {
        int temp = firstLimit;
        int digit = 1;
        while (temp % 10 == 0) {
            temp /= 10;
            ++digit;
        }
        return (firstLimit / MathExtensions.positivePow(10, digit) + 1) * MathExtensions.positivePow(10, digit) - 1;
    }

    private static final int coerceLastLimitAtMost(int firstLimit, int last) {
        int temp1 = firstLimit / 10;
        int temp2 = last / 10;
        int digit = 1;
        while (temp1 != temp2) {
            temp1 /= 10;
            temp2 /= 10;
            ++digit;
        }
        return digit == 1 ? last : last / MathExtensions.positivePow(10, digit - 1) * MathExtensions.positivePow(10, digit - 1) - 1;
    }
}

