/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import icu.windea.breezeframework.core.extension.StringExtensions;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\r\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0086\b\u001a\r\u0010\u0010\u001a\u00020\u0011*\u00020\u0002H\u0086\b\u001a\r\u0010\u0012\u001a\u00020\u0013*\u00020\u0002H\u0086\b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\")\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000b\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"fullPath", "", "Ljava/net/URL;", "getFullPath", "(Ljava/net/URL;)Ljava/lang/String;", "hasQueryParams", "", "getHasQueryParams", "(Ljava/net/URL;)Z", "queryParams", "", "", "getQueryParams", "(Ljava/net/URL;)Ljava/util/Map;", "toFile", "Ljava/io/File;", "toPath", "Ljava/nio/file/Path;", "toUri", "Ljava/net/URI;", "breeze-core"})
@JvmName(name="UrlExtensions")
public final class UrlExtensions {
    @NotNull
    public static final String getFullPath(@NotNull URL $this$fullPath) {
        Intrinsics.checkNotNullParameter((Object)$this$fullPath, (String)"$this$fullPath");
        return $this$fullPath.getHost() + $this$fullPath.getPath();
    }

    public static final boolean getHasQueryParams(@NotNull URL $this$hasQueryParams) {
        Intrinsics.checkNotNullParameter((Object)$this$hasQueryParams, (String)"$this$hasQueryParams");
        return $this$hasQueryParams.getQuery() != null;
    }

    @Nullable
    public static final Map<String, List<String>> getQueryParams(@NotNull URL $this$queryParams) {
        Intrinsics.checkNotNullParameter((Object)$this$queryParams, (String)"$this$queryParams");
        String string = $this$queryParams.getQuery();
        return string != null ? StringExtensions.toQueryParams(string) : null;
    }

    @NotNull
    public static final File toFile(@NotNull URL $this$toFile) {
        int $i$f$toFile = 0;
        Intrinsics.checkNotNullParameter((Object)$this$toFile, (String)"$this$toFile");
        return new File($this$toFile.toURI().normalize());
    }

    @NotNull
    public static final Path toPath(@NotNull URL $this$toPath) {
        int $i$f$toPath = 0;
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"$this$toPath");
        URL $this$toFile$iv = $this$toPath;
        boolean $i$f$toFile = false;
        Path path = new File($this$toFile$iv.toURI().normalize()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.toFile().toPath()");
        return path;
    }

    @NotNull
    public static final URI toUri(@NotNull URL $this$toUri) {
        int $i$f$toUri = 0;
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"$this$toUri");
        URI uRI = $this$toUri.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"this.toURI()");
        return uRI;
    }
}

