// Copyright (c) 2020-2021 DragonKnightOfBreeze Windea
// Breeze is blowing...

package icu.windea.breezeframework.core.type

/**
 * 代表了一个字节范围。
 *
 * Represents a range of byte numbers.
 */
typealias ByteRange = ClosedRange<Byte>

/**
 * 代表了一个短整数范围。
 *
 * Represents a range of short numbers.
 */
typealias ShortRange = ClosedRange<Short>

/**
 * 代表了一个单精度浮点数范围。
 *
 * Represents a range of float numbers.
 */
typealias FloatRange = ClosedFloatingPointRange<Float>

/**
 * 代表了一个双精度浮点数范围。
 *
 * Represents a range of double numbers.
 */
typealias DoubleRange = ClosedFloatingPointRange<Double>
