/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.annotation.InternalApi;
import icu.windea.breezeframework.core.component.PathFormat;
import icu.windea.breezeframework.core.component.Queriers;
import icu.windea.breezeframework.core.extension.CollectionExtensions;
import icu.windea.breezeframework.core.extension.StringExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J#\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001aJ+\u0010\u001b\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u0002H\u0017H\u0016\u00a2\u0006\u0002\u0010\u001dJ1\u0010\u001e\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001fH\u0016\u00a2\u0006\u0002\u0010 J%\u0010!\u001a\u0004\u0018\u0001H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\"\u001a\u00020#H\u0016J\u001b\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&H\u0016\u00a2\u0006\u0002\u0010'J\u0016\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050(H\u0016J\u0016\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050)H\u0016J\u0018\u0010*\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J%\u0010+\u001a\u0004\u0018\u0001H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010\u001aJ$\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00170-\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0014J\u0010\u0010.\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J$\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00170-\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J$\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005012\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050)2\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00065"}, d2={"Licu/windea/breezeframework/core/component/AbstractPathFormat;", "Licu/windea/breezeframework/core/component/PathFormat;", "delimiter", "", "prefix", "", "variablePrefix", "variableSuffix", "(CLjava/lang/String;CLjava/lang/Character;)V", "getDelimiter", "()C", "delimiterString", "getPrefix", "()Ljava/lang/String;", "getVariablePrefix", "getVariableSuffix", "()Ljava/lang/Character;", "Ljava/lang/Character;", "equals", "", "other", "", "get", "T", "value", "path", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "getOrDefault", "defaultValue", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getOrElse", "Lkotlin/Function0;", "(Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrNull", "hashCode", "", "joinToString", "metaPaths", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "metaGet", "metaQuery", "", "normalize", "query", "resolveVariables", "", "split", "splitToSequence", "toString", "breeze-core"})
public abstract class AbstractPathFormat
implements PathFormat {
    private final char delimiter;
    @NotNull
    private final String prefix;
    private final char variablePrefix;
    @Nullable
    private final Character variableSuffix;
    @NotNull
    private final String delimiterString;

    public AbstractPathFormat(char delimiter, @NotNull String prefix, char variablePrefix, @Nullable Character variableSuffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.variablePrefix = variablePrefix;
        this.variableSuffix = variableSuffix;
        this.delimiterString = String.valueOf(this.delimiter);
    }

    public /* synthetic */ AbstractPathFormat(char c, String string, char c2, Character c3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            c = (char)47;
        }
        if ((n & 2) != 0) {
            string = "/";
        }
        if ((n & 4) != 0) {
            c2 = (char)123;
        }
        if ((n & 8) != 0) {
            c3 = Character.valueOf('}');
        }
        this(c, string, c2, c3);
    }

    protected final char getDelimiter() {
        return this.delimiter;
    }

    @NotNull
    protected final String getPrefix() {
        return this.prefix;
    }

    protected final char getVariablePrefix() {
        return this.variablePrefix;
    }

    @Nullable
    protected final Character getVariableSuffix() {
        return this.variableSuffix;
    }

    @Override
    @NotNull
    public String normalize(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = new StringBuilder();
        StringBuilder $this$normalize_u24lambda_u2d0 = object;
        boolean bl = false;
        String string = ((Object)StringsKt.trim((CharSequence)path)).toString();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (CharsKt.isWhitespace((char)c)) continue;
            $this$normalize_u24lambda_u2d0.append(c);
        }
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        object = new char[1];
        object[0] = this.delimiter;
        return StringsKt.trimEnd((String)string2, (char[])object);
    }

    @Override
    public boolean matches(@NotNull String value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int pathIndex = 0;
        int valueIndex = 0;
        int lastPathIndex = StringsKt.getLastIndex((CharSequence)path);
        int lastValueIndex = StringsKt.getLastIndex((CharSequence)value);
        while (pathIndex <= lastPathIndex && valueIndex <= lastValueIndex) {
            int n;
            char pathChar = path.charAt(pathIndex);
            if (pathChar == this.delimiter && pathIndex < lastPathIndex && path.charAt(pathIndex + 1) == this.variablePrefix) {
                while ((pathIndex = (n = pathIndex) + 1) <= lastPathIndex && path.charAt(pathIndex) != this.delimiter) {
                }
                while ((valueIndex = (n = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != this.delimiter) {
                }
                if (this.variableSuffix == null) continue;
                Character c = this.variableSuffix;
                if (c != null && path.charAt(pathIndex - 1) == c.charValue()) continue;
                throw new IllegalArgumentException("Invalid path '" + path + "': mismatched variable prefix and suffix.");
            }
            if (pathChar != value.charAt(valueIndex)) {
                return false;
            }
            n = pathIndex;
            pathIndex = n + 1;
            n = valueIndex;
            valueIndex = n + 1;
        }
        return pathIndex - lastPathIndex == valueIndex - lastValueIndex;
    }

    @Override
    @NotNull
    public Map<String, String> resolveVariables(@NotNull String value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Map variables = new LinkedHashMap();
        int pathIndex = 0;
        int valueIndex = 0;
        int lastPathIndex = StringsKt.getLastIndex((CharSequence)path);
        int lastValueIndex = StringsKt.getLastIndex((CharSequence)value);
        while (pathIndex <= lastPathIndex && valueIndex <= lastValueIndex) {
            char pathChar = path.charAt(pathIndex);
            if (pathChar == this.delimiter && pathIndex < lastPathIndex && path.charAt(pathIndex + 1) == this.variablePrefix) {
                int n;
                int variableNameStartIndex = pathIndex + 2;
                int variableValueStartIndex = valueIndex + 1;
                while ((pathIndex = (n = pathIndex) + 1) <= lastPathIndex && path.charAt(pathIndex) != this.delimiter) {
                }
                while ((valueIndex = (n = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != this.delimiter) {
                }
                if (this.variableSuffix != null) {
                    Character c = this.variableSuffix;
                    if (c == null || path.charAt(pathIndex - 1) != c.charValue()) {
                        throw new IllegalArgumentException("Invalid path '" + path + "': mismatched variable prefix and suffix.");
                    }
                }
                int variableNameEndIndex = pathIndex - 1;
                int variableValueEndIndex = valueIndex;
                String string = path.substring(variableNameStartIndex, variableNameEndIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String variableName = string;
                String string2 = value.substring(variableValueStartIndex, variableValueEndIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String variableValue = string2;
                variables.put(variableName, variableValue);
                continue;
            }
            if (pathChar != value.charAt(valueIndex)) {
                return MapsKt.emptyMap();
            }
            int n = pathIndex;
            pathIndex = n + 1;
            n = valueIndex;
            valueIndex = n + 1;
        }
        return pathIndex - lastPathIndex == valueIndex - lastValueIndex ? variables : MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> split(@NotNull String path) {
        void $this$filterNotEmptyTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        char[] cArray = new char[]{this.delimiter};
        Iterable $this$filterNotEmpty$iv = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)this.normalize(path), (CharSequence)this.prefix), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNotEmpty = false;
        Iterable iterable = $this$filterNotEmpty$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotEmptyTo = false;
        for (CharSequence element$iv$iv : $this$filterNotEmptyTo$iv$iv) {
            if (!(element$iv$iv.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Sequence<String> splitToSequence(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        char[] cArray = new char[]{this.delimiter};
        Sequence $this$filterNotEmpty$iv = StringsKt.splitToSequence$default((CharSequence)StringsKt.removePrefix((String)this.normalize(path), (CharSequence)this.prefix), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNotEmpty = false;
        return SequencesKt.filter((Sequence)$this$filterNotEmpty$iv, (Function1)CollectionExtensions.filterNotEmpty.1.INSTANCE);
    }

    @Override
    @NotNull
    public String joinToString(@NotNull String[] metaPaths) {
        Intrinsics.checkNotNullParameter((Object)metaPaths, (String)"metaPaths");
        return StringExtensions.addPrefix(ArraysKt.joinToString$default((Object[])metaPaths, (CharSequence)this.delimiterString, null, null, (int)0, null, null, (int)62, null), (CharSequence)this.prefix);
    }

    @Override
    @NotNull
    public String joinToString(@NotNull Iterable<String> metaPaths) {
        Intrinsics.checkNotNullParameter(metaPaths, (String)"metaPaths");
        return StringExtensions.addPrefix(CollectionsKt.joinToString$default(metaPaths, (CharSequence)this.delimiterString, null, null, (int)0, null, null, (int)62, null), (CharSequence)this.prefix);
    }

    @Override
    @NotNull
    public String joinToString(@NotNull Sequence<String> metaPaths) {
        Intrinsics.checkNotNullParameter(metaPaths, (String)"metaPaths");
        return StringExtensions.addPrefix(SequencesKt.joinToString$default(metaPaths, (CharSequence)this.delimiterString, null, null, (int)0, null, null, (int)62, null), (CharSequence)this.prefix);
    }

    @NotNull
    protected <T> List<T> metaQuery(@NotNull Object value, @NotNull String path) {
        List list;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((CharSequence)path, (char)this.variablePrefix, (boolean)false, (int)2, null) && (this.variableSuffix == null || StringsKt.endsWith$default((CharSequence)path, (char)this.variableSuffix.charValue(), (boolean)false, (int)2, null))) {
            list = Queriers.ResultsQuerier.INSTANCE.query(value, "");
        } else {
            if (StringsKt.startsWith$default((CharSequence)path, (char)this.variablePrefix, (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Invalid path '" + path + "': mismatched variable prefix and suffix.");
            }
            Object r = Queriers.StringQuerier.INSTANCE.queryOrNull(value, StringsKt.removePrefix((String)path, (CharSequence)this.prefix));
            List list2 = r == null ? null : CollectionExtensions.toSingletonList$default(r, false, 1, null);
            list = list2 == null ? CollectionsKt.emptyList() : list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T> List<T> query(@NotNull Object value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Sequence<String> metaPaths = this.splitToSequence(path);
        if (SequencesKt.none(metaPaths)) {
            return CollectionsKt.listOf((Object)value);
        }
        List result = CollectionsKt.listOf((Object)value);
        for (String metaPath : metaPaths) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = result;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                List<T> list;
                Object element$iv$iv;
                Object v = element$iv$iv = iterator.next();
                boolean bl = false;
                try {
                    list = v != null ? this.metaQuery(v, metaPath) : CollectionsKt.emptyList();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot query '" + value.getClass().getSimpleName() + "' by path '" + path + "'.", e);
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            result = (List)destination$iv$iv;
        }
        return result;
    }

    @Nullable
    protected <T> T metaGet(@NotNull Object value, @NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((CharSequence)path, (char)this.variablePrefix, (boolean)false, (int)2, null) && (this.variableSuffix == null || StringsKt.endsWith$default((CharSequence)path, (char)this.variableSuffix.charValue(), (boolean)false, (int)2, null))) {
            object = Queriers.FirstResultQuerier.INSTANCE.queryOrNull(value, "");
        } else {
            if (StringsKt.startsWith$default((CharSequence)path, (char)this.variablePrefix, (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Invalid path '" + path + "': mismatched variable prefix and suffix.");
            }
            object = Queriers.StringQuerier.INSTANCE.queryOrNull(value, StringsKt.removePrefix((String)path, (CharSequence)this.prefix));
        }
        return (T)object;
    }

    @Override
    public <T> T get(@NotNull Object value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Sequence<String> metaPaths = this.splitToSequence(path);
        if (SequencesKt.none(metaPaths)) {
            return (T)value;
        }
        Object currentValue = value;
        for (String metaPath : metaPaths) {
            if (this.metaGet(currentValue, metaPath) != null) continue;
            throw new IllegalArgumentException("Cannot query by path '" + path + "'.");
        }
        return (T)currentValue;
    }

    @Override
    @Nullable
    public <T> T getOrNull(@NotNull Object value, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Sequence<String> metaPaths = this.splitToSequence(path);
        if (SequencesKt.none(metaPaths)) {
            return (T)value;
        }
        Object currentValue = value;
        for (String metaPath : metaPaths) {
            if (this.metaGet(currentValue, metaPath) != null) continue;
            return null;
        }
        return (T)currentValue;
    }

    @Override
    public <T> T getOrDefault(@NotNull Object value, @NotNull String path, T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Sequence<String> metaPaths = this.splitToSequence(path);
        if (SequencesKt.none(metaPaths)) {
            return (T)value;
        }
        Object currentValue = value;
        for (String metaPath : metaPaths) {
            if (this.metaGet(currentValue, metaPath) != null) continue;
            return defaultValue;
        }
        return (T)currentValue;
    }

    @Override
    public <T> T getOrElse(@NotNull Object value, @NotNull String path, @NotNull Function0<? extends T> defaultValue) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Sequence<String> metaPaths = this.splitToSequence(path);
        if (SequencesKt.none(metaPaths)) {
            return (T)value;
        }
        Object currentValue = value;
        for (String metaPath : metaPaths) {
            if (this.metaGet(currentValue, metaPath) != null) continue;
            return (T)defaultValue.invoke();
        }
        return (T)currentValue;
    }

    public boolean equals(@Nullable Object other) {
        return this.componentEquals(other);
    }

    public int hashCode() {
        return this.componentHashcode();
    }

    @NotNull
    public String toString() {
        return this.componentToString();
    }

    @Override
    @NotNull
    public PathFormat componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
        return PathFormat.DefaultImpls.componentCopy(this, componentParams);
    }

    @Override
    public String getComponentId() {
        return PathFormat.DefaultImpls.getComponentId(this);
    }

    @Override
    @NotNull
    public Map<String, Object> getComponentParams() {
        return PathFormat.DefaultImpls.getComponentParams(this);
    }

    @Override
    @InternalApi
    public boolean componentEquals(@Nullable Object other) {
        return PathFormat.DefaultImpls.componentEquals(this, other);
    }

    @Override
    @InternalApi
    public int componentHashcode() {
        return PathFormat.DefaultImpls.componentHashcode(this);
    }

    @Override
    @InternalApi
    @NotNull
    public String componentToString() {
        return PathFormat.DefaultImpls.componentToString(this);
    }

    public AbstractPathFormat() {
        this('\u0000', null, '\u0000', null, 15, null);
    }
}

