/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.annotation.InternalApi;
import icu.windea.breezeframework.core.component.AbstractCaseFormat;
import icu.windea.breezeframework.core.component.CaseFormat;
import icu.windea.breezeframework.core.component.CaseFormats;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.extension.CollectionExtensions;
import icu.windea.breezeframework.core.extension.InternalExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0014\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u001d"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/CaseFormat;", "()V", "infer", "value", "", "registerDefault", "", "CamelCaseFormat", "Capitalized", "CapitalizedWords", "FirstWordCapitalized", "HyphenWords", "KebabCaseFormat", "KebabUpperCaseFormat", "LinuxPath", "LowerCaseFormat", "LowerCaseFormatWords", "PascalCaseFormat", "PathLikeCaseFormat", "ReferencePath", "ScreamingSnakeCaseFormat", "SnakeCaseFormat", "UnderscoreWords", "UpperCaseFormat", "UpperCaseFormatWords", "WindowsPath", "Words", "breeze-core"})
public final class CaseFormats
extends ComponentRegistry<CaseFormat> {
    @NotNull
    public static final CaseFormats INSTANCE = new CaseFormats();

    private CaseFormats() {
    }

    @Override
    protected void registerDefault() {
        this.register((Component)LowerCaseFormat.INSTANCE);
        this.register((Component)UpperCaseFormat.INSTANCE);
        this.register((Component)Capitalized.INSTANCE);
        this.register((Component)LowerCaseFormatWords.INSTANCE);
        this.register((Component)UpperCaseFormatWords.INSTANCE);
        this.register((Component)FirstWordCapitalized.INSTANCE);
        this.register((Component)CapitalizedWords.INSTANCE);
        this.register((Component)Words.INSTANCE);
        this.register((Component)CamelCaseFormat.INSTANCE);
        this.register((Component)PascalCaseFormat.INSTANCE);
        this.register((Component)SnakeCaseFormat.INSTANCE);
        this.register((Component)ScreamingSnakeCaseFormat.INSTANCE);
        this.register((Component)UnderscoreWords.INSTANCE);
        this.register((Component)KebabCaseFormat.INSTANCE);
        this.register((Component)KebabUpperCaseFormat.INSTANCE);
        this.register((Component)HyphenWords.INSTANCE);
        this.register((Component)ReferencePath.INSTANCE);
        this.register((Component)LinuxPath.INSTANCE);
        this.register((Component)WindowsPath.INSTANCE);
    }

    @Nullable
    public final CaseFormat infer(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (CaseFormat caseFormat : this.getComponents().values()) {
            if (!caseFormat.matches(value)) continue;
            return caseFormat;
        }
        return null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$LowerCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class LowerCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final LowerCaseFormat INSTANCE = new LowerCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("[a-z]+");

        private LowerCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)value);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object[] objectArray = new String[]{value};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = ArraysKt.joinToString$default((Object[])value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = CollectionsKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = SequencesKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$UpperCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class UpperCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final UpperCaseFormat INSTANCE = new UpperCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("[A-Z]+");

        private UpperCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)value);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object[] objectArray = new String[]{value};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = ArraysKt.joinToString$default((Object[])value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = CollectionsKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = SequencesKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$Capitalized;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class Capitalized
    extends AbstractCaseFormat {
        @NotNull
        public static final Capitalized INSTANCE = new Capitalized();
        @NotNull
        private static final Regex regex = new Regex("[A-Z][a-z]+");

        private Capitalized() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return CollectionsKt.listOf((Object)value);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object[] objectArray = new String[]{value};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return InternalExtensions.firstCharToUpperCase(ArraysKt.joinToString$default((Object[])value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return InternalExtensions.firstCharToUpperCase(CollectionsKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return InternalExtensions.firstCharToUpperCase(SequencesKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$LowerCaseFormatWords;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class LowerCaseFormatWords
    extends AbstractCaseFormat {
        @NotNull
        public static final LowerCaseFormatWords INSTANCE = new LowerCaseFormatWords();
        @NotNull
        private static final Regex regex = new Regex("[a-z']+(?:\\s+[a-z']+)+");

        private LowerCaseFormatWords() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            void $this$filterNotEmptyTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Iterable $this$filterNotEmpty$iv = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            Iterable iterable = $this$filterNotEmpty$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotEmptyTo = false;
            for (CharSequence element$iv$iv : $this$filterNotEmptyTo$iv$iv) {
                if (!(element$iv$iv.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Sequence $this$filterNotEmpty$iv = StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            return SequencesKt.filter((Sequence)$this$filterNotEmpty$iv, (Function1)CollectionExtensions.filterNotEmpty.1.INSTANCE);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = ArraysKt.joinToString$default((Object[])value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = CollectionsKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = SequencesKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$UpperCaseFormatWords;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class UpperCaseFormatWords
    extends AbstractCaseFormat {
        @NotNull
        public static final UpperCaseFormatWords INSTANCE = new UpperCaseFormatWords();
        @NotNull
        private static final Regex regex = new Regex("[A-Z']+(?:\\s+[A-Z']+)+");

        private UpperCaseFormatWords() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            void $this$filterNotEmptyTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Iterable $this$filterNotEmpty$iv = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            Iterable iterable = $this$filterNotEmpty$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotEmptyTo = false;
            for (CharSequence element$iv$iv : $this$filterNotEmptyTo$iv$iv) {
                if (!(element$iv$iv.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Sequence $this$filterNotEmpty$iv = StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            return SequencesKt.filter((Sequence)$this$filterNotEmpty$iv, (Function1)CollectionExtensions.filterNotEmpty.1.INSTANCE);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = ArraysKt.joinToString$default((Object[])value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = CollectionsKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            String string = SequencesKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$FirstWordCapitalized;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class FirstWordCapitalized
    extends AbstractCaseFormat {
        @NotNull
        public static final FirstWordCapitalized INSTANCE = new FirstWordCapitalized();
        @NotNull
        private static final Regex regex = new Regex("[A-Z][a-z']*(?:\\s+[a-z']+)+");

        private FirstWordCapitalized() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            void $this$filterNotEmptyTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Iterable $this$filterNotEmpty$iv = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            Iterable iterable = $this$filterNotEmpty$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotEmptyTo = false;
            for (CharSequence element$iv$iv : $this$filterNotEmptyTo$iv$iv) {
                if (!(element$iv$iv.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Sequence $this$filterNotEmpty$iv = StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            return SequencesKt.filter((Sequence)$this$filterNotEmpty$iv, (Function1)CollectionExtensions.filterNotEmpty.1.INSTANCE);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return InternalExtensions.firstCharToUpperCase(ArraysKt.joinToString$default((Object[])value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return InternalExtensions.firstCharToUpperCase(CollectionsKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return InternalExtensions.firstCharToUpperCase(SequencesKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$CapitalizedWords;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class CapitalizedWords
    extends AbstractCaseFormat {
        @NotNull
        public static final CapitalizedWords INSTANCE = new CapitalizedWords();
        @NotNull
        private static final Regex regex = new Regex("[A-Z][a-z']*(?:\\s+[a-z']+)+");

        private CapitalizedWords() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            void $this$filterNotEmptyTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Iterable $this$filterNotEmpty$iv = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            Iterable iterable = $this$filterNotEmpty$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotEmptyTo = false;
            for (CharSequence element$iv$iv : $this$filterNotEmptyTo$iv$iv) {
                if (!(element$iv$iv.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Sequence $this$filterNotEmpty$iv = StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            return SequencesKt.filter((Sequence)$this$filterNotEmpty$iv, (Function1)CollectionExtensions.filterNotEmpty.1.INSTANCE);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)" ", null, null, (int)0, null, (Function1)joinToString.1.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, (Function1)joinToString.2.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, (Function1)joinToString.3.INSTANCE, (int)30, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$Words;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class Words
    extends AbstractCaseFormat {
        @NotNull
        public static final Words INSTANCE = new Words();
        @NotNull
        private static final Regex regex = new Regex("[a-zA-Z']+(?:\\s+[a-zA-Z']+)+");

        private Words() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            void $this$filterNotEmptyTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Iterable $this$filterNotEmpty$iv = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            Iterable iterable = $this$filterNotEmpty$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotEmptyTo = false;
            for (CharSequence element$iv$iv : $this$filterNotEmptyTo$iv$iv) {
                if (!(element$iv$iv.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            Sequence $this$filterNotEmpty$iv = StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filterNotEmpty = false;
            return SequencesKt.filter((Sequence)$this$filterNotEmpty$iv, (Function1)CollectionExtensions.filterNotEmpty.1.INSTANCE);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$CamelCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class CamelCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final CamelCaseFormat INSTANCE = new CamelCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("\\$?[a-z]+(?:\\$?[A-Z][a-z]+\\$?|\\$?[A-Z]+\\$?|\\d+)+");

        private CamelCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            return StringsKt.split$default((CharSequence)InternalExtensions.splitWords(value), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            return StringsKt.splitToSequence$default((CharSequence)InternalExtensions.splitWords(value), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return InternalExtensions.firstCharToLowerCase(ArraysKt.joinToString$default((Object[])value, (CharSequence)"", null, null, (int)0, null, (Function1)joinToString.1.INSTANCE, (int)30, null));
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return InternalExtensions.firstCharToLowerCase(CollectionsKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, (Function1)joinToString.2.INSTANCE, (int)30, null));
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return InternalExtensions.firstCharToLowerCase(SequencesKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, (Function1)joinToString.3.INSTANCE, (int)30, null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$PascalCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class PascalCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final PascalCaseFormat INSTANCE = new PascalCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("\\$?(?:[A-Z][a-z]+|[A-Z]+)(?:\\$?[A-Z][a-z]+\\$?|\\$?[A-Z]+\\$?|\\d+)+");

        private PascalCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            return StringsKt.split$default((CharSequence)InternalExtensions.splitWords(value), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{' '};
            return StringsKt.splitToSequence$default((CharSequence)InternalExtensions.splitWords(value), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"", null, null, (int)0, null, (Function1)joinToString.1.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, (Function1)joinToString.2.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"", null, null, (int)0, null, (Function1)joinToString.3.INSTANCE, (int)30, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$SnakeCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class SnakeCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final SnakeCaseFormat INSTANCE = new SnakeCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("\\$?[a-z]+(?:_(?:\\$?[a-z]+\\$?|\\d+))+");

        private SnakeCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'_'};
            return StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'_'};
            return StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"_", null, null, (int)0, null, (Function1)joinToString.1.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"_", null, null, (int)0, null, (Function1)joinToString.2.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"_", null, null, (int)0, null, (Function1)joinToString.3.INSTANCE, (int)30, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$ScreamingSnakeCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class ScreamingSnakeCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final ScreamingSnakeCaseFormat INSTANCE = new ScreamingSnakeCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("\\$?[A-Z]+(?:_(?:\\$?[A-Z]+|\\d+))+");

        private ScreamingSnakeCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'_'};
            return StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'_'};
            return StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"_", null, null, (int)0, null, (Function1)joinToString.1.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"_", null, null, (int)0, null, (Function1)joinToString.2.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"_", null, null, (int)0, null, (Function1)joinToString.3.INSTANCE, (int)30, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$UnderscoreWords;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class UnderscoreWords
    extends AbstractCaseFormat {
        @NotNull
        public static final UnderscoreWords INSTANCE = new UnderscoreWords();
        @NotNull
        private static final Regex regex = new Regex("_*[a-zA-Z$]+(?:_+(?:[a-zA-Z$]+|\\d+))+");

        private UnderscoreWords() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'_'};
            return StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'_'};
            return StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$KebabCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class KebabCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final KebabCaseFormat INSTANCE = new KebabCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("[a-z]+(?:-(?:[a-z]+|\\d+))+");

        private KebabCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'-'};
            return StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'-'};
            return StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"-", null, null, (int)0, null, (Function1)joinToString.1.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"-", null, null, (int)0, null, (Function1)joinToString.2.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"-", null, null, (int)0, null, (Function1)joinToString.3.INSTANCE, (int)30, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$KebabUpperCaseFormat;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class KebabUpperCaseFormat
    extends AbstractCaseFormat {
        @NotNull
        public static final KebabUpperCaseFormat INSTANCE = new KebabUpperCaseFormat();
        @NotNull
        private static final Regex regex = new Regex("[A-Z]+(?:-(?:[A-Z]+|\\d+))+");

        private KebabUpperCaseFormat() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'-'};
            return StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'-'};
            return StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"-", null, null, (int)0, null, (Function1)joinToString.1.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"-", null, null, (int)0, null, (Function1)joinToString.2.INSTANCE, (int)30, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"-", null, null, (int)0, null, (Function1)joinToString.3.INSTANCE, (int)30, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$HyphenWords;", "Licu/windea/breezeframework/core/component/AbstractCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class HyphenWords
    extends AbstractCaseFormat {
        @NotNull
        public static final HyphenWords INSTANCE = new HyphenWords();
        @NotNull
        private static final Regex regex = new Regex("-*[a-zA-Z]+(?:-+(?:[a-zA-Z]+|\\d+))+");

        private HyphenWords() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'-'};
            return StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'-'};
            return StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"-", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$PathLikeCaseFormat;", "", "breeze-core"})
    public static interface PathLikeCaseFormat {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$ReferencePath;", "Licu/windea/breezeframework/core/component/CaseFormat;", "Licu/windea/breezeframework/core/component/CaseFormats$PathLikeCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class ReferencePath
    implements CaseFormat,
    PathLikeCaseFormat {
        @NotNull
        public static final ReferencePath INSTANCE = new ReferencePath();
        @NotNull
        private static final Regex regex = new Regex("[a-zA-Z_\\-$]+(?:\\.[a-zA-Z_\\-$]+)+");

        private ReferencePath() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'.'};
            return StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'.'};
            return StringsKt.splitToSequence$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public CaseFormat componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            return CaseFormat.DefaultImpls.componentCopy(this, componentParams);
        }

        @Override
        public String getComponentId() {
            return CaseFormat.DefaultImpls.getComponentId(this);
        }

        @Override
        @NotNull
        public Map<String, Object> getComponentParams() {
            return CaseFormat.DefaultImpls.getComponentParams(this);
        }

        @Override
        @InternalApi
        public boolean componentEquals(@Nullable Object other) {
            return CaseFormat.DefaultImpls.componentEquals(this, other);
        }

        @Override
        @InternalApi
        public int componentHashcode() {
            return CaseFormat.DefaultImpls.componentHashcode(this);
        }

        @Override
        @InternalApi
        @NotNull
        public String componentToString() {
            return CaseFormat.DefaultImpls.componentToString(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$LinuxPath;", "Licu/windea/breezeframework/core/component/CaseFormat;", "Licu/windea/breezeframework/core/component/CaseFormats$PathLikeCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class LinuxPath
    implements CaseFormat,
    PathLikeCaseFormat {
        @NotNull
        public static final LinuxPath INSTANCE = new LinuxPath();
        @NotNull
        private static final Regex regex = new Regex("/?[^/\\\\\\s]+(?:/[^/\\\\\\s]+]+)+/?");

        private LinuxPath() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'/'};
            CharSequence charSequence = StringsKt.trim((String)value, (char[])cArray);
            cArray = new char[]{'/'};
            return StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'/'};
            CharSequence charSequence = StringsKt.trim((String)value, (char[])cArray);
            cArray = new char[]{'/'};
            return StringsKt.splitToSequence$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public CaseFormat componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            return CaseFormat.DefaultImpls.componentCopy(this, componentParams);
        }

        @Override
        public String getComponentId() {
            return CaseFormat.DefaultImpls.getComponentId(this);
        }

        @Override
        @NotNull
        public Map<String, Object> getComponentParams() {
            return CaseFormat.DefaultImpls.getComponentParams(this);
        }

        @Override
        @InternalApi
        public boolean componentEquals(@Nullable Object other) {
            return CaseFormat.DefaultImpls.componentEquals(this, other);
        }

        @Override
        @InternalApi
        public int componentHashcode() {
            return CaseFormat.DefaultImpls.componentHashcode(this);
        }

        @Override
        @InternalApi
        @NotNull
        public String componentToString() {
            return CaseFormat.DefaultImpls.componentToString(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Licu/windea/breezeframework/core/component/CaseFormats$WindowsPath;", "Licu/windea/breezeframework/core/component/CaseFormat;", "Licu/windea/breezeframework/core/component/CaseFormats$PathLikeCaseFormat;", "()V", "regex", "Lkotlin/text/Regex;", "joinToString", "", "value", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "Lkotlin/sequences/Sequence;", "matches", "", "split", "", "splitToSequence", "breeze-core"})
    public static final class WindowsPath
    implements CaseFormat,
    PathLikeCaseFormat {
        @NotNull
        public static final WindowsPath INSTANCE = new WindowsPath();
        @NotNull
        private static final Regex regex = new Regex("\\\\?[^/\\\\\\s]+(?:\\\\[^/\\\\\\s]+]+)+\\\\?");

        private WindowsPath() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return regex.matches((CharSequence)value);
        }

        @Override
        @NotNull
        public List<String> split(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'\\'};
            CharSequence charSequence = StringsKt.trim((String)value, (char[])cArray);
            cArray = new char[]{'\\'};
            return StringsKt.split$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public Sequence<String> splitToSequence(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = new char[]{'\\'};
            CharSequence charSequence = StringsKt.trim((String)value, (char[])cArray);
            cArray = new char[]{'\\'};
            return StringsKt.splitToSequence$default((CharSequence)charSequence, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull String[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.joinToString$default((Object[])value, (CharSequence)"\\", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Iterable<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return CollectionsKt.joinToString$default(value, (CharSequence)"\\", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public String joinToString(@NotNull Sequence<String> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return SequencesKt.joinToString$default(value, (CharSequence)"\\", null, null, (int)0, null, null, (int)62, null);
        }

        @Override
        @NotNull
        public CaseFormat componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            return CaseFormat.DefaultImpls.componentCopy(this, componentParams);
        }

        @Override
        public String getComponentId() {
            return CaseFormat.DefaultImpls.getComponentId(this);
        }

        @Override
        @NotNull
        public Map<String, Object> getComponentParams() {
            return CaseFormat.DefaultImpls.getComponentParams(this);
        }

        @Override
        @InternalApi
        public boolean componentEquals(@Nullable Object other) {
            return CaseFormat.DefaultImpls.componentEquals(this, other);
        }

        @Override
        @InternalApi
        public int componentHashcode() {
            return CaseFormat.DefaultImpls.componentHashcode(this);
        }

        @Override
        @InternalApi
        @NotNull
        public String componentToString() {
            return CaseFormat.DefaultImpls.componentToString(this);
        }
    }
}

