/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.component.AbstractConverter;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.Converter;
import icu.windea.breezeframework.core.component.GenericConverter;
import icu.windea.breezeframework.core.component.extension.ConverterExtensions;
import icu.windea.breezeframework.core.extension.AnyExtensions;
import icu.windea.breezeframework.core.extension.BooleanExtensions;
import icu.windea.breezeframework.core.extension.CharExtensions;
import icu.windea.breezeframework.core.extension.FileExtensions;
import icu.windea.breezeframework.core.extension.InternalExtensions;
import icu.windea.breezeframework.core.extension.StreamExtensions;
import icu.windea.breezeframework.core.extension.StringExtensions;
import icu.windea.breezeframework.core.model.TypeReference;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UByteArray;
import kotlin.UInt;
import kotlin.UIntArray;
import kotlin.ULong;
import kotlin.ULongArray;
import kotlin.UShort;
import kotlin.UShortArray;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharProgression;
import kotlin.ranges.CharRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import kotlin.ranges.UIntProgression;
import kotlin.ranges.UIntRange;
import kotlin.ranges.ULongProgression;
import kotlin.ranges.ULongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\bD\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:C%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefgB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003JA\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011\u00a2\u0006\u0002\u0010\u0013J;\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011\u00a2\u0006\u0002\u0010\u0015J8\u0010\n\u001a\u0002H\u000b\"\u0006\b\u0000\u0010\u000b\u0018\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011H\u0086\b\u00a2\u0006\u0002\u0010\u0016JC\u0010\u0017\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011\u00a2\u0006\u0002\u0010\u0013J=\u0010\u0017\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011\u00a2\u0006\u0002\u0010\u0015J:\u0010\u0017\u001a\u0004\u0018\u0001H\u000b\"\u0006\b\u0000\u0010\u000b\u0018\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011H\u0086\b\u00a2\u0006\u0002\u0010\u0016J;\u0010\u0018\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0015J=\u0010\u0019\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00142\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0015J+\u0010\u001a\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0002\u00a2\u0006\u0002\u0010\u001bJS\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u000b\"\u000e\b\u0001\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u000b0\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f\u00a2\u0006\u0002\u0010 J0\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011H\u0002J*\u0010\"\u001a\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0011H\u0002J\b\u0010#\u001a\u00020$H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006h"}, d2={"Licu/windea/breezeframework/core/component/Converters;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/Converter;", "()V", "useFallbackStrategy", "", "getUseFallbackStrategy", "()Z", "setUseFallbackStrategy", "(Z)V", "convert", "T", "value", "", "targetType", "Ljava/lang/Class;", "componentParams", "", "", "(Ljava/lang/Object;Ljava/lang/Class;Ljava/util/Map;)Ljava/lang/Object;", "Ljava/lang/reflect/Type;", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/lang/Object;Ljava/util/Map;)Ljava/lang/Object;", "convertOrNull", "doConvert", "doConvertOrNull", "fallbackConvert", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "get", "C", "defaultValue", "Lkotlin/Function0;", "(Ljava/lang/Class;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Licu/windea/breezeframework/core/component/Converter;", "infer", "inferKey", "registerDefault", "", "ArrayConverter", "AtomicBooleanConverter", "AtomicIntegerConverter", "AtomicLongConverter", "BigDecimalConverter", "BigIntegerConverter", "BooleanArrayConverter", "BooleanConverter", "ByteArrayConverter", "ByteConverter", "CharArrayConverter", "CharConverter", "CharRangeConverter", "CharsetConverter", "ClassConverter", "CollectionConverter", "DateConverter", "DoubleArrayConverter", "DoubleConverter", "DurationConverter", "EnumConverter", "FileConverter", "FloatArrayConverter", "FloatConverter", "InstantConverter", "IntArrayConverter", "IntConverter", "IntRangeConverter", "IterableConverter", "IteratorConverter", "ListConverter", "LocalDateConverter", "LocalDateTimeConverter", "LocalTimeConverter", "LocaleConverter", "LongArrayConverter", "LongConverter", "LongRangeConverter", "MutableCollectionConverter", "MutableIterableConverter", "MutableIteratorConverter", "MutableListConverter", "MutableSetConverter", "PathConverter", "PatternConverter", "PeriodConverter", "RegexConverter", "SequenceConverter", "SetConverter", "ShortArrayConverter", "ShortConverter", "StreamConverter", "StringConverter", "TimeZoneConverter", "UByteArrayConverter", "UByteConverter", "UIntArrayConverter", "UIntConverter", "UIntRangeConverter", "ULongArrayConverter", "ULongConverter", "ULongRangeConverter", "UShortArrayConverter", "UShortConverter", "UriConverter", "UrlConverter", "ZoneIdConverter", "breeze-core"})
public final class Converters
extends ComponentRegistry<Converter<?>> {
    @NotNull
    public static final Converters INSTANCE = new Converters();
    private static boolean useFallbackStrategy;

    private Converters() {
    }

    public final boolean getUseFallbackStrategy() {
        return useFallbackStrategy;
    }

    public final void setUseFallbackStrategy(boolean bl) {
        useFallbackStrategy = bl;
    }

    @Override
    protected void registerDefault() {
        this.register((Component)ByteConverter.INSTANCE);
        this.register((Component)ShortConverter.INSTANCE);
        this.register((Component)IntConverter.INSTANCE);
        this.register((Component)LongConverter.INSTANCE);
        this.register((Component)FloatConverter.INSTANCE);
        this.register((Component)DoubleConverter.INSTANCE);
        this.register((Component)BooleanConverter.Default);
        this.register((Component)CharConverter.INSTANCE);
        this.register((Component)BigIntegerConverter.INSTANCE);
        this.register((Component)BigDecimalConverter.INSTANCE);
        this.register((Component)UByteConverter.INSTANCE);
        this.register((Component)UShortConverter.INSTANCE);
        this.register((Component)UIntConverter.INSTANCE);
        this.register((Component)ULongConverter.INSTANCE);
        this.register((Component)AtomicIntegerConverter.INSTANCE);
        this.register((Component)AtomicLongConverter.INSTANCE);
        this.register((Component)AtomicBooleanConverter.INSTANCE);
        this.register((Component)StringConverter.Default);
        this.register((Component)RegexConverter.Default);
        this.register((Component)PatternConverter.INSTANCE);
        this.register((Component)CharsetConverter.INSTANCE);
        this.register((Component)ClassConverter.INSTANCE);
        this.register((Component)LocaleConverter.INSTANCE);
        this.register((Component)TimeZoneConverter.INSTANCE);
        this.register((Component)ZoneIdConverter.INSTANCE);
        this.register((Component)DateConverter.Default);
        this.register((Component)LocalDateConverter.Default);
        this.register((Component)LocalTimeConverter.Default);
        this.register((Component)LocalDateTimeConverter.Default);
        this.register((Component)InstantConverter.INSTANCE);
        this.register((Component)DurationConverter.Default);
        this.register((Component)PeriodConverter.Default);
        this.register((Component)FileConverter.INSTANCE);
        this.register((Component)PathConverter.INSTANCE);
        this.register((Component)UrlConverter.INSTANCE);
        this.register((Component)UriConverter.INSTANCE);
        this.register((Component)EnumConverter.INSTANCE);
        this.register((Component)ArrayConverter.Default);
        this.register((Component)ByteArrayConverter.Default);
        this.register((Component)ShortArrayConverter.Default);
        this.register((Component)IntArrayConverter.Default);
        this.register((Component)LongArrayConverter.Default);
        this.register((Component)FloatArrayConverter.Default);
        this.register((Component)DoubleArrayConverter.Default);
        this.register((Component)BooleanArrayConverter.Default);
        this.register((Component)CharArrayConverter.Default);
        this.register((Component)UByteArrayConverter.Default);
        this.register((Component)UShortArrayConverter.Default);
        this.register((Component)UIntArrayConverter.Default);
        this.register((Component)ULongArrayConverter.Default);
        this.register((Component)IteratorConverter.Default);
        this.register((Component)MutableIteratorConverter.Default);
        this.register((Component)IterableConverter.Default);
        this.register((Component)MutableIterableConverter.Default);
        this.register((Component)CollectionConverter.Default);
        this.register((Component)MutableCollectionConverter.Default);
        this.register((Component)ListConverter.Default);
        this.register((Component)MutableListConverter.Default);
        this.register((Component)SetConverter.Default);
        this.register((Component)MutableSetConverter.Default);
        this.register((Component)IntRangeConverter.INSTANCE);
        this.register((Component)LongRangeConverter.INSTANCE);
        this.register((Component)CharRangeConverter.INSTANCE);
        this.register((Component)UIntRangeConverter.INSTANCE);
        this.register((Component)ULongRangeConverter.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T, C extends Converter<T>> C get(@NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> componentParams, @NotNull Function0<? extends C> defaultValue) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Map map = this.getComponents();
        String key$iv = this.inferKey(targetType, componentParams);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Object answer$iv = defaultValue.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (C)((Converter)object);
    }

    public final /* synthetic */ <T> T convert(Object value, Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        boolean $i$f$convert = false;
        boolean $i$f$javaTypeOf = false;
        Intrinsics.needClassReification();
        return this.convert(value, new TypeReference<T>(){}.getType(), componentParams);
    }

    public static /* synthetic */ Object convert$default(Converters this_, Object value, Map componentParams, int n, Object object) {
        if ((n & 2) != 0) {
            componentParams = MapsKt.emptyMap();
        }
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        boolean $i$f$convert = false;
        boolean $i$f$javaTypeOf = false;
        Intrinsics.needClassReification();
        return this_.convert(value, new /* invalid duplicate definition of identical inner class */.getType(), (Map<String, ? extends Object>)componentParams);
    }

    public final <T> T convert(@Nullable Object value, @NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        return this.doConvert(value, targetType, componentParams);
    }

    public static /* synthetic */ Object convert$default(Converters converters, Object object, Class clazz, Map map, int n, Object object2) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return converters.convert(object, clazz, (Map<String, ? extends Object>)map);
    }

    public final <T> T convert(@Nullable Object value, @NotNull Type targetType, @NotNull Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        return this.doConvert(value, targetType, componentParams);
    }

    public static /* synthetic */ Object convert$default(Converters converters, Object object, Type type, Map map, int n, Object object2) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return converters.convert(object, type, (Map<String, ? extends Object>)map);
    }

    public final /* synthetic */ <T> T convertOrNull(Object value, Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        boolean $i$f$convertOrNull = false;
        boolean $i$f$javaTypeOf = false;
        Intrinsics.needClassReification();
        return this.convertOrNull(value, new TypeReference<T>(){}.getType(), componentParams);
    }

    public static /* synthetic */ Object convertOrNull$default(Converters this_, Object value, Map componentParams, int n, Object object) {
        if ((n & 2) != 0) {
            componentParams = MapsKt.emptyMap();
        }
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        boolean $i$f$convertOrNull = false;
        boolean $i$f$javaTypeOf = false;
        Intrinsics.needClassReification();
        return this_.convertOrNull(value, new /* invalid duplicate definition of identical inner class */.getType(), (Map<String, ? extends Object>)componentParams);
    }

    @Nullable
    public final <T> T convertOrNull(@Nullable Object value, @NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        return this.doConvertOrNull(value, targetType, componentParams);
    }

    public static /* synthetic */ Object convertOrNull$default(Converters converters, Object object, Class clazz, Map map, int n, Object object2) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return converters.convertOrNull(object, clazz, (Map<String, ? extends Object>)map);
    }

    @Nullable
    public final <T> T convertOrNull(@Nullable Object value, @NotNull Type targetType, @NotNull Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        return this.doConvertOrNull(value, targetType, componentParams);
    }

    public static /* synthetic */ Object convertOrNull$default(Converters converters, Object object, Type type, Map map, int n, Object object2) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return converters.convertOrNull(object, type, (Map<String, ? extends Object>)map);
    }

    private final <T> T doConvert(Object value, Type targetType, Map<String, ? extends Object> componentParams) {
        Converter converter;
        Object object;
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert null value to a specified type.");
        }
        Class<?> targetClass = InternalExtensions.inferClass(targetType);
        if (Intrinsics.areEqual(targetClass, (Object)targetType) && targetClass.isInstance(value)) {
            return (T)value;
        }
        String key = this.inferKey(targetClass, componentParams);
        Map $this$getOrPut$iv = this.getComponents();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Converter<?> result = INSTANCE.infer(targetClass, componentParams);
            if (result == null) {
                Object fallback;
                if (Intrinsics.areEqual((Object)targetType, String.class)) {
                    return (T)value.toString();
                }
                if (INSTANCE.getUseFallbackStrategy() && (fallback = INSTANCE.fallbackConvert(value, targetClass)) != null) {
                    return (T)fallback;
                }
                throw new IllegalArgumentException("No matched converter found for target type '" + targetType + "'.");
            }
            Converter<?> answer$iv = result;
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((converter = (Converter)object) instanceof GenericConverter) {
            return ((GenericConverter)converter).convert(value, targetType);
        }
        return converter.convert(value);
    }

    private final <T> T doConvertOrNull(Object value, Type targetType, Map<String, ? extends Object> componentParams) {
        Object t;
        Converter converter;
        Object object;
        if (value == null) {
            return null;
        }
        Class<?> targetClass = InternalExtensions.inferClass(targetType);
        if (Intrinsics.areEqual(targetClass, (Object)targetType) && targetClass.isInstance(value)) {
            return (T)value;
        }
        String key = this.inferKey(targetClass, componentParams);
        Map $this$getOrPut$iv = this.getComponents();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Converter<?> result = INSTANCE.infer(targetClass, componentParams);
            if (result == null) {
                Object fallback;
                if (Intrinsics.areEqual((Object)targetType, String.class)) {
                    return (T)value.toString();
                }
                if (INSTANCE.getUseFallbackStrategy() && (fallback = INSTANCE.fallbackConvert(value, targetClass)) != null) {
                    return (T)fallback;
                }
                return null;
            }
            Converter<?> answer$iv = result;
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((converter = (Converter)object) instanceof GenericConverter) {
            Object t2 = ((GenericConverter)converter).convertOrNull(value, targetType);
            if (t2 == null) {
                // empty if block
            }
            t = t2;
        } else {
            Object t3 = converter.convertOrNull(value);
            if (t3 == null) {
                // empty if block
            }
            t = t3;
        }
        return t;
    }

    private final String inferKey(Class<?> targetType, Map<String, ? extends Object> componentParams) {
        String string;
        if (componentParams.isEmpty()) {
            String string2 = targetType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetType.name");
            string = string2;
        } else {
            string = targetType.getName() + '@' + componentParams;
        }
        return string;
    }

    private final Converter<?> infer(Class<?> targetType, Map<String, ? extends Object> componentParams) {
        Iterable iterable = this.getComponents().values();
        Object var5_4 = null;
        for (Object t : iterable) {
            Converter it = (Converter)t;
            boolean bl = false;
            if (!it.getTargetType().isAssignableFrom(targetType)) continue;
            var5_4 = t;
        }
        Converter converter = var5_4;
        if (converter == null) {
            return null;
        }
        Converter result = converter;
        if (!Intrinsics.areEqual((Object)result.getComponentParams().toString(), (Object)componentParams.toString())) {
            result = result.componentCopy(componentParams);
        }
        return result;
    }

    private final <T> T fallbackConvert(Object value, Class<T> targetType) {
        try {
            Constructor<?>[] constructorArray = targetType.getDeclaredConstructors();
            Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"targetType.declaredConstructors");
            for (Constructor<?> constructor : constructorArray) {
                if (constructor.getParameterCount() != 1) continue;
                try {
                    constructor.setAccessible(true);
                    Object[] exception = new Object[]{value};
                    return (T)constructor.newInstance(exception);
                }
                catch (Exception exception) {
                }
            }
            Method[] methodArray = targetType.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"targetType.declaredMethods");
            for (Executable executable : methodArray) {
                if (((Method)executable).getParameterCount() != 1) continue;
                try {
                    ((Method)executable).setAccessible(true);
                    return (T)((Method)executable).invoke(value, new Object[0]);
                }
                catch (Exception exception) {
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$ByteConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "()V", "convert", "value", "", "(Ljava/lang/Object;)Ljava/lang/Byte;", "convertOrNull", "breeze-core"})
    public static final class ByteConverter
    extends AbstractConverter<Byte> {
        @NotNull
        public static final ByteConverter INSTANCE = new ByteConverter();

        private ByteConverter() {
        }

        @Override
        @NotNull
        public Byte convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Byte ? ((Number)value).byteValue() : (value instanceof Number ? ((Number)value).byteValue() : (value instanceof Character ? (byte)((Character)value).charValue() : (value instanceof Boolean ? BooleanExtensions.toByte((Boolean)value) : Byte.parseByte(value.toString()))));
        }

        @Override
        @Nullable
        public Byte convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Byte ? (Byte)value : (value instanceof Number ? Byte.valueOf(((Number)value).byteValue()) : (value instanceof Character ? Byte.valueOf((byte)((Character)value).charValue()) : (value instanceof Boolean ? Byte.valueOf(BooleanExtensions.toByte((Boolean)value)) : StringsKt.toByteOrNull((String)value.toString()))));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$ShortConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "()V", "convert", "value", "", "(Ljava/lang/Object;)Ljava/lang/Short;", "convertOrNull", "breeze-core"})
    public static final class ShortConverter
    extends AbstractConverter<Short> {
        @NotNull
        public static final ShortConverter INSTANCE = new ShortConverter();

        private ShortConverter() {
        }

        @Override
        @NotNull
        public Short convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Short ? ((Number)value).shortValue() : (value instanceof Number ? ((Number)value).shortValue() : (value instanceof Character ? (short)((Character)value).charValue() : (value instanceof Boolean ? BooleanExtensions.toShort((Boolean)value) : Short.parseShort(value.toString()))));
        }

        @Override
        @Nullable
        public Short convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Short ? (Short)value : (value instanceof Number ? Short.valueOf(((Number)value).shortValue()) : (value instanceof Character ? Short.valueOf((short)((Character)value).charValue()) : StringsKt.toShortOrNull((String)value.toString())));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$IntConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "()V", "convert", "value", "", "(Ljava/lang/Object;)Ljava/lang/Integer;", "convertOrNull", "breeze-core"})
    public static final class IntConverter
    extends AbstractConverter<Integer> {
        @NotNull
        public static final IntConverter INSTANCE = new IntConverter();

        private IntConverter() {
        }

        @Override
        @NotNull
        public Integer convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Integer ? ((Number)value).intValue() : (value instanceof Number ? ((Number)value).intValue() : (value instanceof Character ? (int)((Character)value).charValue() : (value instanceof Boolean ? BooleanExtensions.toInt((Boolean)value) : Integer.parseInt(value.toString()))));
        }

        @Override
        @Nullable
        public Integer convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Integer ? (Integer)value : (value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : (value instanceof Character ? Integer.valueOf(((Character)value).charValue()) : (value instanceof Boolean ? Integer.valueOf(BooleanExtensions.toInt((Boolean)value)) : StringsKt.toIntOrNull((String)value.toString()))));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$LongConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "()V", "convert", "value", "", "(Ljava/lang/Object;)Ljava/lang/Long;", "convertOrNull", "breeze-core"})
    public static final class LongConverter
    extends AbstractConverter<Long> {
        @NotNull
        public static final LongConverter INSTANCE = new LongConverter();

        private LongConverter() {
        }

        @Override
        @NotNull
        public Long convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Long ? ((Number)value).longValue() : (value instanceof Number ? ((Number)value).longValue() : (value instanceof Character ? (long)((Character)value).charValue() : (value instanceof Boolean ? BooleanExtensions.toLong((Boolean)value) : Long.parseLong(value.toString()))));
        }

        @Override
        @Nullable
        public Long convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Long ? (Long)value : (value instanceof Number ? Long.valueOf(((Number)value).longValue()) : (value instanceof Character ? Long.valueOf(((Character)value).charValue()) : (value instanceof Boolean ? Long.valueOf(BooleanExtensions.toLong((Boolean)value)) : StringsKt.toLongOrNull((String)value.toString()))));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$FloatConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "()V", "convert", "value", "", "(Ljava/lang/Object;)Ljava/lang/Float;", "convertOrNull", "breeze-core"})
    public static final class FloatConverter
    extends AbstractConverter<Float> {
        @NotNull
        public static final FloatConverter INSTANCE = new FloatConverter();

        private FloatConverter() {
        }

        @Override
        @NotNull
        public Float convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Float.valueOf(value instanceof Float ? ((Number)value).floatValue() : (value instanceof Number ? ((Number)value).floatValue() : (value instanceof Character ? (float)((Character)value).charValue() : (value instanceof Boolean ? BooleanExtensions.toFloat((Boolean)value) : Float.parseFloat(value.toString())))));
        }

        @Override
        @Nullable
        public Float convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Float ? (Float)value : (value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : (value instanceof Character ? Float.valueOf(((Character)value).charValue()) : (value instanceof Boolean ? Float.valueOf(BooleanExtensions.toFloat((Boolean)value)) : StringsKt.toFloatOrNull((String)value.toString()))));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$DoubleConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "()V", "convert", "value", "", "(Ljava/lang/Object;)Ljava/lang/Double;", "convertOrNull", "breeze-core"})
    public static final class DoubleConverter
    extends AbstractConverter<Double> {
        @NotNull
        public static final DoubleConverter INSTANCE = new DoubleConverter();

        private DoubleConverter() {
        }

        @Override
        @NotNull
        public Double convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Double ? ((Number)value).doubleValue() : (value instanceof Number ? ((Number)value).doubleValue() : (value instanceof Character ? (double)((Character)value).charValue() : (value instanceof Boolean ? BooleanExtensions.toDouble((Boolean)value) : Double.parseDouble(value.toString()))));
        }

        @Override
        @Nullable
        public Double convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Double ? (Double)value : (value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : (value instanceof Character ? Double.valueOf(((Character)value).charValue()) : (value instanceof Boolean ? Double.valueOf(BooleanExtensions.toDouble((Boolean)value)) : StringsKt.toDoubleOrNull((String)value.toString()))));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\r\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/Converters$BooleanConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "relaxConvert", "getRelaxConvert", "()Z", "componentCopy", "convert", "value", "(Ljava/lang/Object;)Ljava/lang/Boolean;", "doConvert", "doRelaxConvert", "Default", "breeze-core"})
    public static class BooleanConverter
    extends AbstractConverter<Boolean> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final boolean relaxConvert;

        public BooleanConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.relaxConvert = InternalExtensions.convertToBooleanOrFalse(this.componentParams.get("relaxConvert"));
        }

        public /* synthetic */ BooleanConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final boolean getRelaxConvert() {
            return this.relaxConvert;
        }

        @Override
        @NotNull
        public Boolean convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.relaxConvert ? this.doRelaxConvert(value) : this.doConvert(value);
        }

        private final boolean doConvert(Object value) {
            return Intrinsics.areEqual((Object)value, (Object)true) || Intrinsics.areEqual((Object)value.toString(), (Object)"true");
        }

        private final boolean doRelaxConvert(Object value) {
            boolean bl;
            if (value instanceof Boolean) {
                bl = (Boolean)value;
            } else if (value instanceof Number) {
                String it = value.toString();
                boolean bl2 = false;
                bl = !Intrinsics.areEqual((Object)it, (Object)"0") || !Intrinsics.areEqual((Object)it, (Object)"0.0");
            } else {
                bl = value instanceof CharSequence ? ((CharSequence)value).length() > 0 : (value instanceof Object[] ? !(((Object[])value).length == 0) : (value instanceof Collection ? !((Collection)value).isEmpty() : (value instanceof Iterable ? CollectionsKt.any((Iterable)((Iterable)value)) : (value instanceof Sequence ? SequencesKt.any((Sequence)((Sequence)value)) : (value instanceof Map ? !((Map)value).isEmpty() : false)))));
            }
            return bl;
        }

        @Override
        @NotNull
        public BooleanConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new BooleanConverter(componentParams);
        }

        public BooleanConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$BooleanConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$BooleanConverter;", "()V", "breeze-core"})
        public static final class Default
        extends BooleanConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$CharConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "()V", "convert", "value", "", "(Ljava/lang/Object;)Ljava/lang/Character;", "convertOrNull", "breeze-core"})
    public static final class CharConverter
    extends AbstractConverter<Character> {
        @NotNull
        public static final CharConverter INSTANCE = new CharConverter();

        private CharConverter() {
        }

        @Override
        @NotNull
        public Character convert(@NotNull Object value) {
            char c;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Character) {
                c = ((Character)value).charValue();
            } else if (value instanceof Number) {
                c = (char)((Number)value).intValue();
            } else if (value instanceof CharSequence) {
                c = StringsKt.single((CharSequence)((CharSequence)value));
            } else {
                throw new IllegalArgumentException("Cannot convert '" + value + "' to Char.");
            }
            return Character.valueOf(c);
        }

        @Override
        @Nullable
        public Character convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Character ? (Character)value : (value instanceof Number ? Character.valueOf((char)((Number)value).intValue()) : (value instanceof CharSequence ? StringsKt.singleOrNull((CharSequence)((CharSequence)value)) : null));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Converters$BigIntegerConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/math/BigInteger;", "()V", "convert", "value", "", "convertOrNull", "breeze-core"})
    public static final class BigIntegerConverter
    extends AbstractConverter<BigInteger> {
        @NotNull
        public static final BigIntegerConverter INSTANCE = new BigIntegerConverter();

        private BigIntegerConverter() {
        }

        @Override
        @NotNull
        public BigInteger convert(@NotNull Object value) {
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof BigInteger) {
                bigInteger = (BigInteger)value;
            } else if (value instanceof Long) {
                BigInteger bigInteger2 = BigInteger.valueOf(((Number)value).longValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(value)");
                bigInteger = bigInteger2;
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                BigInteger bigInteger3 = BigInteger.valueOf(((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(value.convert<Long>())");
                bigInteger = bigInteger3;
            }
            return bigInteger;
        }

        @Override
        @Nullable
        public BigInteger convertOrNull(@NotNull Object value) {
            BigInteger bigInteger;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof BigInteger) {
                bigInteger = (BigInteger)value;
            } else if (value instanceof Long) {
                bigInteger = BigInteger.valueOf(((Number)value).longValue());
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Long l = (Long)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                if (l == null) {
                    return null;
                }
                bigInteger = BigInteger.valueOf(l);
            }
            return bigInteger;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Converters$BigDecimalConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/math/BigDecimal;", "()V", "convert", "value", "", "convertOrNull", "breeze-core"})
    public static final class BigDecimalConverter
    extends AbstractConverter<BigDecimal> {
        @NotNull
        public static final BigDecimalConverter INSTANCE = new BigDecimalConverter();

        private BigDecimalConverter() {
        }

        @Override
        @NotNull
        public BigDecimal convert(@NotNull Object value) {
            BigDecimal bigDecimal;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof BigDecimal) {
                bigDecimal = (BigDecimal)value;
            } else if (value instanceof Double) {
                BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)value).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(value)");
                bigDecimal = bigDecimal2;
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Double>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(value.convert<Double>())");
                bigDecimal = bigDecimal3;
            }
            return bigDecimal;
        }

        @Override
        @Nullable
        public BigDecimal convertOrNull(@NotNull Object value) {
            BigDecimal bigDecimal;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof BigDecimal) {
                bigDecimal = (BigDecimal)value;
            } else if (value instanceof Double) {
                bigDecimal = BigDecimal.valueOf(((Number)value).doubleValue());
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Double d = (Double)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Double>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                if (d == null) {
                    return null;
                }
                bigDecimal = BigDecimal.valueOf(d);
            }
            return bigDecimal;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\n\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000b"}, d2={"Licu/windea/breezeframework/core/component/Converters$UByteConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/UByte;", "()V", "convert", "value", "", "convert-Wa3L5BU", "(Ljava/lang/Object;)B", "convertOrNull", "convertOrNull-do-JOtI", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static final class UByteConverter
    extends AbstractConverter<UByte> {
        @NotNull
        public static final UByteConverter INSTANCE = new UByteConverter();

        private UByteConverter() {
        }

        public byte convert-Wa3L5BU(@NotNull Object value) {
            byte by;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof UByte) {
                by = ((UByte)value).unbox-impl();
            } else if (value instanceof Byte) {
                by = UByte.constructor-impl((byte)((Number)value).byteValue());
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                by = UByte.constructor-impl((byte)((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Byte>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).byteValue());
            }
            return by;
        }

        @Nullable
        public UByte convertOrNull-do-JOtI(@NotNull Object value) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof UByte) {
                object = (UByte)value;
            } else if (value instanceof Byte) {
                object = UByte.box-impl((byte)UByte.constructor-impl((byte)((Number)value).byteValue()));
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Byte by = (Byte)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Byte>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                object = by == null ? null : UByte.box-impl((byte)UByte.constructor-impl((byte)by));
            }
            return object;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\n\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000b"}, d2={"Licu/windea/breezeframework/core/component/Converters$UShortConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/UShort;", "()V", "convert", "value", "", "convert-BwKQO78", "(Ljava/lang/Object;)S", "convertOrNull", "convertOrNull-162jBTc", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static final class UShortConverter
    extends AbstractConverter<UShort> {
        @NotNull
        public static final UShortConverter INSTANCE = new UShortConverter();

        private UShortConverter() {
        }

        public short convert-BwKQO78(@NotNull Object value) {
            short s;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof UShort) {
                s = ((UShort)value).unbox-impl();
            } else if (value instanceof Short) {
                s = UShort.constructor-impl((short)((Number)value).shortValue());
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                s = UShort.constructor-impl((short)((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Short>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).shortValue());
            }
            return s;
        }

        @Nullable
        public UShort convertOrNull-162jBTc(@NotNull Object value) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof UShort) {
                object = (UShort)value;
            } else if (value instanceof Short) {
                object = UShort.box-impl((short)UShort.constructor-impl((short)((Number)value).shortValue()));
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Short s = (Short)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Short>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                object = s == null ? null : UShort.box-impl((short)UShort.constructor-impl((short)s));
            }
            return object;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\n\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000b"}, d2={"Licu/windea/breezeframework/core/component/Converters$UIntConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/UInt;", "()V", "convert", "value", "", "convert-OGnWXxg", "(Ljava/lang/Object;)I", "convertOrNull", "convertOrNull-gbq4QnA", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static final class UIntConverter
    extends AbstractConverter<UInt> {
        @NotNull
        public static final UIntConverter INSTANCE = new UIntConverter();

        private UIntConverter() {
        }

        public int convert-OGnWXxg(@NotNull Object value) {
            int n;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof UInt) {
                n = ((UInt)value).unbox-impl();
            } else if (value instanceof Integer) {
                n = UInt.constructor-impl((int)((Number)value).intValue());
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                n = UInt.constructor-impl((int)((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue());
            }
            return n;
        }

        @Nullable
        public UInt convertOrNull-gbq4QnA(@NotNull Object value) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof UInt) {
                object = (UInt)value;
            } else if (value instanceof Integer) {
                object = UInt.box-impl((int)UInt.constructor-impl((int)((Number)value).intValue()));
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Integer n = (Integer)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                object = n == null ? null : UInt.box-impl((int)UInt.constructor-impl((int)n));
            }
            return object;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b\n\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000b"}, d2={"Licu/windea/breezeframework/core/component/Converters$ULongConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/ULong;", "()V", "convert", "value", "", "convert-I7RO_PI", "(Ljava/lang/Object;)J", "convertOrNull", "convertOrNull-JlBESG8", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static final class ULongConverter
    extends AbstractConverter<ULong> {
        @NotNull
        public static final ULongConverter INSTANCE = new ULongConverter();

        private ULongConverter() {
        }

        public long convert-I7RO_PI(@NotNull Object value) {
            long l;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof ULong) {
                l = ((ULong)value).unbox-impl();
            } else if (value instanceof Long) {
                l = ULong.constructor-impl((long)((Number)value).longValue());
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                l = ULong.constructor-impl((long)((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue());
            }
            return l;
        }

        @Nullable
        public ULong convertOrNull-JlBESG8(@NotNull Object value) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof ULong) {
                object = (ULong)value;
            } else if (value instanceof Long) {
                object = ULong.box-impl((long)ULong.constructor-impl((long)((Number)value).longValue()));
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Long l = (Long)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                object = l == null ? null : ULong.box-impl((long)ULong.constructor-impl((long)l));
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Converters$AtomicIntegerConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/concurrent/atomic/AtomicInteger;", "()V", "convert", "value", "", "convertOrNull", "breeze-core"})
    public static final class AtomicIntegerConverter
    extends AbstractConverter<AtomicInteger> {
        @NotNull
        public static final AtomicIntegerConverter INSTANCE = new AtomicIntegerConverter();

        private AtomicIntegerConverter() {
        }

        @Override
        @NotNull
        public AtomicInteger convert(@NotNull Object value) {
            AtomicInteger atomicInteger;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof AtomicInteger) {
                atomicInteger = (AtomicInteger)value;
            } else if (value instanceof Integer) {
                atomicInteger = new AtomicInteger(((Number)value).intValue());
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                AtomicInteger atomicInteger2 = new AtomicInteger(((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue());
                atomicInteger = atomicInteger2;
            }
            return atomicInteger;
        }

        @Override
        @Nullable
        public AtomicInteger convertOrNull(@NotNull Object value) {
            AtomicInteger atomicInteger;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof AtomicInteger) {
                atomicInteger = (AtomicInteger)value;
            } else if (value instanceof Integer) {
                atomicInteger = new AtomicInteger(((Number)value).intValue());
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Integer n = (Integer)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                if (n == null) {
                    return null;
                }
                atomicInteger = new AtomicInteger(n);
            }
            return atomicInteger;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Converters$AtomicLongConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/concurrent/atomic/AtomicLong;", "()V", "convert", "value", "", "convertOrNull", "breeze-core"})
    public static final class AtomicLongConverter
    extends AbstractConverter<AtomicLong> {
        @NotNull
        public static final AtomicLongConverter INSTANCE = new AtomicLongConverter();

        private AtomicLongConverter() {
        }

        @Override
        @NotNull
        public AtomicLong convert(@NotNull Object value) {
            AtomicLong atomicLong;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof AtomicLong) {
                atomicLong = (AtomicLong)value;
            } else if (value instanceof Long) {
                atomicLong = new AtomicLong(((Number)value).longValue());
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                AtomicLong atomicLong2 = new AtomicLong(((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue());
                atomicLong = atomicLong2;
            }
            return atomicLong;
        }

        @Override
        @Nullable
        public AtomicLong convertOrNull(@NotNull Object value) {
            AtomicLong atomicLong;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof AtomicLong) {
                atomicLong = (AtomicLong)value;
            } else if (value instanceof Long) {
                atomicLong = new AtomicLong(((Number)value).longValue());
            } else if (value instanceof Number) {
                atomicLong = new AtomicLong(((Number)value).longValue());
            } else {
                Object $this$convertOrNull_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convertOrNull = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convertOrNull2 = false;
                boolean $i$f$javaTypeOf = false;
                Long l = (Long)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                if (l == null) {
                    return null;
                }
                atomicLong = new AtomicLong(l);
            }
            return atomicLong;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$AtomicBooleanConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()V", "convert", "value", "", "breeze-core"})
    public static final class AtomicBooleanConverter
    extends AbstractConverter<AtomicBoolean> {
        @NotNull
        public static final AtomicBooleanConverter INSTANCE = new AtomicBooleanConverter();

        private AtomicBooleanConverter() {
        }

        @Override
        @NotNull
        public AtomicBoolean convert(@NotNull Object value) {
            AtomicBoolean atomicBoolean;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof AtomicBoolean) {
                atomicBoolean = (AtomicBoolean)value;
            } else if (value instanceof Boolean) {
                atomicBoolean = new AtomicBoolean((Boolean)value);
            } else {
                Object $this$convert_u24default$iv = value;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                AtomicBoolean atomicBoolean2 = new AtomicBoolean((Boolean)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Boolean>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv));
                atomicBoolean = atomicBoolean2;
            }
            return atomicBoolean;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010'\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0005H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0016\u0010\u0014\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR2\u0010\u001d\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u001f0\u001f \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u001f0\u001f\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR\u0016\u0010\"\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Licu/windea/breezeframework/core/component/Converters$StringConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "dateFormat", "getDateFormat", "()Ljava/lang/String;", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "dateTimeFormat", "getDateTimeFormat", "dateTimeFormatter", "format", "getFormat", "formatter", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "raw", "", "getRaw", "()Z", "threadLocalDateFormat", "Ljava/lang/ThreadLocal;", "Ljava/text/SimpleDateFormat;", "timeFormat", "getTimeFormat", "timeFormatter", "timeZone", "Ljava/util/TimeZone;", "getTimeZone", "()Ljava/util/TimeZone;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class StringConverter
    extends AbstractConverter<String> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final boolean raw;
        @NotNull
        private final String format;
        @NotNull
        private final String dateFormat;
        @NotNull
        private final String timeFormat;
        @NotNull
        private final String dateTimeFormat;
        @NotNull
        private final Locale locale;
        @NotNull
        private final TimeZone timeZone;
        private final ThreadLocal<SimpleDateFormat> threadLocalDateFormat;
        private final DateTimeFormatter formatter;
        private final DateTimeFormatter dateFormatter;
        private final DateTimeFormatter timeFormatter;
        private final DateTimeFormatter dateTimeFormatter;

        public StringConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.raw = InternalExtensions.convertToBooleanOrFalse(this.componentParams.get("raw"));
            String string4 = InternalExtensions.convertToStringOrNull(this.componentParams.get("format"));
            if (string4 == null) {
                string4 = this.format = "yyyy-MM-dd";
            }
            if ((string3 = InternalExtensions.convertToStringOrNull(this.componentParams.get("dateFormat"))) == null) {
                string3 = this.dateFormat = "yyyy-MM-dd";
            }
            if ((string2 = InternalExtensions.convertToStringOrNull(this.componentParams.get("timeFormat"))) == null) {
                string2 = this.timeFormat = "HH:mm:ss";
            }
            if ((string = InternalExtensions.convertToStringOrNull(this.componentParams.get("dateTimeFormat"))) == null) {
                string = "yyyy-MM-dd HH:mm:ss";
            }
            this.dateTimeFormat = string;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("locale");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Object object = (Locale)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Locale>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (object == null) {
                $this$convertOrNull_u24default$iv = InternalExtensions.getDefaultLocale();
                Intrinsics.checkNotNullExpressionValue((Object)$this$convertOrNull_u24default$iv, (String)"defaultLocale");
                object = $this$convertOrNull_u24default$iv;
            }
            this.locale = object;
            $this$convertOrNull_u24default$iv = this.componentParams.get("timeZone");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            TimeZone timeZone = (TimeZone)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<TimeZone>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (timeZone == null) {
                TimeZone timeZone2 = InternalExtensions.getDefaultTimeZone();
                Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"defaultTimeZone");
                timeZone = timeZone2;
            }
            this.timeZone = timeZone;
            this.threadLocalDateFormat = ThreadLocal.withInitial(() -> StringConverter.threadLocalDateFormat$lambda-1(this));
            this.formatter = DateTimeFormatter.ofPattern(this.format, this.locale).withZone(this.timeZone.toZoneId());
            this.dateFormatter = DateTimeFormatter.ofPattern(this.dateFormat, this.locale).withZone(this.timeZone.toZoneId());
            this.timeFormatter = DateTimeFormatter.ofPattern(this.timeFormat, this.locale).withZone(this.timeZone.toZoneId());
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale).withZone(this.timeZone.toZoneId());
        }

        public /* synthetic */ StringConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final boolean getRaw() {
            return this.raw;
        }

        @NotNull
        public final String getFormat() {
            return this.format;
        }

        @NotNull
        public final String getDateFormat() {
            return this.dateFormat;
        }

        @NotNull
        public final String getTimeFormat() {
            return this.timeFormat;
        }

        @NotNull
        public final String getDateTimeFormat() {
            return this.dateTimeFormat;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public final TimeZone getTimeZone() {
            return this.timeZone;
        }

        @Override
        @NotNull
        public String convert(@NotNull Object value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (this.raw) {
                string = value.toString();
            } else if (value instanceof Date) {
                String string2 = this.threadLocalDateFormat.get().format((Date)value);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"threadLocalDateFormat.get().format(value)");
                string = string2;
            } else if (value instanceof LocalDate) {
                String string3 = this.dateFormatter.format((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dateFormatter.format(value)");
                string = string3;
            } else if (value instanceof LocalTime) {
                String string4 = this.timeFormatter.format((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"timeFormatter.format(value)");
                string = string4;
            } else if (value instanceof LocalDateTime) {
                String string5 = this.dateTimeFormatter.format((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"dateTimeFormatter.format(value)");
                string = string5;
            } else if (value instanceof TemporalAccessor) {
                String string6 = this.formatter.format((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"formatter.format(value)");
                string = string6;
            } else {
                string = AnyExtensions.smartToString(value);
            }
            return string;
        }

        @Override
        @NotNull
        public StringConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new StringConverter(componentParams);
        }

        private static final SimpleDateFormat threadLocalDateFormat$lambda-1(StringConverter this$0) {
            SimpleDateFormat simpleDateFormat;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SimpleDateFormat it = simpleDateFormat = new SimpleDateFormat(this$0.format, this$0.locale);
            boolean bl = false;
            it.setTimeZone(this$0.getTimeZone());
            return simpleDateFormat;
        }

        public StringConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$StringConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$StringConverter;", "()V", "breeze-core"})
        public static final class Default
        extends StringConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0006H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/Converters$RegexConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/text/Regex;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "regexOptions", "", "Lkotlin/text/RegexOption;", "getRegexOptions", "()Ljava/util/Set;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class RegexConverter
    extends AbstractConverter<Regex> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Set<RegexOption> regexOptions;

        public RegexConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("regexOptions");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Set set = (Set)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Set<? extends RegexOption>>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (set == null) {
                set = SetsKt.emptySet();
            }
            this.regexOptions = set;
        }

        public /* synthetic */ RegexConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final Set<RegexOption> getRegexOptions() {
            return this.regexOptions;
        }

        @Override
        @NotNull
        public Regex convert(@NotNull Object value) {
            Regex regex;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Regex) {
                regex = (Regex)value;
            } else if (value instanceof Pattern) {
                regex = new Regex((Pattern)value);
            } else {
                switch (this.regexOptions.size()) {
                    case 0: {
                        regex = new Regex(value.toString());
                        break;
                    }
                    case 1: {
                        regex = new Regex(value.toString(), (RegexOption)CollectionsKt.first((Iterable)this.regexOptions));
                        break;
                    }
                    default: {
                        regex = new Regex(value.toString(), this.regexOptions);
                    }
                }
            }
            return regex;
        }

        @Override
        @NotNull
        public RegexConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RegexConverter(componentParams);
        }

        public RegexConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$RegexConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$RegexConverter;", "()V", "breeze-core"})
        public static final class Default
        extends RegexConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$PatternConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/regex/Pattern;", "()V", "convert", "value", "", "breeze-core"})
    public static final class PatternConverter
    extends AbstractConverter<Pattern> {
        @NotNull
        public static final PatternConverter INSTANCE = new PatternConverter();

        private PatternConverter() {
        }

        @Override
        @NotNull
        public Pattern convert(@NotNull Object value) {
            Pattern pattern;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Regex) {
                pattern = ((Regex)value).toPattern();
            } else if (value instanceof Pattern) {
                pattern = (Pattern)value;
            } else {
                Pattern pattern2 = Pattern.compile(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(value.toString())");
                pattern = pattern2;
            }
            return pattern;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Converters$CharsetConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/nio/charset/Charset;", "()V", "convert", "value", "", "convertOrNull", "breeze-core"})
    public static final class CharsetConverter
    extends AbstractConverter<Charset> {
        @NotNull
        public static final CharsetConverter INSTANCE = new CharsetConverter();

        private CharsetConverter() {
        }

        @Override
        @NotNull
        public Charset convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Charset ? (Charset)value : StringExtensions.toCharset(value.toString());
        }

        @Override
        @Nullable
        public Charset convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Charset ? (Charset)value : StringExtensions.toCharsetOrNull(value.toString());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Converters$ClassConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/lang/Class;", "()V", "convert", "value", "", "convertOrNull", "breeze-core"})
    public static final class ClassConverter
    extends AbstractConverter<Class<?>> {
        @NotNull
        public static final ClassConverter INSTANCE = new ClassConverter();

        private ClassConverter() {
        }

        @Override
        @NotNull
        public Class<?> convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Class ? (Class<?>)value : StringExtensions.toClass(value.toString());
        }

        @Override
        @Nullable
        public Class<?> convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Class ? (Class<?>)value : StringExtensions.toClassOrNull(value.toString());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$LocaleConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/Locale;", "()V", "convert", "value", "", "breeze-core"})
    public static final class LocaleConverter
    extends AbstractConverter<Locale> {
        @NotNull
        public static final LocaleConverter INSTANCE = new LocaleConverter();

        private LocaleConverter() {
        }

        @Override
        @NotNull
        public Locale convert(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof Locale ? (Locale)value : StringExtensions.toLocale(value.toString());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Converters$TimeZoneConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/TimeZone;", "()V", "convert", "value", "", "convertOrNull", "breeze-core"})
    public static final class TimeZoneConverter
    extends AbstractConverter<TimeZone> {
        @NotNull
        public static final TimeZoneConverter INSTANCE = new TimeZoneConverter();

        private TimeZoneConverter() {
        }

        @Override
        @NotNull
        public TimeZone convert(@NotNull Object value) {
            TimeZone timeZone;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof TimeZone) {
                timeZone = (TimeZone)value;
            } else if (value instanceof ZoneId) {
                TimeZone timeZone2 = TimeZone.getTimeZone((ZoneId)value);
                Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"getTimeZone(value)");
                timeZone = timeZone2;
            } else {
                timeZone = StringExtensions.toTimeZone(value.toString());
            }
            return timeZone;
        }

        @Override
        @Nullable
        public TimeZone convertOrNull(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value instanceof TimeZone ? (TimeZone)value : (value instanceof ZoneId ? TimeZone.getTimeZone((ZoneId)value) : StringExtensions.toTimeZoneOrNull(value.toString()));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$ZoneIdConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/time/ZoneId;", "()V", "convert", "value", "", "breeze-core"})
    public static final class ZoneIdConverter
    extends AbstractConverter<ZoneId> {
        @NotNull
        public static final ZoneIdConverter INSTANCE = new ZoneIdConverter();

        private ZoneIdConverter() {
        }

        @Override
        @NotNull
        public ZoneId convert(@NotNull Object value) {
            ZoneId zoneId;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof ZoneId) {
                zoneId = (ZoneId)value;
            } else if (value instanceof TimeZone) {
                ZoneId zoneId2 = ((TimeZone)value).toZoneId();
                Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"value.toZoneId()");
                zoneId = zoneId2;
            } else if (value instanceof TemporalAccessor) {
                ZoneId zoneId3 = ZoneId.from((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)zoneId3, (String)"from(value)");
                zoneId = zoneId3;
            } else {
                ZoneId zoneId4 = ZoneId.of(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)zoneId4, (String)"of(value.toString())");
                zoneId = zoneId4;
            }
            return zoneId;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0019\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R2\u0010\u0011\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013 \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u0013\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Licu/windea/breezeframework/core/component/Converters$DateConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/Date;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "format", "getFormat", "()Ljava/lang/String;", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "threadLocalDateFormat", "Ljava/lang/ThreadLocal;", "Ljava/text/SimpleDateFormat;", "kotlin.jvm.PlatformType", "timeZone", "Ljava/util/TimeZone;", "getTimeZone", "()Ljava/util/TimeZone;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class DateConverter
    extends AbstractConverter<Date> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final String format;
        @NotNull
        private final Locale locale;
        @NotNull
        private final TimeZone timeZone;
        private final ThreadLocal<SimpleDateFormat> threadLocalDateFormat;

        public DateConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String string = InternalExtensions.convertToStringOrNull(this.componentParams.get("format"));
            if (string == null) {
                string = "yyyy-MM-dd";
            }
            this.format = string;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("locale");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Object object = (Locale)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Locale>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (object == null) {
                $this$convertOrNull_u24default$iv = InternalExtensions.getDefaultLocale();
                Intrinsics.checkNotNullExpressionValue((Object)$this$convertOrNull_u24default$iv, (String)"defaultLocale");
                object = $this$convertOrNull_u24default$iv;
            }
            this.locale = object;
            $this$convertOrNull_u24default$iv = this.componentParams.get("timeZone");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            TimeZone timeZone = (TimeZone)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<TimeZone>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (timeZone == null) {
                TimeZone timeZone2 = InternalExtensions.getDefaultTimeZone();
                Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"defaultTimeZone");
                timeZone = timeZone2;
            }
            this.timeZone = timeZone;
            this.threadLocalDateFormat = ThreadLocal.withInitial(() -> DateConverter.threadLocalDateFormat$lambda-1(this));
        }

        public /* synthetic */ DateConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getFormat() {
            return this.format;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public final TimeZone getTimeZone() {
            return this.timeZone;
        }

        @Override
        @NotNull
        public Date convert(@NotNull Object value) {
            Date date;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Date) {
                date = (Date)value;
            } else if (value instanceof Instant) {
                Date date2 = Date.from((Instant)value);
                Intrinsics.checkNotNullExpressionValue((Object)date2, (String)"from(value)");
                date = date2;
            } else if (value instanceof String) {
                Date date3 = this.threadLocalDateFormat.get().parse((String)value);
                Intrinsics.checkNotNullExpressionValue((Object)date3, (String)"threadLocalDateFormat.get().parse(value)");
                date = date3;
            } else {
                Date date4 = this.threadLocalDateFormat.get().parse(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)date4, (String)"threadLocalDateFormat.ge\u2026).parse(value.toString())");
                date = date4;
            }
            return date;
        }

        @Override
        @NotNull
        public DateConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new DateConverter(componentParams);
        }

        private static final SimpleDateFormat threadLocalDateFormat$lambda-1(DateConverter this$0) {
            SimpleDateFormat simpleDateFormat;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            SimpleDateFormat it = simpleDateFormat = new SimpleDateFormat(this$0.format, this$0.locale);
            boolean bl = false;
            it.setTimeZone(this$0.getTimeZone());
            return simpleDateFormat;
        }

        public DateConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$DateConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$DateConverter;", "()V", "breeze-core"})
        public static final class Default
        extends DateConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0018\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Licu/windea/breezeframework/core/component/Converters$LocalDateConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/time/LocalDate;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "format", "getFormat", "()Ljava/lang/String;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "timeZone", "Ljava/util/TimeZone;", "getTimeZone", "()Ljava/util/TimeZone;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class LocalDateConverter
    extends AbstractConverter<LocalDate> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final String format;
        @NotNull
        private final Locale locale;
        @NotNull
        private final TimeZone timeZone;
        private final DateTimeFormatter formatter;

        public LocalDateConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String string = InternalExtensions.convertToStringOrNull(this.componentParams.get("format"));
            if (string == null) {
                string = "yyyy-MM-dd";
            }
            this.format = string;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("locale");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Object object = (Locale)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Locale>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (object == null) {
                $this$convertOrNull_u24default$iv = InternalExtensions.getDefaultLocale();
                Intrinsics.checkNotNullExpressionValue((Object)$this$convertOrNull_u24default$iv, (String)"defaultLocale");
                object = $this$convertOrNull_u24default$iv;
            }
            this.locale = object;
            $this$convertOrNull_u24default$iv = this.componentParams.get("timeZone");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            TimeZone timeZone = (TimeZone)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<TimeZone>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (timeZone == null) {
                TimeZone timeZone2 = InternalExtensions.getDefaultTimeZone();
                Intrinsics.checkNotNullExpressionValue((Object)timeZone2, (String)"defaultTimeZone");
                timeZone = timeZone2;
            }
            this.timeZone = timeZone;
            this.formatter = DateTimeFormatter.ofPattern(this.format, this.locale).withZone(this.timeZone.toZoneId());
        }

        public /* synthetic */ LocalDateConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getFormat() {
            return this.format;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public final TimeZone getTimeZone() {
            return this.timeZone;
        }

        @Override
        @NotNull
        public LocalDate convert(@NotNull Object value) {
            LocalDate localDate;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof LocalDate) {
                localDate = (LocalDate)value;
            } else if (value instanceof TemporalAccessor) {
                LocalDate localDate2 = LocalDate.from((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"from(value)");
                localDate = localDate2;
            } else if (value instanceof Date) {
                LocalDate localDate3 = LocalDate.from(((Date)value).toInstant());
                Intrinsics.checkNotNullExpressionValue((Object)localDate3, (String)"from(value.toInstant())");
                localDate = localDate3;
            } else if (value instanceof String) {
                LocalDate localDate4 = LocalDate.parse((CharSequence)value, this.formatter);
                Intrinsics.checkNotNullExpressionValue((Object)localDate4, (String)"parse(value, formatter)");
                localDate = localDate4;
            } else {
                LocalDate localDate5 = LocalDate.parse(value.toString(), this.formatter);
                Intrinsics.checkNotNullExpressionValue((Object)localDate5, (String)"parse(value.toString(), formatter)");
                localDate = localDate5;
            }
            return localDate;
        }

        @Override
        @NotNull
        public LocalDateConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new LocalDateConverter(componentParams);
        }

        public LocalDateConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$LocalDateConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$LocalDateConverter;", "()V", "breeze-core"})
        public static final class Default
        extends LocalDateConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0018\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Licu/windea/breezeframework/core/component/Converters$LocalTimeConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/time/LocalTime;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "format", "getFormat", "()Ljava/lang/String;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "timeZone", "Ljava/util/TimeZone;", "getTimeZone", "()Ljava/util/TimeZone;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class LocalTimeConverter
    extends AbstractConverter<LocalTime> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final String format;
        @NotNull
        private final Locale locale;
        @NotNull
        private final TimeZone timeZone;
        private final DateTimeFormatter formatter;

        public LocalTimeConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            Locale locale;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converters this_$iv$iv;
            boolean $i$f$convertOrNull2;
            Map componentParams$iv;
            Object $this$convertOrNull_u24default$iv;
            Locale locale2;
            String string;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object object = this.componentParams.get("format");
            if (object == null) {
                string = "HH:mm:ss";
            } else {
                string = InternalExtensions.convertToStringOrNull(object);
                if (string == null) {
                    string = "HH:mm:ss";
                }
            }
            this.format = string;
            Object object2 = this.componentParams.get("locale");
            if (object2 == null) {
                locale2 = null;
            } else {
                $this$convertOrNull_u24default$iv = object2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                locale2 = locale = (Locale)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Locale>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            }
            if (locale2 == null) {
                cloneable3 = InternalExtensions.getDefaultLocale();
                Intrinsics.checkNotNullExpressionValue((Object)cloneable3, (String)"defaultLocale");
                locale = cloneable3;
            }
            this.locale = locale;
            Object object3 = this.componentParams.get("timeZone");
            if (object3 == null) {
                cloneable2 = null;
            } else {
                $this$convertOrNull_u24default$iv = object3;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                cloneable2 = cloneable = (TimeZone)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<TimeZone>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            }
            if (cloneable2 == null) {
                cloneable3 = InternalExtensions.getDefaultTimeZone();
                Intrinsics.checkNotNullExpressionValue((Object)cloneable3, (String)"defaultTimeZone");
                cloneable = cloneable3;
            }
            this.timeZone = cloneable;
            this.formatter = DateTimeFormatter.ofPattern(this.format, this.locale).withZone(this.timeZone.toZoneId());
        }

        public /* synthetic */ LocalTimeConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getFormat() {
            return this.format;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public final TimeZone getTimeZone() {
            return this.timeZone;
        }

        @Override
        @NotNull
        public LocalTime convert(@NotNull Object value) {
            LocalTime localTime;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof LocalTime) {
                localTime = (LocalTime)value;
            } else if (value instanceof TemporalAccessor) {
                LocalTime localTime2 = LocalTime.from((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"from(value)");
                localTime = localTime2;
            } else if (value instanceof Date) {
                LocalTime localTime3 = LocalTime.from(((Date)value).toInstant());
                Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"from(value.toInstant())");
                localTime = localTime3;
            } else if (value instanceof String) {
                LocalTime localTime4 = LocalTime.parse((CharSequence)value, this.formatter);
                Intrinsics.checkNotNullExpressionValue((Object)localTime4, (String)"parse(value, formatter)");
                localTime = localTime4;
            } else {
                LocalTime localTime5 = LocalTime.parse(value.toString(), this.formatter);
                Intrinsics.checkNotNullExpressionValue((Object)localTime5, (String)"parse(value.toString(), formatter)");
                localTime = localTime5;
            }
            return localTime;
        }

        @Override
        @NotNull
        public LocalTimeConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new LocalTimeConverter(componentParams);
        }

        public LocalTimeConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$LocalTimeConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$LocalTimeConverter;", "()V", "breeze-core"})
        public static final class Default
        extends LocalTimeConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0018\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Licu/windea/breezeframework/core/component/Converters$LocalDateTimeConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/time/LocalDateTime;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "format", "getFormat", "()Ljava/lang/String;", "formatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "locale", "Ljava/util/Locale;", "getLocale", "()Ljava/util/Locale;", "timeZone", "Ljava/util/TimeZone;", "getTimeZone", "()Ljava/util/TimeZone;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class LocalDateTimeConverter
    extends AbstractConverter<LocalDateTime> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final String format;
        @NotNull
        private final Locale locale;
        @NotNull
        private final TimeZone timeZone;
        private final DateTimeFormatter formatter;

        public LocalDateTimeConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Cloneable cloneable;
            Cloneable cloneable2;
            Cloneable cloneable3;
            Locale locale;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converters this_$iv$iv;
            boolean $i$f$convertOrNull2;
            Map componentParams$iv;
            Object $this$convertOrNull_u24default$iv;
            Locale locale2;
            String string;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object object = this.componentParams.get("format");
            if (object == null) {
                string = "yyyy-MM-dd HH:mm:ss";
            } else {
                string = InternalExtensions.convertToStringOrNull(object);
                if (string == null) {
                    string = "yyyy-MM-dd HH:mm:ss";
                }
            }
            this.format = string;
            Object object2 = this.componentParams.get("locale");
            if (object2 == null) {
                locale2 = null;
            } else {
                $this$convertOrNull_u24default$iv = object2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                locale2 = locale = (Locale)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Locale>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            }
            if (locale2 == null) {
                cloneable3 = InternalExtensions.getDefaultLocale();
                Intrinsics.checkNotNullExpressionValue((Object)cloneable3, (String)"defaultLocale");
                locale = cloneable3;
            }
            this.locale = locale;
            Object object3 = this.componentParams.get("timeZone");
            if (object3 == null) {
                cloneable2 = null;
            } else {
                $this$convertOrNull_u24default$iv = object3;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                cloneable2 = cloneable = (TimeZone)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<TimeZone>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            }
            if (cloneable2 == null) {
                cloneable3 = InternalExtensions.getDefaultTimeZone();
                Intrinsics.checkNotNullExpressionValue((Object)cloneable3, (String)"defaultTimeZone");
                cloneable = cloneable3;
            }
            this.timeZone = cloneable;
            this.formatter = DateTimeFormatter.ofPattern(this.format, this.locale).withZone(this.timeZone.toZoneId());
        }

        public /* synthetic */ LocalDateTimeConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getFormat() {
            return this.format;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @NotNull
        public final TimeZone getTimeZone() {
            return this.timeZone;
        }

        @Override
        @NotNull
        public LocalDateTime convert(@NotNull Object value) {
            LocalDateTime localDateTime;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof LocalDateTime) {
                localDateTime = (LocalDateTime)value;
            } else if (value instanceof TemporalAccessor) {
                LocalDateTime localDateTime2 = LocalDateTime.from((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"from(value)");
                localDateTime = localDateTime2;
            } else if (value instanceof Date) {
                LocalDateTime localDateTime3 = LocalDateTime.from(((Date)value).toInstant());
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"from(value.toInstant())");
                localDateTime = localDateTime3;
            } else if (value instanceof String) {
                LocalDateTime localDateTime4 = LocalDateTime.parse((CharSequence)value, this.formatter);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime4, (String)"parse(value, formatter)");
                localDateTime = localDateTime4;
            } else {
                LocalDateTime localDateTime5 = LocalDateTime.parse(value.toString(), this.formatter);
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime5, (String)"parse(value.toString(), formatter)");
                localDateTime = localDateTime5;
            }
            return localDateTime;
        }

        @Override
        @NotNull
        public LocalDateTimeConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new LocalDateTimeConverter(componentParams);
        }

        public LocalDateTimeConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$LocalDateTimeConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$LocalDateTimeConverter;", "()V", "breeze-core"})
        public static final class Default
        extends LocalDateTimeConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$InstantConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/time/Instant;", "()V", "convert", "value", "", "breeze-core"})
    public static final class InstantConverter
    extends AbstractConverter<Instant> {
        @NotNull
        public static final InstantConverter INSTANCE = new InstantConverter();

        private InstantConverter() {
        }

        @Override
        @NotNull
        public Instant convert(@NotNull Object value) {
            Instant instant;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Instant) {
                instant = (Instant)value;
            } else if (value instanceof TemporalAccessor) {
                Instant instant2 = Instant.from((TemporalAccessor)value);
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"from(value)");
                instant = instant2;
            } else if (value instanceof String) {
                Instant instant3 = Instant.parse((CharSequence)value);
                Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"parse(value)");
                instant = instant3;
            } else {
                Instant instant4 = Instant.parse(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"parse(value.toString())");
                instant = instant4;
            }
            return instant;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\b\b\u0016\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0006H\u0016R\"\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Licu/windea/breezeframework/core/component/Converters$DurationConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/time/Duration;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class DurationConverter
    extends AbstractConverter<Duration> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;

        public DurationConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
        }

        public /* synthetic */ DurationConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @Override
        @NotNull
        public Duration convert(@NotNull Object value) {
            Duration duration;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Duration) {
                duration = (Duration)value;
            } else if (value instanceof TemporalAmount) {
                Duration duration2 = Duration.from((TemporalAmount)value);
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"from(value)");
                duration = duration2;
            } else if (value instanceof Pair) {
                Object start = ((Pair)value).component1();
                Object end = ((Pair)value).component2();
                if (!(start instanceof Temporal) || !(end instanceof Temporal)) {
                    throw new IllegalArgumentException("Cannot convert '" + value + "' to Duration.");
                }
                Duration duration3 = Duration.between((Temporal)start, (Temporal)end);
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"{\n\t\t\t\t\tval (start, end) \u2026 Duration.\")\n\t\t\t\t\t}\n\t\t\t\t}");
                duration = duration3;
            } else {
                Duration duration4 = Duration.parse(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"parse(value.toString())");
                duration = duration4;
            }
            return duration;
        }

        @Override
        @NotNull
        public DurationConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new DurationConverter(componentParams);
        }

        public DurationConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$DurationConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$DurationConverter;", "()V", "breeze-core"})
        public static final class Default
        extends DurationConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\b\b\u0016\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Licu/windea/breezeframework/core/component/Converters$PeriodConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/time/Period;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "componentCopy", "convert", "value", "Default", "breeze-core"})
    public static class PeriodConverter
    extends AbstractConverter<Period> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;

        public PeriodConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
        }

        public /* synthetic */ PeriodConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @Override
        @NotNull
        public Period convert(@NotNull Object value) {
            Period period;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Period) {
                period = (Period)value;
            } else if (value instanceof TemporalAmount) {
                Period period2 = Period.from((TemporalAmount)value);
                Intrinsics.checkNotNullExpressionValue((Object)period2, (String)"from(value)");
                period = period2;
            } else if (value instanceof Pair) {
                Object start = ((Pair)value).component1();
                Object end = ((Pair)value).component2();
                if (!(start instanceof LocalDate) || !(end instanceof LocalDate)) {
                    throw new IllegalArgumentException("Cannot convert '" + value + "' to Period.");
                }
                Period period3 = Period.between((LocalDate)start, (LocalDate)end);
                Intrinsics.checkNotNullExpressionValue((Object)period3, (String)"{\n\t\t\t\t\tval (start, end) \u2026to Period.\")\n\t\t\t\t\t}\n\t\t\t\t}");
                period = period3;
            } else if (value instanceof String) {
                Period period4 = Period.parse((CharSequence)value);
                Intrinsics.checkNotNullExpressionValue((Object)period4, (String)"parse(value)");
                period = period4;
            } else {
                Period period5 = Period.parse(value.toString());
                Intrinsics.checkNotNullExpressionValue((Object)period5, (String)"parse(value.toString())");
                period = period5;
            }
            return period;
        }

        @Override
        @NotNull
        public PeriodConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new PeriodConverter(componentParams);
        }

        public PeriodConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$PeriodConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$PeriodConverter;", "()V", "breeze-core"})
        public static final class Default
        extends PeriodConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$FileConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/io/File;", "()V", "convert", "value", "", "breeze-core"})
    public static final class FileConverter
    extends AbstractConverter<File> {
        @NotNull
        public static final FileConverter INSTANCE = new FileConverter();

        private FileConverter() {
        }

        @Override
        @NotNull
        public File convert(@NotNull Object value) {
            File file;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof File) {
                file = (File)value;
            } else if (value instanceof Path) {
                File file2 = ((Path)value).toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"value.toFile()");
                file = file2;
            } else if (value instanceof URL) {
                URL $this$toFile$iv = (URL)value;
                boolean $i$f$toFile = false;
                file = new File($this$toFile$iv.toURI().normalize());
            } else if (value instanceof URI) {
                URI $this$toFile$iv = (URI)value;
                boolean $i$f$toFile = false;
                file = new File($this$toFile$iv);
            } else {
                file = StringExtensions.toFile(value.toString());
            }
            return file;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$PathConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/nio/file/Path;", "()V", "convert", "value", "", "breeze-core"})
    public static final class PathConverter
    extends AbstractConverter<Path> {
        @NotNull
        public static final PathConverter INSTANCE = new PathConverter();

        private PathConverter() {
        }

        @Override
        @NotNull
        public Path convert(@NotNull Object value) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof File) {
                Path path2 = ((File)value).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"value.toPath()");
                path = path2;
            } else if (value instanceof Path) {
                path = (Path)value;
            } else if (value instanceof URL) {
                URL $this$toPath$iv = (URL)value;
                boolean $i$f$toPath = false;
                URL $this$toFile$iv$iv = $this$toPath$iv;
                boolean $i$f$toFile = false;
                Path path3 = new File($this$toFile$iv$iv.toURI().normalize()).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.toFile().toPath()");
                path = path3;
            } else if (value instanceof URI) {
                URI $this$toPath$iv = (URI)value;
                boolean $i$f$toPath = false;
                URI $this$toFile$iv$iv = $this$toPath$iv;
                boolean $i$f$toFile = false;
                Path path4 = new File($this$toFile$iv$iv).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.toFile().toPath()");
                path = path4;
            } else {
                path = StringExtensions.toPath(value.toString());
            }
            return path;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$UrlConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/net/URL;", "()V", "convert", "value", "", "breeze-core"})
    public static final class UrlConverter
    extends AbstractConverter<URL> {
        @NotNull
        public static final UrlConverter INSTANCE = new UrlConverter();

        private UrlConverter() {
        }

        @Override
        @NotNull
        public URL convert(@NotNull Object value) {
            URL uRL;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof File) {
                uRL = FileExtensions.toUrl((File)value);
            } else if (value instanceof Path) {
                Path $this$toUrl$iv = (Path)value;
                boolean $i$f$toUrl = false;
                URL uRL2 = $this$toUrl$iv.toUri().toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"this.toUri().toURL()");
                uRL = uRL2;
            } else if (value instanceof URL) {
                uRL = (URL)value;
            } else if (value instanceof URI) {
                URI $this$toUrl$iv = (URI)value;
                boolean $i$f$toUrl = false;
                URL uRL3 = $this$toUrl$iv.toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL3, (String)"this.toURL()");
                uRL = uRL3;
            } else {
                uRL = StringExtensions.toUrl$default(value.toString(), null, null, 3, null);
            }
            return uRL;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Converters$UriConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/net/URI;", "()V", "convert", "value", "", "breeze-core"})
    public static final class UriConverter
    extends AbstractConverter<URI> {
        @NotNull
        public static final UriConverter INSTANCE = new UriConverter();

        private UriConverter() {
        }

        @Override
        @NotNull
        public URI convert(@NotNull Object value) {
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof File) {
                uRI = FileExtensions.toUri((File)value);
            } else if (value instanceof Path) {
                URI uRI2 = ((Path)value).toUri();
                Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"value.toUri()");
                uRI = uRI2;
            } else if (value instanceof URL) {
                URL $this$toUri$iv = (URL)value;
                boolean $i$f$toUri = false;
                URI uRI3 = $this$toUri$iv.toURI();
                Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"this.toURI()");
                uRI = uRI3;
            } else {
                uRI = value instanceof URI ? (URI)value : StringExtensions.toUri(value.toString());
            }
            return uRI;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Licu/windea/breezeframework/core/component/Converters$EnumConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "()V", "convert", "value", "", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "breeze-core"})
    public static final class EnumConverter
    extends AbstractConverter<Enum<?>>
    implements GenericConverter<Enum<?>> {
        @NotNull
        public static final EnumConverter INSTANCE = new EnumConverter();

        private EnumConverter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Enum<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Class<Enum<?>> enumClass = InternalExtensions.inferEnumClass(targetType);
            if (Intrinsics.areEqual(enumClass, Enum.class)) {
                throw new IllegalArgumentException("Cannot get actual enum class.");
            }
            if (value instanceof Number) {
                List enumValues;
                List list;
                int index = ((Number)value).intValue();
                Object $this$getOrPut$iv = InternalExtensions.getEnumValuesCache();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(enumClass);
                if (value$iv == null) {
                    boolean bl = false;
                    Object[] objectArray = enumClass.getEnumConstants();
                    List list2 = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List answer$iv = list2;
                    $this$getOrPut$iv.put(enumClass, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                if (($this$getOrPut$iv = (Enum)CollectionsKt.getOrNull(enumValues = list, (int)index)) == null) {
                    throw new IllegalArgumentException("Cannot find enum constant by index '" + index + "'.");
                }
                object = $this$getOrPut$iv;
            } else {
                Map enumValueMap;
                Map map;
                String name = value.toString();
                Map<Class<Enum<?>>, Map<String, Enum<?>>> $this$getOrPut$iv = InternalExtensions.getEnumValueMapCache();
                boolean $i$f$getOrPut = false;
                Map value$iv = $this$getOrPut$iv.get(enumClass);
                if (value$iv == null) {
                    Map map2;
                    boolean bl = false;
                    Object[] objectArray = enumClass.getEnumConstants();
                    if (objectArray == null) {
                        map2 = null;
                    } else {
                        List list = ArraysKt.toList((Object[])objectArray);
                        if (list == null) {
                            map2 = null;
                        } else {
                            void $this$associateByTo$iv$iv;
                            Iterable $this$associateBy$iv = list;
                            boolean $i$f$associateBy = false;
                            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                            Iterable iterable = $this$associateBy$iv;
                            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                            boolean $i$f$associateByTo = false;
                            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                                void it;
                                Enum enum_ = (Enum)element$iv$iv;
                                Map map3 = destination$iv$iv;
                                boolean bl2 = false;
                                map3.put(it.name(), element$iv$iv);
                            }
                            map2 = destination$iv$iv;
                        }
                    }
                    Map map4 = map2;
                    if (map2 == null) {
                        map4 = MapsKt.emptyMap();
                    }
                    Map answer$iv = map4;
                    $this$getOrPut$iv.put(enumClass, answer$iv);
                    map = answer$iv;
                } else {
                    map = value$iv;
                }
                if ((object = (enumValueMap = map).get(name)) == null) {
                    throw new IllegalArgumentException("Cannot find enum constant by name '" + name + "'.");
                }
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Enum<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Enum enum_;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Class<Enum<?>> enumClass = InternalExtensions.inferEnumClass(targetType);
            if (Intrinsics.areEqual(enumClass, Enum.class)) {
                throw new IllegalArgumentException("Cannot get actual enum class.");
            }
            if (value instanceof Number) {
                List list;
                int index = ((Number)value).intValue();
                Map<Class<Enum<?>>, List<Enum<?>>> $this$getOrPut$iv = InternalExtensions.getEnumValuesCache();
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(enumClass);
                if (value$iv == null) {
                    boolean bl = false;
                    Object[] objectArray = enumClass.getEnumConstants();
                    List list2 = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    List answer$iv = list2;
                    $this$getOrPut$iv.put(enumClass, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                List enumValues = list;
                enum_ = (Enum)CollectionsKt.getOrNull(enumValues, (int)index);
            } else {
                Object object;
                Object $this$getOrPut$iv = value.toString().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)$this$getOrPut$iv, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String name = $this$getOrPut$iv;
                $this$getOrPut$iv = InternalExtensions.getEnumValueMapCache();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(enumClass);
                if (value$iv == null) {
                    Map map;
                    boolean bl = false;
                    Object[] objectArray = enumClass.getEnumConstants();
                    if (objectArray == null) {
                        map = null;
                    } else {
                        List list = ArraysKt.toList((Object[])objectArray);
                        if (list == null) {
                            map = null;
                        } else {
                            void $this$associateByTo$iv$iv;
                            Iterable $this$associateBy$iv = list;
                            boolean $i$f$associateBy = false;
                            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                            Iterable iterable = $this$associateBy$iv;
                            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                            boolean $i$f$associateByTo = false;
                            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                                void it;
                                Enum enum_2 = (Enum)element$iv$iv;
                                Map map2 = destination$iv$iv;
                                boolean bl2 = false;
                                map2.put(it.name(), element$iv$iv);
                            }
                            map = destination$iv$iv;
                        }
                    }
                    Map map3 = map;
                    if (map == null) {
                        map3 = MapsKt.emptyMap();
                    }
                    Map answer$iv = map3;
                    $this$getOrPut$iv.put(enumClass, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Map enumValueMap = (Map)object;
                enum_ = (Enum)enumValueMap.get(name);
            }
            return enum_;
        }

        @Override
        @NotNull
        public Enum<?> convert(@NotNull Object value) {
            return (Enum)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Enum<?> convertOrNull(@NotNull Object value) {
            return (Enum)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u001eB\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J!\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001f"}, d2={"Licu/windea/breezeframework/core/component/Converters$ArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)[Ljava/lang/Object;", "convertElement", "element", "elementType", "splitValue", "", "Default", "breeze-core"})
    public static class ArrayConverter
    extends AbstractConverter<Object[]>
    implements GenericConverter<Object[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public ArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ ArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public Object[] convert(@NotNull Object value, @NotNull Type targetType) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Type elementType = InternalExtensions.inferTypeArgument(targetType);
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                Object[] objectArray2 = new Object[n2];
                while (n < n2) {
                    int n3 = n++;
                    objectArray2[n3] = this.convertElement(((Object[])value)[n3], elementType);
                }
                objectArray = objectArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                Object[] objectArray3 = new Object[n4];
                while (n < n4) {
                    int n5 = n++;
                    objectArray3[n5] = this.convertElement(((byte[])value)[n5], elementType);
                }
                objectArray = objectArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                Object[] objectArray4 = new Object[n6];
                while (n < n6) {
                    int n7 = n++;
                    objectArray4[n7] = this.convertElement(((short[])value)[n7], elementType);
                }
                objectArray = objectArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                Object[] objectArray5 = new Object[n8];
                while (n < n8) {
                    int n9 = n++;
                    objectArray5[n9] = this.convertElement(((int[])value)[n9], elementType);
                }
                objectArray = objectArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                Object[] objectArray6 = new Object[n10];
                while (n < n10) {
                    int n11 = n++;
                    objectArray6[n11] = this.convertElement(((long[])value)[n11], elementType);
                }
                objectArray = objectArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                Object[] objectArray7 = new Object[n12];
                while (n < n12) {
                    int n13 = n++;
                    objectArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]), elementType);
                }
                objectArray = objectArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                Object[] objectArray8 = new Object[n14];
                while (n < n14) {
                    int n15 = n++;
                    objectArray8[n15] = this.convertElement(((double[])value)[n15], elementType);
                }
                objectArray = objectArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                Object[] objectArray9 = new Object[n16];
                while (n < n16) {
                    int n17 = n++;
                    objectArray9[n17] = this.convertElement(((boolean[])value)[n17], elementType);
                }
                objectArray = objectArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                Object[] objectArray10 = new Object[n18];
                while (n < n18) {
                    int n19 = n++;
                    objectArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]), elementType);
                }
                objectArray = objectArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                Object[] objectArray11 = new Object[n20];
                while (n < n20) {
                    int n21 = n++;
                    objectArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)), elementType);
                }
                objectArray = objectArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                Object[] objectArray12 = new Object[n22];
                while (n < n22) {
                    int n23 = n++;
                    objectArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)), elementType);
                }
                objectArray = objectArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                Object[] objectArray13 = new Object[n24];
                while (n < n24) {
                    int n25 = n++;
                    objectArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)), elementType);
                }
                objectArray = objectArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                Object[] objectArray14 = new Object[n26];
                while (n < n26) {
                    int n27 = n++;
                    objectArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)), elementType);
                }
                objectArray = objectArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                Object[] objectArray15 = new Object[n28];
                while (n < n28) {
                    int n29 = n++;
                    objectArray15[n29] = this.convertElement(v.get(n29), elementType);
                }
                objectArray = objectArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                Object[] objectArray16 = new Object[n30];
                while (n < n30) {
                    int n31 = n++;
                    objectArray16[n31] = this.convertElement(v.get(n31), elementType);
                }
                objectArray = objectArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                Object[] objectArray17 = new Object[n32];
                while (n < n32) {
                    int n33 = n++;
                    objectArray17[n33] = this.convertElement(v.get(n33), elementType);
                }
                objectArray = objectArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                Object[] objectArray18 = new Object[n34];
                while (n < n34) {
                    int n35 = n++;
                    objectArray18[n35] = this.convertElement(v.get(n35), elementType);
                }
                objectArray = objectArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                Object[] objectArray19 = new Object[n36];
                while (n < n36) {
                    int n37 = n++;
                    objectArray19[n37] = this.convertElement(v.get(n37), elementType);
                }
                objectArray = objectArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                Object[] objectArray20 = new Object[n38];
                while (n < n38) {
                    int n39 = n++;
                    objectArray20[n39] = this.convertElement(v.get(n39), elementType);
                }
                objectArray = objectArray20;
            } else {
                Object[] objectArray21 = new Object[]{this.convertElement(value, elementType)};
                objectArray = objectArray21;
            }
            return objectArray;
        }

        private final Object convertElement(Object element, Type elementType) {
            return ConverterExtensions.convert(element, elementType, this.passingParams);
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public ArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new ArrayConverter(componentParams);
        }

        @Override
        @NotNull
        public Object[] convert(@NotNull Object value) {
            return (Object[])GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Object[] convertOrNull(@NotNull Object value) {
            return (Object[])GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        @Override
        @Nullable
        public Object[] convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            return (Object[])GenericConverter.DefaultImpls.convertOrNull(this, value, targetType);
        }

        public ArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$ArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$ArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends ArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$ByteArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class ByteArrayConverter
    extends AbstractConverter<byte[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public ByteArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ ByteArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public byte[] convert(@NotNull Object value) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                byte[] byArray2 = new byte[n2];
                while (n < n2) {
                    int n3 = n++;
                    byArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                byArray = byArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                byte[] byArray3 = new byte[n4];
                while (n < n4) {
                    int n5 = n++;
                    byArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                byArray = byArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                byte[] byArray4 = new byte[n6];
                while (n < n6) {
                    int n7 = n++;
                    byArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                byArray = byArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                byte[] byArray5 = new byte[n8];
                while (n < n8) {
                    int n9 = n++;
                    byArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                byArray = byArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                byte[] byArray6 = new byte[n10];
                while (n < n10) {
                    int n11 = n++;
                    byArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                byArray = byArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                byte[] byArray7 = new byte[n12];
                while (n < n12) {
                    int n13 = n++;
                    byArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                byArray = byArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                byte[] byArray8 = new byte[n14];
                while (n < n14) {
                    int n15 = n++;
                    byArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                byArray = byArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                byte[] byArray9 = new byte[n16];
                while (n < n16) {
                    int n17 = n++;
                    byArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                byArray = byArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                byte[] byArray10 = new byte[n18];
                while (n < n18) {
                    int n19 = n++;
                    byArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                byArray = byArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                byte[] byArray11 = new byte[n20];
                while (n < n20) {
                    int n21 = n++;
                    byArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                byArray = byArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                byte[] byArray12 = new byte[n22];
                while (n < n22) {
                    int n23 = n++;
                    byArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                byArray = byArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                byte[] byArray13 = new byte[n24];
                while (n < n24) {
                    int n25 = n++;
                    byArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                byArray = byArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                byte[] byArray14 = new byte[n26];
                while (n < n26) {
                    int n27 = n++;
                    byArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                byArray = byArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                byte[] byArray15 = new byte[n28];
                while (n < n28) {
                    int n29 = n++;
                    byArray15[n29] = this.convertElement(v.get(n29));
                }
                byArray = byArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                byte[] byArray16 = new byte[n30];
                while (n < n30) {
                    int n31 = n++;
                    byArray16[n31] = this.convertElement(v.get(n31));
                }
                byArray = byArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                byte[] byArray17 = new byte[n32];
                while (n < n32) {
                    int n33 = n++;
                    byArray17[n33] = this.convertElement(v.get(n33));
                }
                byArray = byArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                byte[] byArray18 = new byte[n34];
                while (n < n34) {
                    int n35 = n++;
                    byArray18[n35] = this.convertElement(v.get(n35));
                }
                byArray = byArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                byte[] byArray19 = new byte[n36];
                while (n < n36) {
                    int n37 = n++;
                    byArray19[n37] = this.convertElement(v.get(n37));
                }
                byArray = byArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                byte[] byArray20 = new byte[n38];
                while (n < n38) {
                    int n39 = n++;
                    byArray20[n39] = this.convertElement(v.get(n39));
                }
                byArray = byArray20;
            } else {
                byte[] byArray21 = new byte[]{this.convertElement(value)};
                byArray = byArray21;
            }
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        private final byte convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((Number)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Byte>(){}.getType(), componentParams$iv)).byteValue();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public ByteArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new ByteArrayConverter(componentParams);
        }

        public ByteArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$ByteArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$ByteArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends ByteArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$ShortArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class ShortArrayConverter
    extends AbstractConverter<short[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public ShortArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ ShortArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public short[] convert(@NotNull Object value) {
            short[] sArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                short[] sArray2 = new short[n2];
                while (n < n2) {
                    int n3 = n++;
                    sArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                sArray = sArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                short[] sArray3 = new short[n4];
                while (n < n4) {
                    int n5 = n++;
                    sArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                sArray = sArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                short[] sArray4 = new short[n6];
                while (n < n6) {
                    int n7 = n++;
                    sArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                sArray = sArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                short[] sArray5 = new short[n8];
                while (n < n8) {
                    int n9 = n++;
                    sArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                sArray = sArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                short[] sArray6 = new short[n10];
                while (n < n10) {
                    int n11 = n++;
                    sArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                sArray = sArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                short[] sArray7 = new short[n12];
                while (n < n12) {
                    int n13 = n++;
                    sArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                sArray = sArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                short[] sArray8 = new short[n14];
                while (n < n14) {
                    int n15 = n++;
                    sArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                sArray = sArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                short[] sArray9 = new short[n16];
                while (n < n16) {
                    int n17 = n++;
                    sArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                sArray = sArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                short[] sArray10 = new short[n18];
                while (n < n18) {
                    int n19 = n++;
                    sArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                sArray = sArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                short[] sArray11 = new short[n20];
                while (n < n20) {
                    int n21 = n++;
                    sArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                sArray = sArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                short[] sArray12 = new short[n22];
                while (n < n22) {
                    int n23 = n++;
                    sArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                sArray = sArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                short[] sArray13 = new short[n24];
                while (n < n24) {
                    int n25 = n++;
                    sArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                sArray = sArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                short[] sArray14 = new short[n26];
                while (n < n26) {
                    int n27 = n++;
                    sArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                sArray = sArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                short[] sArray15 = new short[n28];
                while (n < n28) {
                    int n29 = n++;
                    sArray15[n29] = this.convertElement(v.get(n29));
                }
                sArray = sArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                short[] sArray16 = new short[n30];
                while (n < n30) {
                    int n31 = n++;
                    sArray16[n31] = this.convertElement(v.get(n31));
                }
                sArray = sArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                short[] sArray17 = new short[n32];
                while (n < n32) {
                    int n33 = n++;
                    sArray17[n33] = this.convertElement(v.get(n33));
                }
                sArray = sArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                short[] sArray18 = new short[n34];
                while (n < n34) {
                    int n35 = n++;
                    sArray18[n35] = this.convertElement(v.get(n35));
                }
                sArray = sArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                short[] sArray19 = new short[n36];
                while (n < n36) {
                    int n37 = n++;
                    sArray19[n37] = this.convertElement(v.get(n37));
                }
                sArray = sArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                short[] sArray20 = new short[n38];
                while (n < n38) {
                    int n39 = n++;
                    sArray20[n39] = this.convertElement(v.get(n39));
                }
                sArray = sArray20;
            } else {
                short[] sArray21 = new short[]{this.convertElement(value)};
                sArray = sArray21;
            }
            return sArray;
        }

        /*
         * WARNING - void declaration
         */
        private final short convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((Number)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Short>(){}.getType(), componentParams$iv)).shortValue();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public ShortArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new ShortArrayConverter(componentParams);
        }

        public ShortArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$ShortArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$ShortArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends ShortArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$IntArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class IntArrayConverter
    extends AbstractConverter<int[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public IntArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ IntArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public int[] convert(@NotNull Object value) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                int[] nArray2 = new int[n2];
                while (n < n2) {
                    int n3 = n++;
                    nArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                nArray = nArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                int[] nArray3 = new int[n4];
                while (n < n4) {
                    int n5 = n++;
                    nArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                nArray = nArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                int[] nArray4 = new int[n6];
                while (n < n6) {
                    int n7 = n++;
                    nArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                nArray = nArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                int[] nArray5 = new int[n8];
                while (n < n8) {
                    int n9 = n++;
                    nArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                nArray = nArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                int[] nArray6 = new int[n10];
                while (n < n10) {
                    int n11 = n++;
                    nArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                nArray = nArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                int[] nArray7 = new int[n12];
                while (n < n12) {
                    int n13 = n++;
                    nArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                nArray = nArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                int[] nArray8 = new int[n14];
                while (n < n14) {
                    int n15 = n++;
                    nArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                nArray = nArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                int[] nArray9 = new int[n16];
                while (n < n16) {
                    int n17 = n++;
                    nArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                nArray = nArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                int[] nArray10 = new int[n18];
                while (n < n18) {
                    int n19 = n++;
                    nArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                nArray = nArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                int[] nArray11 = new int[n20];
                while (n < n20) {
                    int n21 = n++;
                    nArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                nArray = nArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                int[] nArray12 = new int[n22];
                while (n < n22) {
                    int n23 = n++;
                    nArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                nArray = nArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                int[] nArray13 = new int[n24];
                while (n < n24) {
                    int n25 = n++;
                    nArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                nArray = nArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                int[] nArray14 = new int[n26];
                while (n < n26) {
                    int n27 = n++;
                    nArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                nArray = nArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                int[] nArray15 = new int[n28];
                while (n < n28) {
                    int n29 = n++;
                    nArray15[n29] = this.convertElement(v.get(n29));
                }
                nArray = nArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                int[] nArray16 = new int[n30];
                while (n < n30) {
                    int n31 = n++;
                    nArray16[n31] = this.convertElement(v.get(n31));
                }
                nArray = nArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                int[] nArray17 = new int[n32];
                while (n < n32) {
                    int n33 = n++;
                    nArray17[n33] = this.convertElement(v.get(n33));
                }
                nArray = nArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                int[] nArray18 = new int[n34];
                while (n < n34) {
                    int n35 = n++;
                    nArray18[n35] = this.convertElement(v.get(n35));
                }
                nArray = nArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                int[] nArray19 = new int[n36];
                while (n < n36) {
                    int n37 = n++;
                    nArray19[n37] = this.convertElement(v.get(n37));
                }
                nArray = nArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                int[] nArray20 = new int[n38];
                while (n < n38) {
                    int n39 = n++;
                    nArray20[n39] = this.convertElement(v.get(n39));
                }
                nArray = nArray20;
            } else {
                int[] nArray21 = new int[]{this.convertElement(value)};
                nArray = nArray21;
            }
            return nArray;
        }

        /*
         * WARNING - void declaration
         */
        private final int convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((Number)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Integer>(){}.getType(), componentParams$iv)).intValue();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public IntArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new IntArrayConverter(componentParams);
        }

        public IntArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$IntArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$IntArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends IntArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$LongArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class LongArrayConverter
    extends AbstractConverter<long[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public LongArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ LongArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public long[] convert(@NotNull Object value) {
            long[] lArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                long[] lArray2 = new long[n2];
                while (n < n2) {
                    int n3 = n++;
                    lArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                lArray = lArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                long[] lArray3 = new long[n4];
                while (n < n4) {
                    int n5 = n++;
                    lArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                lArray = lArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                long[] lArray4 = new long[n6];
                while (n < n6) {
                    int n7 = n++;
                    lArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                lArray = lArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                long[] lArray5 = new long[n8];
                while (n < n8) {
                    int n9 = n++;
                    lArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                lArray = lArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                long[] lArray6 = new long[n10];
                while (n < n10) {
                    int n11 = n++;
                    lArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                lArray = lArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                long[] lArray7 = new long[n12];
                while (n < n12) {
                    int n13 = n++;
                    lArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                lArray = lArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                long[] lArray8 = new long[n14];
                while (n < n14) {
                    int n15 = n++;
                    lArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                lArray = lArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                long[] lArray9 = new long[n16];
                while (n < n16) {
                    int n17 = n++;
                    lArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                lArray = lArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                long[] lArray10 = new long[n18];
                while (n < n18) {
                    int n19 = n++;
                    lArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                lArray = lArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                long[] lArray11 = new long[n20];
                while (n < n20) {
                    int n21 = n++;
                    lArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                lArray = lArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                long[] lArray12 = new long[n22];
                while (n < n22) {
                    int n23 = n++;
                    lArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                lArray = lArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                long[] lArray13 = new long[n24];
                while (n < n24) {
                    int n25 = n++;
                    lArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                lArray = lArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                long[] lArray14 = new long[n26];
                while (n < n26) {
                    int n27 = n++;
                    lArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                lArray = lArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                long[] lArray15 = new long[n28];
                while (n < n28) {
                    int n29 = n++;
                    lArray15[n29] = this.convertElement(v.get(n29));
                }
                lArray = lArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                long[] lArray16 = new long[n30];
                while (n < n30) {
                    int n31 = n++;
                    lArray16[n31] = this.convertElement(v.get(n31));
                }
                lArray = lArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                long[] lArray17 = new long[n32];
                while (n < n32) {
                    int n33 = n++;
                    lArray17[n33] = this.convertElement(v.get(n33));
                }
                lArray = lArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                long[] lArray18 = new long[n34];
                while (n < n34) {
                    int n35 = n++;
                    lArray18[n35] = this.convertElement(v.get(n35));
                }
                lArray = lArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                long[] lArray19 = new long[n36];
                while (n < n36) {
                    int n37 = n++;
                    lArray19[n37] = this.convertElement(v.get(n37));
                }
                lArray = lArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                long[] lArray20 = new long[n38];
                while (n < n38) {
                    int n39 = n++;
                    lArray20[n39] = this.convertElement(v.get(n39));
                }
                lArray = lArray20;
            } else {
                long[] lArray21 = new long[]{this.convertElement(value)};
                lArray = lArray21;
            }
            return lArray;
        }

        /*
         * WARNING - void declaration
         */
        private final long convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((Number)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Long>(){}.getType(), componentParams$iv)).longValue();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public LongArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new LongArrayConverter(componentParams);
        }

        public LongArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$LongArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$LongArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends LongArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$FloatArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class FloatArrayConverter
    extends AbstractConverter<float[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public FloatArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ FloatArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public float[] convert(@NotNull Object value) {
            float[] fArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                float[] fArray2 = new float[n2];
                while (n < n2) {
                    int n3 = n++;
                    fArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                fArray = fArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                float[] fArray3 = new float[n4];
                while (n < n4) {
                    int n5 = n++;
                    fArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                fArray = fArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                float[] fArray4 = new float[n6];
                while (n < n6) {
                    int n7 = n++;
                    fArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                fArray = fArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                float[] fArray5 = new float[n8];
                while (n < n8) {
                    int n9 = n++;
                    fArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                fArray = fArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                float[] fArray6 = new float[n10];
                while (n < n10) {
                    int n11 = n++;
                    fArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                fArray = fArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                float[] fArray7 = new float[n12];
                while (n < n12) {
                    int n13 = n++;
                    fArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                fArray = fArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                float[] fArray8 = new float[n14];
                while (n < n14) {
                    int n15 = n++;
                    fArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                fArray = fArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                float[] fArray9 = new float[n16];
                while (n < n16) {
                    int n17 = n++;
                    fArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                fArray = fArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                float[] fArray10 = new float[n18];
                while (n < n18) {
                    int n19 = n++;
                    fArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                fArray = fArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                float[] fArray11 = new float[n20];
                while (n < n20) {
                    int n21 = n++;
                    fArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                fArray = fArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                float[] fArray12 = new float[n22];
                while (n < n22) {
                    int n23 = n++;
                    fArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                fArray = fArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                float[] fArray13 = new float[n24];
                while (n < n24) {
                    int n25 = n++;
                    fArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                fArray = fArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                float[] fArray14 = new float[n26];
                while (n < n26) {
                    int n27 = n++;
                    fArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                fArray = fArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                float[] fArray15 = new float[n28];
                while (n < n28) {
                    int n29 = n++;
                    fArray15[n29] = this.convertElement(v.get(n29));
                }
                fArray = fArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                float[] fArray16 = new float[n30];
                while (n < n30) {
                    int n31 = n++;
                    fArray16[n31] = this.convertElement(v.get(n31));
                }
                fArray = fArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                float[] fArray17 = new float[n32];
                while (n < n32) {
                    int n33 = n++;
                    fArray17[n33] = this.convertElement(v.get(n33));
                }
                fArray = fArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                float[] fArray18 = new float[n34];
                while (n < n34) {
                    int n35 = n++;
                    fArray18[n35] = this.convertElement(v.get(n35));
                }
                fArray = fArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                float[] fArray19 = new float[n36];
                while (n < n36) {
                    int n37 = n++;
                    fArray19[n37] = this.convertElement(v.get(n37));
                }
                fArray = fArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                float[] fArray20 = new float[n38];
                while (n < n38) {
                    int n39 = n++;
                    fArray20[n39] = this.convertElement(v.get(n39));
                }
                fArray = fArray20;
            } else {
                float[] fArray21 = new float[]{this.convertElement(value)};
                fArray = fArray21;
            }
            return fArray;
        }

        /*
         * WARNING - void declaration
         */
        private final float convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((Number)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Float>(){}.getType(), componentParams$iv)).floatValue();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public FloatArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new FloatArrayConverter(componentParams);
        }

        public FloatArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$FloatArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$FloatArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends FloatArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$DoubleArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class DoubleArrayConverter
    extends AbstractConverter<double[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public DoubleArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ DoubleArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public double[] convert(@NotNull Object value) {
            double[] dArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                double[] dArray2 = new double[n2];
                while (n < n2) {
                    int n3 = n++;
                    dArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                dArray = dArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                double[] dArray3 = new double[n4];
                while (n < n4) {
                    int n5 = n++;
                    dArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                dArray = dArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                double[] dArray4 = new double[n6];
                while (n < n6) {
                    int n7 = n++;
                    dArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                dArray = dArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                double[] dArray5 = new double[n8];
                while (n < n8) {
                    int n9 = n++;
                    dArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                dArray = dArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                double[] dArray6 = new double[n10];
                while (n < n10) {
                    int n11 = n++;
                    dArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                dArray = dArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                double[] dArray7 = new double[n12];
                while (n < n12) {
                    int n13 = n++;
                    dArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                dArray = dArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                double[] dArray8 = new double[n14];
                while (n < n14) {
                    int n15 = n++;
                    dArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                dArray = dArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                double[] dArray9 = new double[n16];
                while (n < n16) {
                    int n17 = n++;
                    dArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                dArray = dArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                double[] dArray10 = new double[n18];
                while (n < n18) {
                    int n19 = n++;
                    dArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                dArray = dArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                double[] dArray11 = new double[n20];
                while (n < n20) {
                    int n21 = n++;
                    dArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                dArray = dArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                double[] dArray12 = new double[n22];
                while (n < n22) {
                    int n23 = n++;
                    dArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                dArray = dArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                double[] dArray13 = new double[n24];
                while (n < n24) {
                    int n25 = n++;
                    dArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                dArray = dArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                double[] dArray14 = new double[n26];
                while (n < n26) {
                    int n27 = n++;
                    dArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                dArray = dArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                double[] dArray15 = new double[n28];
                while (n < n28) {
                    int n29 = n++;
                    dArray15[n29] = this.convertElement(v.get(n29));
                }
                dArray = dArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                double[] dArray16 = new double[n30];
                while (n < n30) {
                    int n31 = n++;
                    dArray16[n31] = this.convertElement(v.get(n31));
                }
                dArray = dArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                double[] dArray17 = new double[n32];
                while (n < n32) {
                    int n33 = n++;
                    dArray17[n33] = this.convertElement(v.get(n33));
                }
                dArray = dArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                double[] dArray18 = new double[n34];
                while (n < n34) {
                    int n35 = n++;
                    dArray18[n35] = this.convertElement(v.get(n35));
                }
                dArray = dArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                double[] dArray19 = new double[n36];
                while (n < n36) {
                    int n37 = n++;
                    dArray19[n37] = this.convertElement(v.get(n37));
                }
                dArray = dArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                double[] dArray20 = new double[n38];
                while (n < n38) {
                    int n39 = n++;
                    dArray20[n39] = this.convertElement(v.get(n39));
                }
                dArray = dArray20;
            } else {
                double[] dArray21 = new double[]{this.convertElement(value)};
                dArray = dArray21;
            }
            return dArray;
        }

        /*
         * WARNING - void declaration
         */
        private final double convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((Number)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Double>(){}.getType(), componentParams$iv)).doubleValue();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public DoubleArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new DoubleArrayConverter(componentParams);
        }

        public DoubleArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$DoubleArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$DoubleArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends DoubleArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$BooleanArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class BooleanArrayConverter
    extends AbstractConverter<boolean[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public BooleanArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ BooleanArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public boolean[] convert(@NotNull Object value) {
            boolean[] blArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                boolean[] blArray2 = new boolean[n2];
                while (n < n2) {
                    int n3 = n++;
                    blArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                blArray = blArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                boolean[] blArray3 = new boolean[n4];
                while (n < n4) {
                    int n5 = n++;
                    blArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                blArray = blArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                boolean[] blArray4 = new boolean[n6];
                while (n < n6) {
                    int n7 = n++;
                    blArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                blArray = blArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                boolean[] blArray5 = new boolean[n8];
                while (n < n8) {
                    int n9 = n++;
                    blArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                blArray = blArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                boolean[] blArray6 = new boolean[n10];
                while (n < n10) {
                    int n11 = n++;
                    blArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                blArray = blArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                boolean[] blArray7 = new boolean[n12];
                while (n < n12) {
                    int n13 = n++;
                    blArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                blArray = blArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                boolean[] blArray8 = new boolean[n14];
                while (n < n14) {
                    int n15 = n++;
                    blArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                blArray = blArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                boolean[] blArray9 = new boolean[n16];
                while (n < n16) {
                    int n17 = n++;
                    blArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                blArray = blArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                boolean[] blArray10 = new boolean[n18];
                while (n < n18) {
                    int n19 = n++;
                    blArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                blArray = blArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                boolean[] blArray11 = new boolean[n20];
                while (n < n20) {
                    int n21 = n++;
                    blArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                blArray = blArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                boolean[] blArray12 = new boolean[n22];
                while (n < n22) {
                    int n23 = n++;
                    blArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                blArray = blArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                boolean[] blArray13 = new boolean[n24];
                while (n < n24) {
                    int n25 = n++;
                    blArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                blArray = blArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                boolean[] blArray14 = new boolean[n26];
                while (n < n26) {
                    int n27 = n++;
                    blArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                blArray = blArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                boolean[] blArray15 = new boolean[n28];
                while (n < n28) {
                    int n29 = n++;
                    blArray15[n29] = this.convertElement(v.get(n29));
                }
                blArray = blArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                boolean[] blArray16 = new boolean[n30];
                while (n < n30) {
                    int n31 = n++;
                    blArray16[n31] = this.convertElement(v.get(n31));
                }
                blArray = blArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                boolean[] blArray17 = new boolean[n32];
                while (n < n32) {
                    int n33 = n++;
                    blArray17[n33] = this.convertElement(v.get(n33));
                }
                blArray = blArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                boolean[] blArray18 = new boolean[n34];
                while (n < n34) {
                    int n35 = n++;
                    blArray18[n35] = this.convertElement(v.get(n35));
                }
                blArray = blArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                boolean[] blArray19 = new boolean[n36];
                while (n < n36) {
                    int n37 = n++;
                    blArray19[n37] = this.convertElement(v.get(n37));
                }
                blArray = blArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                boolean[] blArray20 = new boolean[n38];
                while (n < n38) {
                    int n39 = n++;
                    blArray20[n39] = this.convertElement(v.get(n39));
                }
                blArray = blArray20;
            } else {
                boolean[] blArray21 = new boolean[]{this.convertElement(value)};
                blArray = blArray21;
            }
            return blArray;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return (Boolean)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Boolean>(){}.getType(), componentParams$iv);
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public BooleanArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new BooleanArrayConverter(componentParams);
        }

        public BooleanArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$BooleanArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$BooleanArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends BooleanArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001b"}, d2={"Licu/windea/breezeframework/core/component/Converters$CharArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convertElement", "", "element", "splitValue", "", "Default", "breeze-core"})
    public static class CharArrayConverter
    extends AbstractConverter<char[]> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public CharArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ CharArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @Override
        @NotNull
        public char[] convert(@NotNull Object value) {
            char[] cArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = 0;
                int n2 = ((Object[])value).length;
                char[] cArray2 = new char[n2];
                while (n < n2) {
                    int n3 = n++;
                    cArray2[n3] = this.convertElement(((Object[])value)[n3]);
                }
                cArray = cArray2;
            } else if (value instanceof byte[]) {
                int n = 0;
                int n4 = ((byte[])value).length;
                char[] cArray3 = new char[n4];
                while (n < n4) {
                    int n5 = n++;
                    cArray3[n5] = this.convertElement(((byte[])value)[n5]);
                }
                cArray = cArray3;
            } else if (value instanceof short[]) {
                int n = 0;
                int n6 = ((short[])value).length;
                char[] cArray4 = new char[n6];
                while (n < n6) {
                    int n7 = n++;
                    cArray4[n7] = this.convertElement(((short[])value)[n7]);
                }
                cArray = cArray4;
            } else if (value instanceof int[]) {
                int n = 0;
                int n8 = ((int[])value).length;
                char[] cArray5 = new char[n8];
                while (n < n8) {
                    int n9 = n++;
                    cArray5[n9] = this.convertElement(((int[])value)[n9]);
                }
                cArray = cArray5;
            } else if (value instanceof long[]) {
                int n = 0;
                int n10 = ((long[])value).length;
                char[] cArray6 = new char[n10];
                while (n < n10) {
                    int n11 = n++;
                    cArray6[n11] = this.convertElement(((long[])value)[n11]);
                }
                cArray = cArray6;
            } else if (value instanceof float[]) {
                int n = 0;
                int n12 = ((float[])value).length;
                char[] cArray7 = new char[n12];
                while (n < n12) {
                    int n13 = n++;
                    cArray7[n13] = this.convertElement(Float.valueOf(((float[])value)[n13]));
                }
                cArray = cArray7;
            } else if (value instanceof double[]) {
                int n = 0;
                int n14 = ((double[])value).length;
                char[] cArray8 = new char[n14];
                while (n < n14) {
                    int n15 = n++;
                    cArray8[n15] = this.convertElement(((double[])value)[n15]);
                }
                cArray = cArray8;
            } else if (value instanceof boolean[]) {
                int n = 0;
                int n16 = ((boolean[])value).length;
                char[] cArray9 = new char[n16];
                while (n < n16) {
                    int n17 = n++;
                    cArray9[n17] = this.convertElement(((boolean[])value)[n17]);
                }
                cArray = cArray9;
            } else if (value instanceof char[]) {
                int n = 0;
                int n18 = ((char[])value).length;
                char[] cArray10 = new char[n18];
                while (n < n18) {
                    int n19 = n++;
                    cArray10[n19] = this.convertElement(Character.valueOf(((char[])value)[n19]));
                }
                cArray = cArray10;
            } else if (value instanceof UByteArray) {
                int n = 0;
                int n20 = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                char[] cArray11 = new char[n20];
                while (n < n20) {
                    int n21 = n++;
                    cArray11[n21] = this.convertElement(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)n21)));
                }
                cArray = cArray11;
            } else if (value instanceof UShortArray) {
                int n = 0;
                int n22 = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                char[] cArray12 = new char[n22];
                while (n < n22) {
                    int n23 = n++;
                    cArray12[n23] = this.convertElement(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)n23)));
                }
                cArray = cArray12;
            } else if (value instanceof UIntArray) {
                int n = 0;
                int n24 = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                char[] cArray13 = new char[n24];
                while (n < n24) {
                    int n25 = n++;
                    cArray13[n25] = this.convertElement(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)n25)));
                }
                cArray = cArray13;
            } else if (value instanceof ULongArray) {
                int n = 0;
                int n26 = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                char[] cArray14 = new char[n26];
                while (n < n26) {
                    int n27 = n++;
                    cArray14[n27] = this.convertElement(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)n27)));
                }
                cArray = cArray14;
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = 0;
                int n28 = v.size();
                char[] cArray15 = new char[n28];
                while (n < n28) {
                    int n29 = n++;
                    cArray15[n29] = this.convertElement(v.get(n29));
                }
                cArray = cArray15;
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = 0;
                int n30 = v.size();
                char[] cArray16 = new char[n30];
                while (n < n30) {
                    int n31 = n++;
                    cArray16[n31] = this.convertElement(v.get(n31));
                }
                cArray = cArray16;
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = 0;
                int n32 = v.size();
                char[] cArray17 = new char[n32];
                while (n < n32) {
                    int n33 = n++;
                    cArray17[n33] = this.convertElement(v.get(n33));
                }
                cArray = cArray17;
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = 0;
                int n34 = v.size();
                char[] cArray18 = new char[n34];
                while (n < n34) {
                    int n35 = n++;
                    cArray18[n35] = this.convertElement(v.get(n35));
                }
                cArray = cArray18;
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = 0;
                int n36 = v.size();
                char[] cArray19 = new char[n36];
                while (n < n36) {
                    int n37 = n++;
                    cArray19[n37] = this.convertElement(v.get(n37));
                }
                cArray = cArray19;
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = 0;
                int n38 = v.size();
                char[] cArray20 = new char[n38];
                while (n < n38) {
                    int n39 = n++;
                    cArray20[n39] = this.convertElement(v.get(n39));
                }
                cArray = cArray20;
            } else {
                char[] cArray21 = new char[]{this.convertElement(value)};
                cArray = cArray21;
            }
            return cArray;
        }

        /*
         * WARNING - void declaration
         */
        private final char convertElement(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((Character)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<Character>(){}.getType(), componentParams$iv)).charValue();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public CharArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new CharArrayConverter(componentParams);
        }

        public CharArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$CharArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$CharArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends CharArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J \u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"Licu/windea/breezeframework/core/component/Converters$UByteArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/UByteArray;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convert-NTtOWj4", "(Ljava/lang/Object;)[B", "convertElement", "Lkotlin/UByte;", "element", "convertElement-Wa3L5BU", "(Ljava/lang/Object;)B", "splitValue", "", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class UByteArrayConverter
    extends AbstractConverter<UByteArray> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public UByteArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ UByteArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public byte[] convert-NTtOWj4(@NotNull Object value) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = ((Object[])value).length;
                int n2 = 0;
                int n3 = n;
                byte[] byArray2 = new byte[n3];
                while (n2 < n3) {
                    void it;
                    byte by;
                    int n4;
                    int n5 = n4 = n2++;
                    int n6 = n4;
                    byte[] byArray3 = byArray2;
                    boolean bl = false;
                    byArray3[n6] = by = this.convertElement-Wa3L5BU(((Object[])value)[it]);
                }
                byArray = UByteArray.constructor-impl((byte[])byArray2);
            } else if (value instanceof byte[]) {
                int n = ((byte[])value).length;
                int n7 = 0;
                int n8 = n;
                byte[] byArray4 = new byte[n8];
                while (n7 < n8) {
                    byte by;
                    int n9;
                    int it = n9 = n7++;
                    int n10 = n9;
                    byte[] byArray5 = byArray4;
                    boolean bl = false;
                    byArray5[n10] = by = this.convertElement-Wa3L5BU(((byte[])value)[it]);
                }
                byArray = UByteArray.constructor-impl((byte[])byArray4);
            } else if (value instanceof short[]) {
                int n = ((short[])value).length;
                int n11 = 0;
                int n12 = n;
                byte[] byArray6 = new byte[n12];
                while (n11 < n12) {
                    byte by;
                    int n13;
                    int it = n13 = n11++;
                    int n14 = n13;
                    byte[] byArray7 = byArray6;
                    boolean bl = false;
                    byArray7[n14] = by = this.convertElement-Wa3L5BU(((short[])value)[it]);
                }
                byArray = UByteArray.constructor-impl((byte[])byArray6);
            } else if (value instanceof int[]) {
                int n = ((int[])value).length;
                int n15 = 0;
                int n16 = n;
                byte[] byArray8 = new byte[n16];
                while (n15 < n16) {
                    byte by;
                    int n17;
                    int it = n17 = n15++;
                    int n18 = n17;
                    byte[] byArray9 = byArray8;
                    boolean bl = false;
                    byArray9[n18] = by = this.convertElement-Wa3L5BU(((int[])value)[it]);
                }
                byArray = UByteArray.constructor-impl((byte[])byArray8);
            } else if (value instanceof long[]) {
                int n = ((long[])value).length;
                int n19 = 0;
                int n20 = n;
                byte[] byArray10 = new byte[n20];
                while (n19 < n20) {
                    byte by;
                    int n21;
                    int it = n21 = n19++;
                    int n22 = n21;
                    byte[] byArray11 = byArray10;
                    boolean bl = false;
                    byArray11[n22] = by = this.convertElement-Wa3L5BU(((long[])value)[it]);
                }
                byArray = UByteArray.constructor-impl((byte[])byArray10);
            } else if (value instanceof float[]) {
                int n = ((float[])value).length;
                int n23 = 0;
                int n24 = n;
                byte[] byArray12 = new byte[n24];
                while (n23 < n24) {
                    byte by;
                    int n25;
                    int it = n25 = n23++;
                    int n26 = n25;
                    byte[] byArray13 = byArray12;
                    boolean bl = false;
                    byArray13[n26] = by = this.convertElement-Wa3L5BU(Float.valueOf(((float[])value)[it]));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray12);
            } else if (value instanceof double[]) {
                int n = ((double[])value).length;
                int n27 = 0;
                int n28 = n;
                byte[] byArray14 = new byte[n28];
                while (n27 < n28) {
                    byte by;
                    int n29;
                    int it = n29 = n27++;
                    int n30 = n29;
                    byte[] byArray15 = byArray14;
                    boolean bl = false;
                    byArray15[n30] = by = this.convertElement-Wa3L5BU(((double[])value)[it]);
                }
                byArray = UByteArray.constructor-impl((byte[])byArray14);
            } else if (value instanceof boolean[]) {
                int n = ((boolean[])value).length;
                int n31 = 0;
                int n32 = n;
                byte[] byArray16 = new byte[n32];
                while (n31 < n32) {
                    byte by;
                    int n33;
                    int it = n33 = n31++;
                    int n34 = n33;
                    byte[] byArray17 = byArray16;
                    boolean bl = false;
                    byArray17[n34] = by = this.convertElement-Wa3L5BU(((boolean[])value)[it]);
                }
                byArray = UByteArray.constructor-impl((byte[])byArray16);
            } else if (value instanceof char[]) {
                int n = ((char[])value).length;
                int n35 = 0;
                int n36 = n;
                byte[] byArray18 = new byte[n36];
                while (n35 < n36) {
                    byte by;
                    int n37;
                    int it = n37 = n35++;
                    int n38 = n37;
                    byte[] byArray19 = byArray18;
                    boolean bl = false;
                    byArray19[n38] = by = this.convertElement-Wa3L5BU(Character.valueOf(((char[])value)[it]));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray18);
            } else if (value instanceof UByteArray) {
                int n = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                int n39 = 0;
                int n40 = n;
                byte[] byArray20 = new byte[n40];
                while (n39 < n40) {
                    byte by;
                    int n41;
                    int it = n41 = n39++;
                    int n42 = n41;
                    byte[] byArray21 = byArray20;
                    boolean bl = false;
                    byArray21[n42] = by = this.convertElement-Wa3L5BU(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)it)));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray20);
            } else if (value instanceof UShortArray) {
                int n = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                int n43 = 0;
                int n44 = n;
                byte[] byArray22 = new byte[n44];
                while (n43 < n44) {
                    byte by;
                    int n45;
                    int it = n45 = n43++;
                    int n46 = n45;
                    byte[] byArray23 = byArray22;
                    boolean bl = false;
                    byArray23[n46] = by = this.convertElement-Wa3L5BU(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)it)));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray22);
            } else if (value instanceof UIntArray) {
                int n = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                int n47 = 0;
                int n48 = n;
                byte[] byArray24 = new byte[n48];
                while (n47 < n48) {
                    byte by;
                    int n49;
                    int it = n49 = n47++;
                    int n50 = n49;
                    byte[] byArray25 = byArray24;
                    boolean bl = false;
                    byArray25[n50] = by = this.convertElement-Wa3L5BU(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)it)));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray24);
            } else if (value instanceof ULongArray) {
                int n = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                int n51 = 0;
                int n52 = n;
                byte[] byArray26 = new byte[n52];
                while (n51 < n52) {
                    byte by;
                    int n53;
                    int it = n53 = n51++;
                    int n54 = n53;
                    byte[] byArray27 = byArray26;
                    boolean bl = false;
                    byArray27[n54] = by = this.convertElement-Wa3L5BU(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)it)));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray26);
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = v.size();
                int n55 = 0;
                int n56 = n;
                byte[] byArray28 = new byte[n56];
                while (n55 < n56) {
                    void it;
                    byte by;
                    int n57;
                    int n58 = n57 = n55++;
                    int n59 = n57;
                    byte[] byArray29 = byArray28;
                    boolean bl2 = false;
                    byArray29[n59] = by = this.convertElement-Wa3L5BU(v.get((int)it));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray28);
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = v.size();
                int n60 = 0;
                int n61 = n;
                byte[] byArray30 = new byte[n61];
                while (n60 < n61) {
                    byte by;
                    int n62;
                    int it = n62 = n60++;
                    int n63 = n62;
                    byte[] byArray31 = byArray30;
                    boolean bl3 = false;
                    byArray31[n63] = by = this.convertElement-Wa3L5BU(v.get(it));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray30);
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = v.size();
                int n64 = 0;
                int n65 = n;
                byte[] byArray32 = new byte[n65];
                while (n64 < n65) {
                    byte by;
                    int n66;
                    int it = n66 = n64++;
                    int n67 = n66;
                    byte[] byArray33 = byArray32;
                    boolean bl4 = false;
                    byArray33[n67] = by = this.convertElement-Wa3L5BU(v.get(it));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray32);
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = v.size();
                int n68 = 0;
                int n69 = n;
                byte[] byArray34 = new byte[n69];
                while (n68 < n69) {
                    byte by;
                    int n70;
                    int it = n70 = n68++;
                    int n71 = n70;
                    byte[] byArray35 = byArray34;
                    boolean bl5 = false;
                    byArray35[n71] = by = this.convertElement-Wa3L5BU(v.get(it));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray34);
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = v.size();
                int n72 = 0;
                int n73 = n;
                byte[] byArray36 = new byte[n73];
                while (n72 < n73) {
                    byte by;
                    int n74;
                    int it = n74 = n72++;
                    int n75 = n74;
                    byte[] byArray37 = byArray36;
                    boolean bl6 = false;
                    byArray37[n75] = by = this.convertElement-Wa3L5BU(v.get(it));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray36);
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = v.size();
                int n76 = 0;
                int n77 = n;
                byte[] byArray38 = new byte[n77];
                while (n76 < n77) {
                    byte by;
                    int n78;
                    int it = n78 = n76++;
                    int n79 = n78;
                    byte[] byArray39 = byArray38;
                    boolean bl7 = false;
                    byArray39[n79] = by = this.convertElement-Wa3L5BU(v.get(it));
                }
                byArray = UByteArray.constructor-impl((byte[])byArray38);
            } else {
                byte[] byArray40 = new byte[]{this.convertElement-Wa3L5BU(value)};
                byArray = byArray40;
            }
            return byArray;
        }

        /*
         * WARNING - void declaration
         */
        private final byte convertElement-Wa3L5BU(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((UByte)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<UByte>(){}.getType(), componentParams$iv)).unbox-impl();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public UByteArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new UByteArrayConverter(componentParams);
        }

        public UByteArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$UByteArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$UByteArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends UByteArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J \u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"Licu/windea/breezeframework/core/component/Converters$UShortArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/UShortArray;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convert-m2bxwOc", "(Ljava/lang/Object;)[S", "convertElement", "Lkotlin/UShort;", "element", "convertElement-BwKQO78", "(Ljava/lang/Object;)S", "splitValue", "", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class UShortArrayConverter
    extends AbstractConverter<UShortArray> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public UShortArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ UShortArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public short[] convert-m2bxwOc(@NotNull Object value) {
            short[] sArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = ((Object[])value).length;
                int n2 = 0;
                int n3 = n;
                short[] sArray2 = new short[n3];
                while (n2 < n3) {
                    void it;
                    short s;
                    int n4;
                    int n5 = n4 = n2++;
                    int n6 = n4;
                    short[] sArray3 = sArray2;
                    boolean bl = false;
                    sArray3[n6] = s = this.convertElement-BwKQO78(((Object[])value)[it]);
                }
                sArray = UShortArray.constructor-impl((short[])sArray2);
            } else if (value instanceof byte[]) {
                int n = ((byte[])value).length;
                int n7 = 0;
                int n8 = n;
                short[] sArray4 = new short[n8];
                while (n7 < n8) {
                    short s;
                    int n9;
                    int it = n9 = n7++;
                    int n10 = n9;
                    short[] sArray5 = sArray4;
                    boolean bl = false;
                    sArray5[n10] = s = this.convertElement-BwKQO78(((byte[])value)[it]);
                }
                sArray = UShortArray.constructor-impl((short[])sArray4);
            } else if (value instanceof short[]) {
                int n = ((short[])value).length;
                int n11 = 0;
                int n12 = n;
                short[] sArray6 = new short[n12];
                while (n11 < n12) {
                    short s;
                    int n13;
                    int it = n13 = n11++;
                    int n14 = n13;
                    short[] sArray7 = sArray6;
                    boolean bl = false;
                    sArray7[n14] = s = this.convertElement-BwKQO78(((short[])value)[it]);
                }
                sArray = UShortArray.constructor-impl((short[])sArray6);
            } else if (value instanceof int[]) {
                int n = ((int[])value).length;
                int n15 = 0;
                int n16 = n;
                short[] sArray8 = new short[n16];
                while (n15 < n16) {
                    short s;
                    int n17;
                    int it = n17 = n15++;
                    int n18 = n17;
                    short[] sArray9 = sArray8;
                    boolean bl = false;
                    sArray9[n18] = s = this.convertElement-BwKQO78(((int[])value)[it]);
                }
                sArray = UShortArray.constructor-impl((short[])sArray8);
            } else if (value instanceof long[]) {
                int n = ((long[])value).length;
                int n19 = 0;
                int n20 = n;
                short[] sArray10 = new short[n20];
                while (n19 < n20) {
                    short s;
                    int n21;
                    int it = n21 = n19++;
                    int n22 = n21;
                    short[] sArray11 = sArray10;
                    boolean bl = false;
                    sArray11[n22] = s = this.convertElement-BwKQO78(((long[])value)[it]);
                }
                sArray = UShortArray.constructor-impl((short[])sArray10);
            } else if (value instanceof float[]) {
                int n = ((float[])value).length;
                int n23 = 0;
                int n24 = n;
                short[] sArray12 = new short[n24];
                while (n23 < n24) {
                    short s;
                    int n25;
                    int it = n25 = n23++;
                    int n26 = n25;
                    short[] sArray13 = sArray12;
                    boolean bl = false;
                    sArray13[n26] = s = this.convertElement-BwKQO78(Float.valueOf(((float[])value)[it]));
                }
                sArray = UShortArray.constructor-impl((short[])sArray12);
            } else if (value instanceof double[]) {
                int n = ((double[])value).length;
                int n27 = 0;
                int n28 = n;
                short[] sArray14 = new short[n28];
                while (n27 < n28) {
                    short s;
                    int n29;
                    int it = n29 = n27++;
                    int n30 = n29;
                    short[] sArray15 = sArray14;
                    boolean bl = false;
                    sArray15[n30] = s = this.convertElement-BwKQO78(((double[])value)[it]);
                }
                sArray = UShortArray.constructor-impl((short[])sArray14);
            } else if (value instanceof boolean[]) {
                int n = ((boolean[])value).length;
                int n31 = 0;
                int n32 = n;
                short[] sArray16 = new short[n32];
                while (n31 < n32) {
                    short s;
                    int n33;
                    int it = n33 = n31++;
                    int n34 = n33;
                    short[] sArray17 = sArray16;
                    boolean bl = false;
                    sArray17[n34] = s = this.convertElement-BwKQO78(((boolean[])value)[it]);
                }
                sArray = UShortArray.constructor-impl((short[])sArray16);
            } else if (value instanceof char[]) {
                int n = ((char[])value).length;
                int n35 = 0;
                int n36 = n;
                short[] sArray18 = new short[n36];
                while (n35 < n36) {
                    short s;
                    int n37;
                    int it = n37 = n35++;
                    int n38 = n37;
                    short[] sArray19 = sArray18;
                    boolean bl = false;
                    sArray19[n38] = s = this.convertElement-BwKQO78(Character.valueOf(((char[])value)[it]));
                }
                sArray = UShortArray.constructor-impl((short[])sArray18);
            } else if (value instanceof UByteArray) {
                int n = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                int n39 = 0;
                int n40 = n;
                short[] sArray20 = new short[n40];
                while (n39 < n40) {
                    short s;
                    int n41;
                    int it = n41 = n39++;
                    int n42 = n41;
                    short[] sArray21 = sArray20;
                    boolean bl = false;
                    sArray21[n42] = s = this.convertElement-BwKQO78(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)it)));
                }
                sArray = UShortArray.constructor-impl((short[])sArray20);
            } else if (value instanceof UShortArray) {
                int n = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                int n43 = 0;
                int n44 = n;
                short[] sArray22 = new short[n44];
                while (n43 < n44) {
                    short s;
                    int n45;
                    int it = n45 = n43++;
                    int n46 = n45;
                    short[] sArray23 = sArray22;
                    boolean bl = false;
                    sArray23[n46] = s = this.convertElement-BwKQO78(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)it)));
                }
                sArray = UShortArray.constructor-impl((short[])sArray22);
            } else if (value instanceof UIntArray) {
                int n = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                int n47 = 0;
                int n48 = n;
                short[] sArray24 = new short[n48];
                while (n47 < n48) {
                    short s;
                    int n49;
                    int it = n49 = n47++;
                    int n50 = n49;
                    short[] sArray25 = sArray24;
                    boolean bl = false;
                    sArray25[n50] = s = this.convertElement-BwKQO78(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)it)));
                }
                sArray = UShortArray.constructor-impl((short[])sArray24);
            } else if (value instanceof ULongArray) {
                int n = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                int n51 = 0;
                int n52 = n;
                short[] sArray26 = new short[n52];
                while (n51 < n52) {
                    short s;
                    int n53;
                    int it = n53 = n51++;
                    int n54 = n53;
                    short[] sArray27 = sArray26;
                    boolean bl = false;
                    sArray27[n54] = s = this.convertElement-BwKQO78(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)it)));
                }
                sArray = UShortArray.constructor-impl((short[])sArray26);
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = v.size();
                int n55 = 0;
                int n56 = n;
                short[] sArray28 = new short[n56];
                while (n55 < n56) {
                    void it;
                    short s;
                    int n57;
                    int n58 = n57 = n55++;
                    int n59 = n57;
                    short[] sArray29 = sArray28;
                    boolean bl2 = false;
                    sArray29[n59] = s = this.convertElement-BwKQO78(v.get((int)it));
                }
                sArray = UShortArray.constructor-impl((short[])sArray28);
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = v.size();
                int n60 = 0;
                int n61 = n;
                short[] sArray30 = new short[n61];
                while (n60 < n61) {
                    short s;
                    int n62;
                    int it = n62 = n60++;
                    int n63 = n62;
                    short[] sArray31 = sArray30;
                    boolean bl3 = false;
                    sArray31[n63] = s = this.convertElement-BwKQO78(v.get(it));
                }
                sArray = UShortArray.constructor-impl((short[])sArray30);
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = v.size();
                int n64 = 0;
                int n65 = n;
                short[] sArray32 = new short[n65];
                while (n64 < n65) {
                    short s;
                    int n66;
                    int it = n66 = n64++;
                    int n67 = n66;
                    short[] sArray33 = sArray32;
                    boolean bl4 = false;
                    sArray33[n67] = s = this.convertElement-BwKQO78(v.get(it));
                }
                sArray = UShortArray.constructor-impl((short[])sArray32);
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = v.size();
                int n68 = 0;
                int n69 = n;
                short[] sArray34 = new short[n69];
                while (n68 < n69) {
                    short s;
                    int n70;
                    int it = n70 = n68++;
                    int n71 = n70;
                    short[] sArray35 = sArray34;
                    boolean bl5 = false;
                    sArray35[n71] = s = this.convertElement-BwKQO78(v.get(it));
                }
                sArray = UShortArray.constructor-impl((short[])sArray34);
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = v.size();
                int n72 = 0;
                int n73 = n;
                short[] sArray36 = new short[n73];
                while (n72 < n73) {
                    short s;
                    int n74;
                    int it = n74 = n72++;
                    int n75 = n74;
                    short[] sArray37 = sArray36;
                    boolean bl6 = false;
                    sArray37[n75] = s = this.convertElement-BwKQO78(v.get(it));
                }
                sArray = UShortArray.constructor-impl((short[])sArray36);
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = v.size();
                int n76 = 0;
                int n77 = n;
                short[] sArray38 = new short[n77];
                while (n76 < n77) {
                    short s;
                    int n78;
                    int it = n78 = n76++;
                    int n79 = n78;
                    short[] sArray39 = sArray38;
                    boolean bl7 = false;
                    sArray39[n79] = s = this.convertElement-BwKQO78(v.get(it));
                }
                sArray = UShortArray.constructor-impl((short[])sArray38);
            } else {
                short[] sArray40 = new short[]{this.convertElement-BwKQO78(value)};
                sArray = sArray40;
            }
            return sArray;
        }

        /*
         * WARNING - void declaration
         */
        private final short convertElement-BwKQO78(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((UShort)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<UShort>(){}.getType(), componentParams$iv)).unbox-impl();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public UShortArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new UShortArrayConverter(componentParams);
        }

        public UShortArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$UShortArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$UShortArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends UShortArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J \u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"Licu/windea/breezeframework/core/component/Converters$UIntArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/UIntArray;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convert-g_c56RQ", "(Ljava/lang/Object;)[I", "convertElement", "Lkotlin/UInt;", "element", "convertElement-OGnWXxg", "(Ljava/lang/Object;)I", "splitValue", "", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class UIntArrayConverter
    extends AbstractConverter<UIntArray> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public UIntArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ UIntArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public int[] convert-g_c56RQ(@NotNull Object value) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = ((Object[])value).length;
                int n2 = 0;
                int n3 = n;
                int[] nArray2 = new int[n3];
                while (n2 < n3) {
                    void it;
                    int n4;
                    int n5;
                    int n6 = n5 = n2++;
                    int n7 = n5;
                    int[] nArray3 = nArray2;
                    boolean bl = false;
                    nArray3[n7] = n4 = this.convertElement-OGnWXxg(((Object[])value)[it]);
                }
                nArray = UIntArray.constructor-impl((int[])nArray2);
            } else if (value instanceof byte[]) {
                int n = ((byte[])value).length;
                int n8 = 0;
                int n9 = n;
                int[] nArray4 = new int[n9];
                while (n8 < n9) {
                    int n10;
                    int n11;
                    int it = n11 = n8++;
                    int n12 = n11;
                    int[] nArray5 = nArray4;
                    boolean bl = false;
                    nArray5[n12] = n10 = this.convertElement-OGnWXxg(((byte[])value)[it]);
                }
                nArray = UIntArray.constructor-impl((int[])nArray4);
            } else if (value instanceof short[]) {
                int n = ((short[])value).length;
                int n13 = 0;
                int n14 = n;
                int[] nArray6 = new int[n14];
                while (n13 < n14) {
                    int n15;
                    int n16;
                    int it = n16 = n13++;
                    int n17 = n16;
                    int[] nArray7 = nArray6;
                    boolean bl = false;
                    nArray7[n17] = n15 = this.convertElement-OGnWXxg(((short[])value)[it]);
                }
                nArray = UIntArray.constructor-impl((int[])nArray6);
            } else if (value instanceof int[]) {
                int n = ((int[])value).length;
                int n18 = 0;
                int n19 = n;
                int[] nArray8 = new int[n19];
                while (n18 < n19) {
                    int n20;
                    int n21;
                    int it = n21 = n18++;
                    int n22 = n21;
                    int[] nArray9 = nArray8;
                    boolean bl = false;
                    nArray9[n22] = n20 = this.convertElement-OGnWXxg(((int[])value)[it]);
                }
                nArray = UIntArray.constructor-impl((int[])nArray8);
            } else if (value instanceof long[]) {
                int n = ((long[])value).length;
                int n23 = 0;
                int n24 = n;
                int[] nArray10 = new int[n24];
                while (n23 < n24) {
                    int n25;
                    int n26;
                    int it = n26 = n23++;
                    int n27 = n26;
                    int[] nArray11 = nArray10;
                    boolean bl = false;
                    nArray11[n27] = n25 = this.convertElement-OGnWXxg(((long[])value)[it]);
                }
                nArray = UIntArray.constructor-impl((int[])nArray10);
            } else if (value instanceof float[]) {
                int n = ((float[])value).length;
                int n28 = 0;
                int n29 = n;
                int[] nArray12 = new int[n29];
                while (n28 < n29) {
                    int n30;
                    int n31;
                    int it = n31 = n28++;
                    int n32 = n31;
                    int[] nArray13 = nArray12;
                    boolean bl = false;
                    nArray13[n32] = n30 = this.convertElement-OGnWXxg(Float.valueOf(((float[])value)[it]));
                }
                nArray = UIntArray.constructor-impl((int[])nArray12);
            } else if (value instanceof double[]) {
                int n = ((double[])value).length;
                int n33 = 0;
                int n34 = n;
                int[] nArray14 = new int[n34];
                while (n33 < n34) {
                    int n35;
                    int n36;
                    int it = n36 = n33++;
                    int n37 = n36;
                    int[] nArray15 = nArray14;
                    boolean bl = false;
                    nArray15[n37] = n35 = this.convertElement-OGnWXxg(((double[])value)[it]);
                }
                nArray = UIntArray.constructor-impl((int[])nArray14);
            } else if (value instanceof boolean[]) {
                int n = ((boolean[])value).length;
                int n38 = 0;
                int n39 = n;
                int[] nArray16 = new int[n39];
                while (n38 < n39) {
                    int n40;
                    int n41;
                    int it = n41 = n38++;
                    int n42 = n41;
                    int[] nArray17 = nArray16;
                    boolean bl = false;
                    nArray17[n42] = n40 = this.convertElement-OGnWXxg(((boolean[])value)[it]);
                }
                nArray = UIntArray.constructor-impl((int[])nArray16);
            } else if (value instanceof char[]) {
                int n = ((char[])value).length;
                int n43 = 0;
                int n44 = n;
                int[] nArray18 = new int[n44];
                while (n43 < n44) {
                    int n45;
                    int n46;
                    int it = n46 = n43++;
                    int n47 = n46;
                    int[] nArray19 = nArray18;
                    boolean bl = false;
                    nArray19[n47] = n45 = this.convertElement-OGnWXxg(Character.valueOf(((char[])value)[it]));
                }
                nArray = UIntArray.constructor-impl((int[])nArray18);
            } else if (value instanceof UByteArray) {
                int n = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                int n48 = 0;
                int n49 = n;
                int[] nArray20 = new int[n49];
                while (n48 < n49) {
                    int n50;
                    int n51;
                    int it = n51 = n48++;
                    int n52 = n51;
                    int[] nArray21 = nArray20;
                    boolean bl = false;
                    nArray21[n52] = n50 = this.convertElement-OGnWXxg(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)it)));
                }
                nArray = UIntArray.constructor-impl((int[])nArray20);
            } else if (value instanceof UShortArray) {
                int n = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                int n53 = 0;
                int n54 = n;
                int[] nArray22 = new int[n54];
                while (n53 < n54) {
                    int n55;
                    int n56;
                    int it = n56 = n53++;
                    int n57 = n56;
                    int[] nArray23 = nArray22;
                    boolean bl = false;
                    nArray23[n57] = n55 = this.convertElement-OGnWXxg(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)it)));
                }
                nArray = UIntArray.constructor-impl((int[])nArray22);
            } else if (value instanceof UIntArray) {
                int n = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                int n58 = 0;
                int n59 = n;
                int[] nArray24 = new int[n59];
                while (n58 < n59) {
                    int n60;
                    int n61;
                    int it = n61 = n58++;
                    int n62 = n61;
                    int[] nArray25 = nArray24;
                    boolean bl = false;
                    nArray25[n62] = n60 = this.convertElement-OGnWXxg(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)it)));
                }
                nArray = UIntArray.constructor-impl((int[])nArray24);
            } else if (value instanceof ULongArray) {
                int n = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                int n63 = 0;
                int n64 = n;
                int[] nArray26 = new int[n64];
                while (n63 < n64) {
                    int n65;
                    int n66;
                    int it = n66 = n63++;
                    int n67 = n66;
                    int[] nArray27 = nArray26;
                    boolean bl = false;
                    nArray27[n67] = n65 = this.convertElement-OGnWXxg(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)it)));
                }
                nArray = UIntArray.constructor-impl((int[])nArray26);
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = v.size();
                int n68 = 0;
                int n69 = n;
                int[] nArray28 = new int[n69];
                while (n68 < n69) {
                    void it;
                    int n70;
                    int n71;
                    int n72 = n71 = n68++;
                    int n73 = n71;
                    int[] nArray29 = nArray28;
                    boolean bl2 = false;
                    nArray29[n73] = n70 = this.convertElement-OGnWXxg(v.get((int)it));
                }
                nArray = UIntArray.constructor-impl((int[])nArray28);
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = v.size();
                int n74 = 0;
                int n75 = n;
                int[] nArray30 = new int[n75];
                while (n74 < n75) {
                    int n76;
                    int n77;
                    int it = n77 = n74++;
                    int n78 = n77;
                    int[] nArray31 = nArray30;
                    boolean bl3 = false;
                    nArray31[n78] = n76 = this.convertElement-OGnWXxg(v.get(it));
                }
                nArray = UIntArray.constructor-impl((int[])nArray30);
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = v.size();
                int n79 = 0;
                int n80 = n;
                int[] nArray32 = new int[n80];
                while (n79 < n80) {
                    int n81;
                    int n82;
                    int it = n82 = n79++;
                    int n83 = n82;
                    int[] nArray33 = nArray32;
                    boolean bl4 = false;
                    nArray33[n83] = n81 = this.convertElement-OGnWXxg(v.get(it));
                }
                nArray = UIntArray.constructor-impl((int[])nArray32);
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = v.size();
                int n84 = 0;
                int n85 = n;
                int[] nArray34 = new int[n85];
                while (n84 < n85) {
                    int n86;
                    int n87;
                    int it = n87 = n84++;
                    int n88 = n87;
                    int[] nArray35 = nArray34;
                    boolean bl5 = false;
                    nArray35[n88] = n86 = this.convertElement-OGnWXxg(v.get(it));
                }
                nArray = UIntArray.constructor-impl((int[])nArray34);
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = v.size();
                int n89 = 0;
                int n90 = n;
                int[] nArray36 = new int[n90];
                while (n89 < n90) {
                    int n91;
                    int n92;
                    int it = n92 = n89++;
                    int n93 = n92;
                    int[] nArray37 = nArray36;
                    boolean bl6 = false;
                    nArray37[n93] = n91 = this.convertElement-OGnWXxg(v.get(it));
                }
                nArray = UIntArray.constructor-impl((int[])nArray36);
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = v.size();
                int n94 = 0;
                int n95 = n;
                int[] nArray38 = new int[n95];
                while (n94 < n95) {
                    int n96;
                    int n97;
                    int it = n97 = n94++;
                    int n98 = n97;
                    int[] nArray39 = nArray38;
                    boolean bl7 = false;
                    nArray39[n98] = n96 = this.convertElement-OGnWXxg(v.get(it));
                }
                nArray = UIntArray.constructor-impl((int[])nArray38);
            } else {
                int[] nArray40 = new int[]{this.convertElement-OGnWXxg(value)};
                nArray = nArray40;
            }
            return nArray;
        }

        /*
         * WARNING - void declaration
         */
        private final int convertElement-OGnWXxg(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((UInt)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<UInt>(){}.getType(), componentParams$iv)).unbox-impl();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public UIntArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new UIntArrayConverter(componentParams);
        }

        public UIntArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$UIntArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$UIntArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends UIntArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J \u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001f"}, d2={"Licu/windea/breezeframework/core/component/Converters$ULongArrayConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/ULongArray;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "convert-DHQ6RzY", "(Ljava/lang/Object;)[J", "convertElement", "Lkotlin/ULong;", "element", "convertElement-I7RO_PI", "(Ljava/lang/Object;)J", "splitValue", "", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class ULongArrayConverter
    extends AbstractConverter<ULongArray> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public ULongArrayConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ ULongArrayConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public long[] convert-DHQ6RzY(@NotNull Object value) {
            long[] lArray;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof Object[]) {
                int n = ((Object[])value).length;
                int n2 = 0;
                int n3 = n;
                long[] lArray2 = new long[n3];
                while (n2 < n3) {
                    void it;
                    long l;
                    int n4;
                    int n5 = n4 = n2++;
                    int n6 = n4;
                    long[] lArray3 = lArray2;
                    boolean bl = false;
                    lArray3[n6] = l = this.convertElement-I7RO_PI(((Object[])value)[it]);
                }
                lArray = ULongArray.constructor-impl((long[])lArray2);
            } else if (value instanceof byte[]) {
                int n = ((byte[])value).length;
                int n7 = 0;
                int n8 = n;
                long[] lArray4 = new long[n8];
                while (n7 < n8) {
                    long l;
                    int n9;
                    int it = n9 = n7++;
                    int n10 = n9;
                    long[] lArray5 = lArray4;
                    boolean bl = false;
                    lArray5[n10] = l = this.convertElement-I7RO_PI(((byte[])value)[it]);
                }
                lArray = ULongArray.constructor-impl((long[])lArray4);
            } else if (value instanceof short[]) {
                int n = ((short[])value).length;
                int n11 = 0;
                int n12 = n;
                long[] lArray6 = new long[n12];
                while (n11 < n12) {
                    long l;
                    int n13;
                    int it = n13 = n11++;
                    int n14 = n13;
                    long[] lArray7 = lArray6;
                    boolean bl = false;
                    lArray7[n14] = l = this.convertElement-I7RO_PI(((short[])value)[it]);
                }
                lArray = ULongArray.constructor-impl((long[])lArray6);
            } else if (value instanceof int[]) {
                int n = ((int[])value).length;
                int n15 = 0;
                int n16 = n;
                long[] lArray8 = new long[n16];
                while (n15 < n16) {
                    long l;
                    int n17;
                    int it = n17 = n15++;
                    int n18 = n17;
                    long[] lArray9 = lArray8;
                    boolean bl = false;
                    lArray9[n18] = l = this.convertElement-I7RO_PI(((int[])value)[it]);
                }
                lArray = ULongArray.constructor-impl((long[])lArray8);
            } else if (value instanceof long[]) {
                int n = ((long[])value).length;
                int n19 = 0;
                int n20 = n;
                long[] lArray10 = new long[n20];
                while (n19 < n20) {
                    long l;
                    int n21;
                    int it = n21 = n19++;
                    int n22 = n21;
                    long[] lArray11 = lArray10;
                    boolean bl = false;
                    lArray11[n22] = l = this.convertElement-I7RO_PI(((long[])value)[it]);
                }
                lArray = ULongArray.constructor-impl((long[])lArray10);
            } else if (value instanceof float[]) {
                int n = ((float[])value).length;
                int n23 = 0;
                int n24 = n;
                long[] lArray12 = new long[n24];
                while (n23 < n24) {
                    long l;
                    int n25;
                    int it = n25 = n23++;
                    int n26 = n25;
                    long[] lArray13 = lArray12;
                    boolean bl = false;
                    lArray13[n26] = l = this.convertElement-I7RO_PI(Float.valueOf(((float[])value)[it]));
                }
                lArray = ULongArray.constructor-impl((long[])lArray12);
            } else if (value instanceof double[]) {
                int n = ((double[])value).length;
                int n27 = 0;
                int n28 = n;
                long[] lArray14 = new long[n28];
                while (n27 < n28) {
                    long l;
                    int n29;
                    int it = n29 = n27++;
                    int n30 = n29;
                    long[] lArray15 = lArray14;
                    boolean bl = false;
                    lArray15[n30] = l = this.convertElement-I7RO_PI(((double[])value)[it]);
                }
                lArray = ULongArray.constructor-impl((long[])lArray14);
            } else if (value instanceof boolean[]) {
                int n = ((boolean[])value).length;
                int n31 = 0;
                int n32 = n;
                long[] lArray16 = new long[n32];
                while (n31 < n32) {
                    long l;
                    int n33;
                    int it = n33 = n31++;
                    int n34 = n33;
                    long[] lArray17 = lArray16;
                    boolean bl = false;
                    lArray17[n34] = l = this.convertElement-I7RO_PI(((boolean[])value)[it]);
                }
                lArray = ULongArray.constructor-impl((long[])lArray16);
            } else if (value instanceof char[]) {
                int n = ((char[])value).length;
                int n35 = 0;
                int n36 = n;
                long[] lArray18 = new long[n36];
                while (n35 < n36) {
                    long l;
                    int n37;
                    int it = n37 = n35++;
                    int n38 = n37;
                    long[] lArray19 = lArray18;
                    boolean bl = false;
                    lArray19[n38] = l = this.convertElement-I7RO_PI(Character.valueOf(((char[])value)[it]));
                }
                lArray = ULongArray.constructor-impl((long[])lArray18);
            } else if (value instanceof UByteArray) {
                int n = UByteArray.getSize-impl((byte[])((UByteArray)value).unbox-impl());
                int n39 = 0;
                int n40 = n;
                long[] lArray20 = new long[n40];
                while (n39 < n40) {
                    long l;
                    int n41;
                    int it = n41 = n39++;
                    int n42 = n41;
                    long[] lArray21 = lArray20;
                    boolean bl = false;
                    lArray21[n42] = l = this.convertElement-I7RO_PI(UByte.box-impl((byte)UByteArray.get-w2LRezQ((byte[])((UByteArray)value).unbox-impl(), (int)it)));
                }
                lArray = ULongArray.constructor-impl((long[])lArray20);
            } else if (value instanceof UShortArray) {
                int n = UShortArray.getSize-impl((short[])((UShortArray)value).unbox-impl());
                int n43 = 0;
                int n44 = n;
                long[] lArray22 = new long[n44];
                while (n43 < n44) {
                    long l;
                    int n45;
                    int it = n45 = n43++;
                    int n46 = n45;
                    long[] lArray23 = lArray22;
                    boolean bl = false;
                    lArray23[n46] = l = this.convertElement-I7RO_PI(UShort.box-impl((short)UShortArray.get-Mh2AYeg((short[])((UShortArray)value).unbox-impl(), (int)it)));
                }
                lArray = ULongArray.constructor-impl((long[])lArray22);
            } else if (value instanceof UIntArray) {
                int n = UIntArray.getSize-impl((int[])((UIntArray)value).unbox-impl());
                int n47 = 0;
                int n48 = n;
                long[] lArray24 = new long[n48];
                while (n47 < n48) {
                    long l;
                    int n49;
                    int it = n49 = n47++;
                    int n50 = n49;
                    long[] lArray25 = lArray24;
                    boolean bl = false;
                    lArray25[n50] = l = this.convertElement-I7RO_PI(UInt.box-impl((int)UIntArray.get-pVg5ArA((int[])((UIntArray)value).unbox-impl(), (int)it)));
                }
                lArray = ULongArray.constructor-impl((long[])lArray24);
            } else if (value instanceof ULongArray) {
                int n = ULongArray.getSize-impl((long[])((ULongArray)value).unbox-impl());
                int n51 = 0;
                int n52 = n;
                long[] lArray26 = new long[n52];
                while (n51 < n52) {
                    long l;
                    int n53;
                    int it = n53 = n51++;
                    int n54 = n53;
                    long[] lArray27 = lArray26;
                    boolean bl = false;
                    lArray27[n54] = l = this.convertElement-I7RO_PI(ULong.box-impl((long)ULongArray.get-s-VKNKU((long[])((ULongArray)value).unbox-impl(), (int)it)));
                }
                lArray = ULongArray.constructor-impl((long[])lArray26);
            } else if (value instanceof Iterator) {
                List v = CollectionsKt.toList((Iterable)new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                });
                boolean bl = false;
                int n = v.size();
                int n55 = 0;
                int n56 = n;
                long[] lArray28 = new long[n56];
                while (n55 < n56) {
                    void it;
                    long l;
                    int n57;
                    int n58 = n57 = n55++;
                    int n59 = n57;
                    long[] lArray29 = lArray28;
                    boolean bl2 = false;
                    lArray29[n59] = l = this.convertElement-I7RO_PI(v.get((int)it));
                }
                lArray = ULongArray.constructor-impl((long[])lArray28);
            } else if (value instanceof Iterable) {
                List v = CollectionsKt.toList((Iterable)((Iterable)value));
                boolean bl = false;
                int n = v.size();
                int n60 = 0;
                int n61 = n;
                long[] lArray30 = new long[n61];
                while (n60 < n61) {
                    long l;
                    int n62;
                    int it = n62 = n60++;
                    int n63 = n62;
                    long[] lArray31 = lArray30;
                    boolean bl3 = false;
                    lArray31[n63] = l = this.convertElement-I7RO_PI(v.get(it));
                }
                lArray = ULongArray.constructor-impl((long[])lArray30);
            } else if (value instanceof Sequence) {
                List v = SequencesKt.toList((Sequence)((Sequence)value));
                boolean bl = false;
                int n = v.size();
                int n64 = 0;
                int n65 = n;
                long[] lArray32 = new long[n65];
                while (n64 < n65) {
                    long l;
                    int n66;
                    int it = n66 = n64++;
                    int n67 = n66;
                    long[] lArray33 = lArray32;
                    boolean bl4 = false;
                    lArray33[n67] = l = this.convertElement-I7RO_PI(v.get(it));
                }
                lArray = ULongArray.constructor-impl((long[])lArray32);
            } else if (value instanceof Stream) {
                List v = StreamExtensions.toList((Stream)value);
                boolean bl = false;
                int n = v.size();
                int n68 = 0;
                int n69 = n;
                long[] lArray34 = new long[n69];
                while (n68 < n69) {
                    long l;
                    int n70;
                    int it = n70 = n68++;
                    int n71 = n70;
                    long[] lArray35 = lArray34;
                    boolean bl5 = false;
                    lArray35[n71] = l = this.convertElement-I7RO_PI(v.get(it));
                }
                lArray = ULongArray.constructor-impl((long[])lArray34);
            } else if (value instanceof String) {
                List<String> v = this.splitValue((String)value);
                boolean bl = false;
                int n = v.size();
                int n72 = 0;
                int n73 = n;
                long[] lArray36 = new long[n73];
                while (n72 < n73) {
                    long l;
                    int n74;
                    int it = n74 = n72++;
                    int n75 = n74;
                    long[] lArray37 = lArray36;
                    boolean bl6 = false;
                    lArray37[n75] = l = this.convertElement-I7RO_PI(v.get(it));
                }
                lArray = ULongArray.constructor-impl((long[])lArray36);
            } else if (value instanceof CharSequence) {
                List<String> v = this.splitValue(value.toString());
                boolean bl = false;
                int n = v.size();
                int n76 = 0;
                int n77 = n;
                long[] lArray38 = new long[n77];
                while (n76 < n77) {
                    long l;
                    int n78;
                    int it = n78 = n76++;
                    int n79 = n78;
                    long[] lArray39 = lArray38;
                    boolean bl7 = false;
                    lArray39[n79] = l = this.convertElement-I7RO_PI(v.get(it));
                }
                lArray = ULongArray.constructor-impl((long[])lArray38);
            } else {
                long[] lArray40 = new long[]{this.convertElement-I7RO_PI(value)};
                lArray = lArray40;
            }
            return lArray;
        }

        /*
         * WARNING - void declaration
         */
        private final long convertElement-I7RO_PI(Object element) {
            void $this$convert$iv;
            Object object = element;
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            return ((ULong)this_$iv$iv.convert((Object)$this$convert$iv, new TypeReference<ULong>(){}.getType(), componentParams$iv)).unbox-impl();
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public ULongArrayConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new ULongArrayConverter(componentParams);
        }

        public ULongArrayConverter() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$ULongArrayConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$ULongArrayConverter;", "()V", "breeze-core"})
        public static final class Default
        extends ULongArrayConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u0018B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Licu/windea/breezeframework/core/component/Converters$IteratorConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "iterableConverter", "Licu/windea/breezeframework/core/component/Converters$MutableIterableConverter;", "getIterableConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableIterableConverter;", "iterableConverter$delegate", "Lkotlin/Lazy;", "passingParams", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class IteratorConverter
    extends AbstractConverter<Iterator<?>>
    implements GenericConverter<Iterator<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy iterableConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;

        public IteratorConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.iterableConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableIterableConverter>(this){
                final /* synthetic */ IteratorConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableIterableConverter invoke() {
                    return (MutableIterableConverter)Converters.INSTANCE.get(Iterable.class, IteratorConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableIterableConverter>(this.this$0){
                        final /* synthetic */ IteratorConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableIterableConverter invoke() {
                            return new MutableIterableConverter(IteratorConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.passingParams = this.componentParams;
        }

        public /* synthetic */ IteratorConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final MutableIterableConverter getIterableConverter() {
            Lazy lazy = this.iterableConverter$delegate;
            return (MutableIterableConverter)lazy.getValue();
        }

        @Override
        @NotNull
        public Iterator<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return this.getIterableConverter().convert(value, targetType).iterator();
        }

        @Override
        @Nullable
        public Iterator<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Object object = this.getIterableConverter().convertOrNull(value, targetType);
            return object == null ? null : object.iterator();
        }

        @Override
        @NotNull
        public IteratorConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new IteratorConverter(componentParams);
        }

        @Override
        @NotNull
        public Iterator<?> convert(@NotNull Object value) {
            return (Iterator)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Iterator<?> convertOrNull(@NotNull Object value) {
            return (Iterator)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public IteratorConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(IteratorConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$IteratorConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$IteratorConverter;", "()V", "breeze-core"})
        public static final class Default
        extends IteratorConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u0018B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableIteratorConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "mutableIterableConverter", "Licu/windea/breezeframework/core/component/Converters$MutableIterableConverter;", "getMutableIterableConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableIterableConverter;", "mutableIterableConverter$delegate", "Lkotlin/Lazy;", "passingParams", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class MutableIteratorConverter
    extends AbstractConverter<Iterator<?>>
    implements GenericConverter<Iterator<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy mutableIterableConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;

        public MutableIteratorConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.mutableIterableConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableIterableConverter>(this){
                final /* synthetic */ MutableIteratorConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableIterableConverter invoke() {
                    return (MutableIterableConverter)Converters.INSTANCE.get(Iterable.class, MutableIteratorConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableIterableConverter>(this.this$0){
                        final /* synthetic */ MutableIteratorConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableIterableConverter invoke() {
                            return new MutableIterableConverter(MutableIteratorConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.passingParams = this.componentParams;
        }

        public /* synthetic */ MutableIteratorConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final MutableIterableConverter getMutableIterableConverter() {
            Lazy lazy = this.mutableIterableConverter$delegate;
            return (MutableIterableConverter)lazy.getValue();
        }

        @Override
        @NotNull
        public Iterator<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return this.getMutableIterableConverter().convert(value, targetType).iterator();
        }

        @Override
        @Nullable
        public Iterator<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Object object = this.getMutableIterableConverter().convertOrNull(value, targetType);
            return object == null ? null : object.iterator();
        }

        @Override
        @NotNull
        public MutableIteratorConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new MutableIteratorConverter(componentParams);
        }

        @Override
        @NotNull
        public Iterator<?> convert(@NotNull Object value) {
            return (Iterator)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Iterator<?> convertOrNull(@NotNull Object value) {
            return (Iterator)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public MutableIteratorConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(MutableIteratorConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableIteratorConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$MutableIteratorConverter;", "()V", "breeze-core"})
        public static final class Default
        extends MutableIteratorConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u0018B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Licu/windea/breezeframework/core/component/Converters$IterableConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "collectionConverter", "Licu/windea/breezeframework/core/component/Converters$MutableCollectionConverter;", "getCollectionConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableCollectionConverter;", "collectionConverter$delegate", "Lkotlin/Lazy;", "getComponentParams", "()Ljava/util/Map;", "passingParams", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class IterableConverter
    extends AbstractConverter<Iterable<?>>
    implements GenericConverter<Iterable<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy collectionConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;

        public IterableConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.collectionConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableCollectionConverter>(this){
                final /* synthetic */ IterableConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableCollectionConverter invoke() {
                    return (MutableCollectionConverter)Converters.INSTANCE.get(Collection.class, IterableConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableCollectionConverter>(this.this$0){
                        final /* synthetic */ IterableConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableCollectionConverter invoke() {
                            return new MutableCollectionConverter(IterableConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.passingParams = this.componentParams;
        }

        public /* synthetic */ IterableConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final MutableCollectionConverter getCollectionConverter() {
            Lazy lazy = this.collectionConverter$delegate;
            return (MutableCollectionConverter)lazy.getValue();
        }

        @Override
        @NotNull
        public Iterable<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return (Iterable)this.getCollectionConverter().convert(value, targetType);
        }

        @Override
        @Nullable
        public Iterable<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return (Iterable)this.getCollectionConverter().convertOrNull(value, targetType);
        }

        @Override
        @NotNull
        public IterableConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new IterableConverter(componentParams);
        }

        @Override
        @NotNull
        public Iterable<?> convert(@NotNull Object value) {
            return (Iterable)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Iterable<?> convertOrNull(@NotNull Object value) {
            return (Iterable)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public IterableConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(IterableConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$IterableConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$IterableConverter;", "()V", "breeze-core"})
        public static final class Default
        extends IterableConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u0018B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableIterableConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "mutableCollectionConverter", "Licu/windea/breezeframework/core/component/Converters$MutableCollectionConverter;", "getMutableCollectionConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableCollectionConverter;", "mutableCollectionConverter$delegate", "Lkotlin/Lazy;", "passingParams", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class MutableIterableConverter
    extends AbstractConverter<Iterable<?>>
    implements GenericConverter<Iterable<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy mutableCollectionConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;

        public MutableIterableConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.mutableCollectionConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableCollectionConverter>(this){
                final /* synthetic */ MutableIterableConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableCollectionConverter invoke() {
                    return (MutableCollectionConverter)Converters.INSTANCE.get(Collection.class, MutableIterableConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableCollectionConverter>(this.this$0){
                        final /* synthetic */ MutableIterableConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableCollectionConverter invoke() {
                            return new MutableCollectionConverter(MutableIterableConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.passingParams = this.componentParams;
        }

        public /* synthetic */ MutableIterableConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final MutableCollectionConverter getMutableCollectionConverter() {
            Lazy lazy = this.mutableCollectionConverter$delegate;
            return (MutableCollectionConverter)lazy.getValue();
        }

        @Override
        @NotNull
        public Iterable<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return (Iterable)this.getMutableCollectionConverter().convert(value, targetType);
        }

        @Override
        @Nullable
        public Iterable<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return (Iterable)this.getMutableCollectionConverter().convertOrNull(value, targetType);
        }

        @Override
        @NotNull
        public MutableIterableConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new MutableIterableConverter(componentParams);
        }

        @Override
        @NotNull
        public Iterable<?> convert(@NotNull Object value) {
            return (Iterable)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Iterable<?> convertOrNull(@NotNull Object value) {
            return (Iterable)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public MutableIterableConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(MutableIterableConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableIterableConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$MutableIterableConverter;", "()V", "breeze-core"})
        public static final class Default
        extends MutableIterableConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000  2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001 B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001a\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Licu/windea/breezeframework/core/component/Converters$CollectionConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "delegate", "getDelegate", "()Ljava/lang/String;", "listConverter", "Licu/windea/breezeframework/core/component/Converters$MutableListConverter;", "getListConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableListConverter;", "listConverter$delegate", "Lkotlin/Lazy;", "passingParams", "setConverter", "Licu/windea/breezeframework/core/component/Converters$MutableSetConverter;", "getSetConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableSetConverter;", "setConverter$delegate", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class CollectionConverter
    extends AbstractConverter<Collection<?>>
    implements GenericConverter<Collection<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy listConverter$delegate;
        @NotNull
        private final Lazy setConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String delegate;

        public CollectionConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.listConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableListConverter>(this){
                final /* synthetic */ CollectionConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableListConverter invoke() {
                    return (MutableListConverter)Converters.INSTANCE.get(List.class, CollectionConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableListConverter>(this.this$0){
                        final /* synthetic */ CollectionConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableListConverter invoke() {
                            return new MutableListConverter(CollectionConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.setConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableSetConverter>(this){
                final /* synthetic */ CollectionConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableSetConverter invoke() {
                    return (MutableSetConverter)Converters.INSTANCE.get(Set.class, CollectionConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableSetConverter>(this.this$0){
                        final /* synthetic */ CollectionConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableSetConverter invoke() {
                            return new MutableSetConverter(CollectionConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            String[] stringArray = new String[]{"delegate"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("delegate");
            if (object == null) {
                string = "list";
            } else {
                string = object.toString();
                if (string == null) {
                    string = "list";
                }
            }
            this.delegate = string;
        }

        public /* synthetic */ CollectionConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final MutableListConverter getListConverter() {
            Lazy lazy = this.listConverter$delegate;
            return (MutableListConverter)lazy.getValue();
        }

        private final MutableSetConverter getSetConverter() {
            Lazy lazy = this.setConverter$delegate;
            return (MutableSetConverter)lazy.getValue();
        }

        @NotNull
        public final String getDelegate() {
            return this.delegate;
        }

        @Override
        @NotNull
        public Collection<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            String string = this.delegate;
            if (Intrinsics.areEqual((Object)string, (Object)"list")) {
                collection = (Collection)this.getListConverter().convert(value, targetType);
            } else if (Intrinsics.areEqual((Object)string, (Object)"set")) {
                collection = (Collection)this.getSetConverter().convert(value, targetType);
            } else {
                throw new IllegalArgumentException("Config param 'delegate' must be one of: list, set.");
            }
            return collection;
        }

        @Override
        @Nullable
        public Collection<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            String string = this.delegate;
            if (Intrinsics.areEqual((Object)string, (Object)"list")) {
                collection = (Collection)this.getListConverter().convertOrNull(value, targetType);
            } else if (Intrinsics.areEqual((Object)string, (Object)"set")) {
                collection = (Collection)this.getSetConverter().convertOrNull(value, targetType);
            } else {
                throw new IllegalArgumentException("Config param 'delegate' must be one of: list, set.");
            }
            return collection;
        }

        @Override
        @NotNull
        public CollectionConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new CollectionConverter(componentParams);
        }

        @Override
        @NotNull
        public Collection<?> convert(@NotNull Object value) {
            return (Collection)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Collection<?> convertOrNull(@NotNull Object value) {
            return (Collection)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public CollectionConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(CollectionConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$CollectionConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$CollectionConverter;", "()V", "breeze-core"})
        public static final class Default
        extends CollectionConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000  2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001 B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001a\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableCollectionConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "delegate", "getDelegate", "()Ljava/lang/String;", "mutableListConverter", "Licu/windea/breezeframework/core/component/Converters$MutableListConverter;", "getMutableListConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableListConverter;", "mutableListConverter$delegate", "Lkotlin/Lazy;", "mutableSetConverter", "Licu/windea/breezeframework/core/component/Converters$MutableSetConverter;", "getMutableSetConverter", "()Licu/windea/breezeframework/core/component/Converters$MutableSetConverter;", "mutableSetConverter$delegate", "passingParams", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class MutableCollectionConverter
    extends AbstractConverter<Collection<?>>
    implements GenericConverter<Collection<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy mutableListConverter$delegate;
        @NotNull
        private final Lazy mutableSetConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String delegate;

        public MutableCollectionConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.mutableListConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableListConverter>(this){
                final /* synthetic */ MutableCollectionConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableListConverter invoke() {
                    return (MutableListConverter)Converters.INSTANCE.get(List.class, MutableCollectionConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableListConverter>(this.this$0){
                        final /* synthetic */ MutableCollectionConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableListConverter invoke() {
                            return new MutableListConverter(MutableCollectionConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.mutableSetConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MutableSetConverter>(this){
                final /* synthetic */ MutableCollectionConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MutableSetConverter invoke() {
                    return (MutableSetConverter)Converters.INSTANCE.get(Set.class, MutableCollectionConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<MutableSetConverter>(this.this$0){
                        final /* synthetic */ MutableCollectionConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final MutableSetConverter invoke() {
                            return new MutableSetConverter(MutableCollectionConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            String[] stringArray = new String[]{"delegate"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("delegate");
            if (object == null) {
                string = "list";
            } else {
                string = object.toString();
                if (string == null) {
                    string = "list";
                }
            }
            this.delegate = string;
        }

        public /* synthetic */ MutableCollectionConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final MutableListConverter getMutableListConverter() {
            Lazy lazy = this.mutableListConverter$delegate;
            return (MutableListConverter)lazy.getValue();
        }

        private final MutableSetConverter getMutableSetConverter() {
            Lazy lazy = this.mutableSetConverter$delegate;
            return (MutableSetConverter)lazy.getValue();
        }

        @NotNull
        public final String getDelegate() {
            return this.delegate;
        }

        @Override
        @NotNull
        public Collection<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            String string = this.delegate;
            if (Intrinsics.areEqual((Object)string, (Object)"list")) {
                collection = (Collection)this.getMutableListConverter().convert(value, targetType);
            } else if (Intrinsics.areEqual((Object)string, (Object)"set")) {
                collection = (Collection)this.getMutableSetConverter().convert(value, targetType);
            } else {
                throw new IllegalArgumentException("Config param 'delegate' must be one of: list, set.");
            }
            return collection;
        }

        @Override
        @Nullable
        public Collection<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            String string = this.delegate;
            if (Intrinsics.areEqual((Object)string, (Object)"list")) {
                collection = (Collection)this.getMutableListConverter().convertOrNull(value, targetType);
            } else if (Intrinsics.areEqual((Object)string, (Object)"set")) {
                collection = (Collection)this.getMutableSetConverter().convertOrNull(value, targetType);
            } else {
                throw new IllegalArgumentException("Config param 'delegate' must be one of: list, set.");
            }
            return collection;
        }

        @Override
        @NotNull
        public MutableCollectionConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new MutableCollectionConverter(componentParams);
        }

        @Override
        @NotNull
        public Collection<?> convert(@NotNull Object value) {
            return (Collection)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Collection<?> convertOrNull(@NotNull Object value) {
            return (Collection)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public MutableCollectionConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(MutableCollectionConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableCollectionConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$MutableCollectionConverter;", "()V", "breeze-core"})
        public static final class Default
        extends MutableCollectionConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001c2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u001cB\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001d"}, d2={"Licu/windea/breezeframework/core/component/Converters$ListConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertElement", "element", "elementType", "splitValue", "Default", "breeze-core"})
    public static class ListConverter
    extends AbstractConverter<List<?>>
    implements GenericConverter<List<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public ListConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ ListConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<?> convert(@NotNull Object value, @NotNull Type targetType) {
            List<Object> list;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Type elementType = InternalExtensions.inferTypeArgument(targetType);
            if (value instanceof Object[]) {
                void $this$mapTo$iv$iv;
                Object[] $this$map$iv = (Object[])value;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void var13_146 = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof byte[]) {
                byte[] $this$map$iv = (byte[])value;
                boolean $i$f$map = false;
                byte[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (byte item$iv$iv : $this$mapTo$iv$iv) {
                    byte it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof short[]) {
                short[] $this$map$iv = (short[])value;
                boolean $i$f$map = false;
                short[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (short item$iv$iv : $this$mapTo$iv$iv) {
                    short it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof int[]) {
                int[] $this$map$iv = (int[])value;
                boolean $i$f$map = false;
                int[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (int item$iv$iv : $this$mapTo$iv$iv) {
                    int it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof long[]) {
                long[] $this$map$iv = (long[])value;
                boolean $i$f$map = false;
                long[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (long item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    long bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.convertElement((long)it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof float[]) {
                float[] $this$map$iv = (float[])value;
                boolean $i$f$map = false;
                float[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (float item$iv$iv : $this$mapTo$iv$iv) {
                    float it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Float.valueOf(it), elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof double[]) {
                double[] $this$map$iv = (double[])value;
                boolean $i$f$map = false;
                double[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (double item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    double bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.convertElement((double)it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof boolean[]) {
                boolean[] $this$map$iv = (boolean[])value;
                boolean $i$f$map = false;
                boolean[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (boolean item$iv$iv : $this$mapTo$iv$iv) {
                    boolean it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof char[]) {
                char[] $this$map$iv = (char[])value;
                boolean $i$f$map = false;
                char[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (char item$iv$iv : $this$mapTo$iv$iv) {
                    char it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Character.valueOf(it), elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof UByteArray) {
                byte[] $this$map$iv = ((UByteArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UByteArray.getSize-impl((byte[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UByteArray.iterator-impl((byte[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    byte destination$iv$iv;
                    byte $i$f$mapTo = destination$iv$iv = ((UByte)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UByte.box-impl((byte)it), elementType));
                }
                list = InternalExtensions.convertToList((List)$i$f$map);
            } else if (value instanceof UShortArray) {
                short[] $this$map$iv = ((UShortArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UShortArray.getSize-impl((short[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UShortArray.iterator-impl((short[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    short destination$iv$iv;
                    short it = destination$iv$iv = ((UShort)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UShort.box-impl((short)it), elementType));
                }
                list = InternalExtensions.convertToList((List)$i$f$map);
            } else if (value instanceof UIntArray) {
                int[] $this$map$iv = ((UIntArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UIntArray.getSize-impl((int[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UIntArray.iterator-impl((int[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    int destination$iv$iv;
                    int it = destination$iv$iv = ((UInt)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UInt.box-impl((int)it), elementType));
                }
                list = InternalExtensions.convertToList((List)$i$f$map);
            } else if (value instanceof ULongArray) {
                long[] $this$map$iv = ((ULongArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(ULongArray.getSize-impl((long[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = ULongArray.iterator-impl((long[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    long destination$iv$iv;
                    long bl = destination$iv$iv = ((ULong)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl4 = false;
                    collection.add(this.convertElement(ULong.box-impl((long)it), elementType));
                }
                list = InternalExtensions.convertToList((List)$i$f$map);
            } else if (value instanceof Iterator) {
                Iterable $this$map$iv = new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                };
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object bl4 = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof Iterable) {
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof Sequence) {
                list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)((Sequence)value), (Function1)((Function1)new Function1<Object, Object>(this, elementType){
                    final /* synthetic */ ListConverter this$0;
                    final /* synthetic */ Type $elementType;
                    {
                        this.this$0 = $receiver;
                        this.$elementType = $elementType;
                        super(1);
                    }

                    @NotNull
                    public final Object invoke(@Nullable Object it) {
                        return ListConverter.access$convertElement(this.this$0, it, this.$elementType);
                    }
                })));
            } else if (value instanceof Stream) {
                Stream<Object> $this$map$iv = ((Stream)value).map(arg_0 -> ListConverter.convert$lambda-16(this, elementType, arg_0));
                Intrinsics.checkNotNullExpressionValue($this$map$iv, (String)"value.map { convertElement(it, elementType) }");
                list = StreamExtensions.toList($this$map$iv);
            } else if (value instanceof String) {
                Iterable $this$map$iv = this.splitValue((String)value);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else if (value instanceof CharSequence) {
                Iterable $this$map$iv = this.splitValue(value.toString());
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToList((List)destination$iv$iv);
            } else {
                list = CollectionsKt.listOf((Object)ConverterExtensions.convert(value, elementType, this.passingParams));
            }
            return list;
        }

        private final Object convertElement(Object element, Type elementType) {
            return ConverterExtensions.convert(element, elementType, this.passingParams);
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public ListConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new ListConverter(componentParams);
        }

        @Override
        @NotNull
        public List<?> convert(@NotNull Object value) {
            return (List)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public List<?> convertOrNull(@NotNull Object value) {
            return (List)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        @Override
        @Nullable
        public List<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            return (List)GenericConverter.DefaultImpls.convertOrNull(this, value, targetType);
        }

        private static final Object convert$lambda-16(ListConverter this$0, Type $elementType, Object it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$elementType, (String)"$elementType");
            return this$0.convertElement(it, $elementType);
        }

        public ListConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Object access$convertElement(ListConverter $this, Object element, Type elementType) {
            return $this.convertElement(element, elementType);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$ListConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$ListConverter;", "()V", "breeze-core"})
        public static final class Default
        extends ListConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u001dB\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001e"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableListConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertElement", "element", "elementType", "splitValue", "", "Default", "breeze-core"})
    public static class MutableListConverter
    extends AbstractConverter<List<?>>
    implements GenericConverter<List<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public MutableListConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ MutableListConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<?> convert(@NotNull Object value, @NotNull Type targetType) {
            List<Object> list;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Type elementType = InternalExtensions.inferTypeArgument(targetType);
            if (value instanceof Object[]) {
                void $this$mapTo$iv$iv;
                Object[] $this$map$iv = (Object[])value;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void var13_147 = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof byte[]) {
                byte[] $this$map$iv = (byte[])value;
                boolean $i$f$map = false;
                byte[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (byte item$iv$iv : $this$mapTo$iv$iv) {
                    byte it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof short[]) {
                short[] $this$map$iv = (short[])value;
                boolean $i$f$map = false;
                short[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (short item$iv$iv : $this$mapTo$iv$iv) {
                    short it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof int[]) {
                int[] $this$map$iv = (int[])value;
                boolean $i$f$map = false;
                int[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (int item$iv$iv : $this$mapTo$iv$iv) {
                    int it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof long[]) {
                long[] $this$map$iv = (long[])value;
                boolean $i$f$map = false;
                long[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (long item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    long bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.convertElement((long)it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof float[]) {
                float[] $this$map$iv = (float[])value;
                boolean $i$f$map = false;
                float[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (float item$iv$iv : $this$mapTo$iv$iv) {
                    float it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Float.valueOf(it), elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof double[]) {
                double[] $this$map$iv = (double[])value;
                boolean $i$f$map = false;
                double[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (double item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    double bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.convertElement((double)it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof boolean[]) {
                boolean[] $this$map$iv = (boolean[])value;
                boolean $i$f$map = false;
                boolean[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (boolean item$iv$iv : $this$mapTo$iv$iv) {
                    boolean it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof char[]) {
                char[] $this$map$iv = (char[])value;
                boolean $i$f$map = false;
                char[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (char item$iv$iv : $this$mapTo$iv$iv) {
                    char it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Character.valueOf(it), elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof UByteArray) {
                byte[] $this$map$iv = ((UByteArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UByteArray.getSize-impl((byte[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UByteArray.iterator-impl((byte[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    byte destination$iv$iv;
                    byte $i$f$mapTo = destination$iv$iv = ((UByte)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UByte.box-impl((byte)it), elementType));
                }
                list = InternalExtensions.convertToMutableList((List)$i$f$map);
            } else if (value instanceof UShortArray) {
                short[] $this$map$iv = ((UShortArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UShortArray.getSize-impl((short[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UShortArray.iterator-impl((short[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    short destination$iv$iv;
                    short it = destination$iv$iv = ((UShort)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UShort.box-impl((short)it), elementType));
                }
                list = InternalExtensions.convertToMutableList((List)$i$f$map);
            } else if (value instanceof UIntArray) {
                int[] $this$map$iv = ((UIntArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UIntArray.getSize-impl((int[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UIntArray.iterator-impl((int[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    int destination$iv$iv;
                    int it = destination$iv$iv = ((UInt)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UInt.box-impl((int)it), elementType));
                }
                list = InternalExtensions.convertToMutableList((List)$i$f$map);
            } else if (value instanceof ULongArray) {
                long[] $this$map$iv = ((ULongArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(ULongArray.getSize-impl((long[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = ULongArray.iterator-impl((long[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    long destination$iv$iv;
                    long bl = destination$iv$iv = ((ULong)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl4 = false;
                    collection.add(this.convertElement(ULong.box-impl((long)it), elementType));
                }
                list = InternalExtensions.convertToMutableList((List)$i$f$map);
            } else if (value instanceof Iterator) {
                Iterable $this$map$iv = new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                };
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object bl4 = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof Iterable) {
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof Sequence) {
                list = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)((Sequence)value), (Function1)((Function1)new Function1<Object, Object>(this, elementType){
                    final /* synthetic */ MutableListConverter this$0;
                    final /* synthetic */ Type $elementType;
                    {
                        this.this$0 = $receiver;
                        this.$elementType = $elementType;
                        super(1);
                    }

                    @NotNull
                    public final Object invoke(@Nullable Object it) {
                        return MutableListConverter.access$convertElement(this.this$0, it, this.$elementType);
                    }
                })));
            } else if (value instanceof Stream) {
                Stream<Object> $this$map$iv = ((Stream)value).map(arg_0 -> MutableListConverter.convert$lambda-16(this, elementType, arg_0));
                Intrinsics.checkNotNullExpressionValue($this$map$iv, (String)"value.map { convertElement(it, elementType) }");
                list = StreamExtensions.toMutableList($this$map$iv);
            } else if (value instanceof String) {
                Iterable $this$map$iv = this.splitValue((String)value);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else if (value instanceof CharSequence) {
                Iterable $this$map$iv = this.splitValue(value.toString());
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                list = InternalExtensions.convertToMutableList((List)destination$iv$iv);
            } else {
                Object[] objectArray = new Object[]{ConverterExtensions.convert(value, elementType, this.passingParams)};
                list = CollectionsKt.mutableListOf((Object[])objectArray);
            }
            return list;
        }

        private final Object convertElement(Object element, Type elementType) {
            return ConverterExtensions.convert(element, elementType, this.passingParams);
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public MutableListConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new MutableListConverter(componentParams);
        }

        @Override
        @NotNull
        public List<?> convert(@NotNull Object value) {
            return (List)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public List<?> convertOrNull(@NotNull Object value) {
            return (List)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        @Override
        @Nullable
        public List<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            return (List)GenericConverter.DefaultImpls.convertOrNull(this, value, targetType);
        }

        private static final Object convert$lambda-16(MutableListConverter this$0, Type $elementType, Object it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$elementType, (String)"$elementType");
            return this$0.convertElement(it, $elementType);
        }

        public MutableListConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Object access$convertElement(MutableListConverter $this, Object element, Type elementType) {
            return $this.convertElement(element, elementType);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableListConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$MutableListConverter;", "()V", "breeze-core"})
        public static final class Default
        extends MutableListConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u001dB\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001e"}, d2={"Licu/windea/breezeframework/core/component/Converters$SetConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertElement", "element", "elementType", "splitValue", "", "Default", "breeze-core"})
    public static class SetConverter
    extends AbstractConverter<Set<?>>
    implements GenericConverter<Set<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public SetConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ SetConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Set<Object> set;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Type elementType = InternalExtensions.inferTypeArgument(targetType);
            if (value instanceof Object[]) {
                void $this$mapTo$iv$iv;
                Object[] $this$map$iv = (Object[])value;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void var13_146 = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof byte[]) {
                byte[] $this$map$iv = (byte[])value;
                boolean $i$f$map = false;
                byte[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (byte item$iv$iv : $this$mapTo$iv$iv) {
                    byte it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof short[]) {
                short[] $this$map$iv = (short[])value;
                boolean $i$f$map = false;
                short[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (short item$iv$iv : $this$mapTo$iv$iv) {
                    short it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof int[]) {
                int[] $this$map$iv = (int[])value;
                boolean $i$f$map = false;
                int[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (int item$iv$iv : $this$mapTo$iv$iv) {
                    int it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof long[]) {
                long[] $this$map$iv = (long[])value;
                boolean $i$f$map = false;
                long[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (long item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    long bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.convertElement((long)it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof float[]) {
                float[] $this$map$iv = (float[])value;
                boolean $i$f$map = false;
                float[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (float item$iv$iv : $this$mapTo$iv$iv) {
                    float it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Float.valueOf(it), elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof double[]) {
                double[] $this$map$iv = (double[])value;
                boolean $i$f$map = false;
                double[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (double item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    double bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.convertElement((double)it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof boolean[]) {
                boolean[] $this$map$iv = (boolean[])value;
                boolean $i$f$map = false;
                boolean[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (boolean item$iv$iv : $this$mapTo$iv$iv) {
                    boolean it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof char[]) {
                char[] $this$map$iv = (char[])value;
                boolean $i$f$map = false;
                char[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (char item$iv$iv : $this$mapTo$iv$iv) {
                    char it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Character.valueOf(it), elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof UByteArray) {
                byte[] $this$map$iv = ((UByteArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UByteArray.getSize-impl((byte[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UByteArray.iterator-impl((byte[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    byte destination$iv$iv;
                    byte $i$f$mapTo = destination$iv$iv = ((UByte)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UByte.box-impl((byte)it), elementType));
                }
                set = InternalExtensions.convertToSet((List)$i$f$map);
            } else if (value instanceof UShortArray) {
                short[] $this$map$iv = ((UShortArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UShortArray.getSize-impl((short[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UShortArray.iterator-impl((short[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    short destination$iv$iv;
                    short it = destination$iv$iv = ((UShort)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UShort.box-impl((short)it), elementType));
                }
                set = InternalExtensions.convertToSet((List)$i$f$map);
            } else if (value instanceof UIntArray) {
                int[] $this$map$iv = ((UIntArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UIntArray.getSize-impl((int[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UIntArray.iterator-impl((int[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    int destination$iv$iv;
                    int it = destination$iv$iv = ((UInt)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UInt.box-impl((int)it), elementType));
                }
                set = InternalExtensions.convertToSet((List)$i$f$map);
            } else if (value instanceof ULongArray) {
                long[] $this$map$iv = ((ULongArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(ULongArray.getSize-impl((long[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = ULongArray.iterator-impl((long[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    long destination$iv$iv;
                    long bl = destination$iv$iv = ((ULong)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl4 = false;
                    collection.add(this.convertElement(ULong.box-impl((long)it), elementType));
                }
                set = InternalExtensions.convertToSet((List)$i$f$map);
            } else if (value instanceof Iterator) {
                Iterable $this$map$iv = new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                };
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object bl4 = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof Iterable) {
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof Sequence) {
                set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)((Sequence)value), (Function1)((Function1)new Function1<Object, Object>(this, elementType){
                    final /* synthetic */ SetConverter this$0;
                    final /* synthetic */ Type $elementType;
                    {
                        this.this$0 = $receiver;
                        this.$elementType = $elementType;
                        super(1);
                    }

                    @NotNull
                    public final Object invoke(@Nullable Object it) {
                        return SetConverter.access$convertElement(this.this$0, it, this.$elementType);
                    }
                })));
            } else if (value instanceof Stream) {
                Stream<Object> $this$map$iv = ((Stream)value).map(arg_0 -> SetConverter.convert$lambda-16(this, elementType, arg_0));
                Intrinsics.checkNotNullExpressionValue($this$map$iv, (String)"value.map { convertElement(it, elementType) }");
                set = StreamExtensions.toSet($this$map$iv);
            } else if (value instanceof String) {
                Iterable $this$map$iv = this.splitValue((String)value);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else if (value instanceof CharSequence) {
                Iterable $this$map$iv = this.splitValue(value.toString());
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToSet((List)destination$iv$iv);
            } else {
                set = SetsKt.setOf((Object)ConverterExtensions.convert(value, elementType, this.passingParams));
            }
            return set;
        }

        private final Object convertElement(Object element, Type elementType) {
            return ConverterExtensions.convert(element, elementType, this.passingParams);
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public SetConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new SetConverter(componentParams);
        }

        @Override
        @NotNull
        public Set<?> convert(@NotNull Object value) {
            return (Set)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Set<?> convertOrNull(@NotNull Object value) {
            return (Set)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        @Override
        @Nullable
        public Set<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            return (Set)GenericConverter.DefaultImpls.convertOrNull(this, value, targetType);
        }

        private static final Object convert$lambda-16(SetConverter this$0, Type $elementType, Object it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$elementType, (String)"$elementType");
            return this$0.convertElement(it, $elementType);
        }

        public SetConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Object access$convertElement(SetConverter $this, Object element, Type elementType) {
            return $this.convertElement(element, elementType);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$SetConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$SetConverter;", "()V", "breeze-core"})
        public static final class Default
        extends SetConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u001dB\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001e"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableSetConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "passingParams", "prefix", "getPrefix", "()Ljava/lang/String;", "separator", "getSeparator", "suffix", "getSuffix", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertElement", "element", "elementType", "splitValue", "", "Default", "breeze-core"})
    public static class MutableSetConverter
    extends AbstractConverter<Set<?>>
    implements GenericConverter<Set<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String separator;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        public MutableSetConverter(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            String[] stringArray = new String[]{"separator", "prefix", "suffix"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            Object object = this.componentParams.get("separator");
            if (object == null) {
                string3 = ",";
            } else {
                string3 = object.toString();
                if (string3 == null) {
                    string3 = ",";
                }
            }
            this.separator = string3;
            Object object2 = this.componentParams.get("prefix");
            if (object2 == null) {
                string2 = "";
            } else {
                string2 = object2.toString();
                if (string2 == null) {
                    string2 = "";
                }
            }
            this.prefix = string2;
            Object object3 = this.componentParams.get("suffix");
            if (object3 == null) {
                string = "";
            } else {
                string = object3.toString();
                if (string == null) {
                    string = "";
                }
            }
            this.suffix = string;
        }

        public /* synthetic */ MutableSetConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Set<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Set<Object> set;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Type elementType = InternalExtensions.inferTypeArgument(targetType);
            if (value instanceof Object[]) {
                void $this$mapTo$iv$iv;
                Object[] $this$map$iv = (Object[])value;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void var13_147 = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof byte[]) {
                byte[] $this$map$iv = (byte[])value;
                boolean $i$f$map = false;
                byte[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (byte item$iv$iv : $this$mapTo$iv$iv) {
                    byte it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof short[]) {
                short[] $this$map$iv = (short[])value;
                boolean $i$f$map = false;
                short[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (short item$iv$iv : $this$mapTo$iv$iv) {
                    short it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof int[]) {
                int[] $this$map$iv = (int[])value;
                boolean $i$f$map = false;
                int[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (int item$iv$iv : $this$mapTo$iv$iv) {
                    int it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof long[]) {
                long[] $this$map$iv = (long[])value;
                boolean $i$f$map = false;
                long[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (long item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    long bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.convertElement((long)it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof float[]) {
                float[] $this$map$iv = (float[])value;
                boolean $i$f$map = false;
                float[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (float item$iv$iv : $this$mapTo$iv$iv) {
                    float it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Float.valueOf(it), elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof double[]) {
                double[] $this$map$iv = (double[])value;
                boolean $i$f$map = false;
                double[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (double item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    double bl = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.convertElement((double)it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof boolean[]) {
                boolean[] $this$map$iv = (boolean[])value;
                boolean $i$f$map = false;
                boolean[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (boolean item$iv$iv : $this$mapTo$iv$iv) {
                    boolean it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof char[]) {
                char[] $this$map$iv = (char[])value;
                boolean $i$f$map = false;
                char[] $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (char item$iv$iv : $this$mapTo$iv$iv) {
                    char it = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(Character.valueOf(it), elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof UByteArray) {
                byte[] $this$map$iv = ((UByteArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UByteArray.getSize-impl((byte[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UByteArray.iterator-impl((byte[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    byte destination$iv$iv;
                    byte $i$f$mapTo = destination$iv$iv = ((UByte)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UByte.box-impl((byte)it), elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)$i$f$map);
            } else if (value instanceof UShortArray) {
                short[] $this$map$iv = ((UShortArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UShortArray.getSize-impl((short[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UShortArray.iterator-impl((short[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    short destination$iv$iv;
                    short it = destination$iv$iv = ((UShort)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UShort.box-impl((short)it), elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)$i$f$map);
            } else if (value instanceof UIntArray) {
                int[] $this$map$iv = ((UIntArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(UIntArray.getSize-impl((int[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = UIntArray.iterator-impl((int[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    int destination$iv$iv;
                    int it = destination$iv$iv = ((UInt)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl = false;
                    collection.add(this.convertElement(UInt.box-impl((int)it), elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)$i$f$map);
            } else if (value instanceof ULongArray) {
                long[] $this$map$iv = ((ULongArray)value).unbox-impl();
                Collection $i$f$map = new ArrayList(ULongArray.getSize-impl((long[])$this$map$iv));
                Iterator $this$mapTo$iv$iv = ULongArray.iterator-impl((long[])$this$map$iv);
                while ($this$mapTo$iv$iv.hasNext()) {
                    void it;
                    long destination$iv$iv;
                    long bl = destination$iv$iv = ((ULong)$this$mapTo$iv$iv.next()).unbox-impl();
                    Collection collection = $i$f$map;
                    boolean bl4 = false;
                    collection.add(this.convertElement(ULong.box-impl((long)it), elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)$i$f$map);
            } else if (value instanceof Iterator) {
                Iterable $this$map$iv = new Iterable<Object>(value){
                    final /* synthetic */ Object $value$inlined;
                    {
                        this.$value$inlined = object;
                    }

                    @NotNull
                    public Iterator<Object> iterator() {
                        boolean bl = false;
                        return (Iterator)this.$value$inlined;
                    }
                };
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object bl4 = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof Iterable) {
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof Sequence) {
                set = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)((Sequence)value), (Function1)((Function1)new Function1<Object, Object>(this, elementType){
                    final /* synthetic */ MutableSetConverter this$0;
                    final /* synthetic */ Type $elementType;
                    {
                        this.this$0 = $receiver;
                        this.$elementType = $elementType;
                        super(1);
                    }

                    @NotNull
                    public final Object invoke(@Nullable Object it) {
                        return MutableSetConverter.access$convertElement(this.this$0, it, this.$elementType);
                    }
                })));
            } else if (value instanceof Stream) {
                Stream<Object> $this$map$iv = ((Stream)value).map(arg_0 -> MutableSetConverter.convert$lambda-16(this, elementType, arg_0));
                Intrinsics.checkNotNullExpressionValue($this$map$iv, (String)"value.map { convertElement(it, elementType) }");
                set = StreamExtensions.toMutableSet($this$map$iv);
            } else if (value instanceof String) {
                Iterable $this$map$iv = this.splitValue((String)value);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else if (value instanceof CharSequence) {
                Iterable $this$map$iv = this.splitValue(value.toString());
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertElement(it, elementType));
                }
                set = InternalExtensions.convertToMutableSet((List)destination$iv$iv);
            } else {
                Object[] objectArray = new Object[]{ConverterExtensions.convert(value, elementType, this.passingParams)};
                set = SetsKt.mutableSetOf((Object[])objectArray);
            }
            return set;
        }

        private final Object convertElement(Object element, Type elementType) {
            return ConverterExtensions.convert(element, elementType, this.passingParams);
        }

        private final List<String> splitValue(String value) {
            return StringExtensions.splitToStrings$default(value, this.separator, this.prefix, this.suffix, false, 0, 24, null);
        }

        @Override
        @NotNull
        public MutableSetConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new MutableSetConverter(componentParams);
        }

        @Override
        @NotNull
        public Set<?> convert(@NotNull Object value) {
            return (Set)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Set<?> convertOrNull(@NotNull Object value) {
            return (Set)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        @Override
        @Nullable
        public Set<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            return (Set)GenericConverter.DefaultImpls.convertOrNull(this, value, targetType);
        }

        private static final Object convert$lambda-16(MutableSetConverter this$0, Type $elementType, Object it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$elementType, (String)"$elementType");
            return this$0.convertElement(it, $elementType);
        }

        public MutableSetConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Object access$convertElement(MutableSetConverter $this, Object element, Type elementType) {
            return $this.convertElement(element, elementType);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$MutableSetConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$MutableSetConverter;", "()V", "breeze-core"})
        public static final class Default
        extends MutableSetConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$IntRangeConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/ranges/IntRange;", "()V", "convert", "value", "", "doConvert", "", "breeze-core"})
    public static final class IntRangeConverter
    extends AbstractConverter<IntRange> {
        @NotNull
        public static final IntRangeConverter INSTANCE = new IntRangeConverter();

        private IntRangeConverter() {
        }

        @Override
        @NotNull
        public IntRange convert(@NotNull Object value) {
            IntRange intRange;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof IntRange) {
                intRange = (IntRange)value;
            } else if (value instanceof IntProgression) {
                intRange = new IntRange(((IntProgression)value).getFirst(), ((IntProgression)value).getLast());
            } else if (value instanceof LongProgression) {
                intRange = new IntRange((int)((LongProgression)value).getFirst(), (int)((LongProgression)value).getLast());
            } else if (value instanceof CharProgression) {
                intRange = new IntRange((int)((CharProgression)value).getFirst(), (int)((CharProgression)value).getLast());
            } else if (value instanceof UIntProgression) {
                intRange = new IntRange(((UIntProgression)value).getFirst-pVg5ArA(), ((UIntProgression)value).getLast-pVg5ArA());
            } else if (value instanceof ULongProgression) {
                intRange = new IntRange((int)((ULongProgression)value).getFirst-s-VKNKU(), (int)((ULongProgression)value).getLast-s-VKNKU());
            } else if (value instanceof Pair) {
                Object object = ((Pair)value).getFirst();
                Intrinsics.checkNotNull((Object)object);
                Object $this$convert_u24default$iv = object;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                int n = ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue();
                Object object2 = ((Pair)value).getSecond();
                Intrinsics.checkNotNull((Object)object2);
                $this$convert_u24default$iv = object2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert2 = false;
                $i$f$javaTypeOf = false;
                IntRange intRange2 = new IntRange(n, ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue());
                intRange = intRange2;
            } else if (value instanceof List) {
                Object e = ((List)value).get(0);
                Intrinsics.checkNotNull(e);
                Object $this$convert_u24default$iv = e;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert3 = false;
                boolean $i$f$javaTypeOf = false;
                int n = ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue();
                Object e2 = ((List)value).get(1);
                Intrinsics.checkNotNull(e2);
                $this$convert_u24default$iv = e2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert3 = false;
                $i$f$javaTypeOf = false;
                IntRange intRange3 = new IntRange(n, ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue());
                intRange = intRange3;
            } else if (value instanceof ClosedRange) {
                Comparable $this$convert_u24default$iv = ((ClosedRange)value).getStart();
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert4 = false;
                boolean $i$f$javaTypeOf = false;
                int n = ((Number)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue();
                $this$convert_u24default$iv = ((ClosedRange)value).getEndInclusive();
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert4 = false;
                $i$f$javaTypeOf = false;
                IntRange intRange4 = new IntRange(n, ((Number)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue());
                intRange = intRange4;
            } else {
                intRange = value instanceof String ? this.doConvert((String)value) : this.doConvert(value.toString());
            }
            return intRange;
        }

        private final IntRange doConvert(String value) {
            String[] stringArray = new String[]{".."};
            List it = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            boolean bl = false;
            Object $this$convert_u24default$iv = it.get(0);
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            int n = ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue();
            $this$convert_u24default$iv = it.get(1);
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convert = false;
            this_$iv$iv = INSTANCE;
            $i$f$convert2 = false;
            $i$f$javaTypeOf = false;
            return new IntRange(n, ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).intValue());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$LongRangeConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/ranges/LongRange;", "()V", "convert", "value", "", "doConvert", "", "breeze-core"})
    public static final class LongRangeConverter
    extends AbstractConverter<LongRange> {
        @NotNull
        public static final LongRangeConverter INSTANCE = new LongRangeConverter();

        private LongRangeConverter() {
        }

        @Override
        @NotNull
        public LongRange convert(@NotNull Object value) {
            LongRange longRange;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof LongRange) {
                longRange = (LongRange)value;
            } else if (value instanceof IntProgression) {
                longRange = new LongRange((long)((IntProgression)value).getFirst(), (long)((IntProgression)value).getLast());
            } else if (value instanceof LongProgression) {
                longRange = new LongRange(((LongProgression)value).getFirst(), ((LongProgression)value).getLast());
            } else if (value instanceof CharProgression) {
                longRange = new LongRange((long)((CharProgression)value).getFirst(), (long)((CharProgression)value).getLast());
            } else if (value instanceof UIntProgression) {
                longRange = new LongRange((long)((UIntProgression)value).getFirst-pVg5ArA() & 0xFFFFFFFFL, (long)((UIntProgression)value).getLast-pVg5ArA() & 0xFFFFFFFFL);
            } else if (value instanceof ULongProgression) {
                longRange = new LongRange(((ULongProgression)value).getFirst-s-VKNKU(), ((ULongProgression)value).getLast-s-VKNKU());
            } else if (value instanceof Pair) {
                Object object = ((Pair)value).getFirst();
                Intrinsics.checkNotNull((Object)object);
                Object $this$convert_u24default$iv = object;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                long l = ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue();
                Object object2 = ((Pair)value).getSecond();
                Intrinsics.checkNotNull((Object)object2);
                $this$convert_u24default$iv = object2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert2 = false;
                $i$f$javaTypeOf = false;
                LongRange longRange2 = new LongRange(l, ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue());
                longRange = longRange2;
            } else if (value instanceof List) {
                Object e = ((List)value).get(0);
                Intrinsics.checkNotNull(e);
                Object $this$convert_u24default$iv = e;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert3 = false;
                boolean $i$f$javaTypeOf = false;
                long l = ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue();
                Object e2 = ((List)value).get(1);
                Intrinsics.checkNotNull(e2);
                $this$convert_u24default$iv = e2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert3 = false;
                $i$f$javaTypeOf = false;
                LongRange longRange3 = new LongRange(l, ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue());
                longRange = longRange3;
            } else if (value instanceof ClosedRange) {
                Comparable $this$convert_u24default$iv = ((ClosedRange)value).getStart();
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert4 = false;
                boolean $i$f$javaTypeOf = false;
                long l = ((Number)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue();
                $this$convert_u24default$iv = ((ClosedRange)value).getEndInclusive();
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert4 = false;
                $i$f$javaTypeOf = false;
                LongRange longRange4 = new LongRange(l, ((Number)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue());
                longRange = longRange4;
            } else {
                longRange = value instanceof String ? this.doConvert((String)value) : this.doConvert(value.toString());
            }
            return longRange;
        }

        private final LongRange doConvert(String value) {
            String[] stringArray = new String[]{".."};
            List it = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            boolean bl = false;
            Object $this$convert_u24default$iv = it.get(0);
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            long l = ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue();
            $this$convert_u24default$iv = it.get(1);
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convert = false;
            this_$iv$iv = INSTANCE;
            $i$f$convert2 = false;
            $i$f$javaTypeOf = false;
            return new LongRange(l, ((Number)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).longValue());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$CharRangeConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/ranges/CharRange;", "()V", "convert", "value", "", "doConvert", "", "breeze-core"})
    public static final class CharRangeConverter
    extends AbstractConverter<CharRange> {
        @NotNull
        public static final CharRangeConverter INSTANCE = new CharRangeConverter();

        private CharRangeConverter() {
        }

        @Override
        @NotNull
        public CharRange convert(@NotNull Object value) {
            CharRange charRange;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof CharRange) {
                charRange = (CharRange)value;
            } else if (value instanceof IntProgression) {
                charRange = new CharRange((char)((IntProgression)value).getFirst(), (char)((IntProgression)value).getLast());
            } else if (value instanceof LongProgression) {
                charRange = new CharRange((char)((LongProgression)value).getFirst(), (char)((LongProgression)value).getLast());
            } else if (value instanceof CharProgression) {
                charRange = new CharRange(((CharProgression)value).getFirst(), ((CharProgression)value).getLast());
            } else if (value instanceof UIntProgression) {
                int $this$toChar$iv = ((UIntProgression)value).getFirst-pVg5ArA();
                boolean bl = false;
                char c = (char)$this$toChar$iv;
                $this$toChar$iv = ((UIntProgression)value).getLast-pVg5ArA();
                bl = false;
                CharRange charRange2 = new CharRange(c, (char)$this$toChar$iv);
                charRange = charRange2;
            } else if (value instanceof ULongProgression) {
                long $this$toChar$iv = ((ULongProgression)value).getFirst-s-VKNKU();
                boolean bl = false;
                char c = (char)$this$toChar$iv;
                $this$toChar$iv = ((ULongProgression)value).getLast-s-VKNKU();
                bl = false;
                CharRange charRange3 = new CharRange(c, (char)$this$toChar$iv);
                charRange = charRange3;
            } else if (value instanceof Pair) {
                Object object = ((Pair)value).getFirst();
                Intrinsics.checkNotNull((Object)object);
                Object $this$convert_u24default$iv = object;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                char c = ((Character)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue();
                Object object2 = ((Pair)value).getSecond();
                Intrinsics.checkNotNull((Object)object2);
                $this$convert_u24default$iv = object2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert2 = false;
                $i$f$javaTypeOf = false;
                CharRange charRange4 = new CharRange(c, ((Character)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue());
                charRange = charRange4;
            } else if (value instanceof List) {
                Object e = ((List)value).get(0);
                Intrinsics.checkNotNull(e);
                Object $this$convert_u24default$iv = e;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert3 = false;
                boolean $i$f$javaTypeOf = false;
                char c = ((Character)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue();
                Object e2 = ((List)value).get(1);
                Intrinsics.checkNotNull(e2);
                $this$convert_u24default$iv = e2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert3 = false;
                $i$f$javaTypeOf = false;
                CharRange charRange5 = new CharRange(c, ((Character)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue());
                charRange = charRange5;
            } else if (value instanceof ClosedRange) {
                Comparable $this$convert_u24default$iv = ((ClosedRange)value).getStart();
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert4 = false;
                boolean $i$f$javaTypeOf = false;
                char c = ((Character)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue();
                $this$convert_u24default$iv = ((ClosedRange)value).getEndInclusive();
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convert = false;
                this_$iv$iv = INSTANCE;
                $i$f$convert4 = false;
                $i$f$javaTypeOf = false;
                CharRange charRange6 = new CharRange(c, ((Character)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue());
                charRange = charRange6;
            } else {
                charRange = value instanceof String ? this.doConvert((String)value) : this.doConvert(value.toString());
            }
            return charRange;
        }

        private final CharRange doConvert(String value) {
            String[] stringArray = new String[]{".."};
            List it = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            boolean bl = false;
            Object $this$convert_u24default$iv = it.get(0);
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            char c = ((Character)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue();
            $this$convert_u24default$iv = it.get(1);
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convert = false;
            this_$iv$iv = INSTANCE;
            $i$f$convert2 = false;
            $i$f$javaTypeOf = false;
            return new CharRange(c, ((Character)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).charValue());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$UIntRangeConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/ranges/UIntRange;", "()V", "convert", "value", "", "doConvert", "", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static final class UIntRangeConverter
    extends AbstractConverter<UIntRange> {
        @NotNull
        public static final UIntRangeConverter INSTANCE = new UIntRangeConverter();

        private UIntRangeConverter() {
        }

        @Override
        @NotNull
        public UIntRange convert(@NotNull Object value) {
            UIntRange uIntRange;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof UIntRange) {
                uIntRange = (UIntRange)value;
            } else if (value instanceof IntProgression) {
                uIntRange = new UIntRange(UInt.constructor-impl((int)((IntProgression)value).getFirst()), UInt.constructor-impl((int)((IntProgression)value).getLast()), null);
            } else if (value instanceof LongProgression) {
                uIntRange = new UIntRange(UInt.constructor-impl((int)((int)((LongProgression)value).getFirst())), UInt.constructor-impl((int)((int)((LongProgression)value).getLast())), null);
            } else if (value instanceof CharProgression) {
                uIntRange = new UIntRange(CharExtensions.toUInt(((CharProgression)value).getFirst()), CharExtensions.toUInt(((CharProgression)value).getLast()), null);
            } else if (value instanceof UIntProgression) {
                uIntRange = new UIntRange(((UIntProgression)value).getFirst-pVg5ArA(), ((UIntProgression)value).getLast-pVg5ArA(), null);
            } else if (value instanceof ULongProgression) {
                uIntRange = new UIntRange(UInt.constructor-impl((int)((int)((ULongProgression)value).getFirst-s-VKNKU())), UInt.constructor-impl((int)((int)((ULongProgression)value).getLast-s-VKNKU())), null);
            } else if (value instanceof Pair) {
                Object object = ((Pair)value).getFirst();
                Intrinsics.checkNotNull((Object)object);
                Object $this$convert_u24default$iv = object;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                int n = ((UInt)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl();
                Object object2 = ((Pair)value).getSecond();
                Intrinsics.checkNotNull((Object)object2);
                Object $this$convert_u24default$iv2 = object2;
                Map componentParams$iv2 = MapsKt.emptyMap();
                boolean $i$f$convert3 = false;
                Converters this_$iv$iv2 = INSTANCE;
                boolean $i$f$convert4 = false;
                boolean $i$f$javaTypeOf2 = false;
                UIntRange uIntRange2 = new UIntRange(n, ((UInt)this_$iv$iv2.convert($this$convert_u24default$iv2, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv2)).unbox-impl(), null);
                uIntRange = uIntRange2;
            } else if (value instanceof List) {
                Object e = ((List)value).get(0);
                Intrinsics.checkNotNull(e);
                Object $this$convert_u24default$iv = e;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert5 = false;
                boolean $i$f$javaTypeOf = false;
                int n = ((UInt)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl();
                Object e2 = ((List)value).get(1);
                Intrinsics.checkNotNull(e2);
                Object $this$convert_u24default$iv3 = e2;
                Map componentParams$iv3 = MapsKt.emptyMap();
                boolean $i$f$convert6 = false;
                Converters this_$iv$iv3 = INSTANCE;
                boolean $i$f$convert7 = false;
                boolean $i$f$javaTypeOf3 = false;
                UIntRange uIntRange3 = new UIntRange(n, ((UInt)this_$iv$iv3.convert($this$convert_u24default$iv3, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv3)).unbox-impl(), null);
                uIntRange = uIntRange3;
            } else if (value instanceof ClosedRange) {
                Comparable $this$convert_u24default$iv = ((ClosedRange)value).getStart();
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert8 = false;
                boolean $i$f$javaTypeOf = false;
                Comparable $this$convert_u24default$iv4 = ((ClosedRange)value).getEndInclusive();
                Map componentParams$iv4 = MapsKt.emptyMap();
                boolean $i$f$convert9 = false;
                Converters this_$iv$iv4 = INSTANCE;
                boolean $i$f$convert10 = false;
                boolean $i$f$javaTypeOf4 = false;
                UIntRange uIntRange4 = new UIntRange(((UInt)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl(), ((UInt)this_$iv$iv4.convert((Object)$this$convert_u24default$iv4, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv4)).unbox-impl(), null);
                uIntRange = uIntRange4;
            } else {
                uIntRange = value instanceof String ? this.doConvert((String)value) : this.doConvert(value.toString());
            }
            return uIntRange;
        }

        private final UIntRange doConvert(String value) {
            String[] stringArray = new String[]{".."};
            List it = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            boolean bl = false;
            Object $this$convert_u24default$iv = it.get(0);
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            Object $this$convert_u24default$iv2 = it.get(1);
            Map componentParams$iv2 = MapsKt.emptyMap();
            boolean $i$f$convert3 = false;
            Converters this_$iv$iv2 = INSTANCE;
            boolean $i$f$convert4 = false;
            boolean $i$f$javaTypeOf2 = false;
            return new UIntRange(((UInt)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl(), ((UInt)this_$iv$iv2.convert($this$convert_u24default$iv2, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv2)).unbox-impl(), null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Converters$ULongRangeConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/ranges/ULongRange;", "()V", "convert", "value", "", "doConvert", "", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static final class ULongRangeConverter
    extends AbstractConverter<ULongRange> {
        @NotNull
        public static final ULongRangeConverter INSTANCE = new ULongRangeConverter();

        private ULongRangeConverter() {
        }

        @Override
        @NotNull
        public ULongRange convert(@NotNull Object value) {
            ULongRange uLongRange;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof ULongRange) {
                uLongRange = (ULongRange)value;
            } else if (value instanceof IntProgression) {
                uLongRange = new ULongRange(ULong.constructor-impl((long)((IntProgression)value).getFirst()), ULong.constructor-impl((long)((IntProgression)value).getLast()), null);
            } else if (value instanceof LongProgression) {
                uLongRange = new ULongRange(ULong.constructor-impl((long)((LongProgression)value).getFirst()), ULong.constructor-impl((long)((LongProgression)value).getLast()), null);
            } else if (value instanceof CharProgression) {
                uLongRange = new ULongRange(CharExtensions.toULong(((CharProgression)value).getFirst()), CharExtensions.toULong(((CharProgression)value).getLast()), null);
            } else if (value instanceof UIntProgression) {
                uLongRange = new ULongRange(ULong.constructor-impl((long)((long)((UIntProgression)value).getFirst-pVg5ArA() & 0xFFFFFFFFL)), ULong.constructor-impl((long)((long)((UIntProgression)value).getLast-pVg5ArA() & 0xFFFFFFFFL)), null);
            } else if (value instanceof ULongProgression) {
                uLongRange = new ULongRange(((ULongProgression)value).getFirst-s-VKNKU(), ((ULongProgression)value).getLast-s-VKNKU(), null);
            } else if (value instanceof Pair) {
                Object object = ((Pair)value).getFirst();
                Intrinsics.checkNotNull((Object)object);
                Object $this$convert_u24default$iv = object;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert2 = false;
                boolean $i$f$javaTypeOf = false;
                long l = ((ULong)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl();
                Object object2 = ((Pair)value).getSecond();
                Intrinsics.checkNotNull((Object)object2);
                Object $this$convert_u24default$iv2 = object2;
                Map componentParams$iv2 = MapsKt.emptyMap();
                $i$f$convert2 = false;
                Converters this_$iv$iv2 = INSTANCE;
                boolean $i$f$convert3 = false;
                boolean $i$f$javaTypeOf2 = false;
                ULongRange uLongRange2 = new ULongRange(l, ((ULong)this_$iv$iv2.convert($this$convert_u24default$iv2, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv2)).unbox-impl(), null);
                uLongRange = uLongRange2;
            } else if (value instanceof List) {
                Object e = ((List)value).get(0);
                Intrinsics.checkNotNull(e);
                Object $this$convert_u24default$iv = e;
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert4 = false;
                boolean $i$f$javaTypeOf = false;
                long l = ((ULong)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl();
                Object e2 = ((List)value).get(1);
                Intrinsics.checkNotNull(e2);
                Object $this$convert_u24default$iv3 = e2;
                Map componentParams$iv3 = MapsKt.emptyMap();
                $i$f$convert4 = false;
                Converters this_$iv$iv3 = INSTANCE;
                boolean $i$f$convert5 = false;
                boolean $i$f$javaTypeOf3 = false;
                ULongRange uLongRange3 = new ULongRange(l, ((ULong)this_$iv$iv3.convert($this$convert_u24default$iv3, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv3)).unbox-impl(), null);
                uLongRange = uLongRange3;
            } else if (value instanceof ClosedRange) {
                Comparable $this$convert_u24default$iv = ((ClosedRange)value).getStart();
                Map componentParams$iv = MapsKt.emptyMap();
                boolean $i$f$convert = false;
                Converters this_$iv$iv = INSTANCE;
                boolean $i$f$convert6 = false;
                boolean $i$f$javaTypeOf = false;
                Comparable $this$convert_u24default$iv4 = ((ClosedRange)value).getEndInclusive();
                Map componentParams$iv4 = MapsKt.emptyMap();
                $i$f$convert6 = false;
                Converters this_$iv$iv4 = INSTANCE;
                boolean $i$f$convert7 = false;
                boolean $i$f$javaTypeOf4 = false;
                ULongRange uLongRange4 = new ULongRange(((ULong)this_$iv$iv.convert((Object)$this$convert_u24default$iv, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl(), ((ULong)this_$iv$iv4.convert((Object)$this$convert_u24default$iv4, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv4)).unbox-impl(), null);
                uLongRange = uLongRange4;
            } else {
                uLongRange = value instanceof String ? this.doConvert((String)value) : this.doConvert(value.toString());
            }
            return uLongRange;
        }

        private final ULongRange doConvert(String value) {
            String[] stringArray = new String[]{".."};
            List it = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            boolean bl = false;
            Object $this$convert_u24default$iv = it.get(0);
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convert = false;
            Converters this_$iv$iv = INSTANCE;
            boolean $i$f$convert2 = false;
            boolean $i$f$javaTypeOf = false;
            Object $this$convert_u24default$iv2 = it.get(1);
            Map componentParams$iv2 = MapsKt.emptyMap();
            $i$f$convert2 = false;
            Converters this_$iv$iv2 = INSTANCE;
            boolean $i$f$convert3 = false;
            boolean $i$f$javaTypeOf2 = false;
            return new ULongRange(((ULong)this_$iv$iv.convert($this$convert_u24default$iv, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv)).unbox-impl(), ((ULong)this_$iv$iv2.convert($this$convert_u24default$iv2, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv2)).unbox-impl(), null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001\u0018B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Licu/windea/breezeframework/core/component/Converters$SequenceConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Lkotlin/sequences/Sequence;", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "iterableConverter", "Licu/windea/breezeframework/core/component/Converters$IterableConverter;", "getIterableConverter", "()Licu/windea/breezeframework/core/component/Converters$IterableConverter;", "iterableConverter$delegate", "Lkotlin/Lazy;", "passingParams", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class SequenceConverter
    extends AbstractConverter<Sequence<?>>
    implements GenericConverter<Sequence<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy iterableConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;

        public SequenceConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.iterableConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IterableConverter>(this){
                final /* synthetic */ SequenceConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final IterableConverter invoke() {
                    return (IterableConverter)Converters.INSTANCE.get(Iterable.class, SequenceConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<IterableConverter>(this.this$0){
                        final /* synthetic */ SequenceConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final IterableConverter invoke() {
                            return new IterableConverter(SequenceConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.passingParams = this.componentParams;
        }

        public /* synthetic */ SequenceConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final IterableConverter getIterableConverter() {
            Lazy lazy = this.iterableConverter$delegate;
            return (IterableConverter)lazy.getValue();
        }

        @Override
        @NotNull
        public Sequence<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            return CollectionsKt.asSequence((Iterable)this.getIterableConverter().convert(value, targetType));
        }

        @Override
        @Nullable
        public Sequence<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Object object = this.getIterableConverter().convertOrNull(value, targetType);
            return object == null ? null : CollectionsKt.asSequence((Iterable)object);
        }

        @Override
        @NotNull
        public SequenceConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new SequenceConverter(componentParams);
        }

        @Override
        @NotNull
        public Sequence<?> convert(@NotNull Object value) {
            return (Sequence)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Sequence<?> convertOrNull(@NotNull Object value) {
            return (Sequence)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public SequenceConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(SequenceConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$SequenceConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$SequenceConverter;", "()V", "breeze-core"})
        public static final class Default
        extends SequenceConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000  2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003:\u0001 B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u001a\u001a\u00020\u00002\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005H\u0016J\u001c\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Licu/windea/breezeframework/core/component/Converters$StreamConverter;", "Licu/windea/breezeframework/core/component/AbstractConverter;", "Ljava/util/stream/Stream;", "Licu/windea/breezeframework/core/component/GenericConverter;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "delegate", "getDelegate", "()Ljava/lang/String;", "listConverter", "Licu/windea/breezeframework/core/component/Converters$ListConverter;", "getListConverter", "()Licu/windea/breezeframework/core/component/Converters$ListConverter;", "listConverter$delegate", "Lkotlin/Lazy;", "passingParams", "setConverter", "Licu/windea/breezeframework/core/component/Converters$SetConverter;", "getSetConverter", "()Licu/windea/breezeframework/core/component/Converters$SetConverter;", "setConverter$delegate", "componentCopy", "convert", "value", "targetType", "Ljava/lang/reflect/Type;", "convertOrNull", "Default", "breeze-core"})
    public static class StreamConverter
    extends AbstractConverter<Stream<?>>
    implements GenericConverter<Stream<?>> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Lazy listConverter$delegate;
        @NotNull
        private final Lazy setConverter$delegate;
        @NotNull
        private final Map<String, Object> passingParams;
        @NotNull
        private final String delegate;

        public StreamConverter(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            this.listConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ListConverter>(this){
                final /* synthetic */ StreamConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final ListConverter invoke() {
                    return (ListConverter)Converters.INSTANCE.get(List.class, StreamConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<ListConverter>(this.this$0){
                        final /* synthetic */ StreamConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ListConverter invoke() {
                            return new ListConverter(StreamConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            this.setConverter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SetConverter>(this){
                final /* synthetic */ StreamConverter this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final SetConverter invoke() {
                    return (SetConverter)Converters.INSTANCE.get(Set.class, StreamConverter.access$getPassingParams$p(this.this$0), (Function0)new Function0<SetConverter>(this.this$0){
                        final /* synthetic */ StreamConverter this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final SetConverter invoke() {
                            return new SetConverter(StreamConverter.access$getPassingParams$p(this.this$0));
                        }
                    });
                }
            }));
            String[] stringArray = new String[]{"delegate"};
            this.passingParams = InternalExtensions.filterNotComponentParams(this.componentParams, stringArray);
            String string = InternalExtensions.convertToStringOrNull(this.componentParams.get("delegate"));
            if (string == null) {
                string = "list";
            }
            this.delegate = string;
        }

        public /* synthetic */ StreamConverter(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        private final ListConverter getListConverter() {
            Lazy lazy = this.listConverter$delegate;
            return (ListConverter)lazy.getValue();
        }

        private final SetConverter getSetConverter() {
            Lazy lazy = this.setConverter$delegate;
            return (SetConverter)lazy.getValue();
        }

        @NotNull
        public final String getDelegate() {
            return this.delegate;
        }

        @Override
        @NotNull
        public Stream<?> convert(@NotNull Object value, @NotNull Type targetType) {
            Stream stream;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            String string = this.delegate;
            if (Intrinsics.areEqual((Object)string, (Object)"list")) {
                Stream stream2 = this.getListConverter().convert(value, targetType).stream();
                Intrinsics.checkNotNullExpressionValue(stream2, (String)"listConverter.convert(value, targetType).stream()");
                stream = stream2;
            } else if (Intrinsics.areEqual((Object)string, (Object)"set")) {
                Stream stream3 = this.getSetConverter().convert(value, targetType).stream();
                Intrinsics.checkNotNullExpressionValue(stream3, (String)"setConverter.convert(value, targetType).stream()");
                stream = stream3;
            } else {
                throw new IllegalArgumentException("Config param 'delegate' must be one of: list, set.");
            }
            return stream;
        }

        @Override
        @Nullable
        public Stream<?> convertOrNull(@NotNull Object value, @NotNull Type targetType) {
            Stream<Object> stream;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            String string = this.delegate;
            if (Intrinsics.areEqual((Object)string, (Object)"list")) {
                List list = (List)this.getListConverter().convertOrNull(value, targetType);
                stream = list == null ? null : list.stream();
            } else if (Intrinsics.areEqual((Object)string, (Object)"set")) {
                Set set = (Set)this.getSetConverter().convertOrNull(value, targetType);
                stream = set == null ? null : set.stream();
            } else {
                throw new IllegalArgumentException("Config param 'delegate' must be one of: list, set.");
            }
            return stream;
        }

        @Override
        @NotNull
        public StreamConverter componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new StreamConverter(componentParams);
        }

        @Override
        @NotNull
        public Stream<?> convert(@NotNull Object value) {
            return (Stream)GenericConverter.DefaultImpls.convert(this, value);
        }

        @Override
        @Nullable
        public Stream<?> convertOrNull(@NotNull Object value) {
            return (Stream)GenericConverter.DefaultImpls.convertOrNull(this, value);
        }

        public StreamConverter() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Map access$getPassingParams$p(StreamConverter $this) {
            return $this.passingParams;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Converters$StreamConverter$Default;", "Licu/windea/breezeframework/core/component/Converters$StreamConverter;", "()V", "breeze-core"})
        public static final class Default
        extends StreamConverter {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

