/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.component.AbstractEncoder;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.Encoder;
import icu.windea.breezeframework.core.extension.StringExtensions;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0006\u0007\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Licu/windea/breezeframework/core/component/Encoders;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/Encoder;", "()V", "registerDefault", "", "Base64Encoder", "Base64MimeEncoder", "Base64UrlEncoder", "HexEncoder", "UrlEncoder", "breeze-core"})
public final class Encoders
extends ComponentRegistry<Encoder> {
    @NotNull
    public static final Encoders INSTANCE = new Encoders();

    private Encoders() {
    }

    @Override
    protected void registerDefault() {
        this.register((Component)Base64Encoder.INSTANCE);
        this.register((Component)Base64UrlEncoder.INSTANCE);
        this.register((Component)Base64MimeEncoder.INSTANCE);
        this.register((Component)UrlEncoder.INSTANCE);
        this.register((Component)HexEncoder.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoders$Base64Encoder;", "Licu/windea/breezeframework/core/component/AbstractEncoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class Base64Encoder
    extends AbstractEncoder {
        @NotNull
        public static final Base64Encoder INSTANCE = new Base64Encoder();

        private Base64Encoder() {
        }

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Base64.Encoder encoder = Base64.getEncoder();
            byte[] byArray = value.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String string = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEncoder().encodeToStr\u2026lue.toByteArray(charset))");
            return string;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] it = Base64.getDecoder().decode(value);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byte[] byArray = it;
            return new String(byArray, charset);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoders$Base64UrlEncoder;", "Licu/windea/breezeframework/core/component/AbstractEncoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class Base64UrlEncoder
    extends AbstractEncoder {
        @NotNull
        public static final Base64UrlEncoder INSTANCE = new Base64UrlEncoder();

        private Base64UrlEncoder() {
        }

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Base64.Encoder encoder = Base64.getUrlEncoder();
            byte[] byArray = value.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String string = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlEncoder().encodeTo\u2026lue.toByteArray(charset))");
            return string;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] it = Base64.getUrlDecoder().decode(value);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byte[] byArray = it;
            return new String(byArray, charset);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoders$Base64MimeEncoder;", "Licu/windea/breezeframework/core/component/AbstractEncoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class Base64MimeEncoder
    extends AbstractEncoder {
        @NotNull
        public static final Base64MimeEncoder INSTANCE = new Base64MimeEncoder();

        private Base64MimeEncoder() {
        }

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            Base64.Encoder encoder = Base64.getMimeEncoder();
            byte[] byArray = value.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String string = encoder.encodeToString(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMimeEncoder().encodeT\u2026lue.toByteArray(charset))");
            return string;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            byte[] it = Base64.getMimeDecoder().decode(value);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            byte[] byArray = it;
            return new String(byArray, charset);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoders$UrlEncoder;", "Licu/windea/breezeframework/core/component/AbstractEncoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class UrlEncoder
    extends AbstractEncoder {
        @NotNull
        public static final UrlEncoder INSTANCE = new UrlEncoder();

        private UrlEncoder() {
        }

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = URLEncoder.encode(value, charset.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(value, charset.name())");
            return string;
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            String string = URLDecoder.decode(value, charset.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(value, charset.name())");
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Encoders$HexEncoder;", "Licu/windea/breezeframework/core/component/AbstractEncoder;", "()V", "decode", "", "value", "charset", "Ljava/nio/charset/Charset;", "encode", "breeze-core"})
    public static final class HexEncoder
    extends AbstractEncoder {
        @NotNull
        public static final HexEncoder INSTANCE = new HexEncoder();

        private HexEncoder() {
        }

        @Override
        @NotNull
        public String encode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return StringExtensions.hex(value, charset);
        }

        @Override
        @NotNull
        public String decode(@NotNull String value, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return StringExtensions.unhex(value, charset);
        }
    }
}

