/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.component.AbstractEncrypter;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.Encrypter;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\n\u0006\u0007\b\t\n\u000b\f\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0010"}, d2={"Licu/windea/breezeframework/core/component/Encrypters;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/Encrypter;", "()V", "registerDefault", "", "AesEncrypter", "CipherEncrypter", "DesEncrypter", "Md5Encrypter", "MessageDigestEncrypter", "Sha3_256Encrypter", "Sha3_512Encrypter", "Sha_1Encrypter", "Sha_256Encrypter", "Sha_512Encrypter", "breeze-core"})
public final class Encrypters
extends ComponentRegistry<Encrypter> {
    @NotNull
    public static final Encrypters INSTANCE = new Encrypters();

    private Encrypters() {
    }

    @Override
    protected void registerDefault() {
        this.register((Component)DesEncrypter.INSTANCE);
        this.register((Component)AesEncrypter.INSTANCE);
        this.register((Component)Md5Encrypter.INSTANCE);
        this.register((Component)Sha_1Encrypter.INSTANCE);
        this.register((Component)Sha_256Encrypter.INSTANCE);
        this.register((Component)Sha_512Encrypter.INSTANCE);
        this.register((Component)Sha3_256Encrypter.INSTANCE);
        this.register((Component)Sha3_512Encrypter.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$CipherEncrypter;", "Licu/windea/breezeframework/core/component/AbstractEncrypter;", "transformation", "", "(Ljava/lang/String;)V", "cipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "getTransformation", "()Ljava/lang/String;", "decrypt", "", "value", "secret", "encrypt", "breeze-core"})
    public static class CipherEncrypter
    extends AbstractEncrypter {
        @NotNull
        private final String transformation;
        private final Cipher cipher;

        public CipherEncrypter(@NotNull String transformation) {
            Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
            this.transformation = transformation;
            this.cipher = Cipher.getInstance(this.transformation);
        }

        @NotNull
        public final String getTransformation() {
            return this.transformation;
        }

        @Override
        @NotNull
        public byte[] encrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] byArray = secret;
            if (secret == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            SecretKeySpec keySpec = new SecretKeySpec(secret, this.transformation);
            if (StringsKt.contains$default((CharSequence)this.transformation, (CharSequence)"CBC", (boolean)false, (int)2, null)) {
                this.cipher.init(1, (Key)keySpec, new IvParameterSpec(secret));
            } else {
                this.cipher.init(1, keySpec);
            }
            byte[] byArray2 = this.cipher.doFinal(value);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(value)");
            return byArray2;
        }

        @Override
        @NotNull
        public byte[] decrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] byArray = secret;
            if (secret == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            SecretKeySpec keySpec = new SecretKeySpec(secret, this.transformation);
            if (StringsKt.contains$default((CharSequence)this.transformation, (CharSequence)"CBC", (boolean)false, (int)2, null)) {
                this.cipher.init(2, (Key)keySpec, new IvParameterSpec(secret));
            } else {
                this.cipher.init(2, keySpec);
            }
            byte[] byArray2 = this.cipher.doFinal(value);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(value)");
            return byArray2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$DesEncrypter;", "Licu/windea/breezeframework/core/component/Encrypters$CipherEncrypter;", "()V", "breeze-core"})
    public static final class DesEncrypter
    extends CipherEncrypter {
        @NotNull
        public static final DesEncrypter INSTANCE = new DesEncrypter();

        private DesEncrypter() {
            super("DES");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$AesEncrypter;", "Licu/windea/breezeframework/core/component/Encrypters$CipherEncrypter;", "()V", "breeze-core"})
    public static final class AesEncrypter
    extends CipherEncrypter {
        @NotNull
        public static final AesEncrypter INSTANCE = new AesEncrypter();

        private AesEncrypter() {
            super("AES");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$MessageDigestEncrypter;", "Licu/windea/breezeframework/core/component/AbstractEncrypter;", "algorithm", "", "(Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "messageDigest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "decrypt", "", "value", "secret", "encrypt", "breeze-core"})
    public static class MessageDigestEncrypter
    extends AbstractEncrypter {
        @NotNull
        private final String algorithm;
        private final MessageDigest messageDigest;

        public MessageDigestEncrypter(@NotNull String algorithm) {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            this.algorithm = algorithm;
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }

        @NotNull
        public final String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @NotNull
        public byte[] encrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] byArray = this.messageDigest.digest(value);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest(value)");
            return byArray;
        }

        @Override
        @NotNull
        public byte[] decrypt(@NotNull byte[] value, @Nullable byte[] secret) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            throw new UnsupportedOperationException("Decrypt operation is not supported by message digest encrypter.");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$Md5Encrypter;", "Licu/windea/breezeframework/core/component/Encrypters$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Md5Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Md5Encrypter INSTANCE = new Md5Encrypter();

        private Md5Encrypter() {
            super("MD5");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$Sha_1Encrypter;", "Licu/windea/breezeframework/core/component/Encrypters$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha_1Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha_1Encrypter INSTANCE = new Sha_1Encrypter();

        private Sha_1Encrypter() {
            super("SHA-1");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$Sha_256Encrypter;", "Licu/windea/breezeframework/core/component/Encrypters$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha_256Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha_256Encrypter INSTANCE = new Sha_256Encrypter();

        private Sha_256Encrypter() {
            super("SHA-256");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$Sha_512Encrypter;", "Licu/windea/breezeframework/core/component/Encrypters$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha_512Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha_512Encrypter INSTANCE = new Sha_512Encrypter();

        private Sha_512Encrypter() {
            super("SHA3-512");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$Sha3_256Encrypter;", "Licu/windea/breezeframework/core/component/Encrypters$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha3_256Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha3_256Encrypter INSTANCE = new Sha3_256Encrypter();

        private Sha3_256Encrypter() {
            super("SHA3-256");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Encrypters$Sha3_512Encrypter;", "Licu/windea/breezeframework/core/component/Encrypters$MessageDigestEncrypter;", "()V", "breeze-core"})
    public static final class Sha3_512Encrypter
    extends MessageDigestEncrypter {
        @NotNull
        public static final Sha3_512Encrypter INSTANCE = new Sha3_512Encrypter();

        private Sha3_512Encrypter() {
            super("SHA3-512");
        }
    }
}

