/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.component.AbstractEscaper;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.Escaper;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\f\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0012"}, d2={"Licu/windea/breezeframework/core/component/Escapers;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/Escaper;", "()V", "registerDefault", "", "DefaultLineBreakEscaper", "HtmlEscaper", "HtmlLineBreakEscaper", "JavaEscaper", "JavaScriptEscaper", "JsonEscaper", "KotlinEscaper", "LanguageEscaper", "LineBreakEscaper", "XmlAttributeEscaper", "XmlContentEscaper", "XmlEscaper", "breeze-core"})
public final class Escapers
extends ComponentRegistry<Escaper> {
    @NotNull
    public static final Escapers INSTANCE = new Escapers();

    private Escapers() {
    }

    @Override
    protected void registerDefault() {
        this.register((Component)KotlinEscaper.INSTANCE);
        this.register((Component)JavaEscaper.INSTANCE);
        this.register((Component)JavaScriptEscaper.INSTANCE);
        this.register((Component)JsonEscaper.INSTANCE);
        this.register((Component)XmlEscaper.INSTANCE);
        this.register((Component)XmlAttributeEscaper.INSTANCE);
        this.register((Component)XmlContentEscaper.INSTANCE);
        this.register((Component)HtmlEscaper.INSTANCE);
        this.register((Component)DefaultLineBreakEscaper.INSTANCE);
        this.register((Component)HtmlLineBreakEscaper.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "Licu/windea/breezeframework/core/component/AbstractEscaper;", "()V", "escapeBackSlash", "", "getEscapeBackSlash", "()Z", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "escape", "value", "unescape", "breeze-core"})
    public static abstract class LanguageEscaper
    extends AbstractEscaper {
        private final boolean escapeBackSlash;

        public LanguageEscaper() {
            this.escapeBackSlash = true;
        }

        @NotNull
        protected abstract char[] getEscapeChars();

        @NotNull
        protected abstract String[] getEscapedStrings();

        protected final boolean getEscapeBackSlash() {
            return this.escapeBackSlash;
        }

        @Override
        @NotNull
        public String escape(@NotNull String value) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StringBuilder $this$escape_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = value.length();
            for (int i = 0; i < n; ++i) {
                char c = value.charAt(i);
                int index = ArraysKt.indexOf((char[])this.getEscapeChars(), (char)c);
                if (index != -1) {
                    $this$escape_u24lambda_u2d0.append(this.getEscapedStrings()[index]);
                    continue;
                }
                if (this.getEscapeBackSlash() && c == '\\') {
                    $this$escape_u24lambda_u2d0.append("\\\\");
                    continue;
                }
                $this$escape_u24lambda_u2d0.append(c);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @Override
        @NotNull
        public String unescape(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String result = value;
            if (this.escapeBackSlash) {
                result = StringsKt.replace$default((String)result, (String)"\\\\", (String)"\\", (boolean)false, (int)4, null);
            }
            int size = this.getEscapeChars().length;
            int n = 0;
            while (n < size) {
                int i = n++;
                result = StringsKt.replace$default((String)result, (String)this.getEscapedStrings()[i], (String)String.valueOf(this.getEscapeChars()[i]), (boolean)false, (int)4, null);
            }
            return result;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$KotlinEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class KotlinEscaper
    extends LanguageEscaper {
        @NotNull
        public static final KotlinEscaper INSTANCE = new KotlinEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private KotlinEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'\n', '\r', '\t', '\b', '\'', '\"', '$'};
            escapeChars = objectArray;
            objectArray = new String[7];
            objectArray[0] = (char)"\\n";
            objectArray[1] = (char)"\\r";
            objectArray[2] = (char)"\\t";
            objectArray[3] = (char)"\\b";
            objectArray[4] = (char)"\\'";
            objectArray[5] = (char)"\\\"";
            objectArray[6] = (char)"\\$";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$JavaEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class JavaEscaper
    extends LanguageEscaper {
        @NotNull
        public static final JavaEscaper INSTANCE = new JavaEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private JavaEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'\n', '\r', '\t', '\b', '\'', '\"'};
            escapeChars = objectArray;
            objectArray = new String[6];
            objectArray[0] = (char)"\\n";
            objectArray[1] = (char)"\\r";
            objectArray[2] = (char)"\\t";
            objectArray[3] = (char)"\\b";
            objectArray[4] = (char)"\\'";
            objectArray[5] = (char)"\\\"";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$JavaScriptEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class JavaScriptEscaper
    extends LanguageEscaper {
        @NotNull
        public static final JavaScriptEscaper INSTANCE = new JavaScriptEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private JavaScriptEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'\n', '\r', '\t', '\b', '\'', '\"'};
            escapeChars = objectArray;
            objectArray = new String[6];
            objectArray[0] = (char)"\\n";
            objectArray[1] = (char)"\\r";
            objectArray[2] = (char)"\\t";
            objectArray[3] = (char)"\b";
            objectArray[4] = (char)"\\'";
            objectArray[5] = (char)"\\\"";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$JsonEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class JsonEscaper
    extends LanguageEscaper {
        @NotNull
        public static final JsonEscaper INSTANCE = new JsonEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private JsonEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'\t', '\b', '\n', '\r', '\"'};
            escapeChars = objectArray;
            objectArray = new String[5];
            objectArray[0] = (char)"\\t";
            objectArray[1] = (char)"\\b";
            objectArray[2] = (char)"\\n";
            objectArray[3] = (char)"\\r";
            objectArray[4] = (char)"\\\"";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$XmlEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class XmlEscaper
    extends LanguageEscaper {
        @NotNull
        public static final XmlEscaper INSTANCE = new XmlEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private XmlEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'<', '>', '&', '\'', '\"'};
            escapeChars = objectArray;
            objectArray = new String[5];
            objectArray[0] = (char)"&lt;";
            objectArray[1] = (char)"&gt;";
            objectArray[2] = (char)"&amp;";
            objectArray[3] = (char)"&apos;";
            objectArray[4] = (char)"&quot;";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$XmlAttributeEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class XmlAttributeEscaper
    extends LanguageEscaper {
        @NotNull
        public static final XmlAttributeEscaper INSTANCE = new XmlAttributeEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private XmlAttributeEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'<', '>', '&', '\'', '\"', '\n', '\r', '\t'};
            escapeChars = objectArray;
            objectArray = new String[8];
            objectArray[0] = (char)"&lt;";
            objectArray[1] = (char)"&gt;";
            objectArray[2] = (char)"&amp;";
            objectArray[3] = (char)"&apos;";
            objectArray[4] = (char)"&quot;";
            objectArray[5] = (char)"&#xA;";
            objectArray[6] = (char)"&#xD";
            objectArray[7] = (char)"&#x9";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$XmlContentEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class XmlContentEscaper
    extends LanguageEscaper {
        @NotNull
        public static final XmlContentEscaper INSTANCE = new XmlContentEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private XmlContentEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'<', '>', '&'};
            escapeChars = objectArray;
            objectArray = new String[3];
            objectArray[0] = (char)"&lt;";
            objectArray[1] = (char)"&gt;";
            objectArray[2] = (char)"amp;";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Licu/windea/breezeframework/core/component/Escapers$HtmlEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LanguageEscaper;", "()V", "escapeChars", "", "getEscapeChars", "()[C", "escapedStrings", "", "", "getEscapedStrings", "()[Ljava/lang/String;", "[Ljava/lang/String;", "breeze-core"})
    public static final class HtmlEscaper
    extends LanguageEscaper {
        @NotNull
        public static final HtmlEscaper INSTANCE = new HtmlEscaper();
        @NotNull
        private static final char[] escapeChars;
        @NotNull
        private static final String[] escapedStrings;

        private HtmlEscaper() {
        }

        @Override
        @NotNull
        protected char[] getEscapeChars() {
            return escapeChars;
        }

        @Override
        @NotNull
        protected String[] getEscapedStrings() {
            return escapedStrings;
        }

        static {
            Object[] objectArray = new char[]{'<', '>', '&', '\'', '\"'};
            escapeChars = objectArray;
            objectArray = new String[5];
            objectArray[0] = (char)"&lt;";
            objectArray[1] = (char)"&gt;";
            objectArray[2] = (char)"&amp;";
            objectArray[3] = (char)"&apos;";
            objectArray[4] = (char)"&quot;";
            escapedStrings = (String[])objectArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/Escapers$LineBreakEscaper;", "Licu/windea/breezeframework/core/component/AbstractEscaper;", "()V", "breeze-core"})
    public static abstract class LineBreakEscaper
    extends AbstractEscaper {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/Escapers$DefaultLineBreakEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LineBreakEscaper;", "()V", "escape", "", "value", "unescape", "breeze-core"})
    public static final class DefaultLineBreakEscaper
    extends LineBreakEscaper {
        @NotNull
        public static final DefaultLineBreakEscaper INSTANCE = new DefaultLineBreakEscaper();

        private DefaultLineBreakEscaper() {
        }

        @Override
        @NotNull
        public String escape(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return StringsKt.replace$default((String)value, (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return StringsKt.replace$default((String)value, (String)"\\n", (String)"\n", (boolean)false, (int)4, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Escapers$HtmlLineBreakEscaper;", "Licu/windea/breezeframework/core/component/Escapers$LineBreakEscaper;", "()V", "escapedTag", "", "escape", "value", "unescape", "breeze-core"})
    public static final class HtmlLineBreakEscaper
    extends LineBreakEscaper {
        @NotNull
        public static final HtmlLineBreakEscaper INSTANCE = new HtmlLineBreakEscaper();
        @NotNull
        private static final String escapedTag = "<br>";

        private HtmlLineBreakEscaper() {
        }

        @Override
        @NotNull
        public String escape(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return StringsKt.replace$default((String)value, (String)"\n", (String)escapedTag, (boolean)false, (int)4, null);
        }

        @Override
        @NotNull
        public String unescape(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return StringsKt.replace((String)value, (String)escapedTag, (String)"\n", (boolean)true);
        }
    }
}

