/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.component.AbstractPathFormat;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.PathFormat;
import icu.windea.breezeframework.core.component.Queriers;
import icu.windea.breezeframework.core.extension.CollectionExtensions;
import icu.windea.breezeframework.core.extension.StringExtensions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0006\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/PathFormats;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/PathFormat;", "()V", "registerDefault", "", "AntPath", "JsonPointerPath", "ReferencePath", "StandardPath", "breeze-core"})
public final class PathFormats
extends ComponentRegistry<PathFormat> {
    @NotNull
    public static final PathFormats INSTANCE = new PathFormats();

    private PathFormats() {
    }

    @Override
    protected void registerDefault() {
        this.register((Component)StandardPath.INSTANCE);
        this.register((Component)JsonPointerPath.INSTANCE);
        this.register((Component)AntPath.INSTANCE);
        this.register((Component)ReferencePath.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/PathFormats$StandardPath;", "Licu/windea/breezeframework/core/component/AbstractPathFormat;", "()V", "breeze-core"})
    public static final class StandardPath
    extends AbstractPathFormat {
        @NotNull
        public static final StandardPath INSTANCE = new StandardPath();

        private StandardPath() {
            super('\u0000', null, '\u0000', null, 15, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/PathFormats$JsonPointerPath;", "Licu/windea/breezeframework/core/component/AbstractPathFormat;", "()V", "breeze-core"})
    public static final class JsonPointerPath
    extends AbstractPathFormat {
        @NotNull
        public static final JsonPointerPath INSTANCE = new JsonPointerPath();

        private JsonPointerPath() {
            super('\u0000', null, '\u0000', null, 15, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J%\u0010\u0013\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0015\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Licu/windea/breezeframework/core/component/PathFormats$AntPath;", "Licu/windea/breezeframework/core/component/AbstractPathFormat;", "()V", "singleWildcard", "", "wildCard", "getOrElse", "T", "value", "", "path", "", "defaultValue", "Lkotlin/Function0;", "(Ljava/lang/Object;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getOrNull", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "matches", "", "metaGet", "metaQuery", "", "query", "resolveVariables", "", "breeze-core"})
    public static final class AntPath
    extends AbstractPathFormat {
        @NotNull
        public static final AntPath INSTANCE = new AntPath();
        private static final char singleWildcard = '?';
        private static final char wildCard = '*';

        private AntPath() {
            super('\u0000', null, '\u0000', null, 15, null);
        }

        @Override
        public boolean matches(@NotNull String value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            int pathIndex = 0;
            int valueIndex = 0;
            int lastPathIndex = StringsKt.getLastIndex((CharSequence)path);
            int lastValueIndex = StringsKt.getLastIndex((CharSequence)value);
            while (pathIndex <= lastPathIndex && valueIndex <= lastValueIndex) {
                int n;
                char pathChar = path.charAt(pathIndex);
                if (pathChar == this.getDelimiter() && pathIndex < lastPathIndex && path.charAt(pathIndex + 1) == this.getVariablePrefix()) {
                    while ((valueIndex = (n = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != this.getDelimiter()) {
                    }
                    while ((pathIndex = (n = pathIndex) + 1) <= lastPathIndex && path.charAt(pathIndex) != this.getDelimiter()) {
                    }
                    if (this.getVariableSuffix() == null) continue;
                    Character c = this.getVariableSuffix();
                    if (c != null && path.charAt(pathIndex - 1) == c.charValue()) continue;
                    throw new IllegalArgumentException("Invalid path '" + path + "': mismatched variable prefix and suffix.");
                }
                if (pathChar == '*' && pathIndex < lastPathIndex && path.charAt(pathIndex + 1) == '*') {
                    if ((pathIndex += 2) > lastPathIndex) {
                        return true;
                    }
                    while ((valueIndex = (n = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != path.charAt(pathIndex)) {
                    }
                    continue;
                }
                if (pathChar == '*') {
                    if (++pathIndex > lastPathIndex) {
                        return true;
                    }
                    while ((valueIndex = (n = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != this.getDelimiter() && value.charAt(valueIndex) != path.charAt(pathIndex)) {
                    }
                    continue;
                }
                if (pathChar == '?') {
                    n = pathIndex;
                    pathIndex = n + 1;
                    n = valueIndex;
                    valueIndex = n + 1;
                    continue;
                }
                if (pathChar != value.charAt(valueIndex)) {
                    return false;
                }
                n = pathIndex;
                pathIndex = n + 1;
                n = valueIndex;
                valueIndex = n + 1;
            }
            return pathIndex - lastPathIndex == valueIndex - lastValueIndex ? true : (pathIndex == lastPathIndex && path.charAt(pathIndex) == '*' ? true : pathIndex == lastPathIndex - 1 && path.charAt(pathIndex) == '*' && path.charAt(pathIndex + 1) == '*');
        }

        @Override
        @NotNull
        public Map<String, String> resolveVariables(@NotNull String value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Map variables = new LinkedHashMap();
            int pathIndex = 0;
            int valueIndex = 0;
            int lastPathIndex = StringsKt.getLastIndex((CharSequence)path);
            int lastValueIndex = StringsKt.getLastIndex((CharSequence)value);
            while (pathIndex <= lastPathIndex && valueIndex <= lastValueIndex) {
                int n;
                char pathChar = path.charAt(pathIndex);
                if (pathChar == this.getDelimiter() && pathIndex < lastPathIndex && path.charAt(pathIndex + 1) == this.getVariablePrefix()) {
                    int n2;
                    int variableNameStartIndex = pathIndex + 2;
                    int variableValueStartIndex = valueIndex + 1;
                    while ((pathIndex = (n2 = pathIndex) + 1) <= lastPathIndex && path.charAt(pathIndex) != this.getDelimiter()) {
                    }
                    while ((valueIndex = (n2 = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != this.getDelimiter()) {
                    }
                    if (this.getVariableSuffix() != null) {
                        Character c = this.getVariableSuffix();
                        if (c == null || path.charAt(pathIndex - 1) != c.charValue()) {
                            throw new IllegalArgumentException("Invalid path '" + path + "': mismatched variable prefix and suffix.");
                        }
                    }
                    int variableNameEndIndex = pathIndex - 1;
                    int variableValueEndIndex = valueIndex;
                    String string = path.substring(variableNameStartIndex, variableNameEndIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String variableName = string;
                    String string2 = value.substring(variableValueStartIndex, variableValueEndIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String variableValue = string2;
                    variables.put(variableName, variableValue);
                    continue;
                }
                if (pathChar == '*' && pathIndex < lastPathIndex && path.charAt(pathIndex + 1) == '*') {
                    if ((pathIndex += 2) > lastPathIndex) {
                        return variables;
                    }
                    while ((valueIndex = (n = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != path.charAt(pathIndex)) {
                    }
                    continue;
                }
                if (pathChar == '*') {
                    if (++pathIndex > lastPathIndex) {
                        return variables;
                    }
                    while ((valueIndex = (n = valueIndex) + 1) <= lastValueIndex && value.charAt(valueIndex) != this.getDelimiter() && value.charAt(valueIndex) != path.charAt(pathIndex)) {
                    }
                    continue;
                }
                if (pathChar == '?') {
                    n = pathIndex;
                    pathIndex = n + 1;
                    n = valueIndex;
                    valueIndex = n + 1;
                    continue;
                }
                if (pathChar != value.charAt(valueIndex)) {
                    return MapsKt.emptyMap();
                }
                n = pathIndex;
                pathIndex = n + 1;
                n = valueIndex;
                valueIndex = n + 1;
            }
            return pathIndex - lastPathIndex == valueIndex - lastValueIndex ? variables : (pathIndex == lastPathIndex && path.charAt(pathIndex) == '*' ? variables : (pathIndex == lastPathIndex - 1 && path.charAt(pathIndex) == '*' && path.charAt(pathIndex + 1) == '*' ? variables : MapsKt.emptyMap()));
        }

        @Override
        @NotNull
        protected <T> List<T> metaQuery(@NotNull Object value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            throw new UnsupportedOperationException("Query operation is not supported by ant path.");
        }

        @Override
        @NotNull
        public <T> List<T> query(@NotNull Object value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            throw new UnsupportedOperationException("Query operation is not supported by ant path.");
        }

        @Override
        @Nullable
        protected <T> T metaGet(@NotNull Object value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            throw new UnsupportedOperationException("Get operation is not supported by ant path.");
        }

        @Override
        @Nullable
        public <T> T getOrNull(@NotNull Object value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            throw new UnsupportedOperationException("Get operation is not supported by ant path.");
        }

        @Override
        public <T> T getOrElse(@NotNull Object value, @NotNull String path, @NotNull Function0<? extends T> defaultValue) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            throw new UnsupportedOperationException("Get operation is not supported by ant path.");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J%\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010\"\u0004\b\u0000\u0010\f2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/PathFormats$ReferencePath;", "Licu/windea/breezeframework/core/component/AbstractPathFormat;", "()V", "indexPrefix", "", "indexSuffix", "matches", "", "value", "", "path", "metaGet", "T", "", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "metaQuery", "", "normalize", "resolveVariables", "", "breeze-core"})
    public static final class ReferencePath
    extends AbstractPathFormat {
        @NotNull
        public static final ReferencePath INSTANCE = new ReferencePath();
        private static final char indexPrefix = '[';
        private static final char indexSuffix = ']';

        private ReferencePath() {
            super('.', "", '\u0000', null, 12, null);
        }

        @Override
        @NotNull
        public String normalize(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object = new StringBuilder();
            StringBuilder $this$normalize_u24lambda_u2d0 = object;
            boolean bl = false;
            int n = path.length();
            for (int i = 0; i < n; ++i) {
                char c = path.charAt(i);
                if (c != '[') continue;
                $this$normalize_u24lambda_u2d0.append('.').append(c);
            }
            String string = ((StringBuilder)object).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            object = new char[1];
            object[0] = 46;
            return StringsKt.trimStart((String)string, (char[])object);
        }

        @Override
        public boolean matches(@NotNull String value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Intrinsics.areEqual((Object)this.normalize(value), (Object)this.normalize(path));
        }

        @Override
        @NotNull
        public Map<String, String> resolveVariables(@NotNull String value, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            throw new UnsupportedOperationException("Resolve variables operation is not supported by reference path.");
        }

        @Override
        @NotNull
        protected <T> List<T> metaQuery(@NotNull Object value, @NotNull String path) {
            List list;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (StringExtensions.surroundsWith$default((CharSequence)path, '[', ']', false, 4, null)) {
                List list2;
                String string = path.substring(1, path.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                int index = Integer.parseInt(string);
                Object r = Queriers.IndexQuerier.INSTANCE.queryOrNull(value, index);
                List list3 = list2 = r == null ? null : CollectionExtensions.toSingletonList$default(r, false, 1, null);
                list = list2 == null ? CollectionsKt.emptyList() : list2;
            } else {
                Object r = Queriers.StringQuerier.INSTANCE.queryOrNull(value, StringsKt.removePrefix((String)path, (CharSequence)this.getPrefix()));
                List list4 = r == null ? null : CollectionExtensions.toSingletonList$default(r, false, 1, null);
                list = list4 == null ? CollectionsKt.emptyList() : list4;
            }
            return list;
        }

        @Override
        @Nullable
        protected <T> T metaGet(@NotNull Object value, @NotNull String path) {
            Object r;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (StringExtensions.surroundsWith$default((CharSequence)path, '[', ']', false, 4, null)) {
                String string = path.substring(1, path.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                int index = Integer.parseInt(string);
                r = Queriers.IndexQuerier.INSTANCE.queryOrNull(value, index);
            } else {
                r = Queriers.StringQuerier.INSTANCE.queryOrNull(value, StringsKt.removePrefix((String)path, (CharSequence)this.getPrefix()));
            }
            return (T)r;
        }
    }
}

