/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.annotation.InternalApi;
import icu.windea.breezeframework.core.component.AbstractQuerier;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.Querier;
import icu.windea.breezeframework.core.extension.InternalExtensions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001:\n\u0006\u0007\b\t\n\u000b\f\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0010"}, d2={"Licu/windea/breezeframework/core/component/Queriers;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/Querier;", "()V", "registerDefault", "", "FilterableResultsQuerier", "FirstResultQuerier", "IndexQuerier", "IndexRangeQuerier", "LastResultQuerier", "ReflectionMemberQuerier", "ReflectionQuerier", "RegexQuerier", "ResultsQuerier", "StringQuerier", "breeze-core"})
public final class Queriers
extends ComponentRegistry<Querier<?, ?>> {
    @NotNull
    public static final Queriers INSTANCE = new Queriers();

    private Queriers() {
    }

    @Override
    protected void registerDefault() {
        this.register((Component)ResultsQuerier.INSTANCE);
        this.register((Component)FilterableResultsQuerier.INSTANCE);
        this.register((Component)FirstResultQuerier.INSTANCE);
        this.register((Component)LastResultQuerier.INSTANCE);
        this.register((Component)StringQuerier.INSTANCE);
        this.register((Component)RegexQuerier.INSTANCE);
        this.register((Component)IndexQuerier.INSTANCE);
        this.register((Component)IndexRangeQuerier.INSTANCE);
        this.register((Component)ReflectionQuerier.INSTANCE);
        this.register((Component)ReflectionMemberQuerier.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Queriers$ResultsQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "", "", "", "()V", "query", "value", "queryObject", "breeze-core"})
    public static final class ResultsQuerier
    extends AbstractQuerier<String, List<? extends Object>> {
        @NotNull
        public static final ResultsQuerier INSTANCE = new ResultsQuerier();

        private ResultsQuerier() {
        }

        @Override
        @NotNull
        public List<Object> query(@NotNull Object value, @NotNull String queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                List list;
                object = value;
                if (object instanceof Object[]) {
                    list = ArraysKt.toList((Object[])((Object[])value));
                } else if (object instanceof List) {
                    list = (List)value;
                } else if (object instanceof Iterable) {
                    list = CollectionsKt.toList((Iterable)((Iterable)value));
                } else if (object instanceof Sequence) {
                    list = SequencesKt.toList((Sequence)((Sequence)value));
                } else if (object instanceof Map) {
                    list = CollectionsKt.toList((Iterable)((Map)value).values());
                } else {
                    throw new UnsupportedOperationException("Invalid for query " + value.getClass().getSimpleName() + " by query results.");
                }
                object = list;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query '" + value.getClass().getSimpleName() + "' by query results.", e);
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002$\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00050\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00052\u0006\u0010\b\u001a\u00020\u00032\u0014\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/Queriers$FilterableResultsQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "Lkotlin/Function1;", "", "", "", "()V", "query", "value", "queryObject", "breeze-core"})
    public static final class FilterableResultsQuerier
    extends AbstractQuerier<Function1<? super Object, ? extends Boolean>, List<? extends Object>> {
        @NotNull
        public static final FilterableResultsQuerier INSTANCE = new FilterableResultsQuerier();

        private FilterableResultsQuerier() {
        }

        @Override
        @NotNull
        public List<Object> query(@NotNull Object value, @NotNull Function1<Object, Boolean> queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(queryObject, (String)"queryObject");
            try {
                Object object2;
                List list;
                Object $this$filterTo$iv$iv;
                boolean $i$f$filterTo;
                Collection destination$iv$iv;
                boolean $i$f$filter;
                Object $this$filter$iv;
                object = value;
                if (object instanceof Object[]) {
                    $this$filter$iv = (Object[])value;
                    $i$f$filter = false;
                    Object[] objectArray = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        if (!((Boolean)queryObject.invoke(element$iv$iv)).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else if (object instanceof List) {
                    $this$filter$iv = (Iterable)value;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    object2 = $this$filterTo$iv$iv.iterator();
                    while (object2.hasNext()) {
                        Object element$iv$iv = object2.next();
                        if (!((Boolean)queryObject.invoke(element$iv$iv)).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else if (object instanceof Iterable) {
                    $this$filter$iv = (Iterable)value;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    object2 = $this$filterTo$iv$iv.iterator();
                    while (object2.hasNext()) {
                        Object element$iv$iv = object2.next();
                        if (!((Boolean)queryObject.invoke(element$iv$iv)).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else if (object instanceof Sequence) {
                    list = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)value), queryObject));
                } else if (object instanceof Map) {
                    $this$filter$iv = ((Map)value).values();
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    object2 = $this$filterTo$iv$iv.iterator();
                    while (object2.hasNext()) {
                        Object element$iv$iv = object2.next();
                        if (!((Boolean)queryObject.invoke(element$iv$iv)).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    throw new UnsupportedOperationException("Invalid for query " + value.getClass().getSimpleName() + " by query filterable results.");
                }
                object = list;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query '" + value.getClass().getSimpleName() + "' by query filterable results.", e);
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Queriers$FirstResultQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "", "", "()V", "query", "value", "queryObject", "queryOrNull", "breeze-core"})
    public static final class FirstResultQuerier
    extends AbstractQuerier<String, Object> {
        @NotNull
        public static final FirstResultQuerier INSTANCE = new FirstResultQuerier();

        private FirstResultQuerier() {
        }

        @Override
        @Nullable
        public Object query(@NotNull Object value, @NotNull String queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                Object object2;
                object = value;
                if (object instanceof Object[]) {
                    object2 = ArraysKt.firstOrNull((Object[])((Object[])value));
                } else if (object instanceof List) {
                    object2 = CollectionsKt.firstOrNull((List)((List)value));
                } else if (object instanceof Iterable) {
                    object2 = CollectionsKt.firstOrNull((Iterable)((Iterable)value));
                } else if (object instanceof Sequence) {
                    object2 = SequencesKt.firstOrNull((Sequence)((Sequence)value));
                } else if (object instanceof Map) {
                    object2 = CollectionsKt.firstOrNull((Iterable)((Map)value).values());
                } else {
                    throw new UnsupportedOperationException("Invalid for query " + value.getClass().getSimpleName() + " by query first result.");
                }
                object = object2;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query '" + value.getClass().getSimpleName() + "' by query first result.", e);
            }
            return object;
        }

        @Override
        @Nullable
        public Object queryOrNull(@NotNull Object value, @NotNull String queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                Object object2;
                object = value;
                if (object instanceof Object[]) {
                    object2 = ArraysKt.first((Object[])((Object[])value));
                } else if (object instanceof List) {
                    object2 = CollectionsKt.first((List)((List)value));
                } else if (object instanceof Iterable) {
                    object2 = CollectionsKt.first((Iterable)((Iterable)value));
                } else if (object instanceof Sequence) {
                    object2 = SequencesKt.first((Sequence)((Sequence)value));
                } else if (object instanceof Map) {
                    object2 = CollectionsKt.first((Iterable)((Map)value).values());
                } else {
                    throw new UnsupportedOperationException("Invalid for query " + value.getClass().getSimpleName() + " by query first result.");
                }
                object = object2;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query '" + value.getClass().getSimpleName() + "' by get first result.", e);
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Queriers$LastResultQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "", "", "()V", "query", "value", "queryObject", "queryOrNull", "breeze-core"})
    public static final class LastResultQuerier
    extends AbstractQuerier<String, Object> {
        @NotNull
        public static final LastResultQuerier INSTANCE = new LastResultQuerier();

        private LastResultQuerier() {
        }

        @Override
        @Nullable
        public Object query(@NotNull Object value, @NotNull String queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                Object object2;
                object = value;
                if (object instanceof Object[]) {
                    object2 = ArraysKt.lastOrNull((Object[])((Object[])value));
                } else if (object instanceof List) {
                    object2 = CollectionsKt.lastOrNull((List)((List)value));
                } else if (object instanceof Iterable) {
                    object2 = CollectionsKt.lastOrNull((Iterable)((Iterable)value));
                } else if (object instanceof Sequence) {
                    object2 = SequencesKt.lastOrNull((Sequence)((Sequence)value));
                } else if (object instanceof Map) {
                    object2 = CollectionsKt.lastOrNull((Iterable)((Map)value).values());
                } else {
                    throw new UnsupportedOperationException("Invalid for query " + value.getClass().getSimpleName() + " by query last result.");
                }
                object = object2;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query '" + value.getClass().getSimpleName() + "' by query last result.", e);
            }
            return object;
        }

        @Override
        @Nullable
        public Object queryOrNull(@NotNull Object value, @NotNull String queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                Object object2;
                object = value;
                if (object instanceof Object[]) {
                    object2 = ArraysKt.last((Object[])((Object[])value));
                } else if (object instanceof List) {
                    object2 = CollectionsKt.last((List)((List)value));
                } else if (object instanceof Iterable) {
                    object2 = CollectionsKt.last((Iterable)((Iterable)value));
                } else if (object instanceof Sequence) {
                    object2 = SequencesKt.last((Sequence)((Sequence)value));
                } else if (object instanceof Map) {
                    object2 = CollectionsKt.last((Iterable)((Map)value).values());
                } else {
                    throw new UnsupportedOperationException("Invalid for query " + value.getClass().getSimpleName() + " by query last result.");
                }
                object = object2;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query '" + value.getClass().getSimpleName() + "' by get last result.", e);
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Queriers$StringQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "", "", "()V", "query", "value", "queryObject", "breeze-core"})
    public static final class StringQuerier
    extends AbstractQuerier<String, Object> {
        @NotNull
        public static final StringQuerier INSTANCE = new StringQuerier();

        private StringQuerier() {
        }

        @Override
        @Nullable
        public Object query(@NotNull Object value, @NotNull String queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            if (((CharSequence)queryObject).length() == 0) {
                return value;
            }
            try {
                Object object2;
                object = value;
                if (object instanceof Object[]) {
                    object2 = ArraysKt.getOrNull((Object[])((Object[])value), (int)Integer.parseInt(queryObject));
                } else if (object instanceof List) {
                    object2 = CollectionsKt.getOrNull((List)((List)value), (int)Integer.parseInt(queryObject));
                } else if (object instanceof Iterable) {
                    object2 = CollectionsKt.elementAtOrNull((Iterable)((Iterable)value), (int)Integer.parseInt(queryObject));
                } else if (object instanceof Sequence) {
                    object2 = SequencesKt.elementAtOrNull((Sequence)((Sequence)value), (int)Integer.parseInt(queryObject));
                } else if (object instanceof Map) {
                    Object $this$cast$iv = value;
                    boolean $i$f$cast = false;
                    object2 = ((Map)$this$cast$iv).get(queryObject);
                } else {
                    throw new UnsupportedOperationException("Invalid string '" + queryObject + "' for query " + value.getClass().getSimpleName() + '.');
                }
                object = object2;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query by string '" + queryObject + "'.", e);
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Queriers$RegexQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "Lkotlin/text/Regex;", "", "", "()V", "query", "value", "queryObject", "breeze-core"})
    public static final class RegexQuerier
    extends AbstractQuerier<Regex, List<? extends Object>> {
        @NotNull
        public static final RegexQuerier INSTANCE = new RegexQuerier();

        private RegexQuerier() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Object> query(@NotNull Object value, @NotNull Regex queryObject) {
            List list;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                LinkedHashMap result$iv;
                if (value instanceof Map) {
                    void $this$filterKeys$iv;
                    Object $this$cast$iv = value;
                    boolean $i$f$cast = false;
                    $this$cast$iv = (Map)$this$cast$iv;
                    boolean $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap();
                    for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        CharSequence charSequence = it;
                        if (!queryObject.matches(charSequence)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                } else {
                    throw new UnsupportedOperationException("Invalid regex '" + queryObject + "' for query " + value.getClass().getSimpleName() + '.');
                }
                list = CollectionsKt.toList((Iterable)((Map)result$iv).values());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query by regex '" + queryObject + "'.", e);
            }
            return list;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/Queriers$IndexQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "", "", "()V", "query", "value", "queryObject", "breeze-core"})
    public static final class IndexQuerier
    extends AbstractQuerier<Integer, Object> {
        @NotNull
        public static final IndexQuerier INSTANCE = new IndexQuerier();

        private IndexQuerier() {
        }

        @Override
        @Nullable
        public Object query(@NotNull Object value, int queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                Object object2;
                object = value;
                if (object instanceof Object[]) {
                    object2 = ArraysKt.getOrNull((Object[])((Object[])value), (int)queryObject);
                } else if (object instanceof List) {
                    object2 = CollectionsKt.getOrNull((List)((List)value), (int)queryObject);
                } else if (object instanceof Iterable) {
                    object2 = CollectionsKt.elementAtOrNull((Iterable)((Iterable)value), (int)queryObject);
                } else if (object instanceof Sequence) {
                    object2 = SequencesKt.elementAtOrNull((Sequence)((Sequence)value), (int)queryObject);
                } else {
                    throw new UnsupportedOperationException("Invalid index '" + queryObject + "' for query " + value.getClass().getSimpleName() + '.');
                }
                object = object2;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query by index '" + queryObject + "'.", e);
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/Queriers$IndexRangeQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "Lkotlin/ranges/IntRange;", "", "", "()V", "query", "value", "queryObject", "breeze-core"})
    public static final class IndexRangeQuerier
    extends AbstractQuerier<IntRange, List<? extends Object>> {
        @NotNull
        public static final IndexRangeQuerier INSTANCE = new IndexRangeQuerier();

        private IndexRangeQuerier() {
        }

        @Override
        @NotNull
        public List<Object> query(@NotNull Object value, @NotNull IntRange queryObject) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                List list;
                object = value;
                if (object instanceof Object[]) {
                    list = CollectionsKt.slice((List)ArraysKt.toList((Object[])((Object[])value)), (IntRange)queryObject);
                } else if (object instanceof List) {
                    list = CollectionsKt.slice((List)((List)value), (IntRange)queryObject);
                } else if (object instanceof Iterable) {
                    list = CollectionsKt.slice((List)CollectionsKt.toList((Iterable)((Iterable)value)), (IntRange)queryObject);
                } else if (object instanceof Sequence) {
                    list = CollectionsKt.slice((List)SequencesKt.toList((Sequence)((Sequence)value)), (IntRange)queryObject);
                } else {
                    throw new UnsupportedOperationException("Invalid range '" + queryObject + "' for query " + value.getClass().getSimpleName() + '.');
                }
                object = list;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query by range '" + queryObject + "'.", e);
            }
            return object;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/Queriers$ReflectionQuerier;", "Licu/windea/breezeframework/core/component/AbstractQuerier;", "", "", "()V", "getBooleanGetterName", "value", "getGetterName", "query", "queryObject", "breeze-core"})
    public static final class ReflectionQuerier
    extends AbstractQuerier<String, Object> {
        @NotNull
        public static final ReflectionQuerier INSTANCE = new ReflectionQuerier();

        private ReflectionQuerier() {
        }

        @Override
        @NotNull
        public Object query(@NotNull Object value, @NotNull String queryObject) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                Object returnValue;
                Method method;
                Method getter;
                Object object;
                Object object2;
                Class<?> targetType = value.getClass();
                Object object3 = this;
                try {
                    ReflectionQuerier $this$query_u24lambda_u2d0 = object3;
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)targetType.getDeclaredField(queryObject));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object3 = object2;
                Field field = (Field)(Result.isFailure-impl((Object)object3) ? null : object3);
                if (field != null) {
                    Object returnValue2;
                    object2 = this;
                    try {
                        Field field2;
                        ReflectionQuerier $this$query_u24lambda_u2d2 = (ReflectionQuerier)object2;
                        boolean bl = false;
                        Field $this$query_u24lambda_u2d2_u24lambda_u2d1 = field2 = field;
                        boolean bl2 = false;
                        $this$query_u24lambda_u2d2_u24lambda_u2d1.setAccessible(true);
                        object = Result.constructor-impl((Object)field2.get(value));
                    }
                    catch (Throwable $this$query_u24lambda_u2d2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$query_u24lambda_u2d2));
                    }
                    object2 = object;
                    Object object4 = returnValue2 = Result.isFailure-impl((Object)object2) ? null : object2;
                    if (returnValue2 != null) {
                        return returnValue2;
                    }
                }
                if (Intrinsics.areEqual(targetType, Boolean.TYPE)) {
                    Object $this$query_u24lambda_u2d32;
                    object2 = this;
                    try {
                        $this$query_u24lambda_u2d32 = (ReflectionQuerier)object2;
                        boolean bl = false;
                        object = Result.constructor-impl((Object)targetType.getDeclaredMethod(((ReflectionQuerier)$this$query_u24lambda_u2d32).getBooleanGetterName(queryObject), new Class[0]));
                    }
                    catch (Throwable $this$query_u24lambda_u2d32) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$query_u24lambda_u2d32));
                    }
                    object2 = object;
                    getter = (Method)(Result.isFailure-impl((Object)object2) ? null : object2);
                    if (getter != null) {
                        object = this;
                        try {
                            ReflectionQuerier $this$query_u24lambda_u2d5 = (ReflectionQuerier)object;
                            boolean bl = false;
                            Method $this$query_u24lambda_u2d5_u24lambda_u2d4 = method = getter;
                            boolean bl3 = false;
                            $this$query_u24lambda_u2d5_u24lambda_u2d4.setAccessible(true);
                            $this$query_u24lambda_u2d32 = Result.constructor-impl((Object)method.invoke(value, new Object[0]));
                        }
                        catch (Throwable $this$query_u24lambda_u2d5) {
                            $this$query_u24lambda_u2d32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$query_u24lambda_u2d5));
                        }
                        object = $this$query_u24lambda_u2d32;
                        Object object5 = returnValue = Result.isFailure-impl((Object)object) ? null : object;
                        if (returnValue != null) {
                            return returnValue;
                        }
                    }
                }
                returnValue = this;
                try {
                    ReflectionQuerier $this$query_u24lambda_u2d6 = returnValue;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)targetType.getDeclaredMethod($this$query_u24lambda_u2d6.getGetterName(queryObject), new Class[0]));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                returnValue = object;
                getter = (Method)(Result.isFailure-impl((Object)returnValue) ? null : returnValue);
                if (getter != null) {
                    Object object6;
                    object = this;
                    try {
                        ReflectionQuerier $this$query_u24lambda_u2d8 = (ReflectionQuerier)object;
                        boolean bl = false;
                        Method $this$query_u24lambda_u2d8_u24lambda_u2d7 = method = getter;
                        boolean bl4 = false;
                        $this$query_u24lambda_u2d8_u24lambda_u2d7.setAccessible(true);
                        object6 = Result.constructor-impl((Object)method.invoke(value, new Object[0]));
                    }
                    catch (Throwable throwable) {
                        object6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object = object6;
                    Object object7 = returnValue = Result.isFailure-impl((Object)object) ? null : object;
                    if (returnValue != null) {
                        return returnValue;
                    }
                }
                throw new UnsupportedOperationException("Invalid string '" + queryObject + "' for query " + value.getClass().getSimpleName() + " by reflection.");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query by string '" + queryObject + "' by reflection.", e);
            }
        }

        private final String getGetterName(String value) {
            return Intrinsics.stringPlus((String)"get", (Object)InternalExtensions.firstCharToUpperCase(value));
        }

        private final String getBooleanGetterName(String value) {
            return Intrinsics.stringPlus((String)"is", (Object)InternalExtensions.firstCharToUpperCase(value));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/Queriers$ReflectionMemberQuerier;", "Licu/windea/breezeframework/core/component/Querier;", "", "", "()V", "getAnnotationName", "value", "getMethodName", "query", "queryObject", "breeze-core"})
    public static final class ReflectionMemberQuerier
    implements Querier<String, Object> {
        @NotNull
        public static final ReflectionMemberQuerier INSTANCE = new ReflectionMemberQuerier();

        private ReflectionMemberQuerier() {
        }

        @Override
        @NotNull
        public Object query(@NotNull Object value, @NotNull String queryObject) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)queryObject, (String)"queryObject");
            try {
                Object result;
                block11: {
                    Object object;
                    Object it;
                    Object object2;
                    String name;
                    Class<?> targetType = value.getClass();
                    if (StringsKt.startsWith$default((String)queryObject, (String)"@", (boolean)false, (int)2, null)) {
                        name = ((ReflectionMemberQuerier)this).getAnnotationName(queryObject);
                        object2 = targetType.getDeclaredAnnotations();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"targetType.declaredAnnotations");
                        for (Object object3 : (Object[])object2) {
                            it = (Annotation)object3;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)name)) continue;
                            object = object3;
                            break block11;
                        }
                        object = null;
                    } else if (StringsKt.endsWith$default((String)queryObject, (String)"()", (boolean)false, (int)2, null)) {
                        name = ((ReflectionMemberQuerier)this).getMethodName(queryObject);
                        object2 = targetType.getDeclaredMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"targetType.declaredMethods");
                        for (Object object3 : object2) {
                            it = (Method)object3;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((Method)it).getName(), (Object)name)) continue;
                            object = object3;
                            break block11;
                        }
                        object = null;
                    } else {
                        Object object4 = this;
                        try {
                            Object $this$query_u24lambda_u2d2 = object4;
                            boolean bl = false;
                            object2 = Result.constructor-impl((Object)targetType.getDeclaredField(queryObject));
                        }
                        catch (Throwable throwable) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object4 = object2;
                        object = result = Result.isFailure-impl((Object)object4) ? null : object4;
                    }
                }
                if (result != null) {
                    return result;
                }
                throw new UnsupportedOperationException("Invalid string '" + queryObject + "' for query " + value.getClass().getSimpleName() + " by reflection.");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot query by string '" + queryObject + "' by reflection.", e);
            }
        }

        private final String getAnnotationName(String value) {
            return StringsKt.drop((String)value, (int)1);
        }

        private final String getMethodName(String value) {
            return StringsKt.dropLast((String)value, (int)2);
        }

        @Override
        @Nullable
        public Object queryOrNull(@NotNull Object value, @NotNull String queryObject) {
            return Querier.DefaultImpls.queryOrNull(this, value, queryObject);
        }

        @Override
        @Nullable
        public Object queryOrDefault(@NotNull Object value, @NotNull String queryObject, @Nullable Object defaultValue) {
            return Querier.DefaultImpls.queryOrDefault(this, value, queryObject, defaultValue);
        }

        @Override
        @Nullable
        public Object queryOrElse(@NotNull Object value, @NotNull String queryObject, @NotNull Function2<Object, ? super String, ? extends Object> defaultValue) {
            return Querier.DefaultImpls.queryOrElse(this, value, queryObject, defaultValue);
        }

        @Override
        @NotNull
        public Querier<String, Object> componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            return Querier.DefaultImpls.componentCopy(this, componentParams);
        }

        @Override
        public String getComponentId() {
            return Querier.DefaultImpls.getComponentId(this);
        }

        @Override
        @NotNull
        public Map<String, Object> getComponentParams() {
            return Querier.DefaultImpls.getComponentParams(this);
        }

        @Override
        @InternalApi
        public boolean componentEquals(@Nullable Object other) {
            return Querier.DefaultImpls.componentEquals(this, other);
        }

        @Override
        @InternalApi
        public int componentHashcode() {
            return Querier.DefaultImpls.componentHashcode(this);
        }

        @Override
        @InternalApi
        @NotNull
        public String componentToString() {
            return Querier.DefaultImpls.componentToString(this);
        }
    }
}

