/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.annotation.UnstableApi;
import icu.windea.breezeframework.core.component.AbstractRandomGenerator;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.Converters;
import icu.windea.breezeframework.core.component.GenericRandomGenerator;
import icu.windea.breezeframework.core.component.RandomGenerator;
import icu.windea.breezeframework.core.extension.InternalExtensions;
import icu.windea.breezeframework.core.extension.RandomExtensions;
import icu.windea.breezeframework.core.model.TypeReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.URandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0017\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0016#$%&'()*+,-./012345678B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J1\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0013\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J7\u0010\u0016\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r\u00a2\u0006\u0002\u0010\u0017J1\u0010\u0016\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r\u00a2\u0006\u0002\u0010\u0018J.\u0010\u0016\u001a\u0002H\u000b\"\u0006\b\u0000\u0010\u000b\u0018\u00012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0086\b\u00a2\u0006\u0002\u0010\u0019JS\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u000b\"\u000e\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u000b0\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00142\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d\u00a2\u0006\u0002\u0010\u001eJ0\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00142\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0002J*\u0010 \u001a\u00020\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00142\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rH\u0002J\b\u0010!\u001a\u00020\"H\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u00069"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/RandomGenerator;", "()V", "useFallbackStrategy", "", "getUseFallbackStrategy", "()Z", "setUseFallbackStrategy", "(Z)V", "doGenerate", "T", "componentParams", "", "", "", "targetType", "Ljava/lang/reflect/Type;", "(Ljava/util/Map;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "fallbackGenerate", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "generate", "(Ljava/lang/Class;Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/lang/reflect/Type;Ljava/util/Map;)Ljava/lang/Object;", "(Ljava/util/Map;)Ljava/lang/Object;", "get", "C", "defaultValue", "Lkotlin/Function0;", "(Ljava/lang/Class;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Licu/windea/breezeframework/core/component/RandomGenerator;", "infer", "inferKey", "registerDefault", "", "RandomBigDecimalGenerator", "RandomBigIntegerGenerator", "RandomBooleanGenerator", "RandomByteGenerator", "RandomCharGenerator", "RandomDateGenerator", "RandomDoubleGenerator", "RandomEnumGenerator", "RandomFloatGenerator", "RandomInstantGenerator", "RandomIntGenerator", "RandomLocalDateGenerator", "RandomLocalDateTimeGenerator", "RandomLocalTimeGenerator", "RandomLongGenerator", "RandomShortGenerator", "RandomStringGenerator", "RandomUByteGenerator", "RandomUIntGenerator", "RandomULongGenerator", "RandomUShortGenerator", "RandomUuidGenerator", "breeze-core"})
public final class RandomGenerators
extends ComponentRegistry<RandomGenerator<?>> {
    @NotNull
    public static final RandomGenerators INSTANCE = new RandomGenerators();
    private static boolean useFallbackStrategy;

    private RandomGenerators() {
    }

    public final boolean getUseFallbackStrategy() {
        return useFallbackStrategy;
    }

    public final void setUseFallbackStrategy(boolean bl) {
        useFallbackStrategy = bl;
    }

    @Override
    protected void registerDefault() {
        this.register((Component)RandomByteGenerator.Default);
        this.register((Component)RandomShortGenerator.Default);
        this.register((Component)RandomIntGenerator.Default);
        this.register((Component)RandomLongGenerator.Default);
        this.register((Component)RandomFloatGenerator.Default);
        this.register((Component)RandomDoubleGenerator.Default);
        this.register((Component)RandomBooleanGenerator.INSTANCE);
        this.register((Component)RandomCharGenerator.Default);
        this.register((Component)RandomBigIntegerGenerator.Default);
        this.register((Component)RandomBigDecimalGenerator.Default);
        this.register((Component)RandomUByteGenerator.Default);
        this.register((Component)RandomUShortGenerator.Default);
        this.register((Component)RandomUIntGenerator.Default);
        this.register((Component)RandomULongGenerator.Default);
        this.register((Component)RandomStringGenerator.Default);
        this.register((Component)RandomUuidGenerator.INSTANCE);
        this.register((Component)RandomDateGenerator.Default);
        this.register((Component)RandomLocalDateGenerator.Default);
        this.register((Component)RandomLocalTimeGenerator.Default);
        this.register((Component)RandomLocalDateTimeGenerator.Default);
        this.register((Component)RandomInstantGenerator.Default);
        this.register((Component)RandomEnumGenerator.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T, C extends RandomGenerator<T>> C get(@NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> componentParams, @NotNull Function0<? extends C> defaultValue) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Map map = this.getComponents();
        String key$iv = this.inferKey(targetType, componentParams);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Object answer$iv = defaultValue.invoke();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (C)((RandomGenerator)object);
    }

    public final /* synthetic */ <T> T generate(Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        boolean $i$f$generate = false;
        boolean $i$f$javaTypeOf = false;
        Intrinsics.needClassReification();
        return this.generate(new TypeReference<T>(){}.getType(), componentParams);
    }

    public static /* synthetic */ Object generate$default(RandomGenerators this_, Map componentParams, int n, Object object) {
        if ((n & 1) != 0) {
            componentParams = MapsKt.emptyMap();
        }
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        boolean $i$f$generate = false;
        boolean $i$f$javaTypeOf = false;
        Intrinsics.needClassReification();
        return this_.generate(new /* invalid duplicate definition of identical inner class */.getType(), (Map<String, ? extends Object>)componentParams);
    }

    public final <T> T generate(@NotNull Class<T> targetType, @NotNull Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        return this.doGenerate(componentParams, targetType);
    }

    public static /* synthetic */ Object generate$default(RandomGenerators randomGenerators, Class clazz, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return randomGenerators.generate(clazz, (Map<String, ? extends Object>)map);
    }

    public final <T> T generate(@NotNull Type targetType, @NotNull Map<String, ? extends Object> componentParams) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        return this.doGenerate(componentParams, targetType);
    }

    public static /* synthetic */ Object generate$default(RandomGenerators randomGenerators, Type type, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return randomGenerators.generate(type, (Map<String, ? extends Object>)map);
    }

    private final <T> T doGenerate(Map<String, ? extends Object> componentParams, Type targetType) {
        RandomGenerator randomGenerator;
        Object object;
        Class<?> targetClass = InternalExtensions.inferClass(targetType);
        String key = this.inferKey(targetClass, componentParams);
        Map $this$getOrPut$iv = this.getComponents();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            RandomGenerator<?> result = INSTANCE.infer(targetClass, componentParams);
            if (result == null) {
                Object fallback;
                if (INSTANCE.getUseFallbackStrategy() && (fallback = INSTANCE.fallbackGenerate(targetClass)) != null) {
                    return (T)fallback;
                }
                throw new IllegalArgumentException("No suitable random generator found for target type '" + targetType + "'.");
            }
            RandomGenerator<?> answer$iv = result;
            $this$getOrPut$iv.put(key, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (randomGenerator = (RandomGenerator)object) instanceof GenericRandomGenerator ? ((GenericRandomGenerator)randomGenerator).generate(targetType) : randomGenerator.generate();
    }

    private final String inferKey(Class<?> targetType, Map<String, ? extends Object> componentParams) {
        String string;
        if (componentParams.isEmpty()) {
            String string2 = targetType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetType.name");
            string = string2;
        } else {
            string = targetType.getName() + '@' + componentParams;
        }
        return string;
    }

    private final RandomGenerator<?> infer(Class<?> targetType, Map<String, ? extends Object> componentParams) {
        Iterable iterable = this.getComponents().values();
        Object var5_4 = null;
        for (Object t : iterable) {
            RandomGenerator it = (RandomGenerator)t;
            boolean bl = false;
            if (!it.getTargetType().isAssignableFrom(targetType)) continue;
            var5_4 = t;
        }
        RandomGenerator randomGenerator = var5_4;
        if (randomGenerator == null) {
            return null;
        }
        RandomGenerator result = randomGenerator;
        if (!Intrinsics.areEqual((Object)result.getComponentParams().toString(), (Object)componentParams.toString())) {
            result = result.componentCopy(componentParams);
        }
        return result;
    }

    private final <T> T fallbackGenerate(Class<T> targetType) {
        try {
            Constructor<T> constructor = targetType.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomByteGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()B", "min", "getMin", "componentCopy", "generate", "()Ljava/lang/Byte;", "Default", "breeze-core"})
    public static class RandomByteGenerator
    extends AbstractRandomGenerator<Byte> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final byte min;
        private final byte max;

        public RandomByteGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Byte by = (Byte)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Byte>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = by == null ? (byte)0 : by;
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            Byte by2 = (Byte)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Byte>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = by2 == null ? (byte)0 : by2;
        }

        public /* synthetic */ RandomByteGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final byte getMin() {
            return this.min;
        }

        public final byte getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomByteGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomByteGenerator(componentParams);
        }

        @Override
        @NotNull
        public Byte generate() {
            byte by;
            if (this.min != 0 && this.max != 0) {
                by = RandomExtensions.nextByte((Random)Random.Default, this.min, this.max);
            } else if (this.min == 0 && this.max == 0) {
                by = RandomExtensions.nextByte((Random)Random.Default);
            } else if (this.max != 0) {
                by = RandomExtensions.nextByte((Random)Random.Default, this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return by;
        }

        public RandomByteGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomByteGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomByteGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomByteGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomShortGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()S", "min", "getMin", "componentCopy", "generate", "()Ljava/lang/Short;", "Default", "breeze-core"})
    public static class RandomShortGenerator
    extends AbstractRandomGenerator<Short> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final short min;
        private final short max;

        public RandomShortGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Short s = (Short)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Short>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = s == null ? (short)0 : s;
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            Short s2 = (Short)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Short>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = s2 == null ? (short)0 : s2;
        }

        public /* synthetic */ RandomShortGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final short getMin() {
            return this.min;
        }

        public final short getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomShortGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomShortGenerator(componentParams);
        }

        @Override
        @NotNull
        public Short generate() {
            short s;
            if (this.min != 0 && this.max != 0) {
                s = RandomExtensions.nextShort((Random)Random.Default, this.min, this.max);
            } else if (this.min == 0 && this.max == 0) {
                s = RandomExtensions.nextShort((Random)Random.Default);
            } else if (this.max != 0) {
                s = RandomExtensions.nextShort((Random)Random.Default, this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return s;
        }

        public RandomShortGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomShortGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomShortGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomShortGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomIntGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()I", "min", "getMin", "componentCopy", "generate", "()Ljava/lang/Integer;", "Default", "breeze-core"})
    public static class RandomIntGenerator
    extends AbstractRandomGenerator<Integer> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final int min;
        private final int max;

        public RandomIntGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Integer n = (Integer)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = n == null ? 0 : n;
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            Integer n2 = (Integer)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = n2 == null ? 0 : n2;
        }

        public /* synthetic */ RandomIntGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomIntGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomIntGenerator(componentParams);
        }

        @Override
        @NotNull
        public Integer generate() {
            int n;
            if (this.min != 0 && this.max != 0) {
                n = Random.Default.nextInt(this.min, this.max);
            } else if (this.min == 0 && this.max == 0) {
                n = Random.Default.nextInt();
            } else if (this.max != 0) {
                n = Random.Default.nextInt(this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return n;
        }

        public RandomIntGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomIntGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomIntGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomIntGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLongGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()J", "min", "getMin", "componentCopy", "generate", "()Ljava/lang/Long;", "Default", "breeze-core"})
    public static class RandomLongGenerator
    extends AbstractRandomGenerator<Long> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final long min;
        private final long max;

        public RandomLongGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Long l = (Long)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = l == null ? 0L : l;
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            Long l2 = (Long)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Long>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = l2 == null ? 0L : l2;
        }

        public /* synthetic */ RandomLongGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final long getMin() {
            return this.min;
        }

        public final long getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLongGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomLongGenerator(componentParams);
        }

        @Override
        @NotNull
        public Long generate() {
            long l;
            if (this.min != 0L && this.max != 0L) {
                l = Random.Default.nextLong(this.min, this.max);
            } else if (this.min == 0L && this.max == 0L) {
                l = Random.Default.nextLong();
            } else if (this.max != 0L) {
                l = Random.Default.nextLong(this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return l;
        }

        public RandomLongGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLongGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomLongGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLongGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomFloatGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()F", "min", "getMin", "componentCopy", "generate", "()Ljava/lang/Float;", "Default", "breeze-core"})
    public static class RandomFloatGenerator
    extends AbstractRandomGenerator<Float> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final float min;
        private final float max;

        public RandomFloatGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Float f = (Float)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Float>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = f == null ? 0.0f : f.floatValue();
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            Float f2 = (Float)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Float>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = f2 == null ? 0.0f : f2.floatValue();
        }

        public /* synthetic */ RandomFloatGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final float getMin() {
            return this.min;
        }

        public final float getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomFloatGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomFloatGenerator(componentParams);
        }

        @Override
        @NotNull
        public Float generate() {
            float f;
            if (!(this.min == 0.0f) && !(this.max == 0.0f)) {
                f = RandomExtensions.nextFloat((Random)Random.Default, this.min, this.max);
            } else if (this.min == 0.0f && this.max == 0.0f) {
                f = Random.Default.nextFloat();
            } else if (!(this.max == 0.0f)) {
                f = RandomExtensions.nextFloat((Random)Random.Default, this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return Float.valueOf(f);
        }

        public RandomFloatGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomFloatGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomFloatGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomFloatGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomDoubleGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()D", "min", "getMin", "componentCopy", "generate", "()Ljava/lang/Double;", "Default", "breeze-core"})
    public static class RandomDoubleGenerator
    extends AbstractRandomGenerator<Double> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final double min;
        private final double max;

        public RandomDoubleGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Double d = (Double)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Double>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = d == null ? 0.0 : d;
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            Double d2 = (Double)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Double>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = d2 == null ? 0.0 : d2;
        }

        public /* synthetic */ RandomDoubleGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final double getMin() {
            return this.min;
        }

        public final double getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomDoubleGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomDoubleGenerator(componentParams);
        }

        @Override
        @NotNull
        public Double generate() {
            double d;
            if (!(this.min == 0.0) && !(this.max == 0.0)) {
                d = Random.Default.nextDouble(this.min, this.max);
            } else if (this.min == 0.0 && this.max == 0.0) {
                d = Random.Default.nextDouble();
            } else if (!(this.max == 0.0)) {
                d = Random.Default.nextDouble(this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return d;
        }

        public RandomDoubleGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomDoubleGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomDoubleGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomDoubleGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\f\b\u0017\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0012"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomBigIntegerGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/math/BigInteger;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/math/BigInteger;", "min", "getMin", "componentCopy", "generate", "Default", "breeze-core"})
    @UnstableApi
    public static class RandomBigIntegerGenerator
    extends AbstractRandomGenerator<BigInteger> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final BigInteger min;
        @NotNull
        private final BigInteger max;

        public RandomBigIntegerGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Object object = (BigInteger)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<BigInteger>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (object == null) {
                $this$convertOrNull_u24default$iv = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)$this$convertOrNull_u24default$iv, (String)"ZERO");
                object = $this$convertOrNull_u24default$iv;
            }
            this.min = object;
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            BigInteger bigInteger = (BigInteger)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<BigInteger>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (bigInteger == null) {
                BigInteger bigInteger2 = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ZERO");
                bigInteger = bigInteger2;
            }
            this.max = bigInteger;
        }

        public /* synthetic */ RandomBigIntegerGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final BigInteger getMin() {
            return this.min;
        }

        @NotNull
        public final BigInteger getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomBigIntegerGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomBigIntegerGenerator(componentParams);
        }

        @Override
        @NotNull
        public BigInteger generate() {
            BigInteger bigInteger;
            if (!Intrinsics.areEqual((Object)this.min, (Object)BigInteger.ZERO) && !Intrinsics.areEqual((Object)this.max, (Object)BigInteger.ZERO)) {
                bigInteger = RandomExtensions.nextBigInteger((Random)Random.Default, this.min, this.max);
            } else if (Intrinsics.areEqual((Object)this.min, (Object)BigInteger.ZERO) && Intrinsics.areEqual((Object)this.max, (Object)BigInteger.ZERO)) {
                bigInteger = RandomExtensions.nextBigInteger((Random)Random.Default);
            } else if (!Intrinsics.areEqual((Object)this.max, (Object)BigInteger.ZERO)) {
                bigInteger = RandomExtensions.nextBigInteger((Random)Random.Default, this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return bigInteger;
        }

        public RandomBigIntegerGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomBigIntegerGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomBigIntegerGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomBigIntegerGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\f\b\u0017\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0012"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomBigDecimalGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/math/BigDecimal;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/math/BigDecimal;", "min", "getMin", "componentCopy", "generate", "Default", "breeze-core"})
    @UnstableApi
    public static class RandomBigDecimalGenerator
    extends AbstractRandomGenerator<BigDecimal> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final BigDecimal min;
        @NotNull
        private final BigDecimal max;

        public RandomBigDecimalGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Object object = (BigDecimal)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<BigDecimal>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (object == null) {
                $this$convertOrNull_u24default$iv = BigDecimal.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)$this$convertOrNull_u24default$iv, (String)"ZERO");
                object = $this$convertOrNull_u24default$iv;
            }
            this.min = object;
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            BigDecimal bigDecimal = (BigDecimal)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<BigDecimal>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            if (bigDecimal == null) {
                BigDecimal bigDecimal2 = BigDecimal.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ZERO");
                bigDecimal = bigDecimal2;
            }
            this.max = bigDecimal;
        }

        public /* synthetic */ RandomBigDecimalGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @NotNull
        public final BigDecimal getMin() {
            return this.min;
        }

        @NotNull
        public final BigDecimal getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomBigDecimalGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomBigDecimalGenerator(componentParams);
        }

        @Override
        @NotNull
        public BigDecimal generate() {
            BigDecimal bigDecimal;
            if (!Intrinsics.areEqual((Object)this.min, (Object)BigDecimal.ZERO) && !Intrinsics.areEqual((Object)this.max, (Object)BigDecimal.ZERO)) {
                bigDecimal = RandomExtensions.nextBigDecimal$default((Random)Random.Default, this.min, this.max, null, 4, null);
            } else if (Intrinsics.areEqual((Object)this.min, (Object)BigDecimal.ZERO) && Intrinsics.areEqual((Object)this.max, (Object)BigDecimal.ZERO)) {
                bigDecimal = RandomExtensions.nextBigDecimal$default((Random)Random.Default, null, 1, null);
            } else if (!Intrinsics.areEqual((Object)this.max, (Object)BigDecimal.ZERO)) {
                bigDecimal = RandomExtensions.nextBigDecimal$default((Random)Random.Default, this.max, null, 2, null);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return bigDecimal;
        }

        public RandomBigDecimalGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomBigDecimalGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomBigDecimalGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomBigDecimalGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\fR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomUByteGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/UByte;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax-w2LRezQ", "()B", "B", "min", "getMin-w2LRezQ", "componentCopy", "generate", "generate-w2LRezQ", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomUByteGenerator
    extends AbstractRandomGenerator<UByte> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final byte min;
        private final byte max;

        public RandomUByteGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            UByte uByte = (UByte)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<UByte>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = uByte == null ? UByte.constructor-impl((byte)((byte)0)) : uByte.unbox-impl();
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            uByte = (UByte)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<UByte>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = uByte == null ? UByte.constructor-impl((byte)((byte)0)) : uByte.unbox-impl();
        }

        public /* synthetic */ RandomUByteGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final byte getMin-w2LRezQ() {
            return this.min;
        }

        public final byte getMax-w2LRezQ() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomUByteGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomUByteGenerator(componentParams);
        }

        public byte generate-w2LRezQ() {
            byte by;
            if (this.getMin-w2LRezQ() != UByte.constructor-impl((byte)((byte)0)) && this.getMax-w2LRezQ() != UByte.constructor-impl((byte)((byte)0))) {
                by = RandomExtensions.nextUByte-8olNwgk((Random)Random.Default, this.getMin-w2LRezQ(), this.getMax-w2LRezQ());
            } else if (this.getMin-w2LRezQ() == UByte.constructor-impl((byte)((byte)0)) && this.getMax-w2LRezQ() == UByte.constructor-impl((byte)((byte)0))) {
                by = RandomExtensions.nextUByte((Random)Random.Default);
            } else if (this.getMax-w2LRezQ() != UByte.constructor-impl((byte)((byte)0))) {
                by = RandomExtensions.nextUByte-EK-6454((Random)Random.Default, this.getMax-w2LRezQ());
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return by;
        }

        public RandomUByteGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomUByteGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomUByteGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomUByteGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\fR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomUShortGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/UShort;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax-Mh2AYeg", "()S", "S", "min", "getMin-Mh2AYeg", "componentCopy", "generate", "generate-Mh2AYeg", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomUShortGenerator
    extends AbstractRandomGenerator<UShort> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final short min;
        private final short max;

        public RandomUShortGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            UShort uShort = (UShort)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<UShort>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = uShort == null ? UShort.constructor-impl((short)((short)0)) : uShort.unbox-impl();
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            uShort = (UShort)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<UShort>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = uShort == null ? UShort.constructor-impl((short)((short)0)) : uShort.unbox-impl();
        }

        public /* synthetic */ RandomUShortGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final short getMin-Mh2AYeg() {
            return this.min;
        }

        public final short getMax-Mh2AYeg() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomUShortGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomUShortGenerator(componentParams);
        }

        public short generate-Mh2AYeg() {
            short s;
            if (this.getMin-Mh2AYeg() != UShort.constructor-impl((short)((short)0)) && this.getMax-Mh2AYeg() != UShort.constructor-impl((short)((short)0))) {
                s = RandomExtensions.nextUShort-lwaoQsk((Random)Random.Default, this.getMin-Mh2AYeg(), this.getMax-Mh2AYeg());
            } else if (this.getMin-Mh2AYeg() == UShort.constructor-impl((short)((short)0)) && this.getMax-Mh2AYeg() == UShort.constructor-impl((short)((short)0))) {
                s = RandomExtensions.nextUShort((Random)Random.Default);
            } else if (this.getMax-Mh2AYeg() != UShort.constructor-impl((short)((short)0))) {
                s = RandomExtensions.nextUShort-i8woANY((Random)Random.Default, this.getMax-Mh2AYeg());
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return s;
        }

        public RandomUShortGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomUShortGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomUShortGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomUShortGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\fR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomUIntGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/UInt;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax-pVg5ArA", "()I", "I", "min", "getMin-pVg5ArA", "componentCopy", "generate", "generate-pVg5ArA", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomUIntGenerator
    extends AbstractRandomGenerator<UInt> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final int min;
        private final int max;

        public RandomUIntGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            UInt uInt = (UInt)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = uInt == null ? UInt.constructor-impl((int)0) : uInt.unbox-impl();
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            uInt = (UInt)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<UInt>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = uInt == null ? UInt.constructor-impl((int)0) : uInt.unbox-impl();
        }

        public /* synthetic */ RandomUIntGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final int getMin-pVg5ArA() {
            return this.min;
        }

        public final int getMax-pVg5ArA() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomUIntGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomUIntGenerator(componentParams);
        }

        public int generate-pVg5ArA() {
            int n;
            if (this.getMin-pVg5ArA() != UInt.constructor-impl((int)0) && this.getMax-pVg5ArA() != UInt.constructor-impl((int)0)) {
                n = URandomKt.nextUInt-a8DCA5k((Random)((Random)Random.Default), (int)this.getMin-pVg5ArA(), (int)this.getMax-pVg5ArA());
            } else if (this.getMin-pVg5ArA() == UInt.constructor-impl((int)0) && this.getMax-pVg5ArA() == UInt.constructor-impl((int)0)) {
                n = URandomKt.nextUInt((Random)((Random)Random.Default));
            } else if (this.getMax-pVg5ArA() != UInt.constructor-impl((int)0)) {
                n = URandomKt.nextUInt-qCasIEU((Random)((Random)Random.Default), (int)this.getMax-pVg5ArA());
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return n;
        }

        public RandomUIntGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomUIntGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomUIntGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomUIntGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0017\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\u0018\u0010\u0011\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\fR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomULongGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Lkotlin/ULong;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax-s-VKNKU", "()J", "J", "min", "getMin-s-VKNKU", "componentCopy", "generate", "generate-s-VKNKU", "Default", "breeze-core"})
    @ExperimentalUnsignedTypes
    public static class RandomULongGenerator
    extends AbstractRandomGenerator<ULong> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final long min;
        private final long max;

        public RandomULongGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            ULong uLong = (ULong)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = uLong == null ? ULong.constructor-impl((long)0L) : uLong.unbox-impl();
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            uLong = (ULong)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<ULong>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = uLong == null ? ULong.constructor-impl((long)0L) : uLong.unbox-impl();
        }

        public /* synthetic */ RandomULongGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final long getMin-s-VKNKU() {
            return this.min;
        }

        public final long getMax-s-VKNKU() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomULongGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomULongGenerator(componentParams);
        }

        public long generate-s-VKNKU() {
            long l;
            if (this.getMin-s-VKNKU() != ULong.constructor-impl((long)0L) && this.getMax-s-VKNKU() != ULong.constructor-impl((long)0L)) {
                l = URandomKt.nextULong-jmpaW-c((Random)((Random)Random.Default), (long)this.getMin-s-VKNKU(), (long)this.getMax-s-VKNKU());
            } else if (this.getMin-s-VKNKU() == ULong.constructor-impl((long)0L) && this.getMax-s-VKNKU() == ULong.constructor-impl((long)0L)) {
                l = URandomKt.nextULong((Random)((Random)Random.Default));
            } else if (this.getMax-s-VKNKU() != ULong.constructor-impl((long)0L)) {
                l = URandomKt.nextULong-V1Xi4fY((Random)((Random)Random.Default), (long)this.getMax-s-VKNKU());
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return l;
        }

        public RandomULongGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomULongGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomULongGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomULongGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\r\b\u0016\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\r\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomCharGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()C", "min", "getMin", "componentCopy", "generate", "()Ljava/lang/Character;", "Default", "breeze-core"})
    public static class RandomCharGenerator
    extends AbstractRandomGenerator<Character> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final char min;
        private final char max;

        public RandomCharGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            Character c = (Character)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.min = c == null ? (char)'\u0000' : c.charValue();
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            Character c2 = (Character)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Character>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            this.max = c2 == null ? (char)'\u0000' : c2.charValue();
        }

        public /* synthetic */ RandomCharGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final char getMin() {
            return this.min;
        }

        public final char getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomCharGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomCharGenerator(componentParams);
        }

        @Override
        @NotNull
        public Character generate() {
            char c;
            if (this.min != '\u0000' && this.max != '\u0000') {
                c = RandomExtensions.nextChar((Random)Random.Default, this.min, this.max);
            } else if (this.min == '\u0000' && this.max == '\u0000') {
                c = RandomExtensions.nextChar((Random)Random.Default);
            } else if (this.max != '\u0000') {
                c = RandomExtensions.nextChar((Random)Random.Default, this.max);
            } else {
                throw new IllegalArgumentException("Config param 'max' cannot be null or zero where 'min' is not null or zero.");
            }
            return Character.valueOf(c);
        }

        public RandomCharGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomCharGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomCharGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomCharGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomBooleanGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "()V", "generate", "()Ljava/lang/Boolean;", "breeze-core"})
    public static final class RandomBooleanGenerator
    extends AbstractRandomGenerator<Boolean> {
        @NotNull
        public static final RandomBooleanGenerator INSTANCE = new RandomBooleanGenerator();

        private RandomBooleanGenerator() {
        }

        @Override
        @NotNull
        public Boolean generate() {
            return Random.Default.nextBoolean();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\b\u0016\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0014\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomStringGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "componentParams", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "length", "", "getLength", "()I", "maxLength", "getMaxLength", "minLength", "getMinLength", "source", "getSource", "()Ljava/lang/String;", "componentCopy", "generate", "Default", "breeze-core"})
    public static class RandomStringGenerator
    extends AbstractRandomGenerator<String> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        private final int length;
        private final int minLength;
        private final int maxLength;
        @NotNull
        private final String source;

        public RandomStringGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            String string;
            int n;
            int n2;
            boolean $i$f$javaTypeOf;
            boolean $i$f$convertOrNull;
            Converters this_$iv$iv;
            boolean $i$f$convertOrNull2;
            Map componentParams$iv;
            Object $this$convertOrNull_u24default$iv;
            int n3;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object object = this.componentParams.get("length");
            if (object == null) {
                n3 = 0;
            } else {
                $this$convertOrNull_u24default$iv = object;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = Converters.INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                Integer n4 = (Integer)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                n3 = n4 == null ? 0 : n4;
            }
            this.length = n3;
            Object object2 = this.componentParams.get("minLength");
            if (object2 == null) {
                n2 = 0;
            } else {
                $this$convertOrNull_u24default$iv = object2;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = Converters.INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                Integer n5 = (Integer)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                n2 = n5 == null ? 0 : n5;
            }
            this.minLength = n2;
            Object object3 = this.componentParams.get("maxLength");
            if (object3 == null) {
                n = 0;
            } else {
                $this$convertOrNull_u24default$iv = object3;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = Converters.INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                Integer n6 = (Integer)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Integer>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                n = n6 == null ? 0 : n6;
            }
            this.maxLength = n;
            Object object4 = this.componentParams.get("source");
            if (object4 == null) {
                string = "";
            } else {
                $this$convertOrNull_u24default$iv = object4;
                componentParams$iv = MapsKt.emptyMap();
                $i$f$convertOrNull2 = false;
                this_$iv$iv = Converters.INSTANCE;
                $i$f$convertOrNull = false;
                $i$f$javaTypeOf = false;
                string = (String)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<String>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
                if (string == null) {
                    string = "";
                }
            }
            this.source = string;
        }

        public /* synthetic */ RandomStringGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        public final int getLength() {
            return this.length;
        }

        public final int getMinLength() {
            return this.minLength;
        }

        public final int getMaxLength() {
            return this.maxLength;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public RandomStringGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomStringGenerator(componentParams);
        }

        @Override
        @NotNull
        public String generate() {
            StringBuilder stringBuilder;
            if (this.length < 0) {
                throw new IllegalArgumentException("Config param 'length' cannot be negative.");
            }
            if (this.length == 0) {
                if (this.minLength < 0) {
                    throw new IllegalArgumentException("Config param 'minLength' cannot be negative.");
                }
                if (this.maxLength < 0) {
                    throw new IllegalArgumentException("Config param 'maxLength' cannot be negative.");
                }
                if (this.maxLength == 0) {
                    throw new IllegalArgumentException("Config param 'maxLength cannot be null.'");
                }
            }
            if (((CharSequence)this.source).length() == 0) {
                throw new IllegalArgumentException("Config param 'source' cannot be null or empty.");
            }
            int length = this.length != 0 ? this.length : Random.Default.nextInt(this.minLength, this.maxLength);
            StringBuilder $this$generate_u24lambda_u2d1 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = 0;
            while (n < length) {
                int n2;
                int it = n2 = n++;
                boolean bl2 = false;
                $this$generate_u24lambda_u2d1.append(RandomExtensions.nextElement((Random)Random.Default, this.getSource()));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        public RandomStringGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomStringGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomStringGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomStringGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u0005"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomUuidGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/util/UUID;", "()V", "generate", "breeze-core"})
    public static final class RandomUuidGenerator
    extends AbstractRandomGenerator<UUID> {
        @NotNull
        public static final RandomUuidGenerator INSTANCE = new RandomUuidGenerator();

        private RandomUuidGenerator() {
        }

        @Override
        @NotNull
        public UUID generate() {
            return RandomExtensions.nextUuid((Random)Random.Default);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomDateGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/util/Date;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/util/Date;", "maxEpochSecond", "", "min", "getMin", "minEpochSecond", "passingParams", "componentCopy", "generate", "Default", "breeze-core"})
    public static class RandomDateGenerator
    extends AbstractRandomGenerator<Date> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @Nullable
        private final Date min;
        @Nullable
        private final Date max;
        private final long minEpochSecond;
        private final long maxEpochSecond;

        public RandomDateGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            long l;
            long l2;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object object = new String[]{"format", "locale", "timeZone"};
            this.passingParams = InternalExtensions.filterComponentParams(this.componentParams, object);
            object = this.componentParams.get("min");
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            this.min = (Date)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Date>(){}.getType(), componentParams$iv);
            $this$convertOrNull$iv = this.componentParams.get("max");
            componentParams$iv = this.passingParams;
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            this.max = (Date)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<Date>(){}.getType(), componentParams$iv);
            Date date = this.min;
            if (date == null) {
                l2 = 0L;
            } else {
                long l3;
                Instant instant = date.toInstant();
                l2 = instant == null ? 0L : (l3 = instant.getEpochSecond());
            }
            this.minEpochSecond = l2;
            Date date2 = this.max;
            if (date2 == null) {
                l = 0L;
            } else {
                long l4;
                Instant instant = date2.toInstant();
                l = instant == null ? 0L : (l4 = instant.getEpochSecond());
            }
            this.maxEpochSecond = l;
        }

        public /* synthetic */ RandomDateGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @Nullable
        public final Date getMin() {
            return this.min;
        }

        @Nullable
        public final Date getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomDateGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomDateGenerator(componentParams);
        }

        @Override
        @NotNull
        public Date generate() {
            if (this.min == null || this.max == null) {
                throw new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochSecond = Random.Default.nextLong(this.minEpochSecond, this.maxEpochSecond);
            Date date = Date.from(Instant.ofEpochSecond(epochSecond));
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(Instant.ofEpochSecond(epochSecond))");
            return date;
        }

        public RandomDateGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomDateGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomDateGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomDateGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalDateGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/LocalDate;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/LocalDate;", "maxEpochDay", "", "min", "getMin", "minEpochDay", "passingParams", "componentCopy", "generate", "Default", "breeze-core"})
    public static class RandomLocalDateGenerator
    extends AbstractRandomGenerator<LocalDate> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @Nullable
        private final LocalDate min;
        @Nullable
        private final LocalDate max;
        private final long minEpochDay;
        private final long maxEpochDay;

        public RandomLocalDateGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            long l;
            long l2;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object object = new String[]{"format", "locale", "timeZone"};
            this.passingParams = InternalExtensions.filterComponentParams(this.componentParams, object);
            object = this.componentParams.get("min");
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            this.min = (LocalDate)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDate>(){}.getType(), componentParams$iv);
            $this$convertOrNull$iv = this.componentParams.get("max");
            componentParams$iv = this.passingParams;
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            this.max = (LocalDate)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDate>(){}.getType(), componentParams$iv);
            LocalDate localDate = this.min;
            this.minEpochDay = localDate == null ? 0L : (l2 = localDate.toEpochDay());
            LocalDate localDate2 = this.max;
            this.maxEpochDay = localDate2 == null ? 0L : (l = localDate2.toEpochDay());
        }

        public /* synthetic */ RandomLocalDateGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @Nullable
        public final LocalDate getMin() {
            return this.min;
        }

        @Nullable
        public final LocalDate getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLocalDateGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomLocalDateGenerator(componentParams);
        }

        @Override
        @NotNull
        public LocalDate generate() {
            if (this.min == null || this.max == null) {
                throw new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochDay = Random.Default.nextLong(this.minEpochDay, this.maxEpochDay);
            LocalDate localDate = LocalDate.ofEpochDay(epochDay);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(epochDay)");
            return localDate;
        }

        public RandomLocalDateGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalDateGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalDateGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLocalDateGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalTimeGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/LocalTime;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/LocalTime;", "maxNanoOfDay", "", "min", "getMin", "minNanoOfDay", "passingParams", "componentCopy", "generate", "Default", "breeze-core"})
    public static class RandomLocalTimeGenerator
    extends AbstractRandomGenerator<LocalTime> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @Nullable
        private final LocalTime min;
        @Nullable
        private final LocalTime max;
        private final long minNanoOfDay;
        private final long maxNanoOfDay;

        public RandomLocalTimeGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            long l;
            long l2;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object object = new String[]{"format", "locale", "timeZone"};
            this.passingParams = InternalExtensions.filterComponentParams(this.componentParams, object);
            object = this.componentParams.get("min");
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            this.min = (LocalTime)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalTime>(){}.getType(), componentParams$iv);
            $this$convertOrNull$iv = this.componentParams.get("max");
            componentParams$iv = this.passingParams;
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            this.max = (LocalTime)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalTime>(){}.getType(), componentParams$iv);
            LocalTime localTime = this.min;
            this.minNanoOfDay = localTime == null ? 0L : (l2 = localTime.toNanoOfDay());
            LocalTime localTime2 = this.max;
            this.maxNanoOfDay = localTime2 == null ? 0L : (l = localTime2.toNanoOfDay());
        }

        public /* synthetic */ RandomLocalTimeGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @Nullable
        public final LocalTime getMin() {
            return this.min;
        }

        @Nullable
        public final LocalTime getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLocalTimeGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomLocalTimeGenerator(componentParams);
        }

        @Override
        @NotNull
        public LocalTime generate() {
            if (this.min == null || this.max == null) {
                throw new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long nanoOfDay = Random.Default.nextLong(this.minNanoOfDay, this.maxNanoOfDay);
            LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
            Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"ofNanoOfDay(nanoOfDay)");
            return localTime;
        }

        public RandomLocalTimeGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalTimeGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalTimeGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLocalTimeGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\b\u0016\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0013\u001a\u00020\u00002\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalDateTimeGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/LocalDateTime;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/LocalDateTime;", "maxEpochSecond", "", "min", "getMin", "minEpochSecond", "passingParams", "componentCopy", "generate", "Default", "breeze-core"})
    public static class RandomLocalDateTimeGenerator
    extends AbstractRandomGenerator<LocalDateTime> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @NotNull
        private final Map<String, Object> passingParams;
        @Nullable
        private final LocalDateTime min;
        @Nullable
        private final LocalDateTime max;
        private final long minEpochSecond;
        private final long maxEpochSecond;

        public RandomLocalDateTimeGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            long l;
            long l2;
            Object $this$convertOrNull$iv;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object object = new String[]{"format", "locale", "timeZone"};
            this.passingParams = InternalExtensions.filterComponentParams(this.componentParams, object);
            object = this.componentParams.get("min");
            Map<String, Object> componentParams$iv = this.passingParams;
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            this.min = (LocalDateTime)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDateTime>(){}.getType(), componentParams$iv);
            $this$convertOrNull$iv = this.componentParams.get("max");
            componentParams$iv = this.passingParams;
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            this.max = (LocalDateTime)this_$iv$iv.convertOrNull($this$convertOrNull$iv, new TypeReference<LocalDateTime>(){}.getType(), componentParams$iv);
            LocalDateTime localDateTime = this.min;
            this.minEpochSecond = localDateTime == null ? 0L : (l2 = localDateTime.toEpochSecond(ZoneOffset.UTC));
            LocalDateTime localDateTime2 = this.max;
            this.maxEpochSecond = localDateTime2 == null ? 0L : (l = localDateTime2.toEpochSecond(ZoneOffset.UTC));
        }

        public /* synthetic */ RandomLocalDateTimeGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @Nullable
        public final LocalDateTime getMin() {
            return this.min;
        }

        @Nullable
        public final LocalDateTime getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public RandomLocalDateTimeGenerator componentCopy(@NotNull Map<String, ? extends Object> componentParams) {
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            return new RandomLocalDateTimeGenerator(componentParams);
        }

        @Override
        @NotNull
        public LocalDateTime generate() {
            if (this.min == null || this.max == null) {
                throw new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochSecond = Random.Default.nextLong(this.minEpochSecond, this.maxEpochSecond);
            LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(epochSecond, 0, ZoneOffset.UTC);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofEpochSecond(epochSecond, 0, ZoneOffset.UTC)");
            return localDateTime;
        }

        public RandomLocalDateTimeGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalDateTimeGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomLocalDateTimeGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomLocalDateTimeGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0002H\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomInstantGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "Ljava/time/Instant;", "componentParams", "", "", "", "(Ljava/util/Map;)V", "getComponentParams", "()Ljava/util/Map;", "max", "getMax", "()Ljava/time/Instant;", "maxEpochSecond", "", "min", "getMin", "minEpochSecond", "generate", "Default", "breeze-core"})
    public static class RandomInstantGenerator
    extends AbstractRandomGenerator<Instant> {
        @NotNull
        public static final Default Default = new Default(null);
        @NotNull
        private final Map<String, Object> componentParams;
        @Nullable
        private final Instant min;
        @Nullable
        private final Instant max;
        private final long minEpochSecond;
        private final long maxEpochSecond;

        public RandomInstantGenerator(@NotNull Map<String, ? extends Object> componentParams) {
            long l;
            long l2;
            Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
            this.componentParams = componentParams;
            Object $this$convertOrNull_u24default$iv = this.componentParams.get("min");
            Map componentParams$iv = MapsKt.emptyMap();
            boolean $i$f$convertOrNull = false;
            Converters this_$iv$iv = Converters.INSTANCE;
            boolean $i$f$convertOrNull2 = false;
            boolean $i$f$javaTypeOf = false;
            this.min = (Instant)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Instant>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            $this$convertOrNull_u24default$iv = this.componentParams.get("max");
            componentParams$iv = MapsKt.emptyMap();
            $i$f$convertOrNull = false;
            this_$iv$iv = Converters.INSTANCE;
            $i$f$convertOrNull2 = false;
            $i$f$javaTypeOf = false;
            this.max = (Instant)this_$iv$iv.convertOrNull($this$convertOrNull_u24default$iv, new TypeReference<Instant>(){}.getType(), (Map<String, ? extends Object>)componentParams$iv);
            Instant instant = this.min;
            this.minEpochSecond = instant == null ? 0L : (l2 = instant.getEpochSecond());
            Instant instant2 = this.max;
            this.maxEpochSecond = instant2 == null ? 0L : (l = instant2.getEpochSecond());
        }

        public /* synthetic */ RandomInstantGenerator(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @Override
        @NotNull
        public final Map<String, Object> getComponentParams() {
            return this.componentParams;
        }

        @Nullable
        public final Instant getMin() {
            return this.min;
        }

        @Nullable
        public final Instant getMax() {
            return this.max;
        }

        @Override
        @NotNull
        public Instant generate() {
            if (this.min == null || this.max == null) {
                throw new IllegalArgumentException("Config param 'min' or 'max' cannot be null.");
            }
            long epochSecond = Random.Default.nextLong(this.minEpochSecond, this.maxEpochSecond);
            Instant instant = Instant.ofEpochSecond(epochSecond);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(epochSecond)");
            return instant;
        }

        public RandomInstantGenerator() {
            this(null, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomInstantGenerator$Default;", "Licu/windea/breezeframework/core/component/RandomGenerators$RandomInstantGenerator;", "()V", "breeze-core"})
        public static final class Default
        extends RandomInstantGenerator {
            private Default() {
                super(null, 1, null);
            }

            public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Licu/windea/breezeframework/core/component/RandomGenerators$RandomEnumGenerator;", "Licu/windea/breezeframework/core/component/AbstractRandomGenerator;", "", "Licu/windea/breezeframework/core/component/GenericRandomGenerator;", "()V", "generate", "targetType", "Ljava/lang/reflect/Type;", "breeze-core"})
    public static final class RandomEnumGenerator
    extends AbstractRandomGenerator<Enum<?>>
    implements GenericRandomGenerator<Enum<?>> {
        @NotNull
        public static final RandomEnumGenerator INSTANCE = new RandomEnumGenerator();

        private RandomEnumGenerator() {
        }

        @Override
        @NotNull
        public Enum<?> generate(@NotNull Type targetType) {
            List list;
            Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
            Class<Enum<?>> enumClass = InternalExtensions.inferEnumClass(targetType);
            if (Intrinsics.areEqual(enumClass, Enum.class)) {
                throw new IllegalArgumentException("Cannot get actual enum class.");
            }
            Map<Class<Enum<?>>, List<Enum<?>>> $this$getOrPut$iv = InternalExtensions.getEnumValuesCache();
            boolean $i$f$getOrPut = false;
            List value$iv = $this$getOrPut$iv.get(enumClass);
            if (value$iv == null) {
                boolean bl = false;
                Object[] objectArray = enumClass.getEnumConstants();
                List list2 = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List answer$iv = list2;
                $this$getOrPut$iv.put(enumClass, answer$iv);
                list = answer$iv;
            } else {
                list = value$iv;
            }
            List enumValues = list;
            return RandomExtensions.nextElement((Random)Random.Default, enumValues);
        }

        @Override
        @NotNull
        public Enum<?> generate() {
            return (Enum)GenericRandomGenerator.DefaultImpls.generate(this);
        }
    }
}

